# This application is released under the GNU General Public License 
# v3 (or, at your option, any later version). You can find the full 
# text of the license under http://www.gnu.org/licenses/gpl.txt. 
# By using, editing and/or distributing this software you agree to 
# the terms and conditions of this license. 
# Thank you for using free software!

# Songbird API (Extended MprisAPI) (c) BruceLee 2011 <eu.gabii@yahoo.com>


import os
import dbus
import string
import gobject
from Mpris import MprisAPI


class SongbirdAPI(MprisAPI):
	__name__ = 'Songbird API'
	__version__ = '0.3.4.1'
	__author__ = 'BruceLee'
	__desc__ = 'API for Songbird Audio Player'

	this_mpris_ns    = 'org.mpris.songbird'
	this_mpris_iroot = '/Player'
	this_mpris_iface = 'org.freedesktop.MediaPlayer'
			
	def is_active(self, dbus_iface, screenlet_settings):
		if self.this_mpris_ns in dbus_iface.ListNames(): return True
		return False

