# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU Lesser General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License along with
# this program; if not, write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
# copyright 2003-2010 LOGILAB S.A. (Paris, FRANCE), all rights reserved.
# contact http://www.logilab.fr/ -- mailto:contact@logilab.fr
# copyright 2003-2010 Sylvain Thenault, all rights reserved.
# contact mailto:thenault@gmail.com
#
# This file is part of logilab-astng.
#
# logilab-astng is free software: you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by the
# Free Software Foundation, either version 2.1 of the License, or (at your
# option) any later version.
#
# logilab-astng is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
# for more details.
#
# You should have received a copy of the GNU Lesser General Public License along
# with logilab-astng. If not, see <http://www.gnu.org/licenses/>.
"""this module contains exceptions used in the astng library

"""

__doctype__ = "restructuredtext en"

class ASTNGError(Exception):
    """base exception class for all astng related exceptions"""

class ASTNGBuildingException(ASTNGError):
    """exception class when we are unable to build an astng representation"""

class ResolveError(ASTNGError):
    """base class of astng resolution/inference error"""

class NotFoundError(ResolveError):
    """raised when we are unable to resolve a name"""

class InferenceError(ResolveError):
    """raised when we are unable to infer a node"""

class UnresolvableName(InferenceError):
    """raised when we are unable to resolve a name"""

class NoDefault(ASTNGError):
    """raised by function's `default_value` method when an argument has
    no default value
    """

class IgnoreChild(Exception):
    """exception that maybe raised by visit methods to avoid children traversal
    """

