/*
 * Decompiled with CFR 0.152.
 */
package com.baselet.element.old.custom;

import com.baselet.control.config.Config;
import com.baselet.control.config.SharedConfig;
import com.baselet.control.enums.Program;
import com.baselet.control.enums.RuntimeType;
import com.baselet.control.util.Path;
import com.baselet.custom.CompileError;
import com.baselet.element.interfaces.GridElement;
import com.baselet.element.old.custom.CustomElement;
import com.baselet.element.old.custom.CustomElementWithErrors;
import com.baselet.element.old.custom.ErrorHandler;
import com.baselet.element.old.custom.FileClassLoader;
import com.baselet.element.old.element.ErrorOccurred;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomElementCompiler {
    private static final Logger log = LoggerFactory.getLogger(CustomElementCompiler.class);
    private static CustomElementCompiler compiler;
    private static final String templatefile = "Default.java";
    private final String template;
    private final Pattern template_pattern;
    private Matcher template_match;
    private final String classname;
    private int beforecodelines;
    private List<CompileError> compilation_errors;
    private boolean global_error;
    private final File sourcefile;

    public static CustomElementCompiler getInstance() {
        if (compiler == null) {
            compiler = new CustomElementCompiler();
        }
        return compiler;
    }

    private CustomElementCompiler() {
        block5: {
            this.global_error = false;
            this.compilation_errors = new ArrayList<CompileError>();
            this.beforecodelines = 0;
            this.template_pattern = Pattern.compile("(.*)(/\\*\\*\\*\\*CUSTOM_CODE START\\*\\*\\*\\*/\n)(.*)(\n\\s\\s/\\*\\*\\*\\*CUSTOM_CODE END\\*\\*\\*\\*/)(.*)", 32);
            this.template = this.loadJavaSource(new File(Path.customElements() + templatefile));
            if (!"".equals(this.template)) {
                this.template_match = this.template_pattern.matcher(this.template);
                try {
                    if (this.template_match.matches()) {
                        this.beforecodelines = this.template_match.group(1).split("\n").length;
                        break block5;
                    }
                    this.global_error = true;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                this.global_error = true;
            }
        }
        this.classname = "CustomElementImpl";
        this.sourcefile = new File(Path.temp() + this.classname + ".java");
        this.sourcefile.deleteOnExit();
        new File(Path.temp() + this.classname + ".class").deleteOnExit();
    }

    private CustomElement compile(String code) {
        this.saveJavaSource(code);
        CustomElement entity = null;
        this.compilation_errors.clear();
        try {
            StringWriter compilerErrorMessageSW = new StringWriter();
            PrintWriter compilerErrorMessagePW = new PrintWriter(compilerErrorMessageSW);
            String javaVersion = "-\"1.6\"";
            String classpath = "-classpath \"" + this.createClasspath() + "\"";
            String sourcefile = "\"" + this.sourcefile.getAbsolutePath() + "\"";
            boolean compilationSuccessful = Main.compile((String)(javaVersion + " " + classpath + " " + sourcefile), (PrintWriter)new PrintWriter(System.out), (PrintWriter)compilerErrorMessagePW);
            if (compilationSuccessful) {
                FileClassLoader fcl = new FileClassLoader(Thread.currentThread().getContextClassLoader());
                Class<?> c = fcl.findClass(this.classname);
                if (c != null) {
                    entity = (CustomElement)c.newInstance();
                }
            } else {
                this.compilation_errors = CompileError.getListFromString(compilerErrorMessageSW.toString(), this.beforecodelines);
            }
        }
        catch (Exception e) {
            log.error(null, (Throwable)e);
        }
        if (entity == null) {
            entity = new CustomElementWithErrors(this.compilation_errors);
        }
        return entity;
    }

    private String createClasspath() {
        if (!Path.executable().endsWith(".jar") && Program.getInstance().getRuntimeType() == RuntimeType.ECLIPSE_PLUGIN) {
            return Path.executable() + "target/classes";
        }
        return Path.executable() + "\"" + File.pathSeparator + "\"" + Path.executableShared();
    }

    private String loadJavaSource(File sourceFile) {
        StringBuilder sb = new StringBuilder("");
        if (sourceFile != null && sourceFile.getName().endsWith(".java")) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(sourceFile));
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                br.close();
            }
            catch (Exception e) {
                log.error(null, (Throwable)e);
            }
        }
        return sb.toString().replaceAll("\r\n", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveJavaSource(String code) {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(this.sourcefile, false));
            bw.write(this.parseCodeIntoTemplate(code));
            bw.flush();
        }
        catch (IOException e) {
            log.error(null, (Throwable)e);
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String parseCodeFromTemplate(String template) {
        Matcher m = this.template_pattern.matcher(template);
        if (m.matches()) {
            return m.group(3);
        }
        return "";
    }

    private String parseCodeIntoTemplate(String code) {
        return this.template_match.group(1).replaceFirst("<!CLASSNAME!>", this.classname) + this.template_match.group(2) + code + this.template_match.group(4) + this.template_match.group(5);
    }

    public GridElement genEntity(String code, ErrorHandler errorhandler) {
        if (!Config.getInstance().isEnable_custom_elements()) {
            String errorMessage = "Custom Elements are disabled\nEnabled them in the Options\nOnly open them from trusted\nsources to avoid malicious code execution!";
            if (SharedConfig.getInstance().isDev_mode()) {
                errorMessage = errorMessage + "\n------------------------------------\n" + code;
            }
            return new ErrorOccurred(errorMessage);
        }
        if (this.global_error) {
            return new ErrorOccurred();
        }
        if (code == null) {
            code = this.parseCodeFromTemplate(this.template);
        }
        CustomElement element = this.compile(code);
        if (errorhandler != null) {
            errorhandler.addErrors(this.compilation_errors);
        }
        element.setCode(code);
        return element;
    }

    public GridElement genEntity(String code) {
        return this.genEntity(code, null);
    }

    public GridElement genEntityFromTemplate(String templatename, ErrorHandler errorhandler) {
        String template = this.loadJavaSource(new File(Path.customElements() + templatename + ".java"));
        if (!"".equals(template)) {
            return this.genEntity(this.parseCodeFromTemplate(template), errorhandler);
        }
        return null;
    }
}

