/*
 * Decompiled with CFR 0.152.
 */
package net.schmizz.sshj.transport.kex;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import net.schmizz.sshj.common.SSHRuntimeException;
import net.schmizz.sshj.common.SecurityUtils;

public class DH {
    private BigInteger p;
    private BigInteger g;
    private BigInteger e;
    private BigInteger K;
    private final KeyPairGenerator generator;
    private final KeyAgreement agreement;

    public DH() {
        try {
            this.generator = SecurityUtils.getKeyPairGenerator("DH");
            this.agreement = SecurityUtils.getKeyAgreement("DH");
        }
        catch (GeneralSecurityException e) {
            throw new SSHRuntimeException(e);
        }
    }

    public void init(BigInteger p, BigInteger g) throws GeneralSecurityException {
        this.p = p;
        this.g = g;
        this.generator.initialize(new DHParameterSpec(p, g));
        KeyPair kp = this.generator.generateKeyPair();
        this.agreement.init(kp.getPrivate());
        this.e = ((DHPublicKey)kp.getPublic()).getY();
    }

    public void computeK(BigInteger f) throws GeneralSecurityException {
        KeyFactory keyFactory = SecurityUtils.getKeyFactory("DH");
        PublicKey yourPubKey = keyFactory.generatePublic(new DHPublicKeySpec(f, this.p, this.g));
        this.agreement.doPhase(yourPubKey, true);
        this.K = new BigInteger(1, this.agreement.generateSecret());
    }

    public BigInteger getE() {
        return this.e;
    }

    public BigInteger getK() {
        return this.K;
    }
}

