/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.style.ToStringCreator;
import org.springframework.test.context.CacheAwareContextLoaderDelegate;
import org.springframework.test.context.ContextLoader;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergedContextConfiguration
implements Serializable {
    private static final long serialVersionUID = -3290560718464957422L;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> EMPTY_INITIALIZER_CLASSES = Collections.emptySet();
    private final Class<?> testClass;
    private final String[] locations;
    private final Class<?>[] classes;
    private final Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> contextInitializerClasses;
    private final String[] activeProfiles;
    private final ContextLoader contextLoader;
    private final CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate;
    private final MergedContextConfiguration parent;

    private static String[] processLocations(String[] locations) {
        return locations == null ? EMPTY_STRING_ARRAY : locations;
    }

    private static Class<?>[] processClasses(Class<?>[] classes) {
        return classes == null ? EMPTY_CLASS_ARRAY : classes;
    }

    private static Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> processContextInitializerClasses(Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> contextInitializerClasses) {
        return contextInitializerClasses == null ? EMPTY_INITIALIZER_CLASSES : Collections.unmodifiableSet(contextInitializerClasses);
    }

    private static String[] processActiveProfiles(String[] activeProfiles) {
        if (activeProfiles == null) {
            return EMPTY_STRING_ARRAY;
        }
        TreeSet<String> sortedProfilesSet = new TreeSet<String>(Arrays.asList(activeProfiles));
        return StringUtils.toStringArray(sortedProfilesSet);
    }

    protected static String nullSafeToString(ContextLoader contextLoader) {
        return contextLoader == null ? "null" : contextLoader.getClass().getName();
    }

    public MergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, String[] activeProfiles, ContextLoader contextLoader) {
        this(testClass, locations, classes, null, activeProfiles, contextLoader);
    }

    public MergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> contextInitializerClasses, String[] activeProfiles, ContextLoader contextLoader) {
        this(testClass, locations, classes, contextInitializerClasses, activeProfiles, contextLoader, null, null);
    }

    public MergedContextConfiguration(Class<?> testClass, String[] locations, Class<?>[] classes, Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> contextInitializerClasses, String[] activeProfiles, ContextLoader contextLoader, CacheAwareContextLoaderDelegate cacheAwareContextLoaderDelegate, MergedContextConfiguration parent) {
        this.testClass = testClass;
        this.locations = MergedContextConfiguration.processLocations(locations);
        this.classes = MergedContextConfiguration.processClasses(classes);
        this.contextInitializerClasses = MergedContextConfiguration.processContextInitializerClasses(contextInitializerClasses);
        this.activeProfiles = MergedContextConfiguration.processActiveProfiles(activeProfiles);
        this.contextLoader = contextLoader;
        this.cacheAwareContextLoaderDelegate = cacheAwareContextLoaderDelegate;
        this.parent = parent;
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public String[] getLocations() {
        return this.locations;
    }

    public Class<?>[] getClasses() {
        return this.classes;
    }

    public Set<Class<? extends ApplicationContextInitializer<? extends ConfigurableApplicationContext>>> getContextInitializerClasses() {
        return this.contextInitializerClasses;
    }

    public String[] getActiveProfiles() {
        return this.activeProfiles;
    }

    public ContextLoader getContextLoader() {
        return this.contextLoader;
    }

    public MergedContextConfiguration getParent() {
        return this.parent;
    }

    public ApplicationContext getParentApplicationContext() {
        if (this.parent == null) {
            return null;
        }
        Assert.state((this.cacheAwareContextLoaderDelegate != null ? 1 : 0) != 0, (String)"Cannot retrieve a parent application context without access to the CacheAwareContextLoaderDelegate.");
        return this.cacheAwareContextLoaderDelegate.loadContext(this.parent);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.locations);
        result = 31 * result + Arrays.hashCode(this.classes);
        result = 31 * result + this.contextInitializerClasses.hashCode();
        result = 31 * result + Arrays.hashCode(this.activeProfiles);
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + MergedContextConfiguration.nullSafeToString(this.contextLoader).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MergedContextConfiguration)) {
            return false;
        }
        MergedContextConfiguration that = (MergedContextConfiguration)obj;
        if (!Arrays.equals(this.locations, that.locations)) {
            return false;
        }
        if (!Arrays.equals(this.classes, that.classes)) {
            return false;
        }
        if (!this.contextInitializerClasses.equals(that.contextInitializerClasses)) {
            return false;
        }
        if (!Arrays.equals(this.activeProfiles, that.activeProfiles)) {
            return false;
        }
        if (this.parent == null ? that.parent != null : !this.parent.equals(that.parent)) {
            return false;
        }
        return MergedContextConfiguration.nullSafeToString(this.contextLoader).equals(MergedContextConfiguration.nullSafeToString(that.contextLoader));
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("testClass", this.testClass).append("locations", (Object)ObjectUtils.nullSafeToString((Object[])this.locations)).append("classes", (Object)ObjectUtils.nullSafeToString((Object[])this.classes)).append("contextInitializerClasses", (Object)ObjectUtils.nullSafeToString(this.contextInitializerClasses)).append("activeProfiles", (Object)ObjectUtils.nullSafeToString((Object[])this.activeProfiles)).append("contextLoader", (Object)MergedContextConfiguration.nullSafeToString(this.contextLoader)).append("parent", (Object)this.parent).toString();
    }
}

