/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.framing;

import java.nio.ByteBuffer;
import org.java_websocket.exceptions.InvalidDataException;
import org.java_websocket.exceptions.InvalidFrameException;
import org.java_websocket.framing.CloseFrame;
import org.java_websocket.framing.Framedata;
import org.java_websocket.framing.FramedataImpl1;
import org.java_websocket.util.Charsetfunctions;

public class CloseFrameBuilder
extends FramedataImpl1
implements CloseFrame {
    static final ByteBuffer emptybytebuffer = ByteBuffer.allocate(0);
    private int code;
    private String reason;

    public CloseFrameBuilder() {
        super(Framedata.Opcode.CLOSING);
        this.setFin(true);
    }

    public CloseFrameBuilder(int code) throws InvalidDataException {
        super(Framedata.Opcode.CLOSING);
        this.setFin(true);
        this.setCodeAndMessage(code, "");
    }

    public CloseFrameBuilder(int code, String m) throws InvalidDataException {
        super(Framedata.Opcode.CLOSING);
        this.setFin(true);
        this.setCodeAndMessage(code, m);
    }

    private void setCodeAndMessage(int code, String m) throws InvalidDataException {
        if (m == null) {
            m = "";
        }
        if (code == 1015) {
            code = 1005;
            m = "";
        }
        if (code == 1005) {
            if (0 < m.length()) {
                throw new InvalidDataException(1002, "A close frame must have a closecode if it has a reason");
            }
            return;
        }
        byte[] by = Charsetfunctions.utf8Bytes(m);
        ByteBuffer buf = ByteBuffer.allocate(4);
        buf.putInt(code);
        buf.position(2);
        ByteBuffer pay = ByteBuffer.allocate(2 + by.length);
        pay.put(buf);
        pay.put(by);
        pay.rewind();
        this.setPayload(pay);
    }

    private void initCloseCode() throws InvalidFrameException {
        this.code = 1005;
        ByteBuffer payload = super.getPayloadData();
        payload.mark();
        if (payload.remaining() >= 2) {
            ByteBuffer bb = ByteBuffer.allocate(4);
            bb.position(2);
            bb.putShort(payload.getShort());
            bb.position(0);
            this.code = bb.getInt();
            if (this.code == 1006 || this.code == 1015 || this.code == 1005 || this.code > 4999 || this.code < 1000 || this.code == 1004) {
                throw new InvalidFrameException("closecode must not be sent over the wire: " + this.code);
            }
        }
        payload.reset();
    }

    public int getCloseCode() {
        return this.code;
    }

    private void initMessage() throws InvalidDataException {
        if (this.code == 1005) {
            this.reason = Charsetfunctions.stringUtf8(super.getPayloadData());
        } else {
            ByteBuffer b = super.getPayloadData();
            int mark = b.position();
            try {
                b.position(b.position() + 2);
                this.reason = Charsetfunctions.stringUtf8(b);
            }
            catch (IllegalArgumentException e) {
                throw new InvalidFrameException(e);
            }
            finally {
                b.position(mark);
            }
        }
    }

    public String getMessage() {
        return this.reason;
    }

    public String toString() {
        return super.toString() + "code: " + this.code;
    }

    public void setPayload(ByteBuffer payload) throws InvalidDataException {
        super.setPayload(payload);
        this.initCloseCode();
        this.initMessage();
    }

    public ByteBuffer getPayloadData() {
        if (this.code == 1005) {
            return emptybytebuffer;
        }
        return super.getPayloadData();
    }
}

