/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

@Deprecated
public class UpgradeNioProcessor
extends UpgradeProcessor<NioChannel> {
    private final NioChannel nioChannel;
    private final NioSelectorPool pool;
    private final int maxRead;
    private final int maxWrite;

    public UpgradeNioProcessor(SocketWrapper<NioChannel> wrapper, UpgradeInbound upgradeInbound, NioSelectorPool pool) {
        super(upgradeInbound);
        wrapper.setTimeout(upgradeInbound.getReadTimeout());
        this.nioChannel = wrapper.getSocket();
        this.pool = pool;
        this.maxRead = this.nioChannel.getBufHandler().getReadBuffer().capacity();
        this.maxWrite = this.nioChannel.getBufHandler().getWriteBuffer().capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.nioChannel.getAttachment();
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        long writeTimeout = att.getTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException x) {
            // empty catch block
        }
        try {
            while (!this.nioChannel.flush(true, selector, writeTimeout)) {
            }
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.writeToSocket(new byte[]{(byte)b}, 0, 1);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int written = 0;
        while (len - written > this.maxWrite) {
            written += this.writeToSocket(b, off + written, this.maxWrite);
        }
        this.writeToSocket(b, off + written, len - written);
    }

    @Override
    public int read() throws IOException {
        byte[] bytes = new byte[1];
        int result = this.readSocket(true, bytes, 0, 1);
        if (result == -1) {
            return -1;
        }
        return bytes[0] & 0xFF;
    }

    @Override
    public int read(boolean block, byte[] bytes, int off, int len) throws IOException {
        if (len > this.maxRead) {
            return this.readSocket(block, bytes, off, this.maxRead);
        }
        return this.readSocket(block, bytes, off, len);
    }

    private int readSocket(boolean block, byte[] bytes, int offset, int len) throws IOException {
        ByteBuffer readBuffer = this.nioChannel.getBufHandler().getReadBuffer();
        int remaining = readBuffer.remaining();
        if (remaining >= len) {
            readBuffer.get(bytes, offset, len);
            return len;
        }
        int leftToWrite = len;
        int newOffset = offset;
        if (remaining > 0) {
            readBuffer.get(bytes, offset, remaining);
            leftToWrite -= remaining;
            newOffset += remaining;
        }
        readBuffer.clear();
        int nRead = this.fillReadBuffer(block);
        if (nRead > 0) {
            readBuffer.flip();
            readBuffer.limit(nRead);
            if (nRead > leftToWrite) {
                readBuffer.get(bytes, newOffset, leftToWrite);
                leftToWrite = 0;
            } else {
                readBuffer.get(bytes, newOffset, nRead);
                leftToWrite -= nRead;
            }
        } else if (nRead == 0) {
            readBuffer.flip();
            readBuffer.limit(nRead);
        } else if (nRead == -1) {
            throw new EOFException(sm.getString("nio.eof.error"));
        }
        return len - leftToWrite;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillReadBuffer(boolean block) throws IOException {
        int nRead;
        if (block) {
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException x) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.nioChannel.getAttachment();
                if (att == null) {
                    throw new IOException("Key must be cancelled.");
                }
                nRead = this.pool.read(this.nioChannel.getBufHandler().getReadBuffer(), this.nioChannel, selector, att.getTimeout());
            }
            catch (EOFException eof) {
                nRead = -1;
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        } else {
            nRead = this.nioChannel.read(this.nioChannel.getBufHandler().getReadBuffer());
        }
        return nRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int writeToSocket(byte[] bytes, int off, int len) throws IOException {
        this.nioChannel.getBufHandler().getWriteBuffer().clear();
        this.nioChannel.getBufHandler().getWriteBuffer().put(bytes, off, len);
        this.nioChannel.getBufHandler().getWriteBuffer().flip();
        int written = 0;
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.nioChannel.getAttachment();
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        long writeTimeout = att.getTimeout();
        Selector selector = null;
        try {
            selector = this.pool.get();
        }
        catch (IOException x) {
            // empty catch block
        }
        try {
            written = this.pool.write(this.nioChannel.getBufHandler().getWriteBuffer(), this.nioChannel, selector, writeTimeout, true);
        }
        finally {
            if (selector != null) {
                this.pool.put(selector);
            }
        }
        return written;
    }
}

