/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import com.puppycrawl.tools.checkstyle.checks.AbstractImportCheck;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RedundantImportCheck
extends AbstractImportCheck {
    private String mPkgName;
    private final Set mImports = new HashSet();

    public void beginTree(DetailAST aRootAST) {
        this.mPkgName = null;
        this.mImports.clear();
    }

    public int[] getDefaultTokens() {
        return new int[]{30, 16};
    }

    public void visitToken(DetailAST aAST) {
        if (aAST.getType() == 16) {
            DetailAST nameAST = (DetailAST)aAST.getFirstChild();
            this.mPkgName = FullIdent.createFullIdent(nameAST).getText();
        } else {
            FullIdent imp = this.getImportText(aAST);
            if (RedundantImportCheck.fromPackage(imp.getText(), "java.lang")) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.lang", (Object)imp.getText());
            } else if (RedundantImportCheck.fromPackage(imp.getText(), this.mPkgName)) {
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.same", (Object)imp.getText());
            }
            Iterator it = this.mImports.iterator();
            while (it.hasNext()) {
                FullIdent full = (FullIdent)it.next();
                if (!imp.getText().equals(full.getText())) continue;
                this.log(aAST.getLineNo(), aAST.getColumnNo(), "import.duplicate", new Integer(full.getLineNo()), imp.getText());
            }
            this.mImports.add(imp);
        }
    }

    private static boolean fromPackage(String aImport, String aPkg) {
        boolean retVal = false;
        if (aPkg == null) {
            retVal = aImport.indexOf(46) == -1;
        } else {
            int index = aImport.lastIndexOf(46);
            if (index != -1) {
                String front = aImport.substring(0, index);
                retVal = front.equals(aPkg);
            }
        }
        return retVal;
    }
}

