/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.util.Locale;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLServerSocket;
import org.apache.tomcat.util.compat.Jre7Compat;
import org.apache.tomcat.util.compat.Jre8Compat;
import org.apache.tomcat.util.compat.Jre9Compat;
import org.apache.tomcat.util.res.StringManager;

public class JreCompat {
    private static final JreCompat instance;
    private static StringManager sm;
    private static final boolean jre9Available;
    private static final boolean jre8Available;
    private static final boolean jre7Available;

    public static JreCompat getInstance() {
        return instance;
    }

    public static boolean isJre7Available() {
        return jre7Available;
    }

    public Locale forLanguageTag(String languageTag) {
        String language = null;
        String country = null;
        String variant = null;
        int dash = languageTag.indexOf(45);
        if (dash < 0) {
            language = languageTag;
            country = "";
            variant = "";
        } else {
            language = languageTag.substring(0, dash);
            country = languageTag.substring(dash + 1);
            int vDash = country.indexOf(45);
            if (vDash > 0) {
                String cTemp = country.substring(0, vDash);
                variant = country.substring(vDash + 1);
                country = cTemp;
            } else {
                variant = "";
            }
        }
        if (!(JreCompat.isAlpha(language) && JreCompat.isAlpha(country) && JreCompat.isAlpha(variant))) {
            return null;
        }
        return new Locale(language, country, variant);
    }

    private static final boolean isAlpha(String value) {
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') continue;
            return false;
        }
        return true;
    }

    public static boolean isJre8Available() {
        return jre8Available;
    }

    public void setUseServerCipherSuitesOrder(SSLServerSocket socket, boolean useCipherSuitesOrder) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public void setUseServerCipherSuitesOrder(SSLEngine engine, boolean useCipherSuitesOrder) {
        throw new UnsupportedOperationException(sm.getString("jreCompat.noServerCipherSuiteOrder"));
    }

    public static boolean isJre9Available() {
        return jre9Available;
    }

    public boolean isInstanceOfInaccessibleObjectException(Exception e) {
        return false;
    }

    static {
        sm = StringManager.getManager((String)JreCompat.class.getPackage().getName());
        if (Jre9Compat.isSupported()) {
            instance = new Jre9Compat();
            jre9Available = true;
            jre8Available = true;
            jre7Available = true;
        } else if (Jre8Compat.isSupported()) {
            instance = new Jre8Compat();
            jre9Available = false;
            jre8Available = true;
            jre7Available = true;
        } else if (Jre7Compat.isSupported()) {
            instance = new Jre7Compat();
            jre9Available = false;
            jre8Available = false;
            jre7Available = true;
        } else {
            instance = new JreCompat();
            jre9Available = false;
            jre8Available = false;
            jre7Available = false;
        }
    }
}

