/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import javajs.util.Lst;
import javajs.util.PT;
import javajs.util.V3;
import org.jmol.adapter.readers.quantum.GamessReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;

public class GamessUSReader
extends GamessReader {
    private boolean lowdenCharges;

    @Override
    protected void initializeReader() throws Exception {
        this.lowdenCharges = this.checkAndRemoveFilterKey("CHARGE=LOW");
        super.initializeReader();
    }

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" $DATA")) {
            return this.readInputDeck();
        }
        if (this.line.indexOf("***************") >= 0) {
            Logger.info(this.rd());
        }
        if (this.line.indexOf("FINAL ENERGY IS") >= 0 || this.line.indexOf("TOTAL ENERGY = ") >= 0 || this.line.indexOf("FINAL RHF ENERGY IS") >= 0) {
            this.readEnergy();
        }
        if (this.line.indexOf("BASIS OPTIONS") >= 0) {
            this.readBasisInfo();
            return true;
        }
        if (this.line.indexOf("$CONTRL OPTIONS") >= 0) {
            this.readControlInfo();
            return true;
        }
        if (this.line.indexOf("ATOMIC BASIS SET") >= 0) {
            this.readGaussianBasis("SHELL TYPE", "TOTAL");
            return false;
        }
        boolean isBohr = this.line.indexOf("COORDINATES (BOHR)") >= 0;
        if (isBohr || this.line.indexOf("COORDINATES OF ALL ATOMS ARE (ANGS)") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.atomNames = new Lst();
            if (isBohr) {
                this.readAtomsInBohrCoordinates();
            } else {
                this.readAtomsInAngstromCoordinates();
            }
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("FREQUENCIES IN CM") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf("SUMMARY OF THE EFFECTIVE FRAGMENT") >= 0) {
            this.readEFPInBohrCoordinates();
            return false;
        }
        if (this.line.indexOf("  TOTAL MULLIKEN AND LOWDIN ATOMIC POPULATIONS") >= 0) {
            this.readPartialCharges();
            return false;
        }
        if (this.line.indexOf("ELECTROSTATIC MOMENTS") >= 0) {
            this.readDipoleMoment();
            return true;
        }
        if (this.line.indexOf("- ALPHA SET -") >= 0) {
            this.alphaBeta = "alpha";
        } else if (this.line.indexOf("- BETA SET -") >= 0) {
            this.alphaBeta = "beta";
        } else if (this.line.indexOf("  EIGENVECTORS") >= 0 || this.line.indexOf("  INITIAL GUESS ORBITALS") >= 0 || this.line.indexOf("  MCSCF OPTIMIZED ORBITALS") >= 0 || this.line.indexOf("  MCSCF NATURAL ORBITALS") >= 0 || this.line.indexOf("  MOLECULAR ORBITALS") >= 0 && this.line.indexOf("  MOLECULAR ORBITALS LOCALIZED BY THE POPULATION METHOD") < 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(1);
            return false;
        }
        if (this.line.indexOf("EDMISTON-RUEDENBERG ENERGY LOCALIZED ORBITALS") >= 0 || this.line.indexOf("  THE PIPEK-MEZEY POPULATION LOCALIZED ORBITALS ARE") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(0);
            return false;
        }
        if (this.line.indexOf("  NATURAL ORBITALS IN ATOMIC ORBITAL BASIS") >= 0) {
            if (!this.filterMO()) {
                return true;
            }
            this.readMolecularOrbitals(2);
            return false;
        }
        return this.checkNboLine();
    }

    private boolean readInputDeck() throws Exception {
        this.readLines(2);
        this.asc.newAtomSet();
        while (this.rd().indexOf("$END") < 0) {
            String[] tokens = this.getTokens();
            this.addAtomXYZSymName((String[])tokens, (int)2, (String)tokens[0], null).elementNumber = (short)this.parseIntStr(tokens[1]);
        }
        this.continuing = false;
        return false;
    }

    @Override
    protected void readMolecularOrbitals(int headerType) throws Exception {
        this.setCalculationType();
        super.readMolecularOrbitals(headerType);
    }

    protected void readEFPInBohrCoordinates() throws Exception {
        int acInFirstModel = this.asc.ac;
        this.discardLinesUntilContains("MULTIPOLE COORDINATES");
        this.rd();
        this.rd();
        while (this.rd() != null && this.line.length() >= 72) {
            String atomName = this.line.substring(1, 2);
            if (atomName.charAt(0) == 'Z') {
                atomName = this.line.substring(2, 3);
            } else if (this.parseFloatRange(this.line, 67, 73) == 0.0f) continue;
            float x = this.parseFloatRange(this.line, 8, 25);
            float y = this.parseFloatRange(this.line, 25, 40);
            float z = this.parseFloatRange(this.line, 40, 56);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            Atom atom = this.asc.addNewAtom();
            atom.atomName = atomName + ++acInFirstModel;
            this.setAtomCoordXYZ(atom, x * 0.5291772f, y * 0.5291772f, z * 0.5291772f);
            this.atomNames.addLast(atomName);
        }
    }

    @Override
    protected void readAtomsInBohrCoordinates() throws Exception {
        String atomName;
        this.rd();
        this.asc.newAtomSet();
        int n = 0;
        while (this.rd() != null && (atomName = this.parseTokenRange(this.line, 1, 11)) != null) {
            float x = this.parseFloatRange(this.line, 17, 37);
            float y = this.parseFloatRange(this.line, 37, 57);
            float z = this.parseFloatRange(this.line, 57, 77);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            Atom atom = this.asc.addNewAtom();
            atom.elementSymbol = GamessUSReader.getElementSymbol(this.parseIntRange(this.line, 11, 14));
            atom.atomName = atom.elementSymbol + ++n;
            this.setAtomCoordXYZ(atom, x * 0.5291772f, y * 0.5291772f, z * 0.5291772f);
            this.atomNames.addLast(atomName);
        }
    }

    private void readAtomsInAngstromCoordinates() throws Exception {
        Atom atom;
        float z;
        float y;
        float x;
        String atomName;
        this.rd();
        this.rd();
        this.asc.newAtomSet();
        int n = 0;
        while (this.rd() != null && (atomName = this.parseTokenRange(this.line, 1, 11)) != null) {
            x = this.parseFloatRange(this.line, 16, 31);
            y = this.parseFloatRange(this.line, 31, 46);
            z = this.parseFloatRange(this.line, 46, 61);
            if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
            atom = this.asc.addNewAtom();
            this.setAtomCoordXYZ(atom, x, y, z);
            atom.elementSymbol = GamessUSReader.getElementSymbol(this.parseIntRange(this.line, 11, 14));
            atom.atomName = atom.elementSymbol + ++n;
            this.atomNames.addLast(atomName);
        }
        if (this.line.indexOf("COORDINATES OF FRAGMENT MULTIPOLE CENTERS (ANGS)") >= 0) {
            this.rd();
            this.rd();
            this.rd();
            while (this.rd() != null && (atomName = this.parseTokenRange(this.line, 1, 2)) != null) {
                if (this.parseTokenRange(this.line, 1, 2).equals("Z")) {
                    atomName = this.parseTokenRange(this.line, 2, 3);
                } else {
                    if (this.parseTokenRange(this.line, 1, 9).equals("FRAGNAME")) continue;
                    atomName = this.parseTokenRange(this.line, 1, 2);
                }
                x = this.parseFloatRange(this.line, 16, 31);
                y = this.parseFloatRange(this.line, 31, 46);
                z = this.parseFloatRange(this.line, 46, 61);
                if (Float.isNaN(x) || Float.isNaN(y) || Float.isNaN(z)) break;
                atom = this.asc.addNewAtom();
                atom.atomName = atomName + ++n;
                this.setAtomCoordXYZ(atom, x, y, z);
                this.atomNames.addLast(atomName);
            }
        }
    }

    @Override
    protected String fixShellTag(String tag) {
        return tag;
    }

    void readPartialCharges() throws Exception {
        String searchstr;
        String[] tokens = null;
        String string = searchstr = this.lowdenCharges ? "LOW.POP." : "MULL.POP.";
        while (this.rd() != null && ("".equals(this.line.trim()) || this.line.indexOf("ATOM") >= 0)) {
            tokens = this.getTokens();
        }
        int poploc = 0;
        while (++poploc < tokens.length && !searchstr.equals(tokens[poploc])) {
        }
        if (++poploc >= tokens.length || !"CHARGE".equals(tokens[poploc++])) {
            return;
        }
        Atom[] atoms = this.asc.atoms;
        int startAtom = this.asc.getLastAtomSetAtomIndex();
        int endAtom = this.asc.ac;
        for (int i = startAtom; i < endAtom && this.rd() != null; ++i) {
            atoms[i].partialCharge = this.parseFloatStr(PT.getTokens(this.prevline)[poploc]);
        }
    }

    void readDipoleMoment() throws Exception {
        String[] tokens = null;
        this.rd();
        while (this.line != null && ("".equals(this.line.trim()) || this.line.indexOf("DX") < 0)) {
            this.rd();
        }
        tokens = this.getTokens();
        if (tokens.length != 5) {
            return;
        }
        if ("DX".equals(tokens[0]) && "DY".equals(tokens[1]) && "DZ".equals(tokens[2])) {
            tokens = PT.getTokens(this.rd());
            V3 dipole = V3.new3(this.parseFloatStr(tokens[0]), this.parseFloatStr(tokens[1]), this.parseFloatStr(tokens[2]));
            Logger.info("Molecular dipole for model " + this.asc.atomSetCount + " = " + dipole);
            this.asc.setCurrentModelInfo("dipole", dipole);
        }
    }
}

