/*
 * Decompiled with CFR 0.152.
 */
package dguitar.gui;

import common.FileFolderFilter;
import common.FilenameFilterAcceptExtension;
import common.FolderIterator;
import common.LogStream;
import common.LogStreamOptions;
import common.Midi;
import common.ScrollText;
import common.ScrollTextPanel;
import common.SwingWorker;
import common.Util;
import dguitar.codecs.CodecFileFilter;
import dguitar.codecs.guitarPro.GPFileFilter;
import dguitar.codecs.guitarPro.GPInputStream;
import dguitar.codecs.guitarPro.statistics.GPStats;
import dguitar.codecs.midi.MIDFileFilter;
import dguitar.gui.About;
import dguitar.gui.DGDesktopPane;
import dguitar.gui.DGFileChooser;
import dguitar.gui.DisplayOptions;
import dguitar.gui.FileLoaderHandler;
import dguitar.gui.OptionsDisplay;
import dguitar.gui.PlayToolBar;
import dguitar.gui.SongAction;
import dguitar.gui.SongActionParameters;
import dguitar.gui.SongInternalFrame;
import dguitar.gui.SongOptionsListener;
import dguitar.gui.SongOptionsMenu;
import dguitar.gui.listeners.ADropTargetListener;
import dguitar.gui.listeners.DGInternalFrameListener;
import dguitar.gui.midi.MidiDevices;
import dguitar.gui.midi.MidiInternalFrame;
import dguitar.gui.midi.MidiTest;
import i18n.Internationalized;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class DGuitar
extends JFrame
implements Internationalized,
OptionsDisplay {
    private boolean captureErrors;
    private boolean confirmLoad;
    private static short currentSkinIndex;
    private static ButtonGroup buttonGroupSkin;
    private static String[] arraySkinNames;
    private static JCheckBoxMenuItem[] arraySkinCheckBoxes;
    private final String DGpropertiesAbsolute;
    public boolean evaluate;
    protected DGFileChooser fileChooser;
    private int currentFileType;
    private File filePath;
    private Vector files;
    private boolean hasPathChanged;
    private static boolean hasOptionsChanged;
    private String lauchPath;
    private static Image imgIcon;
    private String skinPath;
    private String skinDir;
    private static boolean closableLogWindow;
    private static boolean LogWindowExits;
    private static boolean EnableUnfinishedFeatures;
    public static final int RecentIndexStart = 6;
    private static int contRecent;
    private JMenuBar menu;
    private JMenu menuAbout;
    private JMenuItem menuAboutAuthors;
    private JMenuItem menuAboutLicense;
    private JMenu menuMidi;
    private JMenuItem menuMidiDevices;
    private JMenuItem menuMidiTest;
    private JMenu menuOptions;
    private JCheckBoxMenuItem menuOptionsConfirmLoad;
    private JCheckBoxMenuItem menuOptionsEvaluate;
    private JCheckBoxMenuItem menuOptionsFastLoad;
    private JMenuItem menuOptionsFileLocation;
    private static SongOptionsMenu menuOptionsForAllSongs;
    private JMenu menuOptionsLanguage;
    private JMenuItem menuOptionsLog;
    private JCheckBoxMenuItem menuOptionsLogToFile;
    private JCheckBoxMenuItem menuOptionsLogToWindow;
    private JMenuItem menuOptionsSkins;
    private JCheckBoxMenuItem menuOptionsEnableUnfinishedFeatures;
    private JMenuItem menuOptionsReloadStoredSettings;
    private JMenuItem menuOptionsSaveCurrentSettings;
    private JMenu menuProgram;
    private JMenuItem menuProgramExit;
    private JMenuItem menuProgramNew;
    private JMenuItem menuProgramOpenGP;
    private JMenuItem menuProgramOpenMidi;
    private JMenuItem menuProgramOpenURL;
    private JMenuItem menuProgramStats;
    private JMenu menuWindows;
    private JMenuItem menuWindowsCascade;
    private JMenuItem menuWindowsCloseAll;
    private int menuWindowsOperationsCount;
    private ScrollText STstats;
    public Vector supportedExtensions;
    public String userHome;
    private SwingWorker worker;
    private static About about;
    private static String authors;
    protected static final Image[] Buttons;
    protected static final Image[] DisabledButtons;
    protected static final ImageIcon[] Clefs;
    public static DGDesktopPane desktopPane;
    private static Properties DGO;
    private static final String DGproperties = "DGuitar.properties";
    private DisplayOptions displayOptions;
    protected static final ImageIcon[] Dynamics;
    protected static final ImageIcon[] EONs;
    private static boolean fastLoad;
    public static GPFileFilter gpFileFilter;
    public static final boolean isRelease = true;
    public static String operationalSystem;
    public static final String[] javaVendorExpected;
    public static String javaVMvendor;
    public static String javaSpecVersion;
    public static final String javaVersionExpected = "1.4";
    public static PropertyResourceBundle lang;
    private static String langPath;
    private static Locale locale;
    private static String langCode;
    protected static ImageIcon Logo;
    public static PlayToolBar playToolBar;
    protected static LogStream LS;
    private static Midi midi;
    public static MIDFileFilter midiFileFilter;
    private static int MIN_HEIGHT;
    private static int MIN_WIDTH;
    protected static String msg;
    protected static final Image[] Notes;
    private static Dimension screenSize;
    protected static final ImageIcon[] Silences;
    private static PrintStream sysErr;
    public static Toolkit toolkit;
    public static final String version = "0.5.8";

    static {
        buttonGroupSkin = null;
        arraySkinNames = new String[2];
        arraySkinCheckBoxes = new JCheckBoxMenuItem[2];
        closableLogWindow = false;
        LogWindowExits = false;
        EnableUnfinishedFeatures = true;
        contRecent = 0;
        Buttons = new Image[2];
        DisabledButtons = new Image[2];
        Clefs = new ImageIcon[2];
        Dynamics = new ImageIcon[8];
        EONs = new ImageIcon[7];
        javaVendorExpected = new String[]{"Sun Microsystems Inc.", "Apple Computer, Inc."};
        MIN_HEIGHT = 480;
        MIN_WIDTH = 640;
        Notes = new Image[8];
        Silences = new ImageIcon[7];
    }

    private static void aboutAuthors() {
        String esp = "\n\t\t";
        if (authors == null) {
            authors = "";
            authors = String.valueOf(authors) + "\t\tDEVELOPERS:";
            authors = String.valueOf(authors) + "\n\t\tMauricio Gracia Gutierrez - Project Creator/Admin and User Interface";
            authors = String.valueOf(authors) + "\n\t\tMatthieu Wipliez - GPDecoding and GP4Format Translator";
            authors = String.valueOf(authors) + "\n\t\tChris Nash - Guitar Pro file player";
            authors = String.valueOf(authors) + "\n\t\t";
            authors = String.valueOf(authors) + "\n\t\tTRANSLATORS AND CONTRIBUTORS";
            authors = String.valueOf(authors) + "\n\t\tAvery Ceo - GPFormat Translator French-English";
            authors = String.valueOf(authors) + "\n\t\tTimoth\u00e9e Birckel - Logo creation";
            authors = String.valueOf(authors) + "\n\t\tCatherine Beauchemin - French Tranlation";
            authors = String.valueOf(authors) + "\n\t\tStefan Bethge - German Translation";
            authors = String.valueOf(authors) + "\n\t\tHugo Doria - Portuguese Translation";
            authors = String.valueOf(authors) + "\n\t\tRabbin \"Robin\" - Swedish Translation";
            authors = String.valueOf(authors) + "\n\t\tPetr \u0160igut - Czech Translation";
            authors = String.valueOf(authors) + "\n\t\tMarcin Wo\u0142oszczuk - Polish translation";
            authors = String.valueOf(authors) + "\n\t\tDino Michelon - Italian translation (revised by Martello Giorgio)";
            authors = String.valueOf(authors) + "\n\t\tAnton Roslavsky - Russian translation";
            authors = String.valueOf(authors) + "\n\t\tPratima Rao - Recent File list and more to come";
            authors = String.valueOf(authors) + "\n\t\t";
            authors = String.valueOf(authors) + "\n\t\tFor updates and more info visit:";
            authors = String.valueOf(authors) + "\n\t\t\thttp://DGuitar.sourceforge.net/";
        }
        if (about == null) {
            about = new About(600, 480);
        }
        DGuitar.about.authors.setText(authors);
        about.setTitle(DGuitar.version());
        about.setVisible(true);
    }

    static void correctJavaVersion() {
        try {
            javaVMvendor = System.getProperty("java.vm.vendor");
            javaSpecVersion = System.getProperty("java.specification.version");
            String aux = "Java: " + javaVMvendor;
            aux = String.valueOf(aux) + " version " + javaSpecVersion;
            System.err.print(aux);
            boolean correctVendor = false;
            String err = "\"" + javaVMvendor + "\" " + "is not one of these" + ": ";
            int countVendors = 0;
            while (!correctVendor && countVendors < javaVendorExpected.length) {
                boolean bl = correctVendor = !javaVMvendor.equals(javaVendorExpected[countVendors]);
                if (!correctVendor) {
                    err = String.valueOf(err) + "\"1.4\"";
                }
                ++countVendors;
            }
            if (!correctVendor) {
                System.err.println(err);
                Util.showDialogOk(null, "Warning - incorrect Java vendor found", err);
            } else if (!DGuitar.higherJavaVersion()) {
                err = "\"" + javaSpecVersion + "\" " + "should be" + " ";
                err = String.valueOf(err) + " or higher";
                System.err.println(err);
                Util.showDialogOk(null, "Warning - incorrect Java version found", err);
            }
        }
        catch (SecurityException SE) {
            System.err.println(lang.getString("ERROR_EXCEPTION"));
            SE.printStackTrace();
        }
    }

    public static PropertyResourceBundle getLang() {
        return lang;
    }

    static boolean higherJavaVersion() {
        boolean resp;
        boolean bl = resp = !javaSpecVersion.startsWith(javaVersionExpected);
        if (!resp) {
            String tokenA = new String(javaSpecVersion);
            String tokenB = new String(javaVersionExpected);
            int dotIndexA = tokenA.indexOf(".");
            int dotIndexB = tokenA.indexOf(".");
            resp = true;
            while (resp && dotIndexA >= 0 && dotIndexB >= 0) {
                int b;
                int a = Integer.valueOf(tokenA.substring(0, dotIndexA));
                boolean bl2 = resp = a >= (b = Integer.valueOf(tokenB.substring(0, dotIndexB)).intValue());
                if (dotIndexA < tokenA.length()) {
                    tokenA = tokenA.substring(dotIndexA + 1);
                }
                if (dotIndexB < tokenB.length()) {
                    tokenB = tokenB.substring(dotIndexB + 1);
                }
                dotIndexA = tokenA.indexOf(".");
                dotIndexB = tokenA.indexOf(".");
            }
        }
        return resp;
    }

    protected static void internalFrameLocate(JInternalFrame JIF) {
        int maxH = desktopPane.getRootPane().getHeight();
        int snapH = 50;
        int maxRows = maxH / snapH;
        int n = desktopPane.getComponentCount() - 1;
        int col = n / maxRows;
        int row = n % maxRows;
        int dx = col * 30;
        int dy = row * snapH;
        JIF.setBounds(dx, dy, 0, 0);
        DGuitar.internalFrameOptSize(JIF);
    }

    protected static void internalFrameOptSize(JInternalFrame JIF) {
        int maxH = desktopPane.getRootPane().getHeight();
        int maxW = desktopPane.getRootPane().getWidth();
        int x = JIF.getX();
        int y = JIF.getY();
        Dimension dim = JIF.getPreferredSize();
        int h = dim.height;
        int w = dim.width;
        if (y + (h += 40) > maxH) {
            h = maxH - y;
        }
        if (x + w > maxW) {
            w = maxW - x;
        }
        JIF.setSize(w, h);
    }

    private List convertStringsArgToFileList(String[] args) {
        ArrayList<File> someFiles = new ArrayList<File>();
        int i = 0;
        while (i < args.length) {
            someFiles.add(new File(args[i]));
            i = (short)(i + 1);
        }
        return someFiles;
    }

    public static void main(String[] args) throws FileNotFoundException {
        DGuitar DG = new DGuitar();
        String initS = String.valueOf(DGuitar.version()) + "\t" + DateFormat.getDateTimeInstance().format(new Date()) + "\n";
        String aux = DG.getLaunchPath();
        DG.userHome = System.getProperty("user.home");
        aux = String.valueOf(DG.userHome) + File.separator + "DGuitarLog.txt";
        LogStreamOptions LogSOptions = new LogStreamOptions(2, initS, aux);
        final LogStream LogS = new LogStream((OutputStream)System.err, LogSOptions);
        DG.init(LogS, true);
        SwingWorker worker = new SwingWorker(){

            public Object construct() {
                return LogS;
            }
        };
        worker.start();
        if (DGuitar.requirementsOK()) {
            DG.load();
            LogS.setClosable(closableLogWindow, LogWindowExits);
            DG.setVisible(true);
            DG.displayMultipleFiles(DG.convertStringsArgToFileList(args));
        } else {
            aux = String.valueOf(lang.getString("Screen_Size_should_be")) + " ";
            aux = String.valueOf(aux) + MIN_WIDTH + "x" + MIN_HEIGHT + lang.getString("fix_this_an_try_again");
            LS.print(aux);
        }
    }

    public static void detectOperationalSystem() {
        operationalSystem = System.getProperty("os.name");
        operationalSystem = String.valueOf(operationalSystem) + " version " + System.getProperty("os.version");
        operationalSystem = String.valueOf(operationalSystem) + " architecture " + System.getProperty("os.arch");
        System.err.print(String.valueOf(lang.getString("OS")) + ": " + operationalSystem);
    }

    public static boolean requirementsOK() {
        boolean success = true;
        screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (DGuitar.screenSize.width < MIN_WIDTH) {
            success = false;
        }
        if (DGuitar.screenSize.height < MIN_HEIGHT) {
            success = false;
        }
        DGuitar.detectOperationalSystem();
        DGuitar.correctJavaVersion();
        return success;
    }

    public static void setLang(PropertyResourceBundle lang) {
        DGuitar.lang = lang;
    }

    public static Object showCustomInputDialog(Component parent, String title, Object message, boolean input, String init) {
        JOptionPane JOP = new JOptionPane(message);
        JOP.setWantsInput(input);
        if (input && init != null) {
            JOP.setInitialSelectionValue(init);
        }
        JOP.setOptionType(2);
        JDialog dialog = JOP.createDialog(parent, title);
        dialog.setBounds(10, 100, 638, 140);
        dialog.setVisible(true);
        Object o = JOP.getInputValue();
        return o;
    }

    public static String version() {
        String str = "DGuitar";
        str = String.valueOf(str) + " 0.5.8";
        return str;
    }

    public DGuitar() {
        this.getContentPane().setLayout(new BorderLayout());
        this.determineLaunchPath();
        this.DGpropertiesAbsolute = String.valueOf(System.getProperty("user.home")) + File.separator + DGproperties;
        locale = Locale.getDefault();
        langPath = this.getLangPath();
        lang = this.loadLanguage(langPath, locale.getLanguage());
        authors = null;
        toolkit = this.getToolkit();
        this.fileChooser = null;
        this.hasPathChanged = true;
        this.worker = null;
        currentSkinIndex = 1;
        this.setTitle(DGuitar.version());
        this.files = new Vector(0, 1);
        DGO = new Properties();
    }

    private void aboutLicense() {
        this.showTextFile(lang.getString("GNU/GPL_License,_version_2"), "LICENSE.TXT", true, 550, 450);
    }

    public void addMenuMidi(JMenuBar MB) {
        this.menuMidi = new JMenu();
        this.menuMidiTest = new JMenuItem();
        this.menuMidiDevices = new JMenuItem();
        this.menuMidiDevices.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuMidiDevicesActionPerformed();
            }
        });
        this.menuMidi.add(this.menuMidiDevices);
        this.menuMidiTest.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuMidiTestActionPerformed();
            }
        });
        this.menuMidi.add(this.menuMidiTest);
        MB.add(this.menuMidi);
    }

    public void addMenuAbout(JMenuBar MB) {
        this.menuAbout = new JMenu();
        this.menuAboutAuthors = new JMenuItem();
        this.menuAboutLicense = new JMenuItem();
        this.menuAboutAuthors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.aboutAuthors();
            }
        });
        this.menuAbout.add(this.menuAboutAuthors);
        this.menuAboutLicense.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.aboutLicense();
            }
        });
        this.menuAbout.add(this.menuAboutLicense);
        MB.add(Box.createHorizontalGlue());
        MB.add(this.menuAbout);
    }

    private void addToolBars() {
        LS.print("adding ToolBars");
        playToolBar = new PlayToolBar(Buttons, desktopPane, DisabledButtons);
        this.getContentPane().add((Component)playToolBar, "First");
        this.pack();
    }

    private void removeToolBars() {
        LS.print("removing ToolBars");
        this.getContentPane().remove(playToolBar);
        playToolBar = null;
    }

    private boolean booleanProperty(String key, String defaultValue) {
        String value = DGO.getProperty(key, defaultValue);
        boolean resp = Boolean.valueOf(value);
        if (!DGO.containsKey(key)) {
            DGO.setProperty(key, value);
        }
        return resp;
    }

    private short shortProperty(String key, short defaultValue) {
        String value = DGO.getProperty(key, "" + defaultValue);
        short resp = Integer.valueOf(value).shortValue();
        if (!DGO.containsKey(key)) {
            DGO.setProperty(key, value);
        }
        return resp;
    }

    private void checkFileLocation() {
        boolean isNull = this.filePath == null;
        String filePathAux = this.filePath.getAbsolutePath();
        File folder = this.filePath;
        if (isNull || !this.filePath.exists()) {
            folder = new File(this.getFilePath());
            if (!folder.exists()) {
                folder = folder.getParentFile();
            }
            if (!isNull) {
                msg = "'" + filePathAux + "' " + lang.getString("ERROR_DOES_NOT_EXIST");
                msg = String.valueOf(msg) + "\n" + lang.getString("The_location_has_been_set_to_");
                msg = String.valueOf(msg) + "'";
                msg = String.valueOf(msg) + folder;
                msg = String.valueOf(msg) + "'";
                this.showDialogOk(lang.getString("FileLocation_is_incorrect"), msg);
                hasOptionsChanged = true;
            }
        }
        if (!folder.canRead() || !folder.canWrite()) {
            folder = new File(this.userHome);
        }
        this.filePath = folder;
    }

    public void closeAllWindows() {
        SongActionParameters SAP = new SongActionParameters(2);
        SongAction.perform(desktopPane, SAP);
        playToolBar.setStatus((short)0);
    }

    public void close() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.closeAllWindows();
        if (this.captureErrors) {
            System.setErr(sysErr);
            LS.close();
        }
        this.dispose();
        System.exit(0);
    }

    private void configureMenuOptionsLanguage() {
        String[] ls = this.getLangAvailable();
        ButtonGroup JBG = new ButtonGroup();
        if (ls != null) {
            int i = 0;
            while (i < ls.length) {
                Locale aLocale;
                String language;
                int index = ls[i].indexOf(95);
                if (index > 0) {
                    language = ls[i].substring(0, index);
                    String country = ls[i].substring(index + 1, index + 3);
                    aLocale = new Locale(language, country);
                } else {
                    language = ls[i];
                    aLocale = new Locale(language);
                }
                JCheckBoxMenuItem JCBMI = new JCheckBoxMenuItem(aLocale.getDisplayName());
                if (ls[i].equals(langCode)) {
                    JCBMI.setSelected(true);
                }
                JCBMI.setActionCommand(ls[i]);
                JCBMI.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        Object comp = e.getSource();
                        JCheckBoxMenuItem abc = (JCheckBoxMenuItem)comp;
                        langCode = abc.getActionCommand();
                        lang = DGuitar.this.loadLanguage(langPath, langCode);
                        DGO.setProperty("lang", langCode);
                        DGuitar.this.setLangText();
                        DGuitar.this.refreshLangText();
                        hasOptionsChanged = true;
                    }
                });
                JBG.add(JCBMI);
                this.menuOptionsLanguage.add(JCBMI);
                ++i;
            }
        }
    }

    protected void createFileChooser() {
        if (this.fileChooser == null) {
            UIManager.put("FileChooser.readOnly", Boolean.TRUE);
            this.fileChooser = new DGFileChooser(this.filePath);
            this.fileChooser.setAcceptAllFileFilterUsed(false);
        }
        this.fileChooser.setFileFilter(null);
        this.fileChooser.resetChoosableFileFilters();
        this.fileChooser.setSelectedFile(new File(""));
    }

    public void detectSupportedExtensions() {
        this.supportedExtensions = new Vector();
        this.supportedExtensions.addAll(gpFileFilter.getExtensions());
        this.supportedExtensions.addAll(midiFileFilter.getExtensions());
        Collections.sort(this.supportedExtensions);
        System.err.println(String.valueOf(lang.getString("SupportedExtensions")) + ":" + this.supportedExtensions);
    }

    public boolean isSupportedExtension(String aFileName) {
        boolean resp = false;
        Iterator iterator = this.supportedExtensions.iterator();
        while (!resp && iterator.hasNext()) {
            String ext = (String)iterator.next();
            resp = aFileName.toUpperCase().endsWith(ext);
        }
        return resp;
    }

    void displayGP(String aFileName, byte[] bytes) {
        if (this.confirmLoad) {
            msg = String.valueOf(lang.getString("File")) + "'" + aFileName + "'\n";
            msg = String.valueOf(msg) + lang.getString("Bytes") + ": " + bytes.length;
            this.showDialogOk(lang.getString("File_SUCCESSFULLY_Loaded"), msg);
        }
        this.readAndShow(aFileName, new ByteArrayInputStream(bytes));
    }

    void displayMID(String aFileName) {
        Midi newMidi = new Midi(lang.getString("doesNotHaveAnyReceivers"));
        MidiInternalFrame MIF = new MidiInternalFrame(aFileName, newMidi, playToolBar);
        this.internalFrameAdd(MIF);
    }

    public void displayMultipleFiles(List listOfFiles) {
        if (listOfFiles != null && listOfFiles.size() >= 1) {
            boolean checkExtension = true;
            System.err.println("Opening files:" + listOfFiles);
            Iterator iterator = listOfFiles.iterator();
            while (iterator.hasNext()) {
                File f = (File)iterator.next();
                this.loadAndDisplay(f, checkExtension);
            }
        }
    }

    private void errorSkin() {
        String aux = String.valueOf(lang.getString("ERROR_LOADING")) + " '" + DGuitar.nameForSkinIndex(currentSkinIndex) + "' ";
        aux = String.valueOf(aux) + lang.getString("skin");
        this.showDialogOk(aux, msg);
    }

    private void fileLoad(String file) {
        new FileLoaderHandler(this, file, this.evaluate).start();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.close();
    }

    private String getFilePath() {
        return String.valueOf(this.lauchPath) + File.separator + "files";
    }

    public String getLaunchPath() {
        return this.lauchPath;
    }

    public String[] getLangAvailable() {
        File langFolder = new File(this.getLangPath());
        String[] aux = langFolder.list(new FilenameFilterAcceptExtension(".properties"));
        String[] resp = null;
        if (aux != null && aux.length > 0) {
            int j = 0;
            resp = new String[aux.length - 1];
            int i = 0;
            while (i < aux.length) {
                int index = aux[i].indexOf(95);
                if (index > 0) {
                    int indexDot = aux[i].indexOf(46);
                    resp[j] = aux[i].substring(index + 1, indexDot);
                    ++j;
                }
                ++i;
            }
        }
        return resp;
    }

    public String getLangPath() {
        String resp = this.lauchPath;
        resp = String.valueOf(resp) + "lang";
        return resp;
    }

    public void init(LogStream LogS, boolean captureErrs) {
        LS = LogS;
        this.captureErrors = captureErrs;
        if (this.captureErrors) {
            sysErr = System.err;
            System.setErr(LS);
        }
    }

    public void load() throws FileNotFoundException {
        gpFileFilter = new GPFileFilter();
        midiFileFilter = new MIDFileFilter();
        this.detectSupportedExtensions();
        this.addDropSupport();
        this.preferencesLoad();
        langCode = DGO.getProperty("lang", "en");
        lang = this.loadLanguage(langPath, langCode);
        LS.log(lang.getString("applyPreferences"));
        this.menuCreate();
        this.preferencesUse();
        this.loadCurrentSkin();
        if (!fastLoad) {
            LS.log(lang.getString("Creating_JFileChooser"));
            this.createFileChooser();
        }
        this.addToolBars();
        imgIcon = javaVMvendor.equals(javaVendorExpected[1]) ? this.loadImage(String.valueOf(this.skinDir) + "dguitar_32x32.png") : this.loadImage(String.valueOf(this.skinDir) + "dguitar_16x16.png");
        this.setIconImage(imgIcon);
        LS.setIconImage(imgIcon);
        this.setExtendedState(6);
    }

    private void internalFrameAdd(JInternalFrame JIF) {
        String tit = JIF.getTitle();
        this.OpenedListAdd(tit);
        try {
            JIF.setSelected(true);
        }
        catch (PropertyVetoException pve) {
            this.showDialogOk("PropertyVetoException", String.valueOf(lang.getString("ERROR_EXCEPTION")) + "\n" + pve.getStackTrace().toString());
        }
        JIF.addInternalFrameListener(new DGInternalFrameListener(this));
        JIF.setFrameIcon(Clefs[1]);
        desktopPane.add(JIF);
        DGuitar.internalFrameLocate(JIF);
        JIF.setVisible(true);
    }

    private void loadCurrentSkin() {
        String currentSkin = DGuitar.nameForSkinIndex(currentSkinIndex);
        LS.log(String.valueOf(lang.getString("LoadCurrentSkin")) + ":" + currentSkin);
        boolean success = this.loadSkin(currentSkin);
        if (!success && !currentSkin.equalsIgnoreCase("default")) {
            this.errorSkin();
            success = this.loadSkin(currentSkin);
        }
        if (!success) {
            this.errorSkin();
            System.exit(1);
        }
    }

    private Image loadImage(String path) {
        Image img = null;
        File file = new File(path);
        boolean success = Util.validFile(file);
        if (success) {
            img = toolkit.getImage(path);
        } else {
            this.showDialogOk(lang.getString("File_is_not_valid"), Util.getError());
        }
        return img;
    }

    private boolean loadImages(String basePath, String baseName, int from, int to, Image[] img) {
        boolean success = true;
        int i = from;
        while (i <= to && success) {
            String currentPath = String.valueOf(basePath) + baseName + i + ".gif";
            img[i - 1] = this.loadImage(currentPath);
            success = img[i - 1] != null;
            ++i;
        }
        return success;
    }

    private boolean loadImages(String basePath, String baseName, int from, int to, ImageIcon[] ii) {
        boolean success = true;
        int i = from;
        while (i <= to && success) {
            String currentPath = String.valueOf(basePath) + baseName + i + ".gif";
            Image image = this.loadImage(currentPath);
            boolean bl = success = image != null;
            if (success) {
                ii[i - 1] = new ImageIcon(image);
            }
            ++i;
        }
        return success;
    }

    private PropertyResourceBundle loadLanguage(String pathToLangFolder, String language) {
        String path = String.valueOf(pathToLangFolder) + File.separator + "lang";
        PropertyResourceBundle resp = null;
        resp = this.loadPropertyResourceBundle(String.valueOf(path) + "_" + language);
        if (resp == null && (resp = this.loadPropertyResourceBundle(String.valueOf(path) + "_" + "en")) == null && (resp = this.loadPropertyResourceBundle(path)) == null) {
            this.showDialogOk("This ERROR happend", String.valueOf(path) + " " + "NOT FOUND");
        }
        return resp;
    }

    private PropertyResourceBundle loadPropertyResourceBundle(String path) {
        PropertyResourceBundle resp = null;
        try {
            FileInputStream f = new FileInputStream(String.valueOf(path) + ".properties");
            resp = new PropertyResourceBundle(f);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return resp;
    }

    public boolean loadSkin(String nameOfSkin) {
        boolean success = false;
        this.skinDir = String.valueOf(this.lauchPath) + "skins" + File.separator;
        Image img = this.loadImage(String.valueOf(this.skinDir) + "DGuitarLogo.gif");
        if (img != null) {
            Logo = new ImageIcon(img);
        } else {
            msg = "DGuitarLogo.gif" + lang.getString("ERROR_WAS_NOT_FOUND");
            System.err.println(msg);
        }
        this.skinPath = String.valueOf(this.skinDir) + nameOfSkin + File.separator;
        success = new File(this.skinPath).isDirectory();
        if (success) {
            LS.logNoNewLine("Loading: ");
            LS.logNoNewLine("Notes");
            this.loadImages(this.skinPath, "n", 1, 8, Notes);
            LS.logNoNewLine(",Clefs");
            this.loadImages(this.skinPath, "c", 1, 2, Clefs);
            LS.logNoNewLine(",Silences");
            this.loadImages(this.skinPath, "s", 1, 7, Silences);
            LS.logNoNewLine(",Dynamics");
            this.loadImages(this.skinPath, "d", 1, 8, Dynamics);
            LS.logNoNewLine(",Effects");
            this.loadImages(this.skinPath, "en", 1, EONs.length, EONs);
            LS.log(",Buttons");
            this.loadImages(this.skinPath, "b", 1, 2, Buttons);
        } else {
            msg = String.valueOf(lang.getString("The_path")) + " '" + this.skinPath + "' " + lang.getString("ERROR_WAS_NOT_FOUND");
        }
        if (success) {
            this.setSkinCheckBoxes();
        }
        return success;
    }

    private void switchLog() throws FileNotFoundException {
        boolean window = this.menuOptionsLogToWindow.isSelected();
        short type = this.menuOptionsLogToFile.isSelected() ? (window ? (short)2 : 1) : (window ? (short)3 : 0);
        LS.switchTo(type, lang.getString("DGUITAR_LOG_WINDOW"), closableLogWindow, LogWindowExits);
        DGO.setProperty("typeOfLog", "" + LS.getTypeOfLog());
        hasOptionsChanged = true;
    }

    public static String nameForSkinIndex(short index) {
        String resp = null;
        if (index >= 0 && index < arraySkinNames.length) {
            resp = arraySkinNames[index];
        }
        return resp;
    }

    private boolean performSkinChange(String newSkin) {
        boolean resp = false;
        if (newSkin != null && !newSkin.equals(DGuitar.nameForSkinIndex(currentSkinIndex))) {
            currentSkinIndex = DGuitar.getIndexForSkinName(newSkin);
            DGO.setProperty("skin", newSkin);
            this.loadSkin(newSkin);
            this.removeToolBars();
            this.addToolBars();
            this.setExtendedState(6);
            hasOptionsChanged = true;
            resp = true;
        }
        return resp;
    }

    private void detectSkins(JMenuItem jm) {
        if (buttonGroupSkin == null) {
            buttonGroupSkin = new ButtonGroup();
        }
        short countSkinFolders = 0;
        String tempSkin = null;
        while (countSkinFolders < 2) {
            if (countSkinFolders == 0) {
                tempSkin = new String("default");
            } else if (countSkinFolders == 1) {
                tempSkin = new String("compact");
            }
            DGuitar.arraySkinNames[countSkinFolders] = tempSkin;
            DGuitar.arraySkinCheckBoxes[countSkinFolders] = new JCheckBoxMenuItem(DGuitar.nameForSkinIndex(countSkinFolders));
            arraySkinCheckBoxes[countSkinFolders].addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    JCheckBoxMenuItem JCBMI = (JCheckBoxMenuItem)event.getSource();
                    String aux = JCBMI.getText();
                    DGuitar.this.performSkinChange(aux);
                }
            });
            buttonGroupSkin.add(arraySkinCheckBoxes[countSkinFolders]);
            jm.add(arraySkinCheckBoxes[countSkinFolders]);
            countSkinFolders = (short)(countSkinFolders + 1);
        }
    }

    private void setSkinCheckBoxes() {
        arraySkinCheckBoxes[currentSkinIndex].setSelected(true);
    }

    private void setLogCheckBoxes() {
        boolean logToFile = false;
        boolean logToWindow = false;
        if (LS.isFileType()) {
            logToFile = true;
        }
        if (LS.isWindowType()) {
            logToWindow = true;
        }
        this.menuOptionsLogToWindow.setSelected(logToWindow);
        this.menuOptionsLogToFile.setSelected(logToFile);
    }

    private void menuCreate() {
        desktopPane = new DGDesktopPane();
        this.menu = new JMenuBar();
        this.menuProgram = new JMenu();
        this.menuProgramOpenGP = new JMenuItem();
        this.menuProgramOpenMidi = new JMenuItem();
        this.menuProgramOpenURL = new JMenuItem();
        this.menuProgramNew = new JMenuItem();
        this.menuProgramStats = new JMenuItem();
        this.menuProgramExit = new JMenuItem();
        this.menuOptions = new JMenu();
        this.menuOptionsFileLocation = new JMenuItem();
        this.menuOptionsConfirmLoad = new JCheckBoxMenuItem();
        this.menuOptionsEvaluate = new JCheckBoxMenuItem();
        this.menuOptionsFastLoad = new JCheckBoxMenuItem();
        this.menuOptionsLanguage = new JMenu();
        this.menuOptionsLog = new JMenu();
        this.menuOptionsLogToFile = new JCheckBoxMenuItem();
        this.menuOptionsLogToWindow = new JCheckBoxMenuItem();
        this.setLogCheckBoxes();
        this.menuOptionsEnableUnfinishedFeatures = new JCheckBoxMenuItem();
        this.menuOptionsSkins = new JMenu();
        this.menuOptionsSaveCurrentSettings = new JMenuItem();
        this.menuOptionsReloadStoredSettings = new JMenuItem();
        this.menuWindows = new JMenu();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                DGuitar.this.formWindowClosing(evt);
            }
        });
        this.menuWindowsOperationsCount = 0;
        this.menuWindows.add(new JSeparator());
        ++this.menuWindowsOperationsCount;
        this.menuWindowsCascade = new JMenuItem();
        this.menuWindowsCascade.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                desktopPane.arrangeWindows(3, desktopPane.getAllFrames());
            }
        });
        this.menuWindows.add(this.menuWindowsCascade);
        ++this.menuWindowsOperationsCount;
        this.menuWindowsCloseAll = new JMenuItem();
        this.menuWindowsCloseAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DGuitar.this.closeAllWindows();
            }
        });
        this.menuWindows.add(new JSeparator());
        ++this.menuWindowsOperationsCount;
        this.menuWindows.add(this.menuWindowsCloseAll);
        ++this.menuWindowsOperationsCount;
        this.getContentPane().add((Component)desktopPane, "Center");
        this.menu.setBorder(null);
        this.menuProgramOpenGP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuOpenGPActionPerformed(evt);
            }
        });
        this.menuProgram.add(this.menuProgramOpenGP);
        this.menuProgramOpenMidi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuOpenMidiActionPerformed(evt);
            }
        });
        this.menuProgram.add(this.menuProgramOpenMidi);
        this.menuProgramOpenURL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuOpenURLActionPerformed(evt);
            }
        });
        this.menuProgram.add(this.menuProgramOpenURL);
        this.menuProgram.add(new JSeparator());
        this.menuProgramStats.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuStatsActionPerformed(evt);
            }
        });
        this.menuProgram.add(this.menuProgramStats);
        this.menuProgram.add(new JSeparator());
        this.menuProgramExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuExitActionPerformed(evt);
            }
        });
        this.menuProgram.add(this.menuProgramExit);
        this.menu.add(this.menuProgram);
        this.menuOptionsFileLocation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuOptionsFileLocationActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.menuOptionsFileLocation);
        this.menuOptionsConfirmLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuOptionsConfirmLoadActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.menuOptionsConfirmLoad);
        this.menuOptionsEvaluate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuOptionsEvaluateActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.menuOptionsEvaluate);
        this.menuOptionsFastLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.menuOptionsFastLoadActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.menuOptionsFastLoad);
        this.menuOptionsLogToFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    DGuitar.this.switchLog();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
        this.menuOptionsLog.add(this.menuOptionsLogToFile);
        this.menuOptionsLogToWindow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    DGuitar.this.switchLog();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        });
        this.menuOptionsLog.add(this.menuOptionsLogToWindow);
        this.menuOptions.add(this.menuOptionsLog);
        this.displayOptions = new DisplayOptions();
        this.detectSkins(this.menuOptionsSkins);
        this.menuOptions.add(this.menuOptionsSkins);
        menuOptionsForAllSongs = new SongOptionsMenu("menuDGOptionsForAllSongs");
        menuOptionsForAllSongs.setDisplayOptions(this.displayOptions);
        SongOptionsListener SOL = new SongOptionsListener(this, this);
        menuOptionsForAllSongs.setMenuIndexedListener(SOL);
        this.menuOptions.add(menuOptionsForAllSongs);
        this.menuOptions.add(new JSeparator());
        this.menuOptionsSaveCurrentSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DGuitar.this.preferencesStore();
                hasOptionsChanged = false;
            }
        });
        this.menuOptions.add(this.menuOptionsSaveCurrentSettings);
        this.menuOptionsReloadStoredSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    DGuitar.this.preferencesApply();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
                hasOptionsChanged = false;
            }
        });
        this.menuOptions.add(this.menuOptionsReloadStoredSettings);
        this.menuOptions.add(new JSeparator());
        this.configureMenuOptionsLanguage();
        this.menuOptions.add(this.menuOptionsLanguage);
        this.menuOptions.add(new JSeparator());
        this.menuOptionsEnableUnfinishedFeatures.setSelected(EnableUnfinishedFeatures);
        this.menuOptionsEnableUnfinishedFeatures.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EnableUnfinishedFeatures = !EnableUnfinishedFeatures;
                DGuitar.setEnableUnfinishedFeatures(EnableUnfinishedFeatures);
                DGO.setProperty("EnableUnfinishedFeatures", "" + EnableUnfinishedFeatures);
                hasOptionsChanged = true;
            }
        });
        this.menuOptions.add(this.menuOptionsEnableUnfinishedFeatures);
        this.menu.add(this.menuOptions);
        this.setJMenuBar(this.menu);
        this.menuWindows.setEnabled(false);
        this.addMenuMidi(this.menu);
        this.menu.add(this.menuWindows);
        this.addMenuAbout(this.menu);
        this.setLangText();
        this.pack();
    }

    private void menuExitActionPerformed(ActionEvent evt) {
        int result = 0;
        if (hasOptionsChanged) {
            result = JOptionPane.showConfirmDialog(this, lang.getString("msgSaveCurrentPreferences"));
        }
        if (result == 0) {
            this.preferencesStore();
        }
        if (result != 2) {
            this.close();
        }
    }

    private void setupMidi(boolean showDialog) {
        if (midi == null) {
            midi = new Midi(lang.getString("doesNotHaveAnyReceivers"));
            midi.selectFirstAvailableMidiDevice();
            if (showDialog) {
                Util.showDialogOk(this, lang.getString("currentMidiDeviceHasHeenConfigured"), midi.deviceMessage(lang.getString("MidiDevice"), lang.getString("isNowPreferredDevice")));
            }
        }
    }

    private void menuMidiDevicesActionPerformed() {
        this.setupMidi(true);
        if (midi != null) {
            MidiDevices MD = new MidiDevices(null, true, midi, lang.getString("midiDeviceConfigured"));
            if (MD != null) {
                MD.setVisible(true);
            } else {
                this.showDialogOk(lang.getString("ERORR_CREATING_MIDITEST_OBJECT"), lang.getString("ERROR_NO_MEMORY"));
            }
        } else {
            this.showDialogOk(lang.getString("ERROR_MIDI_INIT"), lang.getString("Take_a_look_a_the_DGuitar_log_window"));
        }
    }

    private void menuMidiTestActionPerformed() {
        this.setupMidi(true);
        if (midi != null) {
            MidiTest MT = new MidiTest(this, true);
            short attempts = MT.createMidiTestWindow(midi, Notes, Buttons[0]);
            if (attempts >= 0) {
                MT.setVisible(true);
            } else {
                attempts = (short)(-1 * attempts);
                String aux = "Devices found: " + attempts + "\n";
                aux = String.valueOf(aux) + "Devices with receivers:0";
                Util.showDialogOk(this, "Midi support failed for this computer", aux);
                midi.selectNextAvailableMidiDevice();
            }
        } else {
            this.showDialogOk(lang.getString("ERROR_MIDI_INIT"), lang.getString("Take_a_look_a_the_DGuitar_log_window"));
        }
    }

    private void menuOpenGPActionPerformed(ActionEvent evt) {
        this.currentFileType = 1;
        this.showFileChooserAndOpen();
    }

    private void menuOpenMidiActionPerformed(ActionEvent evt) {
        this.currentFileType = 2;
        this.showFileChooserAndOpen();
    }

    private void menuOpenRecentFilesActionPerformed(ActionEvent evt) {
        this.fileLoad(evt.getActionCommand());
    }

    private void menuOpenURLActionPerformed(ActionEvent evt) {
        String path = null;
        String pathIni = "http://www.mysongbook.com/files/c/clapt/Clapton%2C%20Eric%20-%20Tears%20In%20Heaven%20%282%29.gp4";
        Object o = DGuitar.showCustomInputDialog(this, lang.getString("Open_GP_file_from_the_Internet"), lang.getString("Paste_Type_URL"), true, pathIni);
        if (o.getClass().isInstance(pathIni)) {
            path = (String)o;
        } else {
            LS.println(String.valueOf(o.toString()) + " is a " + o.getClass().toString());
        }
        if (path != null && !o.equals(JOptionPane.UNINITIALIZED_VALUE)) {
            if (path.startsWith("http://") && gpFileFilter.accept(path)) {
                InputStream IS = null;
                String host = null;
                try {
                    try {
                        LS.println("Trying to open: " + path);
                        URL url = new URL(path);
                        host = url.getHost();
                        IS = url.openStream();
                        this.readAndShow(path, IS);
                    }
                    catch (MalformedURLException MUE) {
                        Util.showDialogOk(this, "Malformed URL" + host, MUE.getLocalizedMessage());
                    }
                    catch (UnknownHostException UHE) {
                        Util.showDialogOk(this, "Unknown host", String.valueOf(host) + " : was not found. Check address, connect to the internet or check DNS settings\n");
                    }
                    catch (IOException IOE) {
                        IOE.printStackTrace();
                    }
                }
                finally {
                    Util.closeIS(IS);
                }
            } else {
                String aux = "\"" + path + "\"";
                aux = String.valueOf(aux) + " must start with \"http://\" and end with \".gp4\",\".gp3\" or \".gtp\"";
                this.showDialogOk("please type a correct URL", aux);
            }
        }
    }

    private void menuOptionsConfirmLoadActionPerformed(ActionEvent evt) {
        this.confirmLoad = !this.confirmLoad;
        DGO.setProperty("ConfirmLoad", "" + this.confirmLoad);
        hasOptionsChanged = true;
    }

    private void menuOptionsEvaluateActionPerformed(ActionEvent evt) {
        this.evaluate = !this.evaluate;
        DGO.setProperty("EvaluatePerformance", "" + this.evaluate);
        hasOptionsChanged = true;
    }

    private void menuOptionsFastLoadActionPerformed(ActionEvent evt) {
        fastLoad = !fastLoad;
        DGO.setProperty("FastLoad", "" + fastLoad);
        hasOptionsChanged = true;
    }

    private void menuOptionsFileLocationActionPerformed(ActionEvent evt) {
        this.createFileChooser();
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setApproveButtonText(lang.getString("Select"));
        int val = this.fileChooser.showOpenDialog(this);
        if (val == 1) {
            return;
        }
        if (val == -1) {
            return;
        }
        File aux = this.fileChooser.getSelectedFile();
        if (!this.filePath.getAbsoluteFile().equals(aux.getAbsoluteFile())) {
            this.filePath = aux;
            this.hasPathChanged = true;
            this.setTitle(this.shortTitle());
            DGO.setProperty("FileLocation", this.filePath.getAbsolutePath());
            hasOptionsChanged = true;
        }
    }

    private void menuOptionsValuesUpdate() {
        this.menuOptionsConfirmLoad.setSelected(this.confirmLoad);
        this.menuOptionsEvaluate.setSelected(this.evaluate);
        this.menuOptionsFastLoad.setSelected(fastLoad);
        this.menuOptionsEnableUnfinishedFeatures.setSelected(EnableUnfinishedFeatures);
        this.setLogCheckBoxes();
        this.setSkinCheckBoxes();
        this.setTitle(this.shortTitle());
    }

    private void menuStatsActionPerformed(ActionEvent evt) {
        if (this.STstats == null) {
            this.STstats = new ScrollText();
            this.STstats.setEditable(false);
            this.STstats.setClosable(true, false);
        }
        if (this.hasPathChanged) {
            if (this.worker != null) {
                this.worker.interrupt();
            }
            this.STstats.setText(String.valueOf(lang.getString("pleaseWait")) + "....");
            this.STstats.setTitle(String.valueOf(lang.getString("Statistics")) + "-" + this.filePath.getAbsolutePath());
            final GPStats GS = new GPStats();
            final FolderIterator FI = new FolderIterator(GS);
            GS.setDetailed(false);
            FI.setStartingPath(this.filePath);
            FI.setFileFolderFilter(new FileFolderFilter(gpFileFilter));
            FI.setHowDeep(0);
            this.worker = new SwingWorker(){

                public Object construct() {
                    String aux = DGuitar.this.menuProgramStats.getText();
                    DGuitar.this.menuProgramStats.setEnabled(false);
                    DGuitar.this.menuProgramStats.setText(lang.getString("pleaseWait"));
                    FI.run();
                    DGuitar.this.STstats.setText(GS.getResults());
                    DGuitar.this.menuProgramStats.setText(aux);
                    DGuitar.this.menuProgramStats.setEnabled(true);
                    return null;
                }
            };
            this.worker.start();
            this.hasPathChanged = false;
        }
        this.STstats.setVisible(true);
    }

    private void OpenedListAdd(String file) {
        if (!this.menuWindows.isEnabled()) {
            this.menuWindows.setEnabled(true);
        }
        JMenuItem tempItem = new JMenuItem(Util.compactAndReadableURL(file, 100));
        tempItem.setActionCommand(file);
        tempItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                int max = desktopPane.getComponentCount();
                boolean found = false;
                int i = 0;
                while (!found && i < max) {
                    JInternalFrame JIF = desktopPane.getJIF(i);
                    if (JIF != null) {
                        if (JIF.getTitle().equals(cmd)) {
                            found = true;
                            try {
                                if (JIF.isIcon()) {
                                    JIF.setIcon(false);
                                }
                                JIF.setSelected(true);
                            }
                            catch (PropertyVetoException pve) {
                                DGuitar.this.showDialogOk(lang.getString("ERROR_EXCEPTION"), pve.getStackTrace().toString());
                            }
                        }
                    } else {
                        DGuitar.this.showDialogOk(lang.getString("Take_a_look_a_the_DGuitar_log_window"), msg);
                    }
                    ++i;
                }
            }
        });
        this.menuWindows.add((Component)tempItem, this.menuWindows.getItemCount() - this.menuWindowsOperationsCount);
        this.menuWindows.validate();
        this.files.addElement(file);
    }

    boolean OpenedListContains(String file) {
        boolean resp = this.files.contains(file);
        return resp;
    }

    public void OpenedListRemove(String file) {
        int pos = this.files.indexOf(file);
        if (pos >= 0) {
            this.menuWindows.remove(pos);
            this.menuWindows.validate();
            this.files.removeElement(file);
            if (this.files.size() == 0) {
                this.menuWindows.setEnabled(false);
            }
        }
    }

    private void preferencesApply() throws FileNotFoundException {
        DGO = new Properties();
        LS.log(lang.getString("applyPreferences"));
        this.preferencesLoad();
        this.preferencesUse();
    }

    private boolean preferencesLoad() {
        boolean success = false;
        try {
            FileInputStream FIS = new FileInputStream(this.DGpropertiesAbsolute);
            DGO.load(FIS);
            success = true;
            LS.print("'" + this.DGpropertiesAbsolute + "' " + lang.getString("File_SUCCESSFULLY_Loaded"));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return success;
    }

    private boolean preferencesStore() {
        boolean success = false;
        try {
            File f = new File(this.DGpropertiesAbsolute);
            if (!f.exists()) {
                f.createNewFile();
            }
            FileOutputStream FOS = new FileOutputStream(f);
            String aux = String.valueOf(DGuitar.version()) + " Properties file, dont delete any lines";
            DGO.store(FOS, aux);
            success = true;
            LS.print(String.valueOf(f.getAbsolutePath()) + " " + lang.getString("File_SUCCESSFULLY_Saved"));
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return success;
    }

    private static short getIndexForSkinName(String skn) {
        short resp = (short)(arraySkinNames.length - 1);
        boolean found = false;
        while (!found && resp >= 0) {
            if (!DGuitar.nameForSkinIndex(resp).equals(skn)) {
                resp = (short)(resp - 1);
                continue;
            }
            found = true;
        }
        return resp;
    }

    private void preferencesUse() throws FileNotFoundException {
        String pathFiles = this.getFilePath();
        String value = DGO.getProperty("FileLocation", pathFiles);
        this.filePath = new File(value);
        this.checkFileLocation();
        DGO.setProperty("FileLocation", this.filePath.getAbsolutePath());
        this.confirmLoad = this.booleanProperty("ConfirmLoad", "false");
        this.evaluate = this.booleanProperty("EvaluatePerformance", "true");
        fastLoad = this.booleanProperty("FastLoad", "false");
        EnableUnfinishedFeatures = this.booleanProperty("EnableUnfinishedFeatures", "false");
        DGuitar.setEnableUnfinishedFeatures(EnableUnfinishedFeatures);
        LS.switchTo(this.shortProperty("typeOfLog", (short)1), lang.getString("DGUITAR_LOG_WINDOW"), closableLogWindow, LogWindowExits);
        this.setLogCheckBoxes();
        String sknName = DGO.getProperty("skin", "compact");
        currentSkinIndex = DGuitar.getIndexForSkinName(sknName);
        DGO.setProperty("skin", sknName);
        this.menuOptionsValuesUpdate();
    }

    private static void setEnableUnfinishedFeatures(boolean enable) {
        menuOptionsForAllSongs.setVisible(enable);
    }

    private void readAndShow(String aFileName, InputStream IS) {
        GPInputStream GPIS = null;
        boolean success = false;
        SongInternalFrame SIF = new SongInternalFrame(aFileName, this, this.displayOptions, playToolBar);
        GPIS = new GPInputStream(IS);
        success = SIF.readAndDisplay(GPIS);
        if (success) {
            this.internalFrameAdd(SIF);
        } else {
            this.showDialogOk("SIF.readAndDisplay has FAILED", msg);
        }
        try {
            GPIS.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void refreshDisplayOptions() {
        SongActionParameters SAP = new SongActionParameters(3, false, this);
        SongAction.perform(desktopPane, SAP);
    }

    private void refreshLangText() {
        SongActionParameters SAP = new SongActionParameters(1);
        SongAction.perform(desktopPane, SAP);
    }

    private void determineLaunchPath() {
        this.lauchPath = new File("").getAbsolutePath();
        if (this.lauchPath.endsWith("dist")) {
            this.lauchPath = this.lauchPath.substring(0, this.lauchPath.length() - 4);
        }
        this.lauchPath = String.valueOf(this.lauchPath) + File.separator;
    }

    public void setLangText() {
        LS.setTitle(lang.getString("DGUITAR_LOG_WINDOW"));
        this.menuProgram.setText(lang.getString("menuDGProgram"));
        this.menuProgramOpenGP.setText(lang.getString("menuDGOpenGP"));
        this.menuProgramOpenMidi.setText(lang.getString("menuDGOpenMID"));
        this.menuProgramOpenURL.setText(lang.getString("menuDGOpenURL"));
        this.menuProgramNew.setText(lang.getString("menuProgramNew"));
        this.menuProgramStats.setText(lang.getString("menuDGDirStats"));
        this.menuProgramExit.setText(lang.getString("menuDGExit"));
        this.menuOptions.setText(lang.getString("menuDGOptions"));
        this.menuOptionsFileLocation.setText(lang.getString("menuDGOptionsFileLocation"));
        this.menuOptionsConfirmLoad.setText(lang.getString("menuDGOptionsConfirmLoad"));
        this.menuOptionsEvaluate.setText(lang.getString("menuDGOptionsEvaluate"));
        this.menuOptionsFastLoad.setText(lang.getString("menuDGOptionsFastLoad"));
        this.menuOptionsLanguage.setText(lang.getString("languages"));
        this.menuOptionsLog.setText(lang.getString("menuDGOptionsLog"));
        this.menuOptionsLogToFile.setText(lang.getString("menuDGOptionsLogToFile"));
        this.menuOptionsLogToWindow.setText(lang.getString("menuDGOptionsLogToWindow"));
        this.menuOptionsEnableUnfinishedFeatures.setText(lang.getString("menuDGOptionsEnabledUnfinishedFeatures"));
        this.menuOptionsSkins.setText(lang.getString("menuDGOptionsSkins"));
        this.menuOptionsSaveCurrentSettings.setText(lang.getString("menuDGSaveCurrentSettings"));
        this.menuOptionsReloadStoredSettings.setText(lang.getString("menuDGReloadStoredSettings"));
        menuOptionsForAllSongs.setLangText();
        this.menuWindows.setText(lang.getString("menuDGWindows"));
        this.menuWindowsCascade.setText(lang.getString("menuDGWindowsCascade"));
        this.menuWindowsCloseAll.setText(lang.getString("menuDGWindowsCloseAll"));
        this.menuMidiDevices.setText(lang.getString("menuMidiDevices"));
        this.menuMidiTest.setText(lang.getString("menuMidiTest"));
        this.menuMidi.setText(lang.getString("menuMidi"));
        this.menuAboutAuthors.setText(lang.getString("menuAboutAuthors"));
        this.menuAboutLicense.setText(lang.getString("menuAboutLicense"));
        this.menuAbout.setText(lang.getString("menuAbout"));
    }

    public String shortTitle() {
        return String.valueOf(DGuitar.version()) + " @ " + this.filePath.getAbsolutePath();
    }

    protected void showDialogOk(String title, Object message) {
        Util.showDialogOk(this, title, message);
    }

    public CodecFileFilter getCodecFileFilter() {
        CodecFileFilter resp = null;
        switch (this.currentFileType) {
            case 1: {
                resp = gpFileFilter;
                break;
            }
            case 2: {
                resp = midiFileFilter;
            }
        }
        return resp;
    }

    private void showFileChooserAndOpen() {
        this.createFileChooser();
        this.fileChooser.setCurrentDirectory(this.filePath);
        this.fileChooser.setFileSelectionMode(2);
        this.fileChooser.setApproveButtonText(lang.getString("Open"));
        this.fileChooser.setFileFilter(this.getCodecFileFilter());
        int val = this.fileChooser.showOpenDialog(this);
        if (val == 1) {
            return;
        }
        if (val == -1) {
            return;
        }
        File f = this.fileChooser.getSelectedFile();
        this.loadAndDisplay(f, false);
    }

    public void loadAndDisplay(File file, boolean checkExtension) {
        String aFileName = file.getName();
        if (!checkExtension || this.isSupportedExtension(aFileName)) {
            if (Util.validFile(file)) {
                aFileName = file.getAbsolutePath();
                JMenuItem recentJMI = new JMenuItem(aFileName);
                recentJMI.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        DGuitar.this.menuOpenRecentFilesActionPerformed(evt);
                    }
                });
                this.menuProgram.add((Component)recentJMI, 6 + contRecent);
                if (contRecent == 0) {
                    this.menuProgram.add((Component)new JSeparator(), 6 + contRecent + 1);
                }
                this.menuProgram.validate();
                ++contRecent;
                this.fileLoad(aFileName);
            } else {
                this.showDialogOk(lang.getString("File_is_not_valid"), Util.getError());
            }
        } else {
            System.err.println("File Extension is not supported:" + aFileName);
        }
    }

    void showMessageAlreadyOpen(String aFileName) {
        String message = "\n" + lang.getString("File") + " '" + aFileName + "' " + lang.getString("already_open");
        this.showDialogOk(String.valueOf(lang.getString("File")) + " " + lang.getString("already_open"), message);
    }

    private void showTextFile(String title, String file, boolean scroll, int w, int h) {
        if (scroll) {
            ScrollText ST = new ScrollText("");
            ST.setTitle(title);
            ST.displayFile(file);
            ST.setBounds((DGuitar.screenSize.width - w) / 2, 50, w, h);
            ST.setSTPColor(Color.WHITE);
            ST.setClosable(true, false);
            ST.setVisible(true);
        } else {
            ScrollTextPanel STP = new ScrollTextPanel();
            STP.displayFile(file);
            this.showDialogOk(title, STP);
        }
    }

    private void addDropSupport() {
        ADropTargetListener DTL = new ADropTargetListener(this);
        DropTarget DT = new DropTarget(this, DTL);
        DT.toString();
    }

    public void setDisplayOptions(DisplayOptions displayOptions) {
        this.displayOptions = displayOptions;
        this.refreshDisplayOptions();
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    static /* synthetic */ boolean access$24() {
        return hasOptionsChanged;
    }
}

