/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.toolchain.internal.gcc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.SimpleWorkResult;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.operations.BuildOperation;
import org.gradle.internal.operations.BuildOperationProcessor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.BuildOperationWorker;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.internal.SharedLibraryLinkerSpec;
import org.gradle.nativeplatform.platform.OperatingSystem;
import org.gradle.nativeplatform.toolchain.internal.ArgsTransformer;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolContext;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocation;
import org.gradle.nativeplatform.toolchain.internal.CommandLineToolInvocationWorker;
import org.gradle.nativeplatform.toolchain.internal.gcc.GccOptionsFileArgsWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class GccLinker
implements Compiler<LinkerSpec> {
    private final CommandLineToolInvocationWorker commandLineToolInvocationWorker;
    private final ArgsTransformer<LinkerSpec> argsTransformer;
    private final CommandLineToolContext invocationContext;
    private final boolean useCommandFile;
    private final BuildOperationProcessor buildOperationProcessor;

    GccLinker(BuildOperationProcessor buildOperationProcessor, CommandLineToolInvocationWorker commandLineToolInvocationWorker, CommandLineToolContext invocationContext, boolean useCommandFile) {
        this.buildOperationProcessor = buildOperationProcessor;
        this.argsTransformer = new GccLinkerArgsTransformer();
        this.invocationContext = invocationContext;
        this.useCommandFile = useCommandFile;
        this.commandLineToolInvocationWorker = commandLineToolInvocationWorker;
    }

    public WorkResult execute(final LinkerSpec spec) {
        List args = (List)this.argsTransformer.transform(spec);
        this.invocationContext.getArgAction().execute((Object)args);
        if (this.useCommandFile) {
            new GccOptionsFileArgsWriter(spec.getTempDir()).execute(args);
        }
        final CommandLineToolInvocation invocation = this.invocationContext.createInvocation("linking " + spec.getOutputFile().getName(), args, spec.getOperationLogger());
        this.buildOperationProcessor.run((BuildOperationWorker)this.commandLineToolInvocationWorker, (Action)new Action<BuildOperationQueue<CommandLineToolInvocation>>(){

            public void execute(BuildOperationQueue<CommandLineToolInvocation> buildQueue) {
                buildQueue.setLogLocation(spec.getOperationLogger().getLogLocation());
                buildQueue.add((BuildOperation)invocation);
            }
        });
        return new SimpleWorkResult(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GccLinkerArgsTransformer
    implements ArgsTransformer<LinkerSpec> {
        private GccLinkerArgsTransformer() {
        }

        public List<String> transform(LinkerSpec spec) {
            ArrayList<String> args = new ArrayList<String>();
            args.addAll(spec.getSystemArgs());
            if (spec instanceof SharedLibraryLinkerSpec) {
                args.add("-shared");
                this.maybeSetInstallName((SharedLibraryLinkerSpec)spec, args);
            }
            args.add("-o");
            args.add(spec.getOutputFile().getAbsolutePath());
            for (File file : spec.getObjectFiles()) {
                args.add(file.getAbsolutePath());
            }
            for (File file : spec.getLibraries()) {
                args.add(file.getAbsolutePath());
            }
            if (!spec.getLibraryPath().isEmpty()) {
                throw new UnsupportedOperationException("Library Path not yet supported on GCC");
            }
            for (String userArg : spec.getArgs()) {
                args.add(userArg);
            }
            return args;
        }

        private void maybeSetInstallName(SharedLibraryLinkerSpec spec, List<String> args) {
            String installName = spec.getInstallName();
            OperatingSystem targetOs = spec.getTargetPlatform().getOperatingSystem();
            if (installName == null || targetOs.isWindows()) {
                return;
            }
            if (targetOs.isMacOsX()) {
                args.add("-Wl,-install_name," + installName);
            } else {
                args.add("-Wl,-soname," + installName);
            }
        }
    }
}

