/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.gradle.api.Transformer;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.connection.ModelResult;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.connection.DefaultFailedModelResult;
import org.gradle.tooling.internal.connection.DefaultModelResult;
import org.gradle.tooling.internal.connection.DefaultProjectIdentifier;
import org.gradle.tooling.internal.consumer.ExceptionTransformer;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ModelProducer;
import org.gradle.tooling.internal.consumer.connection.MultiModelProducer;
import org.gradle.tooling.internal.consumer.parameters.BuildCancellationTokenAdapter;
import org.gradle.tooling.internal.consumer.parameters.ConsumerOperationParameters;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalCompositeAwareConnection;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.internal.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeAwareModelProducer
extends HasCompatibilityMapping
implements MultiModelProducer {
    private final ModelProducer delegate;
    private final ProtocolToModelAdapter adapter;
    private final VersionDetails versionDetails;
    private final ModelMapping modelMapping;
    private final InternalCompositeAwareConnection connection;
    private final Transformer<RuntimeException, RuntimeException> exceptionTransformer;

    public CompositeAwareModelProducer(ModelProducer delegate, ProtocolToModelAdapter adapter, VersionDetails versionDetails, ModelMapping modelMapping, InternalCompositeAwareConnection connection, Transformer<RuntimeException, RuntimeException> exceptionTransformer) {
        super(versionDetails);
        this.delegate = delegate;
        this.adapter = adapter;
        this.versionDetails = versionDetails;
        this.modelMapping = modelMapping;
        this.connection = connection;
        this.exceptionTransformer = exceptionTransformer;
    }

    @Override
    public <T> T produceModel(Class<T> type, ConsumerOperationParameters operationParameters) {
        return this.delegate.produceModel(type, operationParameters);
    }

    @Override
    public <T> Iterable<ModelResult<T>> produceModels(Class<T> elementType, ConsumerOperationParameters operationParameters) {
        BuildResult<?> result = this.buildModels(elementType, operationParameters);
        CompositeExceptionTransformer exceptionTransformer = new CompositeExceptionTransformer(elementType);
        if (result.getModel() instanceof List) {
            LinkedList<ModelResult<T>> models = new LinkedList<ModelResult<T>>();
            List resultMap = (List)result.getModel();
            for (Object modelValueTriple : resultMap) {
                Object[] t = (Object[])modelValueTriple;
                DefaultProjectIdentifier projectIdentifier = new DefaultProjectIdentifier((File)t[0], (String)t[1]);
                Object modelValue = t[2];
                if (modelValue instanceof Throwable) {
                    GradleConnectionException failure = ((ExceptionTransformer)exceptionTransformer).transform((Throwable)modelValue);
                    models.add(new DefaultFailedModelResult(projectIdentifier, failure));
                    continue;
                }
                T modelResult = this.adapter.adapt(elementType, modelValue, this.getCompatibilityMapping(projectIdentifier));
                models.add(new DefaultModelResult<T>(modelResult));
            }
            return models;
        }
        throw new UnsupportedOperationException(String.format("Produced result of type %s for model %s", result.getModel().getClass().getCanonicalName(), elementType.getCanonicalName()));
    }

    private <T> BuildResult<?> buildModels(Class<T> type, ConsumerOperationParameters operationParameters) {
        BuildResult<?> result;
        if (!this.versionDetails.maySupportModel(type)) {
            throw Exceptions.unsupportedModel(type, this.versionDetails.getVersion());
        }
        ModelIdentifier modelIdentifier = this.modelMapping.getModelIdentifierFromModelType(type);
        try {
            result = this.connection.getModels(modelIdentifier, new BuildCancellationTokenAdapter(operationParameters.getCancellationToken()), operationParameters);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(type, e);
        }
        catch (RuntimeException e) {
            throw (RuntimeException)this.exceptionTransformer.transform((Object)e);
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CompositeExceptionTransformer
    extends ExceptionTransformer {
        private final Class<?> modelType;

        public CompositeExceptionTransformer(Class<?> modelType) {
            super(CompositeExceptionTransformer.createConnectionTransformer(modelType));
            this.modelType = modelType;
        }

        @Override
        public GradleConnectionException transform(Throwable failure) {
            if (failure instanceof InternalUnsupportedModelException) {
                return Exceptions.unknownModel(this.modelType, (InternalUnsupportedModelException)failure);
            }
            return super.transform(failure);
        }

        private static Transformer<String, Throwable> createConnectionTransformer(final Class<?> type) {
            return new Transformer<String, Throwable>(){

                public String transform(Throwable throwable) {
                    return String.format("Could not fetch models of type '%s' using Gradle daemon composite connection.", type.getSimpleName());
                }
            };
        }
    }
}

