/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ide.internal.tooling.eclipse;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.api.plugins.WarPlugin;
import org.gradle.plugins.ear.Ear;
import org.gradle.plugins.ear.EarPlugin;
import org.gradle.plugins.ide.eclipse.EclipseWtpPlugin;
import org.gradle.plugins.ide.eclipse.model.EclipseModel;
import org.gradle.plugins.ide.eclipse.model.EclipseWtp;
import org.gradle.plugins.ide.eclipse.model.EclipseWtpComponent;
import org.gradle.plugins.ide.internal.IdeDependenciesExtractor;
import org.gradle.plugins.ide.internal.resolver.model.IdeExtendedRepoFileDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultClasspathAttribute;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseExternalDependency;
import org.gradle.plugins.ide.internal.tooling.eclipse.DefaultEclipseProjectDependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EclipseWtpSupport {
    private static final String ATTRIBUTE_WTP_DEPLOYED = "org.eclipse.jst.component.dependency";
    private static final String ATTRIBUTE_WTP_NONDEPLOYED = "org.eclipse.jst.component.nondependency";
    private static final String DEFAULT_DEPLOY_DIR_NAME = "/WEB-INF/lib";

    public static void applyEclipseWtpPluginOnWebProjects(Project root) {
        Set allProjects = root.getAllprojects();
        for (Project p : allProjects) {
            if (!EclipseWtpSupport.isWebProject(p)) continue;
            p.getPluginManager().apply(EclipseWtpPlugin.class);
        }
    }

    private static boolean isWebProject(Project project) {
        PluginContainer container = project.getPlugins();
        return container.hasPlugin(WarPlugin.class) || container.hasPlugin(EarPlugin.class) || container.hasPlugin(EclipseWtpPlugin.class);
    }

    public static void enhanceProject(Project project, List<DefaultEclipseProjectDependency> projectDependencies, List<DefaultEclipseExternalDependency> externalDependencies) {
        if (EclipseWtpSupport.isWebProject(project)) {
            EclipseWtp eclipseWtp = ((EclipseModel)((Object)project.getExtensions().findByType(EclipseModel.class))).getWtp();
            boolean isUtilityProject = !project.getPlugins().hasPlugin(WarPlugin.class) && !project.getPlugins().hasPlugin(EarPlugin.class);
            Ear ear = (Ear)project.getTasks().findByName("ear");
            String libDirName = ear == null ? DEFAULT_DEPLOY_DIR_NAME : ear.getLibDirName();
            IdeDependenciesExtractor depsExtractor = new IdeDependenciesExtractor();
            EclipseWtpComponent wtpComponent = eclipseWtp.getComponent();
            Set<Configuration> rootConfigs = wtpComponent.getRootConfigurations();
            Set<Configuration> libConfigs = wtpComponent.getLibConfigurations();
            Set<Configuration> minusConfigs = wtpComponent.getMinusConfigurations();
            WtpClasspathAttributeSupport wtpSupport = new WtpClasspathAttributeSupport(depsExtractor, isUtilityProject, libDirName, rootConfigs, libConfigs, minusConfigs);
            wtpSupport.defineAttributesForProjectDependencies(projectDependencies);
            wtpSupport.defineAttributesForExternalDependencies(externalDependencies);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WtpClasspathAttributeSupport {
        private final String libDirName;
        private final boolean isUtilityProject;
        private final Set<ModuleVersionIdentifier> rootConfigModuleVersions;
        private final Set<ModuleVersionIdentifier> libConfigModuleVersions;

        private WtpClasspathAttributeSupport(IdeDependenciesExtractor depsExtractor, boolean isUtilityProject, String libDirName, Set<Configuration> rootConfigs, Set<Configuration> libConfigs, Set<Configuration> minusConfigs) {
            this.isUtilityProject = isUtilityProject;
            this.libDirName = libDirName;
            this.rootConfigModuleVersions = this.collectModuleVersions(depsExtractor, rootConfigs, minusConfigs);
            this.libConfigModuleVersions = this.collectModuleVersions(depsExtractor, libConfigs, minusConfigs);
        }

        private Set<ModuleVersionIdentifier> collectModuleVersions(IdeDependenciesExtractor depsExtractor, Set<Configuration> configs, Set<Configuration> minusConfigs) {
            Collection<IdeExtendedRepoFileDependency> dependencies = depsExtractor.resolvedExternalDependencies(configs, minusConfigs);
            HashSet<ModuleVersionIdentifier> result = new HashSet<ModuleVersionIdentifier>();
            for (IdeExtendedRepoFileDependency dependency : dependencies) {
                dependency.getId();
                result.add(dependency.getId());
            }
            return result;
        }

        public void defineAttributesForProjectDependencies(List<DefaultEclipseProjectDependency> projectDependencies) {
            for (DefaultEclipseProjectDependency dependency : projectDependencies) {
                dependency.getClasspathAttributes().add(new DefaultClasspathAttribute(EclipseWtpSupport.ATTRIBUTE_WTP_NONDEPLOYED, ""));
            }
        }

        public void defineAttributesForExternalDependencies(List<DefaultEclipseExternalDependency> externalDependencies) {
            for (DefaultEclipseExternalDependency dependency : externalDependencies) {
                this.defineAttributesForExternalDependency(dependency);
            }
        }

        private void defineAttributesForExternalDependency(DefaultEclipseExternalDependency dependency) {
            DefaultClasspathAttribute classpathAttribute = this.createDeploymentAttributeFor(dependency);
            dependency.getClasspathAttributes().add(classpathAttribute);
        }

        private DefaultClasspathAttribute createDeploymentAttributeFor(DefaultEclipseExternalDependency dependency) {
            ModuleVersionIdentifier moduleVersion;
            if (!this.isUtilityProject && (moduleVersion = dependency.getModuleVersionIdentifier()) != null) {
                if (this.rootConfigModuleVersions.contains(moduleVersion)) {
                    return new DefaultClasspathAttribute(EclipseWtpSupport.ATTRIBUTE_WTP_DEPLOYED, "/");
                }
                if (this.libConfigModuleVersions.contains(moduleVersion)) {
                    return new DefaultClasspathAttribute(EclipseWtpSupport.ATTRIBUTE_WTP_DEPLOYED, this.libDirName);
                }
            }
            return new DefaultClasspathAttribute(EclipseWtpSupport.ATTRIBUTE_WTP_NONDEPLOYED, "");
        }
    }
}

