/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.play.internal.toolchain;

import java.util.List;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.tasks.compile.daemon.CompilerDaemonManager;
import org.gradle.internal.text.TreeFormatter;
import org.gradle.language.base.internal.compile.CompileSpec;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.play.internal.javascript.GoogleClosureCompiler;
import org.gradle.play.internal.routes.RoutesCompilerFactory;
import org.gradle.play.internal.toolchain.DefaultPlayToolProvider;
import org.gradle.play.internal.toolchain.PlayToolChainInternal;
import org.gradle.play.internal.toolchain.PlayToolProvider;
import org.gradle.play.internal.twirl.TwirlCompilerFactory;
import org.gradle.play.platform.PlayPlatform;
import org.gradle.process.internal.worker.WorkerProcessFactory;
import org.gradle.util.CollectionUtils;
import org.gradle.util.TreeVisitor;

public class DefaultPlayToolChain
implements PlayToolChainInternal {
    private FileResolver fileResolver;
    private CompilerDaemonManager compilerDaemonManager;
    private final ConfigurationContainer configurationContainer;
    private final DependencyHandler dependencyHandler;
    private final WorkerProcessFactory workerProcessBuilderFactory;

    public DefaultPlayToolChain(FileResolver fileResolver, CompilerDaemonManager compilerDaemonManager, ConfigurationContainer configurationContainer, DependencyHandler dependencyHandler, WorkerProcessFactory workerProcessBuilderFactory) {
        this.fileResolver = fileResolver;
        this.compilerDaemonManager = compilerDaemonManager;
        this.configurationContainer = configurationContainer;
        this.dependencyHandler = dependencyHandler;
        this.workerProcessBuilderFactory = workerProcessBuilderFactory;
    }

    public String getName() {
        return "PlayToolchain";
    }

    public String getDisplayName() {
        return "Default Play Toolchain";
    }

    public PlayToolProvider select(PlayPlatform targetPlatform) {
        try {
            Set twirlClasspath = this.resolveToolClasspath(TwirlCompilerFactory.createAdapter(targetPlatform).getDependencyNotation()).resolve();
            Set routesClasspath = this.resolveToolClasspath(RoutesCompilerFactory.createAdapter(targetPlatform).getDependencyNotation()).resolve();
            Set javascriptClasspath = this.resolveToolClasspath(GoogleClosureCompiler.getDependencyNotation()).resolve();
            return new DefaultPlayToolProvider(this.fileResolver, this.compilerDaemonManager, this.workerProcessBuilderFactory, targetPlatform, twirlClasspath, routesClasspath, javascriptClasspath);
        }
        catch (ResolveException e) {
            return new UnavailablePlayToolProvider((Exception)((Object)e));
        }
    }

    private Configuration resolveToolClasspath(Object ... dependencyNotations) {
        List dependencies = CollectionUtils.collect((Object[])dependencyNotations, (Transformer)new Transformer<Dependency, Object>(){

            public Dependency transform(Object dependencyNotation) {
                return DefaultPlayToolChain.this.dependencyHandler.create(dependencyNotation);
            }
        });
        Dependency[] dependenciesArray = dependencies.toArray(new Dependency[0]);
        return this.configurationContainer.detachedConfiguration(dependenciesArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnavailablePlayToolProvider
    implements PlayToolProvider {
        private final Exception exception;

        public UnavailablePlayToolProvider(Exception exception) {
            this.exception = exception;
        }

        public <T extends CompileSpec> Compiler<T> newCompiler(Class<T> spec) {
            throw this.failure();
        }

        public <T> T get(Class<T> toolType) {
            throw this.failure();
        }

        public boolean isAvailable() {
            return false;
        }

        private RuntimeException failure() {
            TreeFormatter formatter = new TreeFormatter();
            this.explain((TreeVisitor<? super String>)formatter);
            return new GradleException(formatter.toString());
        }

        public void explain(TreeVisitor<? super String> visitor) {
            visitor.node((Object)"Cannot provide Play tool provider");
            visitor.startChildren();
            visitor.node((Object)this.exception.getCause().getMessage());
            visitor.endChildren();
        }
    }
}

