/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.foundation.output;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.foundation.output.FileLink;
import org.gradle.foundation.output.FileLinkDefinitionLord;
import org.gradle.foundation.output.OutputParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveOutputParser {
    private OutputParser parser;
    private List<FileLink> fileLinks = new ArrayList<FileLink>();
    private StringBuilder totalTextToParse = new StringBuilder();
    private int lastNewline;

    public LiveOutputParser(FileLinkDefinitionLord fileLinkDefinitionLord, boolean verifyFileExists) {
        this.parser = new OutputParser(fileLinkDefinitionLord, verifyFileExists);
    }

    public void reset() {
        boolean verifyFileExists = this.parser.isVerifyFileExists();
        FileLinkDefinitionLord fileLinkDefinitionLord = this.parser.getFileLinkDefinitionLord();
        this.parser = new OutputParser(fileLinkDefinitionLord, verifyFileExists);
        this.lastNewline = 0;
        this.totalTextToParse.setLength(0);
        this.fileLinks.clear();
    }

    public List<FileLink> appendText(String text) {
        int oldTotalSize = this.totalTextToParse.length();
        this.totalTextToParse.append(text);
        int indexOfNewline = text.lastIndexOf(10);
        if (indexOfNewline == -1) {
            return Collections.emptyList();
        }
        String textToParse = this.totalTextToParse.substring(this.lastNewline, indexOfNewline += oldTotalSize);
        List<FileLink> subFileLinks = this.parser.parseText(textToParse);
        for (FileLink fileLink : subFileLinks) {
            fileLink.move(this.lastNewline);
        }
        this.fileLinks.addAll(subFileLinks);
        this.lastNewline = indexOfNewline;
        return subFileLinks;
    }

    public List<FileLink> getFileLinks() {
        return Collections.unmodifiableList(this.fileLinks);
    }

    public FileLink getFileLink(int index) {
        if (index < 0 || index >= this.totalTextToParse.length()) {
            return null;
        }
        for (FileLink fileLink : this.fileLinks) {
            if (fileLink.getStartingIndex() > index || fileLink.getEndingIndex() < index) continue;
            return fileLink;
        }
        return null;
    }

    public String getText() {
        return this.totalTextToParse.toString();
    }

    public FileLink getPreviousFileLink(int caretLocation) {
        if (this.fileLinks.isEmpty()) {
            return null;
        }
        for (int index = this.fileLinks.size() - 1; index >= 0; --index) {
            FileLink fileLink = this.fileLinks.get(index);
            if (fileLink.getEndingIndex() >= caretLocation) continue;
            return fileLink;
        }
        return this.fileLinks.get(this.fileLinks.size() - 1);
    }

    public FileLink getNextFileLink(int caretLocation) {
        if (this.fileLinks.isEmpty()) {
            return null;
        }
        for (FileLink fileLink : this.fileLinks) {
            if (fileLink.getStartingIndex() <= caretLocation) continue;
            return fileLink;
        }
        return this.fileLinks.get(0);
    }
}

