/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.util;

import groovyx.gpars.AsyncFun;
import groovyx.gpars.GParsPoolUtil;
import groovyx.gpars.util.ASTUtils;
import java.util.Arrays;
import java.util.Collection;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class AsyncFunASTTransformation
implements ASTTransformation {
    private static final ClassNode MY_TYPE = ClassHelper.make(AsyncFun.class);

    public void visit(ASTNode[] nodes, SourceUnit source) {
        AsyncFunASTTransformation.init(nodes);
        AnnotatedNode fieldNode = (AnnotatedNode)nodes[1];
        AnnotationNode annotation = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals((Object)annotation.getClassNode()) || !(fieldNode instanceof FieldNode)) {
            return;
        }
        Collection values = annotation.getMembers().values();
        Expression value = values.isEmpty() ? null : (Expression)values.iterator().next();
        Object classExpression = value != null && value instanceof ClassExpression ? value : new ClassExpression(ClassHelper.make(GParsPoolUtil.class));
        AsyncFunASTTransformation.validatePoolClass(classExpression, fieldNode, source);
        Expression initExpression = ((FieldNode)fieldNode).getInitialValueExpression();
        ConstantExpression blocking = new ConstantExpression((Object)AsyncFunASTTransformation.memberHasValue(annotation, "blocking", true));
        StaticMethodCallExpression newInitExpression = new StaticMethodCallExpression(classExpression.getType(), "asyncFun", (Expression)new ArgumentListExpression(initExpression, (Expression)blocking));
        ((FieldNode)fieldNode).setInitialValueExpression((Expression)newInitExpression);
    }

    private static void validatePoolClass(Expression classExpression, AnnotatedNode fieldNode, SourceUnit source) {
        Parameter[] parameters = new Parameter[]{new Parameter(ClassHelper.CLOSURE_TYPE, "a1"), new Parameter(ClassHelper.boolean_TYPE, "a2")};
        MethodNode asyncFunMethod = classExpression.getType().getMethod("asyncFun", parameters);
        if (asyncFunMethod == null || !asyncFunMethod.isStatic()) {
            ASTUtils.addError("Supplied pool class has no static asyncFun(Closure, boolean) method", (ASTNode)fieldNode, source);
        }
    }

    private static void init(ASTNode[] nodes) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            throw new GroovyBugError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes));
        }
    }

    private static boolean memberHasValue(AnnotationNode node, String name, Object value) {
        Expression member = node.getMember(name);
        return member != null && member instanceof ConstantExpression && ((ConstantExpression)member).getValue() == value;
    }
}

