/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.instructions;

import com.android.dx.io.instructions.DecodedInstruction;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.utils.InsnUtils;

public class ArithNode
extends InsnNode {
    private final ArithOp op;

    public ArithNode(DecodedInstruction insn, ArithOp op, ArgType type, boolean literal) {
        super(InsnType.ARITH, 2);
        this.op = op;
        this.setResult(InsnArg.reg(insn, 0, type));
        int rc = insn.getRegisterCount();
        if (literal) {
            if (rc == 1) {
                this.addReg(insn, 0, type);
                this.addLit(insn, type);
            } else if (rc == 2) {
                this.addReg(insn, 1, type);
                this.addLit(insn, type);
            }
        } else if (rc == 2) {
            this.addReg(insn, 0, type);
            this.addReg(insn, 1, type);
        } else if (rc == 3) {
            this.addReg(insn, 1, type);
            this.addReg(insn, 2, type);
        }
        assert (this.getArgsCount() == 2);
    }

    public ArithNode(ArithOp op, RegisterArg res, InsnArg a, InsnArg b) {
        super(InsnType.ARITH, 2);
        this.op = op;
        this.setResult(res);
        this.addArg(a);
        this.addArg(b);
    }

    public ArithNode(ArithOp op, RegisterArg res, InsnArg a) {
        this(op, res, res, a);
        this.add(AFlag.ARITH_ONEARG);
    }

    public ArithOp getOp() {
        return this.op;
    }

    @Override
    public boolean isSame(InsnNode obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ArithNode) || !super.isSame(obj)) {
            return false;
        }
        ArithNode other = (ArithNode)obj;
        return this.op == other.op;
    }

    @Override
    public String toString() {
        return InsnUtils.formatOffset(this.offset) + ": " + InsnUtils.insnTypeToString(this.insnType) + this.getResult() + " = " + this.getArg(0) + " " + this.op.getSymbol() + " " + this.getArg(1);
    }
}

