/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.LoopInfo;
import jadx.core.dex.attributes.nodes.LoopLabelAttr;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.SwitchNode;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.Edge;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.Region;
import jadx.core.dex.regions.SwitchRegion;
import jadx.core.dex.regions.SynchronizedRegion;
import jadx.core.dex.regions.conditions.IfInfo;
import jadx.core.dex.regions.conditions.IfRegion;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.trycatch.ExcHandlerAttr;
import jadx.core.dex.trycatch.ExceptionHandler;
import jadx.core.dex.trycatch.SplitterBlockAttr;
import jadx.core.dex.trycatch.TryCatchBlock;
import jadx.core.dex.visitors.regions.IfMakerHelper;
import jadx.core.dex.visitors.regions.RegionStack;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.ErrorsCounter;
import jadx.core.utils.InstructionRemover;
import jadx.core.utils.RegionUtils;
import jadx.core.utils.exceptions.JadxOverflowException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionMaker {
    private static final Logger LOG = LoggerFactory.getLogger(RegionMaker.class);
    private static final int REGIONS_LIMIT = 1000000;
    private final MethodNode mth;
    private BitSet processedBlocks;
    private int regionsCount;
    private final Set<BlockNode> cacheSet = new HashSet<BlockNode>();

    public RegionMaker(MethodNode mth) {
        this.mth = mth;
    }

    public Region makeRegion(BlockNode startBlock, RegionStack stack) {
        ++this.regionsCount;
        if (this.regionsCount > 1000000) {
            throw new JadxOverflowException("Regions count limit reached");
        }
        Region r = new Region(stack.peekRegion());
        BlockNode next = startBlock;
        while (next != null) {
            next = this.traverse(r, next, stack);
        }
        return r;
    }

    private BlockNode traverse(IRegion r, BlockNode block, RegionStack stack) {
        BlockNode next = null;
        boolean processed = false;
        List loops = block.getAll(AType.LOOP);
        int loopCount = loops.size();
        if (loopCount != 0 && block.contains(AFlag.LOOP_START)) {
            if (loopCount == 1) {
                next = this.processLoop(r, (LoopInfo)loops.get(0), stack);
                processed = true;
            } else {
                for (LoopInfo loop : loops) {
                    if (loop.getStart() != block) continue;
                    next = this.processLoop(r, loop, stack);
                    processed = true;
                    break;
                }
            }
        }
        if (!processed && block.getInstructions().size() == 1) {
            InsnNode insn = block.getInstructions().get(0);
            switch (insn.getType()) {
                case IF: {
                    next = this.processIf(r, block, (IfNode)insn, stack);
                    processed = true;
                    break;
                }
                case SWITCH: {
                    next = this.processSwitch(r, block, (SwitchNode)insn, stack);
                    processed = true;
                    break;
                }
                case MONITOR_ENTER: {
                    next = this.processMonitorEnter(r, block, insn, stack);
                    processed = true;
                    break;
                }
            }
        }
        if (!processed) {
            r.getSubBlocks().add(block);
            next = BlockUtils.getNextBlock(block);
        }
        if (next != null && !stack.containsExit(block) && !stack.containsExit(next)) {
            return next;
        }
        return null;
    }

    private BlockNode processLoop(IRegion curRegion, LoopInfo loop, RegionStack stack) {
        BlockNode out;
        BlockNode loopExit;
        BlockNode loopStart = loop.getStart();
        Set<BlockNode> exitBlocksSet = loop.getExitNodes();
        ArrayList<BlockNode> exitBlocks = new ArrayList<BlockNode>(exitBlocksSet.size());
        BlockNode nextStart = BlockUtils.getNextBlock(loopStart);
        if (nextStart != null && exitBlocksSet.remove(nextStart)) {
            exitBlocks.add(nextStart);
        }
        if (exitBlocksSet.remove(loopStart)) {
            exitBlocks.add(loopStart);
        }
        if (exitBlocksSet.remove(loop.getEnd())) {
            exitBlocks.add(loop.getEnd());
        }
        exitBlocks.addAll(exitBlocksSet);
        LoopRegion loopRegion = this.makeLoopRegion(curRegion, loop, exitBlocks);
        if (loopRegion == null) {
            BlockNode exit = this.makeEndlessLoop(curRegion, stack, loop, loopStart);
            RegionMaker.insertContinue(loop);
            return exit;
        }
        curRegion.getSubBlocks().add(loopRegion);
        IRegion outerRegion = stack.peekRegion();
        stack.push(loopRegion);
        IfInfo condInfo = IfMakerHelper.makeIfInfo(loopRegion.getHeader());
        condInfo = IfMakerHelper.searchNestedIf(condInfo);
        IfMakerHelper.confirmMerge(condInfo);
        if (!loop.getLoopBlocks().contains(condInfo.getThenBlock())) {
            condInfo = IfInfo.invert(condInfo);
        }
        loopRegion.setCondition(condInfo.getCondition());
        exitBlocks.removeAll(condInfo.getMergedBlocks());
        if (!exitBlocks.isEmpty() && (loopExit = condInfo.getElseBlock()) != null) {
            for (Edge exitEdge : loop.getExitEdges()) {
                if (!exitBlocks.contains(exitEdge.getSource())) continue;
                this.insertBreak(stack, loopExit, exitEdge);
            }
        }
        if (loopRegion.isConditionAtEnd()) {
            BlockNode thenBlock = condInfo.getThenBlock();
            out = thenBlock == loopStart ? condInfo.getElseBlock() : thenBlock;
            loopStart.remove(AType.LOOP);
            loop.getEnd().add(AFlag.SKIP);
            stack.addExit(loop.getEnd());
            loopRegion.setBody(this.makeRegion(loopStart, stack));
            loopStart.addAttr(AType.LOOP, loop);
            loop.getEnd().remove(AFlag.SKIP);
        } else {
            out = condInfo.getElseBlock();
            if (outerRegion != null && out.contains(AFlag.LOOP_START) && !out.getAll(AType.LOOP).contains(loop) && RegionUtils.isRegionContainsBlock(outerRegion, out)) {
                out = null;
            }
            stack.addExit(out);
            BlockNode loopBody = condInfo.getThenBlock();
            Region body = this.makeRegion(loopBody, stack);
            BlockNode conditionBlock = condInfo.getIfBlock();
            if (loopStart != conditionBlock) {
                Set<BlockNode> blocks = BlockUtils.getAllPathsBlocks(loopStart, conditionBlock);
                blocks.remove(conditionBlock);
                for (BlockNode block : blocks) {
                    if (!block.getInstructions().isEmpty() || block.contains(AFlag.SKIP) || RegionUtils.isRegionContainsBlock(body, block)) continue;
                    body.add(block);
                }
            }
            loopRegion.setBody(body);
        }
        stack.pop();
        RegionMaker.insertContinue(loop);
        return out;
    }

    private LoopRegion makeLoopRegion(IRegion curRegion, LoopInfo loop, List<BlockNode> exitBlocks) {
        for (BlockNode block : exitBlocks) {
            List<LoopInfo> list;
            boolean found;
            List loops;
            if (block.contains(AType.EXC_HANDLER) || block.getInstructions().size() != 1 || block.getInstructions().get(0).getType() != InsnType.IF || !(loops = block.getAll(AType.LOOP)).isEmpty() && loops.get(0) != loop) continue;
            LoopRegion loopRegion = new LoopRegion(curRegion, loop, block, block == loop.getEnd());
            if (block == loop.getStart() || block == loop.getEnd() || BlockUtils.isEmptySimplePath(loop.getStart(), block)) {
                found = true;
            } else if (block.getPredecessors().contains(loop.getStart())) {
                loopRegion.setPreCondition(loop.getStart());
                found = loopRegion.checkPreCondition();
            } else {
                found = false;
            }
            if (found && (list = this.mth.getAllLoopsForBlock(block)).size() >= 2) {
                boolean allOuter = true;
                for (BlockNode outerBlock : block.getCleanSuccessors()) {
                    List<LoopInfo> outLoopList = this.mth.getAllLoopsForBlock(outerBlock);
                    outLoopList.remove(loop);
                    if (outLoopList.isEmpty()) continue;
                    allOuter = false;
                    break;
                }
                if (allOuter) {
                    found = false;
                }
            }
            if (!found) continue;
            return loopRegion;
        }
        return null;
    }

    private BlockNode makeEndlessLoop(IRegion curRegion, RegionStack stack, LoopInfo loop, BlockNode loopStart) {
        BlockNode loopEnd;
        LoopRegion loopRegion = new LoopRegion(curRegion, loop, null, false);
        curRegion.getSubBlocks().add(loopRegion);
        loopStart.remove(AType.LOOP);
        stack.push(loopRegion);
        BlockNode loopExit = null;
        List<Edge> exitEdges = loop.getExitEdges();
        for (Edge exitEdge : exitEdges) {
            BlockNode nextBlock;
            BlockNode exit = exitEdge.getTarget();
            if (!this.insertBreak(stack, exit, exitEdge) || (nextBlock = BlockUtils.getNextBlock(exit)) == null) continue;
            stack.addExit(nextBlock);
            loopExit = nextBlock;
        }
        Region body = this.makeRegion(loopStart, stack);
        if (!(RegionUtils.isRegionContainsBlock(body, loopEnd = loop.getEnd()) || loopEnd.contains(AType.EXC_HANDLER) || this.inExceptionHandlerBlocks(loopEnd))) {
            body.getSubBlocks().add(loopEnd);
        }
        loopRegion.setBody(body);
        if (loopExit == null) {
            BlockNode next = BlockUtils.getNextBlock(loopEnd);
            loopExit = RegionUtils.isRegionContainsBlock(body, next) ? null : next;
        }
        stack.pop();
        loopStart.addAttr(AType.LOOP, loop);
        return loopExit;
    }

    private boolean inExceptionHandlerBlocks(BlockNode loopEnd) {
        if (this.mth.getExceptionHandlersCount() == 0) {
            return false;
        }
        for (ExceptionHandler eh : this.mth.getExceptionHandlers()) {
            if (!eh.getBlocks().contains(loopEnd)) continue;
            return true;
        }
        return false;
    }

    private boolean canInsertBreak(BlockNode exit) {
        if (exit.contains(AFlag.RETURN) || BlockUtils.checkLastInsnType(exit, InsnType.BREAK)) {
            return false;
        }
        List<BlockNode> simplePath = BlockUtils.buildSimplePath(exit);
        if (!simplePath.isEmpty() && simplePath.get(simplePath.size() - 1).contains(AFlag.RETURN)) {
            return false;
        }
        Set<BlockNode> paths = BlockUtils.getAllPathsBlocks(this.mth.getEnterBlock(), exit);
        for (BlockNode block : paths) {
            if (!BlockUtils.checkLastInsnType(block, InsnType.SWITCH)) continue;
            return false;
        }
        return true;
    }

    private boolean insertBreak(RegionStack stack, BlockNode loopExit, Edge exitEdge) {
        BlockNode other;
        BlockNode source;
        BlockNode exit = exitEdge.getTarget();
        BlockNode insertBlock = null;
        boolean confirm = false;
        if (loopExit == exit && (source = exitEdge.getSource()).contains(AType.CATCH_BLOCK) && source.getSuccessors().size() == 2 && (other = BlockUtils.selectOther(loopExit, source.getSuccessors())) != null && (other = BlockUtils.skipSyntheticSuccessor(other)).contains(AType.EXC_HANDLER)) {
            insertBlock = source;
            confirm = true;
        }
        if (!confirm) {
            while (exit != null) {
                if (insertBlock != null && BlockUtils.isPathExists(loopExit, exit)) {
                    if (this.canInsertBreak(insertBlock)) {
                        confirm = true;
                        break;
                    }
                    return false;
                }
                insertBlock = exit;
                List<BlockNode> cs = exit.getCleanSuccessors();
                exit = cs.size() == 1 ? cs.get(0) : null;
            }
        }
        if (!confirm) {
            return false;
        }
        InsnNode breakInsn = new InsnNode(InsnType.BREAK, 0);
        insertBlock.getInstructions().add(breakInsn);
        stack.addExit(exit);
        this.addBreakLabel(exitEdge, exit, breakInsn);
        return true;
    }

    private void addBreakLabel(Edge exitEdge, BlockNode exit, InsnNode breakInsn) {
        BlockNode outBlock = BlockUtils.getNextBlock(exitEdge.getTarget());
        if (outBlock == null) {
            return;
        }
        List<LoopInfo> exitLoop = this.mth.getAllLoopsForBlock(outBlock);
        if (!exitLoop.isEmpty()) {
            return;
        }
        List<LoopInfo> inLoops = this.mth.getAllLoopsForBlock(exitEdge.getSource());
        if (inLoops.size() < 2) {
            return;
        }
        LoopInfo parentLoop = null;
        for (LoopInfo loop : inLoops) {
            if (loop.getParentLoop() != null) continue;
            parentLoop = loop;
            break;
        }
        if (parentLoop == null) {
            return;
        }
        if (parentLoop.getEnd() != exit && !parentLoop.getExitNodes().contains(exit)) {
            LoopLabelAttr labelAttr = new LoopLabelAttr(parentLoop);
            breakInsn.addAttr(labelAttr);
            parentLoop.getStart().addAttr(labelAttr);
        }
    }

    private static void insertContinue(LoopInfo loop) {
        BlockNode loopEnd = loop.getEnd();
        List<BlockNode> predecessors = loopEnd.getPredecessors();
        if (predecessors.size() <= 1) {
            return;
        }
        Set<BlockNode> loopExitNodes = loop.getExitNodes();
        for (BlockNode pred : predecessors) {
            if (!RegionMaker.canInsertContinue(pred, predecessors, loopEnd, loopExitNodes)) continue;
            InsnNode cont = new InsnNode(InsnType.CONTINUE, 0);
            pred.getInstructions().add(cont);
        }
    }

    private static boolean canInsertContinue(BlockNode pred, List<BlockNode> predecessors, BlockNode loopEnd, Set<BlockNode> loopExitNodes) {
        if (!pred.contains(AFlag.SYNTHETIC) || BlockUtils.checkLastInsnType(pred, InsnType.CONTINUE)) {
            return false;
        }
        List<BlockNode> preds = pred.getPredecessors();
        if (preds.isEmpty()) {
            return false;
        }
        BlockNode codePred = preds.get(0);
        if (codePred.contains(AFlag.SKIP)) {
            return false;
        }
        if (loopEnd.isDominator(codePred) || loopExitNodes.contains(codePred)) {
            return false;
        }
        if (RegionMaker.isDominatedOnBlocks(codePred, predecessors)) {
            return false;
        }
        boolean gotoExit = false;
        for (BlockNode exit : loopExitNodes) {
            if (!BlockUtils.isPathExists(codePred, exit)) continue;
            gotoExit = true;
            break;
        }
        return gotoExit;
    }

    private static boolean isDominatedOnBlocks(BlockNode dom, List<BlockNode> blocks) {
        for (BlockNode node : blocks) {
            if (node.isDominator(dom)) continue;
            return false;
        }
        return true;
    }

    private BlockNode processMonitorEnter(IRegion curRegion, BlockNode block, InsnNode insn, RegionStack stack) {
        BlockNode exit;
        SynchronizedRegion synchRegion = new SynchronizedRegion(curRegion, insn);
        synchRegion.getSubBlocks().add(block);
        curRegion.getSubBlocks().add(synchRegion);
        HashSet<BlockNode> exits = new HashSet<BlockNode>();
        this.cacheSet.clear();
        RegionMaker.traverseMonitorExits(synchRegion, insn.getArg(0), block, exits, this.cacheSet);
        for (InsnNode exitInsn : synchRegion.getExitInsns()) {
            InstructionRemover.unbindInsn(this.mth, exitInsn);
        }
        BlockNode body = BlockUtils.getNextBlock(block);
        if (body == null) {
            ErrorsCounter.methodError(this.mth, "Unexpected end of synchronized block");
            return null;
        }
        if (exits.size() == 1) {
            exit = BlockUtils.getNextBlock((BlockNode)exits.iterator().next());
        } else {
            this.cacheSet.clear();
            exit = RegionMaker.traverseMonitorExitsCross(body, exits, this.cacheSet);
        }
        stack.push(synchRegion);
        stack.addExit(exit);
        synchRegion.getSubBlocks().add(this.makeRegion(body, stack));
        stack.pop();
        return exit;
    }

    private static void traverseMonitorExits(SynchronizedRegion region, InsnArg arg, BlockNode block, Set<BlockNode> exits, Set<BlockNode> visited) {
        visited.add(block);
        for (InsnNode insn : block.getInstructions()) {
            if (insn.getType() != InsnType.MONITOR_EXIT || !insn.getArg(0).equals(arg)) continue;
            exits.add(block);
            region.getExitInsns().add(insn);
            return;
        }
        for (BlockNode node : block.getSuccessors()) {
            if (visited.contains(node)) continue;
            RegionMaker.traverseMonitorExits(region, arg, node, exits, visited);
        }
    }

    private static BlockNode traverseMonitorExitsCross(BlockNode block, Set<BlockNode> exits, Set<BlockNode> visited) {
        visited.add(block);
        for (BlockNode node : block.getCleanSuccessors()) {
            BlockNode res;
            boolean cross = true;
            for (BlockNode exitBlock : exits) {
                boolean p = BlockUtils.isPathExists(exitBlock, node);
                if (p) continue;
                cross = false;
                break;
            }
            if (cross) {
                return node;
            }
            if (visited.contains(node) || (res = RegionMaker.traverseMonitorExitsCross(node, exits, visited)) == null) continue;
            return res;
        }
        return null;
    }

    private BlockNode processIf(IRegion currentRegion, BlockNode block, IfNode ifnode, RegionStack stack) {
        if (block.contains(AFlag.SKIP)) {
            return ifnode.getThenBlock();
        }
        IfInfo currentIf = IfMakerHelper.makeIfInfo(block);
        IfInfo mergedIf = IfMakerHelper.mergeNestedIfNodes(currentIf);
        currentIf = mergedIf != null ? mergedIf : IfInfo.invert(currentIf);
        IfInfo modifiedIf = IfMakerHelper.restructureIf(this.mth, block, currentIf);
        if (modifiedIf != null) {
            currentIf = modifiedIf;
        } else {
            if (currentIf.getMergedBlocks().size() <= 1) {
                return null;
            }
            currentIf = IfMakerHelper.makeIfInfo(block);
            if ((currentIf = IfMakerHelper.restructureIf(this.mth, block, currentIf)) == null) {
                return null;
            }
        }
        IfMakerHelper.confirmMerge(currentIf);
        IfRegion ifRegion = new IfRegion(currentRegion, block);
        ifRegion.setCondition(currentIf.getCondition());
        currentRegion.getSubBlocks().add(ifRegion);
        stack.push(ifRegion);
        stack.addExit(currentIf.getOutBlock());
        ifRegion.setThenRegion(this.makeRegion(currentIf.getThenBlock(), stack));
        BlockNode elseBlock = currentIf.getElseBlock();
        if (elseBlock == null || stack.containsExit(elseBlock)) {
            ifRegion.setElseRegion(null);
        } else {
            ifRegion.setElseRegion(this.makeRegion(elseBlock, stack));
        }
        stack.pop();
        return currentIf.getOutBlock();
    }

    private BlockNode processSwitch(IRegion currentRegion, BlockNode block, SwitchNode insn, RegionStack stack) {
        BlockNode end;
        SwitchRegion sw = new SwitchRegion(currentRegion, block);
        currentRegion.getSubBlocks().add(sw);
        int len = insn.getTargets().length;
        LinkedHashMap<Integer, ArrayList<Object>> casesMap = new LinkedHashMap<Integer, ArrayList<Object>>(len);
        for (int i = 0; i < len; ++i) {
            Object key = insn.getKeys()[i];
            int targ = insn.getTargets()[i];
            ArrayList<Object> keys = (ArrayList<Object>)casesMap.get(targ);
            if (keys == null) {
                keys = new ArrayList<Object>(2);
                casesMap.put(targ, keys);
            }
            keys.add(key);
        }
        Map<BlockNode, List<Object>> blocksMap = new LinkedHashMap<BlockNode, List<Object>>(len);
        for (Map.Entry entry : casesMap.entrySet()) {
            BlockNode c = BlockUtils.getBlockByOffset((Integer)entry.getKey(), block.getSuccessors());
            assert (c != null);
            blocksMap.put(c, (List<Object>)entry.getValue());
        }
        BlockNode defCase = BlockUtils.getBlockByOffset(insn.getDefaultCaseOffset(), block.getSuccessors());
        if (defCase != null) {
            blocksMap.remove(defCase);
        }
        LoopInfo loop = this.mth.getLoopForBlock(block);
        LinkedHashMap<BlockNode, BlockNode> fallThroughCases = new LinkedHashMap<BlockNode, BlockNode>();
        List<BlockNode> basicBlocks = this.mth.getBasicBlocks();
        BitSet outs = new BitSet(basicBlocks.size());
        outs.or(block.getDomFrontier());
        for (BlockNode s : block.getCleanSuccessors()) {
            BitSet df = s.getDomFrontier();
            if (df.cardinality() > 1) {
                if (df.cardinality() > 2) {
                    LOG.debug("Unexpected case pattern, block: {}, mth: {}", (Object)s, (Object)this.mth);
                } else {
                    BlockNode first = basicBlocks.get(df.nextSetBit(0));
                    BlockNode second = basicBlocks.get(df.nextSetBit(first.getId() + 1));
                    if (second.getDomFrontier().get(first.getId())) {
                        fallThroughCases.put(s, second);
                        df = new BitSet(df.size());
                        df.set(first.getId());
                    } else if (first.getDomFrontier().get(second.getId())) {
                        fallThroughCases.put(s, first);
                        df = new BitSet(df.size());
                        df.set(second.getId());
                    }
                }
            }
            outs.or(df);
        }
        outs.clear(block.getId());
        if (loop != null) {
            outs.clear(loop.getStart().getId());
        }
        stack.push(sw);
        stack.addExits(BlockUtils.bitSetToBlocks(this.mth, outs));
        if (!fallThroughCases.isEmpty() && this.isBadCasesOrder(blocksMap, fallThroughCases)) {
            LOG.debug("Fixing incorrect switch cases order, method: {}", (Object)this.mth);
            blocksMap = this.reOrderSwitchCases(blocksMap, fallThroughCases);
            if (this.isBadCasesOrder(blocksMap, fallThroughCases)) {
                LOG.error("Can't fix incorrect switch cases order, method: {}", (Object)this.mth);
                this.mth.add(AFlag.INCONSISTENT_CODE);
            }
        }
        if (outs.cardinality() > 1) {
            BlockUtils.cleanBitSet(this.mth, outs);
        }
        if (outs.cardinality() > 1) {
            int i = outs.nextSetBit(0);
            while (i >= 0) {
                BlockNode b = basicBlocks.get(i);
                outs.andNot(b.getDomFrontier());
                if (b.contains(AFlag.LOOP_START)) {
                    outs.clear(b.getId());
                } else {
                    for (BlockNode s : b.getCleanSuccessors()) {
                        outs.clear(s.getId());
                    }
                }
                i = outs.nextSetBit(i + 1);
            }
        }
        if (loop != null && outs.cardinality() > 1) {
            outs.clear(loop.getEnd().getId());
        }
        if (outs.cardinality() == 0) {
            for (BlockNode maybeOut : block.getSuccessors()) {
                boolean allReached = true;
                for (BlockNode s : block.getSuccessors()) {
                    if (BlockUtils.isPathExists(s, maybeOut)) continue;
                    allReached = false;
                    break;
                }
                if (!allReached) continue;
                outs.set(maybeOut.getId());
                break;
            }
        }
        BlockNode out = null;
        if (outs.cardinality() == 1) {
            out = basicBlocks.get(outs.nextSetBit(0));
            stack.addExit(out);
        } else if (loop == null && outs.cardinality() > 1) {
            LOG.warn("Can't detect out node for switch block: {} in {}", (Object)block, (Object)this.mth);
        }
        if (loop != null && out != (end = loop.getEnd()) && out != null) {
            RegionMaker.insertContinueInSwitch(block, out, end);
        }
        if (!stack.containsExit(defCase)) {
            sw.setDefaultCase(this.makeRegion(defCase, stack));
        }
        for (Map.Entry<BlockNode, List<Object>> entry : blocksMap.entrySet()) {
            BlockNode caseBlock = entry.getKey();
            if (stack.containsExit(caseBlock)) {
                sw.addCase(entry.getValue(), new Region(stack.peekRegion()));
                continue;
            }
            BlockNode next = (BlockNode)fallThroughCases.get(caseBlock);
            stack.addExit(next);
            Region caseRegion = this.makeRegion(caseBlock, stack);
            stack.removeExit(next);
            if (next != null) {
                next.add(AFlag.FALL_THROUGH);
                caseRegion.add(AFlag.FALL_THROUGH);
            }
            sw.addCase(entry.getValue(), caseRegion);
        }
        stack.pop();
        return out;
    }

    private boolean isBadCasesOrder(Map<BlockNode, List<Object>> blocksMap, Map<BlockNode, BlockNode> fallThroughCases) {
        BlockNode nextCaseBlock = null;
        for (BlockNode caseBlock : blocksMap.keySet()) {
            if (nextCaseBlock != null && !caseBlock.equals(nextCaseBlock)) {
                return true;
            }
            nextCaseBlock = fallThroughCases.get(caseBlock);
        }
        return nextCaseBlock != null;
    }

    private Map<BlockNode, List<Object>> reOrderSwitchCases(Map<BlockNode, List<Object>> blocksMap, final Map<BlockNode, BlockNode> fallThroughCases) {
        ArrayList<BlockNode> list = new ArrayList<BlockNode>(blocksMap.size());
        list.addAll(blocksMap.keySet());
        Collections.sort(list, new Comparator<BlockNode>(){

            @Override
            public int compare(BlockNode a, BlockNode b) {
                BlockNode nextA = (BlockNode)fallThroughCases.get(a);
                if (nextA != null) {
                    if (b.equals(nextA)) {
                        return -1;
                    }
                } else if (a.equals(fallThroughCases.get(b))) {
                    return 1;
                }
                return 0;
            }
        });
        LinkedHashMap<BlockNode, List<Object>> newBlocksMap = new LinkedHashMap<BlockNode, List<Object>>(blocksMap.size());
        for (BlockNode key : list) {
            newBlocksMap.put(key, blocksMap.get(key));
        }
        return newBlocksMap;
    }

    private static void insertContinueInSwitch(BlockNode block, BlockNode out, BlockNode end) {
        int endId = end.getId();
        block0: for (BlockNode s : block.getCleanSuccessors()) {
            if (!s.getDomFrontier().get(endId) || s == out) continue;
            List<BlockNode> list = BlockUtils.collectBlocksDominatedBy(s, s);
            for (BlockNode p : end.getPredecessors()) {
                if (!list.contains(p)) continue;
                if (!p.isSynthetic()) continue block0;
                p.getInstructions().add(new InsnNode(InsnType.CONTINUE, 0));
                continue block0;
            }
        }
    }

    public void processTryCatchBlocks(MethodNode mth) {
        HashSet<TryCatchBlock> tcs = new HashSet<TryCatchBlock>();
        for (ExceptionHandler handler : mth.getExceptionHandlers()) {
            tcs.add(handler.getTryBlock());
        }
        for (TryCatchBlock tc : tcs) {
            ArrayList<BlockNode> blocks = new ArrayList<BlockNode>(tc.getHandlersCount());
            HashSet<BlockNode> splitters = new HashSet<BlockNode>();
            for (ExceptionHandler handler : tc.getHandlers()) {
                BlockNode handlerBlock = handler.getHandlerBlock();
                if (handlerBlock != null) {
                    blocks.add(handlerBlock);
                    splitters.addAll(handlerBlock.getPredecessors());
                    continue;
                }
                LOG.debug(ErrorsCounter.formatErrorMsg(mth, "No exception handler block: " + handler));
            }
            HashSet<BlockNode> exits = new HashSet<BlockNode>();
            for (BlockNode splitter : splitters) {
                for (BlockNode handler : blocks) {
                    List<BlockNode> s = splitter.getSuccessors();
                    if (s.isEmpty()) {
                        LOG.debug(ErrorsCounter.formatErrorMsg(mth, "No successors for splitter: " + splitter));
                        continue;
                    }
                    BlockNode ss = s.get(0);
                    BlockNode cross = BlockUtils.getPathCross(mth, ss, handler);
                    if (cross == null || cross == ss || cross == handler) continue;
                    exits.add(cross);
                }
            }
            for (ExceptionHandler handler : tc.getHandlers()) {
                this.processExcHandler(handler, exits);
            }
        }
    }

    private void processExcHandler(ExceptionHandler handler, Set<BlockNode> exits) {
        BlockNode dom;
        BlockNode start = handler.getHandlerBlock();
        if (start == null) {
            return;
        }
        RegionStack stack = new RegionStack(this.mth);
        if (handler.isFinally()) {
            SplitterBlockAttr splitterAttr = start.get(AType.SPLITTER_BLOCK);
            if (splitterAttr == null) {
                return;
            }
            dom = splitterAttr.getBlock();
        } else {
            dom = start;
            stack.addExits(exits);
        }
        BitSet domFrontier = dom.getDomFrontier();
        List<BlockNode> handlerExits = BlockUtils.bitSetToBlocks(this.mth, domFrontier);
        boolean inLoop = this.mth.getLoopForBlock(start) != null;
        for (BlockNode exit : handlerExits) {
            if (inLoop && !BlockUtils.isPathExists(start, exit) || !RegionUtils.isRegionContainsBlock(this.mth.getRegion(), exit)) continue;
            stack.addExit(exit);
        }
        handler.setHandlerRegion(this.makeRegion(start, stack));
        ExcHandlerAttr excHandlerAttr = start.get(AType.EXC_HANDLER);
        if (excHandlerAttr == null) {
            LOG.warn("Missing exception handler attribute for start block");
        } else {
            handler.getHandlerRegion().addAttr(excHandlerAttr);
        }
    }

    static boolean isEqualPaths(BlockNode b1, BlockNode b2) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        return RegionMaker.isReturnBlocks(b1, b2) || RegionMaker.isSyntheticPath(b1, b2);
    }

    private static boolean isSyntheticPath(BlockNode b1, BlockNode b2) {
        BlockNode n1 = BlockUtils.skipSyntheticSuccessor(b1);
        BlockNode n2 = BlockUtils.skipSyntheticSuccessor(b2);
        return (n1 != b1 || n2 != b2) && RegionMaker.isEqualPaths(n1, n2);
    }

    public static boolean isReturnBlocks(BlockNode b1, BlockNode b2) {
        if (!b1.isReturnBlock() || !b2.isReturnBlock()) {
            return false;
        }
        List<InsnNode> b1Insns = b1.getInstructions();
        List<InsnNode> b2Insns = b2.getInstructions();
        if (b1Insns.size() != 1 || b2Insns.size() != 1) {
            return false;
        }
        InsnNode i1 = b1Insns.get(0);
        InsnNode i2 = b2Insns.get(0);
        if (i1.getArgsCount() != i2.getArgsCount()) {
            return false;
        }
        return i1.getArgsCount() == 0 || i1.getArg(0).equals(i2.getArg(0));
    }
}

