/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.util.HashSet;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyString;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class StringArraySet
extends RubyArray {
    private final Set<String> set = new HashSet<String>(20);

    public StringArraySet(Ruby runtime) {
        super(runtime, 16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void appendString(Ruby runtime, String element) {
        RubyString item = runtime.newString(element);
        StringArraySet stringArraySet = this;
        synchronized (stringArraySet) {
            super.append(item);
            this.set.add(element);
        }
    }

    @Override
    public synchronized RubyArray append(IRubyObject item) {
        RubyArray result2 = super.append(item);
        this.set.add(StringArraySet.convertToString(item));
        return result2;
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.set.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteString(ThreadContext context, String element) {
        RubyString item = context.runtime.newString(element);
        StringArraySet stringArraySet = this;
        synchronized (stringArraySet) {
            super.delete(context, item, Block.NULL_BLOCK);
            this.set.remove(element);
        }
    }

    @Override
    public synchronized IRubyObject delete(ThreadContext context, IRubyObject item, Block block) {
        IRubyObject result2 = super.delete(context, item, block);
        if (!this.includes(context, item)) {
            this.set.remove(StringArraySet.convertToString(item));
        }
        return result2;
    }

    @Override
    public synchronized IRubyObject delete_if(ThreadContext context, Block block) {
        IRubyObject result2 = super.delete_if(context, block);
        return result2;
    }

    @Override
    public final RubyBoolean include_p(ThreadContext context, IRubyObject item) {
        return context.runtime.newBoolean(this.containsString(StringArraySet.convertToString(item)));
    }

    @Override
    public synchronized IRubyObject replace(IRubyObject orig) {
        IRubyObject result2 = super.replace(orig);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject aset(IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = super.aset(arg0, arg1);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject aset(IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        IRubyObject result2 = super.aset(arg0, arg1, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized RubyArray collectBang(ThreadContext context, Block block) {
        RubyArray result2 = super.collectBang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject compact_bang() {
        IRubyObject result2 = super.compact_bang();
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject drop(ThreadContext context, IRubyObject n) {
        IRubyObject result2 = super.drop(context, n);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject drop_while(ThreadContext context, Block block) {
        IRubyObject result2 = super.drop_while(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject flatten_bang(ThreadContext context) {
        IRubyObject result2 = super.flatten_bang(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject flatten_bang(ThreadContext context, IRubyObject arg2) {
        IRubyObject result2 = super.flatten_bang(context, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert() {
        IRubyObject result2 = super.insert();
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(IRubyObject arg2) {
        IRubyObject result2 = super.insert(arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(IRubyObject arg1, IRubyObject arg2) {
        IRubyObject result2 = super.insert(arg1, arg2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject insert(IRubyObject[] args2) {
        IRubyObject result2 = super.insert(args2);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject pop(ThreadContext context) {
        IRubyObject result2 = super.pop(context);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject pop(ThreadContext context, IRubyObject num) {
        IRubyObject result2 = super.pop(context, num);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized RubyArray push(IRubyObject item) {
        RubyArray result2 = super.push(item);
        this.add(item);
        return result2;
    }

    @Override
    public synchronized RubyArray push(IRubyObject[] items) {
        RubyArray result2 = super.push(items);
        this.addAll(items);
        return result2;
    }

    @Override
    public synchronized IRubyObject rejectBang(ThreadContext context, Block block) {
        IRubyObject result2 = super.rejectBang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject select_bang(ThreadContext context, Block block) {
        IRubyObject result2 = super.select_bang(context, block);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject shift(ThreadContext context) {
        IRubyObject result2 = super.shift(context);
        if (result2 != context.nil) {
            this.rehash();
        }
        return result2;
    }

    @Override
    public synchronized IRubyObject shift(ThreadContext context, IRubyObject num) {
        IRubyObject result2 = super.shift(context, num);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject slice_bang(IRubyObject arg0) {
        IRubyObject result2 = super.slice_bang(arg0);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject slice_bang(IRubyObject arg0, IRubyObject arg1) {
        IRubyObject result2 = super.slice_bang(arg0, arg1);
        this.rehash();
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift() {
        IRubyObject result2 = super.unshift();
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift(IRubyObject item) {
        IRubyObject result2 = super.unshift(item);
        this.add(item);
        return result2;
    }

    @Override
    public synchronized IRubyObject unshift(IRubyObject[] items) {
        IRubyObject result2 = super.unshift(items);
        this.addAll(items);
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsString(String element) {
        StringArraySet stringArraySet = this;
        synchronized (stringArraySet) {
            return this.set.contains(element);
        }
    }

    private static String convertToString(IRubyObject item) {
        return item.convertToString().asJavaString();
    }

    private void rehash() {
        this.set.clear();
        this.addAll(this.toJavaArrayMaybeUnsafe());
    }

    private void add(IRubyObject item) {
        this.set.add(StringArraySet.convertToString(item));
    }

    private void addAll(IRubyObject[] items) {
        for (IRubyObject item : items) {
            this.set.add(StringArraySet.convertToString(item));
        }
    }
}

