/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.debug.impl;

import com.oracle.truffle.api.debug.Debugger;
import com.oracle.truffle.api.instrumentation.Instrumenter;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.vm.PolyglotEngine;

public final class DebuggerInstrument
extends TruffleInstrument {
    public static final String ID = "debugger";
    private Debugger debugger;
    private Instrumenter instrumenter;

    @Override
    protected void onCreate(TruffleInstrument.Env env) {
        this.instrumenter = env.getInstrumenter();
        env.registerService(this);
        Source.setFileCaching(true);
    }

    public Debugger getDebugger(PolyglotEngine engine, Factory factory) {
        if (this.debugger == null && factory != null) {
            this.debugger = factory.create(engine, this.instrumenter);
            if (this.debugger == null) {
                throw new NullPointerException();
            }
        }
        return this.debugger;
    }

    public static interface Factory {
        public Debugger create(PolyglotEngine var1, Instrumenter var2);
    }
}

