/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.vm;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import java.util.Arrays;

final class ContextStore {
    final Object vm;
    @CompilerDirectives.CompilationFinal
    Object[] store;
    @CompilerDirectives.CompilationFinal
    private Assumption storeStable = Truffle.getRuntime().createAssumption("context store stable");

    ContextStore(Object vm, int capacity) {
        this.vm = vm;
        this.store = new Object[capacity < 4 ? 4 : capacity];
    }

    Object getContext(int index) {
        if (!this.storeStable.isValid()) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.storeStable = Truffle.getRuntime().createAssumption();
        }
        return index < this.store.length ? this.store[index] : null;
    }

    void setContext(int languageId, Object context) {
        if (languageId >= this.store.length) {
            this.store = Arrays.copyOf(this.store, this.store.length << 1);
        }
        this.store[languageId] = context;
        this.storeStable.invalidate();
    }
}

