/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.Message;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.RubyLanguage;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.interop.ForeignExecuteHelperNode;
import org.jruby.truffle.interop.ForeignExecuteHelperNodeGen;
import org.jruby.truffle.interop.ForeignReadStringCachingHelperNode;
import org.jruby.truffle.interop.ForeignReadStringCachingHelperNodeGen;
import org.jruby.truffle.interop.ForeignWriteStringCachingHelperNode;
import org.jruby.truffle.interop.ForeignWriteStringCachingHelperNodeGen;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.dispatch.DispatchAction;
import org.jruby.truffle.language.dispatch.DispatchHeadNode;
import org.jruby.truffle.language.dispatch.MissingBehavior;

public class RubyMessageResolution {

    public static abstract class ForeignWriteNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        @Node.Child
        private ForeignWriteStringCachingHelperNode helperNode;

        protected Object access(VirtualFrame frame, DynamicObject object, Object name, Object value) {
            return this.getHelperNode().executeStringCachingHelper(frame, object, name, value);
        }

        private ForeignWriteStringCachingHelperNode getHelperNode() {
            if (this.helperNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
                this.helperNode = this.insert(ForeignWriteStringCachingHelperNodeGen.create(context, null, null, null));
            }
            return this.helperNode;
        }
    }

    public static abstract class ForeignUnboxNode
    extends Node {
        private final ConditionProfile stringProfile = ConditionProfile.createBinaryProfile();
        private final ConditionProfile emptyProfile = ConditionProfile.createBinaryProfile();

        protected Object access(DynamicObject object) {
            if (this.stringProfile.profile(RubyGuards.isRubyString(object))) {
                Rope rope = Layouts.STRING.getRope(object);
                if (this.emptyProfile.profile(rope.byteLength() == 0)) {
                    throw UnsupportedMessageException.raise(Message.UNBOX);
                }
                return rope.get(0);
            }
            return object;
        }
    }

    public static abstract class ForeignReadNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        @Node.Child
        private ForeignReadStringCachingHelperNode helperNode;

        protected Object access(VirtualFrame frame, DynamicObject object, Object name) {
            return this.getHelperNode().executeStringCachingHelper(frame, object, name);
        }

        private ForeignReadStringCachingHelperNode getHelperNode() {
            if (this.helperNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
                this.helperNode = this.insert(ForeignReadStringCachingHelperNodeGen.create(context, null, null));
            }
            return this.helperNode;
        }
    }

    public static abstract class ForeignIsNullNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        @CompilerDirectives.CompilationFinal
        RubyContext context;

        protected Object access(DynamicObject object) {
            return object == this.getContext().getCoreLibrary().getNilObject();
        }

        private RubyContext getContext() {
            if (this.context == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                this.context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
            }
            return this.context;
        }
    }

    public static abstract class ForeignIsExecutableNode
    extends Node {
        protected Object access(VirtualFrame frame, DynamicObject object) {
            return RubyGuards.isRubyMethod(object) || RubyGuards.isRubyProc(object);
        }
    }

    public static abstract class ForeignIsBoxedNode
    extends Node {
        protected Object access(DynamicObject object) {
            return RubyGuards.isRubyString(object) && StringOperations.rope(object).byteLength() == 1;
        }
    }

    public static abstract class ForeignInvokeNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        @Node.Child
        private DispatchHeadNode dispatchHeadNode;

        protected Object access(VirtualFrame frame, DynamicObject receiver, String name, Object[] arguments) {
            return this.getDispatchHeadNode().dispatch(frame, receiver, name, null, arguments);
        }

        private DispatchHeadNode getDispatchHeadNode() {
            if (this.dispatchHeadNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
                this.dispatchHeadNode = this.insert(new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD));
            }
            return this.dispatchHeadNode;
        }
    }

    public static abstract class ForeignHasSizeNode
    extends Node {
        protected Object access(DynamicObject object) {
            return RubyGuards.isRubyArray(object) || RubyGuards.isRubyHash(object) || RubyGuards.isRubyString(object);
        }
    }

    public static abstract class ForeignGetSizeNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        @Node.Child
        private DispatchHeadNode dispatchNode;

        protected Object access(VirtualFrame frame, DynamicObject object) {
            return this.getDispatchNode().dispatch(frame, object, "size", null, new Object[0]);
        }

        private DispatchHeadNode getDispatchNode() {
            if (this.dispatchNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
                this.dispatchNode = this.insert(new DispatchHeadNode(context, true, MissingBehavior.CALL_METHOD_MISSING, DispatchAction.CALL_METHOD));
            }
            return this.dispatchNode;
        }
    }

    public static abstract class ForeignExecuteNode
    extends Node {
        @Node.Child
        private Node findContextNode;
        @Node.Child
        private ForeignExecuteHelperNode executeMethodNode;

        protected Object access(VirtualFrame frame, DynamicObject object, Object[] arguments) {
            return this.getHelperNode().executeCall(frame, object, arguments);
        }

        private ForeignExecuteHelperNode getHelperNode() {
            if (this.executeMethodNode == null) {
                CompilerDirectives.transferToInterpreter();
                this.findContextNode = this.insert(RubyLanguage.INSTANCE.unprotectedCreateFindContextNode());
                RubyContext context = RubyLanguage.INSTANCE.unprotectedFindContext(this.findContextNode);
                this.executeMethodNode = this.insert(ForeignExecuteHelperNodeGen.create(context, null, null));
            }
            return this.executeMethodNode;
        }
    }

    public static abstract class Check
    extends Node {
        protected static boolean test(TruffleObject receiver) {
            return RubyGuards.isRubyBasicObject(receiver);
        }
    }
}

