/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.freeform.basic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.encog.engine.network.activation.ActivationFunction;
import org.encog.neural.freeform.FreeformConnection;
import org.encog.neural.freeform.InputSummation;

public class BasicActivationSummation
implements InputSummation,
Serializable {
    private static final long serialVersionUID = 1L;
    private ActivationFunction activationFunction;
    private final List<FreeformConnection> inputs = new ArrayList<FreeformConnection>();
    private double sum;

    public BasicActivationSummation(ActivationFunction theActivationFunction) {
        this.activationFunction = theActivationFunction;
    }

    @Override
    public void add(FreeformConnection connection) {
        this.inputs.add(connection);
    }

    @Override
    public double calculate() {
        double[] sumArray = new double[1];
        this.sum = 0.0;
        for (FreeformConnection connection : this.inputs) {
            connection.getSource().performCalculation();
            this.sum += connection.getWeight() * connection.getSource().getActivation();
        }
        sumArray[0] = this.sum;
        this.activationFunction.activationFunction(sumArray, 0, sumArray.length);
        return sumArray[0];
    }

    @Override
    public ActivationFunction getActivationFunction() {
        return this.activationFunction;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public List<FreeformConnection> list() {
        return this.inputs;
    }

    public void setActivationFunction(ActivationFunction activationFunction) {
        this.activationFunction = activationFunction;
    }
}

