/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.extension.internal;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.maven.project.ExtensionDescriptor;
import org.apache.maven.project.ExtensionDescriptorBuilder;
import org.codehaus.plexus.classworlds.realm.ClassRealm;

public class CoreExtensionEntry {
    private final ClassRealm realm;
    private final Set<String> artifacts;
    private final Set<String> packages;
    private static final ExtensionDescriptorBuilder builder = new ExtensionDescriptorBuilder();

    public CoreExtensionEntry(ClassRealm realm, Collection<String> artifacts, Collection<String> packages) {
        this.realm = realm;
        this.artifacts = ImmutableSet.copyOf(artifacts);
        this.packages = ImmutableSet.copyOf(packages);
    }

    public ClassRealm getClassRealm() {
        return this.realm;
    }

    public Set<String> getExportedArtifacts() {
        return this.artifacts;
    }

    public Set<String> getExportedPackages() {
        return this.packages;
    }

    public static CoreExtensionEntry discoverFrom(ClassRealm loader) {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        try {
            Enumeration urls = loader.getResources(builder.getExtensionDescriptorLocation());
            while (urls.hasMoreElements()) {
                InputStream is = ((URL)urls.nextElement()).openStream();
                Throwable throwable = null;
                try {
                    ExtensionDescriptor descriptor = builder.build(is);
                    artifacts.addAll(descriptor.getExportedArtifacts());
                    packages.addAll(descriptor.getExportedPackages());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CoreExtensionEntry(loader, artifacts, packages);
    }

    public static CoreExtensionEntry discoverFrom(ClassRealm loader, Collection<File> classpath) {
        LinkedHashSet<String> artifacts = new LinkedHashSet<String>();
        LinkedHashSet<String> packages = new LinkedHashSet<String>();
        try {
            for (File entry : classpath) {
                ExtensionDescriptor descriptor = builder.build(entry);
                if (descriptor == null) continue;
                artifacts.addAll(descriptor.getExportedArtifacts());
                packages.addAll(descriptor.getExportedPackages());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CoreExtensionEntry(loader, artifacts, packages);
    }
}

