/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITMoveRefactoringPlugin;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRenamePackagePlugin;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRenameRefactoringPlugin;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITSafeDeleteRefactoringPlugin;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class WSITRefactoringFactory
implements RefactoringPluginFactory {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.websvc.wsitconf.refactoring");

    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        boolean javaPackage;
        LOGGER.log(Level.FINE, "Create instance called: " + refactoring);
        NonRecursiveFolder pkg = (NonRecursiveFolder)refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class);
        boolean bl = javaPackage = pkg != null && WSITRefactoringFactory.isOnSourceClasspath(pkg.getFolder());
        if (javaPackage && refactoring instanceof RenameRefactoring) {
            LOGGER.log(Level.FINE, "Rename package refactoring");
            return new WSITRenamePackagePlugin((RenameRefactoring)refactoring);
        }
        if (refactoring instanceof MoveRefactoring) {
            return new WSITMoveRefactoringPlugin((MoveRefactoring)refactoring);
        }
        TreePathHandle tph = (TreePathHandle)refactoring.getRefactoringSource().lookup(TreePathHandle.class);
        if (tph == null) {
            return null;
        }
        if (refactoring instanceof RenameRefactoring) {
            LOGGER.log(Level.FINE, "Rename refactoring");
            return new WSITRenameRefactoringPlugin((RenameRefactoring)refactoring);
        }
        if (refactoring instanceof SafeDeleteRefactoring) {
            LOGGER.log(Level.FINE, "Safe delete refactoring");
            return new WSITSafeDeleteRefactoringPlugin((SafeDeleteRefactoring)refactoring);
        }
        return null;
    }

    private static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        if (OpenProjects.getDefault().isProjectOpen(project)) {
            SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int j = 0; j < sourceGroups.length; ++j) {
                if (fileObject == sourceGroups[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroups[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

