/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.spi;

import java.io.IOException;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.websvc.wsitconf.spi.ProjectSpecificSecurity;
import org.netbeans.modules.websvc.wsitconf.spi.ProjectSpecificTransport;
import org.netbeans.modules.websvc.wsitconf.util.ServerUtils;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.openide.filesystems.FileObject;

public abstract class WsitProvider {
    protected Project project;
    protected static final String CLIENT_CFG_FOLDER = "META-INF";
    private static final Logger logger = Logger.getLogger(WsitProvider.class.getName());

    public ProjectSpecificSecurity getProjectSecurityUpdater() {
        return null;
    }

    public ProjectSpecificTransport getProjectTransportUpdater() {
        return null;
    }

    public boolean isJsr109Project() {
        return false;
    }

    public boolean isWsitSupported() {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        if (sgs != null && sgs.length > 0) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile");
            FileObject txFO = classPath.findResource("com/sun/xml/ws/api/pipe/helper/AbstractPipeImpl.class");
            if (txFO != null) {
                return true;
            }
            txFO = classPath.findResource("com/sun/xml/ws/tx/service/TxServerPipe.class");
            if (txFO != null) {
                return true;
            }
            J2eePlatform j2eePlatform = ServerUtils.getJ2eePlatform(this.project);
            if (j2eePlatform != null) {
                Collection wsStacks = j2eePlatform.getLookup().lookupAll(WSStack.class);
                for (WSStack stack : wsStacks) {
                    if (!stack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.WSIT)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isWsitRtOnClasspath() {
        ClassPath classPath;
        FileObject rtFO;
        SourceGroup[] sgs = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        return sgs != null && sgs.length > 0 && (rtFO = (classPath = ClassPath.getClassPath((FileObject)sgs[0].getRootFolder(), (String)"classpath/compile")).findResource("com/sun/xml/wss/impl/callback/SAMLCallback.class")) != null;
    }

    public FileObject getConfigFilesFolder(boolean client) {
        return this.getConfigFilesFolder(client, true);
    }

    public FileObject getConfigFilesFolder(boolean client, boolean create) {
        FileObject folder = null;
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        if (sourceGroups != null && sourceGroups.length > 0) {
            folder = sourceGroups[0].getRootFolder();
            if (folder != null) {
                folder = folder.getFileObject(CLIENT_CFG_FOLDER);
            }
            if (!create) {
                return folder;
            }
            if (folder == null || !folder.isValid()) {
                try {
                    folder = sourceGroups[0].getRootFolder().createFolder(CLIENT_CFG_FOLDER);
                }
                catch (IOException ex) {
                    logger.log(Level.SEVERE, null, ex);
                }
            }
        }
        return folder;
    }

    public void addServiceDDEntry(String serviceImplPath, String mexUrl, String targetName) {
    }

    public boolean addMetroLibrary() {
        Library[] jaxwsLibs = new Library[]{LibraryManager.getDefault().getLibrary("jaxws21")};
        Library metroLib = LibraryManager.getDefault().getLibrary("metro");
        if (metroLib != null) {
            try {
                SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
                if (sourceGroups != null && sourceGroups.length > 0) {
                    ProjectClassPathModifier.removeLibraries((Library[])jaxwsLibs, (FileObject)sourceGroups[0].getRootFolder(), (String)"classpath/compile");
                    return ProjectClassPathModifier.addLibraries((Library[])new Library[]{metroLib}, (FileObject)sourceGroups[0].getRootFolder(), (String)"classpath/compile");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean addMetroRtLibrary() {
        return false;
    }

    public void createUser() {
        try {
            this.project.getProjectDirectory().getFileObject("nbproject").createData("wsit.createuser");
        }
        catch (IOException ex) {
            logger.log(Level.FINE, null, ex);
        }
    }
}

