/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.smarty.editor;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.spi.multiview.text.MultiViewEditorElement;
import org.netbeans.modules.php.smarty.editor.TplEditorSupport;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.api.WebUtils;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.SaveAsCapable;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.Node;
import org.openide.util.CharSequences;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.UserCancelException;

public class TplDataObject
extends MultiDataObject
implements CookieSet.Factory {
    private static final long serialVersionUID = 1L;
    private transient TplEditorSupport tplEditorSupport;
    private static final String CHARSET_DECL = "CHARSET=";
    private static final String CHARSET_ATTRIBUTE = "charset";
    private static final String META_TAG = "meta";
    private static final String ICON_LOCATION = "org/netbeans/modules/php/smarty/resources/tpl-icon.png";
    private static final Logger LOG = Logger.getLogger(TplDataObject.class.getName());
    public static final String DEFAULT_CHARSET_NAME = Charset.defaultCharset().name();
    private Integer showEncodingWarnings;

    public TplDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException, IOException {
        super(pf, loader);
        CookieSet set = this.getCookieSet();
        set.add(TplEditorSupport.class, (CookieSet.Factory)this);
        set.assign(SaveAsCapable.class, (Object[])new SaveAsCapable[]{new SaveAsCapable(){

            public void saveAs(FileObject folder, String fileName) throws IOException {
                TplEditorSupport es = (TplEditorSupport)((Object)TplDataObject.this.getLookup().lookup(TplEditorSupport.class));
                try {
                    es.updateEncoding();
                    es.saveAs(folder, fileName);
                }
                catch (UserCancelException e) {
                    // empty catch block
                }
            }
        }});
        set.assign(FileEncodingQueryImplementation.class, (Object[])new FileEncodingQueryImplementation[]{new FileEncodingQueryImpl()});
    }

    public static MultiViewEditorElement createMultiViewEditorElement(Lookup context) {
        return new MultiViewEditorElement(context);
    }

    protected Node createNodeDelegate() {
        DataNode dn = new DataNode((DataObject)this, Children.LEAF, this.getLookup());
        dn.setIconBaseWithExtension(ICON_LOCATION);
        return dn;
    }

    protected int associateLookup() {
        return 1;
    }

    public <T extends Node.Cookie> T createCookie(Class<T> klass) {
        if (klass.isAssignableFrom(TplEditorSupport.class)) {
            return (T)((Node.Cookie)klass.cast((Object)this.getTplEditorSupport()));
        }
        return null;
    }

    private synchronized TplEditorSupport getTplEditorSupport() {
        if (this.tplEditorSupport == null) {
            this.tplEditorSupport = new TplEditorSupport(this);
        }
        return this.tplEditorSupport;
    }

    synchronized void setShowEncodingWarnings(Integer value) {
        this.showEncodingWarnings = value;
    }

    synchronized Integer getShowEncodingWarnings() {
        if (this.showEncodingWarnings == null) {
            return null;
        }
        return this.showEncodingWarnings;
    }

    CookieSet getCookieSet0() {
        return this.getCookieSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getFileEncoding() {
        InputStream is = null;
        try {
            FileObject pf = this.getPrimaryFile();
            if (!pf.isValid()) {
                String string = null;
                return string;
            }
            is = pf.getInputStream();
            String string = this.getFileEncoding(is);
            return string;
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    private String getFileEncoding(InputStream in) throws IOException {
        String encoding = null;
        byte[] arr = new byte[4096];
        int len = in.read(arr);
        int n = len = len >= 0 ? len : 0;
        if (len > 1) {
            int mark = (arr[0] & 0xFF) * 256 + (arr[1] & 0xFF);
            if (mark == 65279) {
                encoding = "UTF-16";
            } else if (mark == 65534) {
                encoding = "UTF-16LE";
            }
        }
        String[] encodings = new String[]{encoding != null ? encoding : DEFAULT_CHARSET_NAME, "UTF-16LE", "UTF-16BE"};
        int i = 0;
        while ((encoding = TplDataObject.findEncoding(this.makeString(arr, 0, len, encodings[i++]))) == null && i < encodings.length) {
        }
        if (encoding != null) {
            encoding = encoding.trim();
        }
        return encoding;
    }

    private String makeString(byte[] arr, int offset, int len, String encoding) throws UnsupportedEncodingException {
        return new String(arr, 0, len, encoding).toUpperCase();
    }

    static String findEncoding(String txt) {
        TokenHierarchy hi = TokenHierarchy.create((CharSequence)txt, (Language)HTMLTokenId.language());
        TokenSequence ts = hi.tokenSequence(HTMLTokenId.language());
        ts.moveStart();
        boolean in_charset_attribute = false;
        CharSequence openTag = "";
        while (ts.moveNext()) {
            Token token = ts.token();
            switch ((HTMLTokenId)token.id()) {
                case TAG_OPEN: {
                    openTag = token.text();
                    break;
                }
                case ARGUMENT: {
                    in_charset_attribute = LexerUtils.equals((CharSequence)CHARSET_ATTRIBUTE, (CharSequence)token.text(), (boolean)true, (boolean)true) && LexerUtils.equals((CharSequence)META_TAG, (CharSequence)openTag, (boolean)true, (boolean)true);
                    break;
                }
                case VALUE: {
                    if (in_charset_attribute) {
                        return WebUtils.unquotedValue((CharSequence)token.text()).toString();
                    }
                    int charsetOffset = CharSequences.indexOf((CharSequence)token.text(), (CharSequence)CHARSET_DECL);
                    if (charsetOffset == -1) {
                        charsetOffset = CharSequences.indexOf((CharSequence)token.text(), (CharSequence)CHARSET_DECL.toLowerCase(Locale.ENGLISH));
                    }
                    if (charsetOffset == -1) break;
                    int charsetEndOffset = charsetOffset + CHARSET_DECL.length();
                    int endOffset = CharSequences.indexOf((CharSequence)token.text(), (CharSequence)";", (int)charsetEndOffset);
                    if (endOffset == -1) {
                        endOffset = CharSequences.indexOf((CharSequence)token.text(), (CharSequence)"\"", (int)charsetEndOffset);
                    }
                    if (endOffset == -1) {
                        endOffset = CharSequences.indexOf((CharSequence)token.text(), (CharSequence)"'", (int)charsetEndOffset);
                    }
                    if (endOffset == -1 || charsetEndOffset >= endOffset) break;
                    return token.text().subSequence(charsetEndOffset, endOffset).toString();
                }
            }
        }
        return null;
    }

    private class FileEncodingQueryImpl
    extends FileEncodingQueryImplementation {
        private volatile Charset cachedEncoding;
        private final AtomicBoolean listeningOnContentChange = new AtomicBoolean();
        private final ThreadLocal<Boolean> callingFEQ = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };

        private FileEncodingQueryImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Charset getEncoding(FileObject file) {
            assert (file != null);
            if (this.callingFEQ.get().booleanValue()) {
                return null;
            }
            Charset encoding = this.cachedEncoding;
            if (encoding != null) {
                LOG.log(Level.FINEST, "TplDataObject.getFileEncoding cached {0}", new Object[]{encoding});
                return encoding;
            }
            this.callingFEQ.set(true);
            try {
                Charset charset = FileEncodingQuery.getEncoding((FileObject)file);
                ProxyCharset proxyCharset = new ProxyCharset(charset);
                return proxyCharset;
            }
            finally {
                this.callingFEQ.set(false);
            }
        }

        private Charset cache(Charset encoding) {
            if (!this.listeningOnContentChange.getAndSet(true)) {
                FileObject primaryFile = TplDataObject.this.getPrimaryFile();
                primaryFile.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileChanged(FileEvent fe) {
                        FileEncodingQueryImpl.this.cachedEncoding = null;
                    }
                }, (Object)primaryFile));
            }
            this.cachedEncoding = encoding;
            LOG.log(Level.FINEST, "TplDataObject.getFileEncoding noncached {0}", new Object[]{encoding});
            return encoding;
        }

        private class HtmlDecoder
        extends CharsetDecoder {
            private ByteBuffer buffer;
            private ByteBuffer remainder;
            private CharsetDecoder decoder;

            public HtmlDecoder(Charset cs) {
                super(cs, 1.0f, 2.0f);
                this.buffer = ByteBuffer.allocate(4096);
            }

            @Override
            protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                if (this.buffer == null) {
                    assert (this.decoder != null);
                    if (this.remainder != null) {
                        ByteBuffer tmp = ByteBuffer.allocate(this.remainder.remaining() + in.remaining());
                        tmp.put(this.remainder);
                        tmp.put(in);
                        tmp.flip();
                        CoderResult result = this.decoder.decode(tmp, out, false);
                        this.remainder = tmp.hasRemaining() ? tmp : null;
                        return result;
                    }
                    return this.decoder.decode(in, out, false);
                }
                if (this.buffer.remaining() == 0) {
                    return this.handleHead(in, out);
                }
                if (this.buffer.remaining() < in.remaining()) {
                    int limit = in.limit();
                    in.limit(in.position() + this.buffer.remaining());
                    this.buffer.put(in);
                    in.limit(limit);
                    return this.handleHead(in, out);
                }
                this.buffer.put(in);
                return CoderResult.UNDERFLOW;
            }

            private CoderResult handleHead(ByteBuffer in, CharBuffer out) {
                Charset c;
                String encoding = null;
                try {
                    encoding = this.getEncoding();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                if (encoding == null) {
                    this.buffer = null;
                    FileEncodingQueryImpl.throwUnknownEncoding();
                    return null;
                }
                try {
                    c = FileEncodingQueryImpl.this.cache(Charset.forName(encoding));
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                    this.buffer = null;
                    FileEncodingQueryImpl.throwUnknownEncoding();
                    return null;
                }
                this.decoder = c.newDecoder();
                return this.flushHead(in, out);
            }

            private CoderResult flushHead(ByteBuffer in, CharBuffer out) {
                this.buffer.flip();
                CoderResult r = this.decoder.decode(this.buffer, out, in == null);
                if (r.isOverflow()) {
                    this.remainder = this.buffer;
                    this.buffer = null;
                    return r;
                }
                this.buffer = null;
                if (in == null) {
                    return r;
                }
                return this.decoder.decode(in, out, false);
            }

            private String getEncoding() throws IOException {
                byte[] arr = this.buffer.array();
                try (ByteArrayInputStream in = new ByteArrayInputStream(arr);){
                    String string = TplDataObject.this.getFileEncoding(in);
                    return string;
                }
            }

            @Override
            protected CoderResult implFlush(CharBuffer out) {
                if (this.buffer != null) {
                    CoderResult res = this.handleHead(null, out);
                    return res;
                }
                if (this.remainder != null) {
                    this.decoder.decode(this.remainder, out, true);
                } else {
                    ByteBuffer empty = (ByteBuffer)ByteBuffer.allocate(0).flip();
                    this.decoder.decode(empty, out, true);
                }
                CoderResult res = this.decoder.flush(out);
                return res;
            }

            @Override
            protected void implReset() {
                if (this.decoder != null) {
                    this.decoder.reset();
                }
            }
        }

        private class HtmlEncoder
        extends CharsetEncoder {
            private CharBuffer buffer;
            private CharBuffer remainder;
            private CharsetEncoder encoder;

            public HtmlEncoder(Charset cs) {
                super(cs, 1.0f, 2.0f);
                this.buffer = CharBuffer.allocate(4096);
            }

            @Override
            protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
                if (this.buffer == null) {
                    CoderResult result;
                    assert (this.encoder != null);
                    if (this.remainder != null) {
                        result = this.encoder.encode(this.remainder, out, false);
                        if (!this.remainder.hasRemaining()) {
                            this.remainder = null;
                        }
                    }
                    result = this.encoder.encode(in, out, false);
                    return result;
                }
                if (this.buffer.remaining() == 0 || this.buffer.position() > 0 && in.limit() == 0) {
                    return this.handleHead(in, out);
                }
                if (this.buffer.remaining() < in.remaining()) {
                    int limit = in.limit();
                    in.limit(in.position() + this.buffer.remaining());
                    this.buffer.put(in);
                    in.limit(limit);
                    return this.handleHead(in, out);
                }
                this.buffer.put(in);
                return CoderResult.UNDERFLOW;
            }

            private CoderResult handleHead(CharBuffer in, ByteBuffer out) {
                Charset c;
                String encoding = null;
                try {
                    encoding = this.getEncoding();
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                if (encoding == null) {
                    this.buffer = null;
                    FileEncodingQueryImpl.throwUnknownEncoding();
                    return null;
                }
                try {
                    c = FileEncodingQueryImpl.this.cache(Charset.forName(encoding));
                }
                catch (IllegalCharsetNameException | UnsupportedCharsetException e) {
                    this.buffer = null;
                    FileEncodingQueryImpl.throwUnknownEncoding();
                    return null;
                }
                this.encoder = c.newEncoder();
                return this.flushHead(in, out);
            }

            private CoderResult flushHead(CharBuffer in, ByteBuffer out) {
                this.buffer.flip();
                CoderResult r = this.encoder.encode(this.buffer, out, in == null);
                if (r.isOverflow()) {
                    this.remainder = this.buffer;
                    this.buffer = null;
                    return r;
                }
                this.buffer = null;
                if (in == null) {
                    return r;
                }
                return this.encoder.encode(in, out, false);
            }

            private String getEncoding() throws IOException {
                String text = this.buffer.asReadOnlyBuffer().flip().toString();
                try (ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes(DEFAULT_CHARSET_NAME));){
                    String string = TplDataObject.this.getFileEncoding(in);
                    return string;
                }
            }

            @Override
            protected CoderResult implFlush(ByteBuffer out) {
                if (this.buffer != null) {
                    CoderResult res = this.handleHead(null, out);
                    return res;
                }
                if (this.remainder != null) {
                    this.encoder.encode(this.remainder, out, true);
                } else {
                    CharBuffer empty = (CharBuffer)CharBuffer.allocate(0).flip();
                    this.encoder.encode(empty, out, true);
                }
                CoderResult res = this.encoder.flush(out);
                return res;
            }

            @Override
            protected void implReset() {
                if (this.encoder != null) {
                    this.encoder.reset();
                }
            }
        }

        private class ProxyCharset
        extends Charset {
            public ProxyCharset(Charset charset) {
                super(charset.name(), new String[0]);
            }

            @Override
            public boolean contains(Charset c) {
                return false;
            }

            @Override
            public CharsetDecoder newDecoder() {
                return new HtmlDecoder(this);
            }

            @Override
            public CharsetEncoder newEncoder() {
                return new HtmlEncoder(this);
            }
        }
    }
}

