/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.transfer;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.s3.model.ProgressListener;
import com.amazonaws.services.s3.transfer.TransferProgress;
import com.amazonaws.services.s3.transfer.internal.ProgressListenerChain;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class Transfer {
    protected volatile TransferState state = TransferState.Waiting;
    private final TransferProgress transferProgress;
    private final String description;
    protected volatile Future<?> future;
    protected ProgressListenerChain progressListenerChain;

    Transfer(String description, TransferProgress transferProgress, ProgressListenerChain progressListenerChain) {
        this.description = description;
        this.progressListenerChain = progressListenerChain;
        this.transferProgress = transferProgress;
    }

    public synchronized boolean isDone() {
        return this.state == TransferState.Failed || this.state == TransferState.Completed || this.state == TransferState.Canceled;
    }

    public void waitForCompletion() throws AmazonClientException, AmazonServiceException, InterruptedException {
        try {
            this.future.get();
        }
        catch (ExecutionException e) {
            this.rethrowExecutionException(e);
        }
    }

    public AmazonClientException waitForException() throws InterruptedException {
        try {
            this.future.get();
            return null;
        }
        catch (ExecutionException e) {
            return this.unwrapExecutionException(e);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized TransferState getState() {
        return this.state;
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        this.progressListenerChain.addProgressListener(listener);
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
        this.progressListenerChain.removeProgressListener(listener);
    }

    public TransferProgress getProgress() {
        return this.transferProgress;
    }

    protected void rethrowExecutionException(ExecutionException e) {
        throw this.unwrapExecutionException(e);
    }

    protected AmazonClientException unwrapExecutionException(ExecutionException e) {
        Throwable t = e.getCause();
        if (t instanceof AmazonClientException) {
            return (AmazonClientException)t;
        }
        return new AmazonClientException("Unable to complete transfer: " + t.getMessage(), t);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransferState {
        Waiting,
        InProgress,
        Completed,
        Canceled,
        Failed;

    }
}

