/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpledb.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.simpledb.model.PutAttributesRequest;
import com.amazonaws.services.simpledb.model.ReplaceableAttribute;
import com.amazonaws.services.simpledb.model.UpdateCondition;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PutAttributesRequestMarshaller
implements Marshaller<Request<PutAttributesRequest>, PutAttributesRequest> {
    @Override
    public Request<PutAttributesRequest> marshall(PutAttributesRequest putAttributesRequest) {
        DefaultRequest<PutAttributesRequest> request = new DefaultRequest<PutAttributesRequest>(putAttributesRequest, "AmazonSimpleDB");
        request.addParameter("Action", "PutAttributes");
        request.addParameter("Version", "2009-04-15");
        if (putAttributesRequest != null && putAttributesRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString(putAttributesRequest.getDomainName()));
        }
        if (putAttributesRequest != null && putAttributesRequest.getItemName() != null) {
            request.addParameter("ItemName", StringUtils.fromString(putAttributesRequest.getItemName()));
        }
        if (putAttributesRequest != null) {
            List<ReplaceableAttribute> attributesList = putAttributesRequest.getAttributes();
            int attributesListIndex = 1;
            for (ReplaceableAttribute attributesListValue : attributesList) {
                if (attributesListValue != null && attributesListValue.getName() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Name", StringUtils.fromString(attributesListValue.getName()));
                }
                if (attributesListValue != null && attributesListValue.getValue() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Value", StringUtils.fromString(attributesListValue.getValue()));
                }
                if (attributesListValue != null && attributesListValue.isReplace() != null) {
                    request.addParameter("Attribute." + attributesListIndex + ".Replace", StringUtils.fromBoolean(attributesListValue.isReplace()));
                }
                ++attributesListIndex;
            }
        }
        if (putAttributesRequest != null) {
            UpdateCondition expected = putAttributesRequest.getExpected();
            if (expected != null && expected.getName() != null) {
                request.addParameter("Expected.Name", StringUtils.fromString(expected.getName()));
            }
            if (expected != null && expected.getValue() != null) {
                request.addParameter("Expected.Value", StringUtils.fromString(expected.getValue()));
            }
            if (expected != null && expected.isExists() != null) {
                request.addParameter("Expected.Exists", StringUtils.fromBoolean(expected.isExists()));
            }
        }
        return request;
    }
}

