/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmFriendFunction;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmNamespaceAlias;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmParameter;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeAlias;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmUsingDeclaration;
import org.netbeans.modules.cnd.api.model.CsmUsingDirective;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.deep.CsmCaseStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCompoundStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmCondition;
import org.netbeans.modules.cnd.api.model.deep.CsmDeclarationStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmExceptionHandler;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.api.model.deep.CsmForStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmIfStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmLoopStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmSwitchStatement;
import org.netbeans.modules.cnd.api.model.deep.CsmTryCatchStatement;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.openide.util.CharSequences;

public final class CsmTracer {
    private static final String NULL_TEXT = "null";
    private final int step = 4;
    private final StringBuilder indentBuffer = new StringBuilder();
    private boolean deep = true;
    private boolean testUniqueName = false;
    private PrintStream printStream;
    private boolean dumpTemplateParameters = false;
    private final Object modelChangeEventLock = new Object();

    public void setPrintStream(PrintStream printStream) {
        this.printStream = printStream;
    }

    public CsmTracer() {
        this.printStream = System.out;
    }

    public CsmTracer(boolean useStdErr) {
        this.printStream = useStdErr ? System.err : System.out;
    }

    public CsmTracer(PrintStream printStream) {
        this.printStream = printStream;
    }

    public CsmTracer(Writer writer) throws IOException {
        this.printStream = CsmTracer.toPrintStream(writer);
    }

    public static PrintStream toPrintStream(Writer writer) throws IOException {
        return new PrintStream((OutputStream)new WriterOutputStream(writer), false, "UTF-8");
    }

    public void setDeep(boolean deep) {
        this.deep = deep;
    }

    public void setDumpTemplateParameters(boolean dumpTemplateParameters) {
        this.dumpTemplateParameters = dumpTemplateParameters;
    }

    public void setTestUniqueName(boolean value) {
        this.testUniqueName = value;
    }

    public void indent() {
        this.setupIndentBuffer(this.indentBuffer.length() + 4);
    }

    public void unindent() {
        this.setupIndentBuffer(this.indentBuffer.length() - 4);
    }

    private void setupIndentBuffer(int len) {
        if (len <= 0) {
            this.indentBuffer.setLength(0);
        } else {
            this.indentBuffer.setLength(len);
            for (int i = 0; i < len; ++i) {
                this.indentBuffer.setCharAt(i, ' ');
            }
        }
    }

    public void print(String s) {
        this.print(s, true);
    }

    protected PrintStream getStream() {
        return this.printStream;
    }

    public void print(String s, boolean newline) {
        PrintStream stream = this.getStream();
        if (stream == null) {
            return;
        }
        if (newline) {
            stream.print('\n');
            stream.print(this.indentBuffer.toString());
        }
        stream.print(s);
    }

    public static String toString(CsmObject obj) {
        String out = CsmKindUtilities.isMacro(obj) ? CsmTracer.toString((CsmMacro)obj) : (CsmKindUtilities.isInclude(obj) ? CsmTracer.toString((CsmInclude)obj) : (CsmKindUtilities.isNamespace(obj) ? CsmTracer.toString((CsmNamespace)obj) : (CsmKindUtilities.isClassifier(obj) ? CsmTracer.toString((CsmClassifier)obj) : (CsmKindUtilities.isFunction(obj) ? CsmTracer.toString((CsmFunction)obj) : (CsmKindUtilities.isVariable(obj) ? CsmTracer.toString((CsmVariable)obj) : (CsmKindUtilities.isDeclaration(obj) ? CsmTracer.toString((CsmDeclaration)obj) : (CsmKindUtilities.isType(obj) ? "TYPE " + CsmTracer.toString((CsmType)obj, true) : (CsmKindUtilities.isExpression(obj) ? CsmTracer.toString((CsmExpression)obj, true) : (CsmKindUtilities.isStatement(obj) ? CsmTracer.toString((CsmStatement)obj) : (CsmKindUtilities.isOffsetable(obj) ? CsmTracer.getOffsetString(obj, true) : (CsmKindUtilities.isFile(obj) ? "FILE " + CsmTracer.toString((CsmFile)obj) : (obj == null ? "" : "UNKNOWN CSM OBJECT ") + obj)))))))))));
        return out;
    }

    public static String toString(CsmNamespace nsp) {
        if (nsp == null) {
            return NULL_TEXT;
        }
        return "NS " + nsp.getQualifiedName();
    }

    public static String toString(CsmMacro macro) {
        if (macro == null) {
            return NULL_TEXT;
        }
        return "MACROS " + macro;
    }

    public static String toString(CsmInclude incl) {
        if (incl == null) {
            return NULL_TEXT;
        }
        return "INCLUDE " + incl;
    }

    public static String toString(CsmStatement stmt) {
        if (stmt == null) {
            return NULL_TEXT;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("STMT ").append((Object)stmt.getKind()).append(" ");
        sb.append("text='");
        sb.append(stmt.getText());
        sb.append("'");
        return sb.toString();
    }

    public static String toString(CsmExpression expr, boolean traceKind) {
        if (expr == null) {
            return NULL_TEXT;
        }
        StringBuilder sb = new StringBuilder();
        if (traceKind) {
            sb.append("EXPR ").append((Object)expr.getKind()).append(" ");
        }
        sb.append("text='");
        sb.append(expr.getText());
        sb.append("'");
        return sb.toString();
    }

    public static String toString(CsmInheritance inh) {
        StringBuilder sb = new StringBuilder();
        sb.append("CLASS=");
        CsmClassifier cls = inh.getClassifier();
        sb.append(cls == null ? NULL_TEXT : cls.getQualifiedName());
        sb.append(" VISIBILITY==").append((Object)inh.getVisibility());
        sb.append(" virtual==").append(inh.isVirtual());
        sb.append(" text='");
        sb.append(inh.getText());
        sb.append("'");
        return sb.toString();
    }

    public static String toString(CsmCondition condition) {
        if (condition == null) {
            return NULL_TEXT;
        }
        StringBuilder sb = new StringBuilder(condition.getKind().toString());
        sb.append(' ');
        if (condition.getKind() == CsmCondition.Kind.EXPRESSION) {
            sb.append(CsmTracer.toString(condition.getExpression(), false));
        } else {
            CsmVariable var = condition.getDeclaration();
            sb.append(CsmTracer.toString(var, false));
        }
        return sb.toString();
    }

    public static String toString(CsmDeclaration decl) {
        return (Object)((Object)decl.getKind()) + " " + CsmTracer.toString(decl, true);
    }

    private static String toString(CsmDeclaration decl, boolean traceFile) {
        if (decl == null) {
            return NULL_TEXT;
        }
        return decl.getQualifiedName() + CsmTracer.getOffsetString(decl, traceFile);
    }

    public static String toString(CsmClassifier cls) {
        return (Object)((Object)cls.getKind()) + " " + CsmTracer.toString(cls, true);
    }

    private static String toString(CsmClassifier cls, boolean traceFile) {
        if (cls == null) {
            return NULL_TEXT;
        }
        return cls.getQualifiedName() + CsmTracer.getOffsetString(cls, traceFile);
    }

    private static String toString(CsmType type, boolean traceFile) {
        StringBuilder sb = new StringBuilder();
        if (type == null) {
            sb.append(NULL_TEXT);
        } else {
            CsmClassifier classifier;
            if (type.isTemplateBased()) {
                // empty if block
            }
            if (!CsmKindUtilities.isFunctionPointerType(type)) {
                if (type.isConst()) {
                    sb.append("const ");
                }
                if (type.isPointer()) {
                    for (int i = 0; i < type.getPointerDepth(); ++i) {
                        sb.append("*");
                    }
                }
                if (type.isReference()) {
                    sb.append("&");
                }
            }
            if ((classifier = type.getClassifier()) != null) {
                sb.append(classifier.getQualifiedName());
            } else {
                sb.append("<*no_classifier*>");
            }
            for (int i = 0; i < type.getArrayDepth(); ++i) {
                sb.append("[]");
            }
            sb.append(" TEXT=").append(type.getText());
        }
        sb.append(' ');
        sb.append(CsmTracer.getOffsetString(type, traceFile));
        return sb.toString();
    }

    public static String toString(CsmFile file) {
        if (file == null) {
            return NULL_TEXT;
        }
        File parent = new File(file.getAbsolutePath().toString()).getParentFile();
        return (parent != null ? parent.getName() + "/" : "") + file.getName();
    }

    public static String toString(CsmVariable var) {
        return (Object)((Object)var.getKind()) + " " + CsmTracer.toString(var, true);
    }

    private static String toString(CsmVariable var, boolean traceFile) {
        if (var == null) {
            return NULL_TEXT;
        }
        StringBuilder sb = new StringBuilder(var.getName());
        sb.append(CsmTracer.getOffsetString(var, traceFile));
        sb.append("  TYPE: ").append(CsmTracer.toString(var.getType(), false));
        sb.append("  INIT: ").append(CsmTracer.toString(var.getInitialValue(), false));
        sb.append("  ").append(CsmTracer.getScopeString(var));
        return sb.toString();
    }

    public static String toString(CsmFunction fun) {
        return (Object)((Object)fun.getKind()) + " " + CsmTracer.toString(fun, true);
    }

    private static String toString(CsmFunction fun, boolean signature) {
        if (fun == null) {
            return NULL_TEXT;
        }
        return (signature ? fun.getSignature().toString() : fun.getName().toString()) + ' ' + CsmTracer.getOffsetString(fun, signature);
    }

    public void dumpModel(CsmFunction fun) {
        this.print("FUNCTION " + fun.getName() + CsmTracer.getOffsetString(fun, false) + ' ' + this.getBriefClassName(fun) + ' ' + CsmTracer.getScopeString(fun));
        if (fun instanceof CsmFunctionDefinition && this.deep) {
            this.dumpStatement(((CsmFunctionDefinition)fun).getBody());
        }
        this.indent();
        this.print("DEFINITION: " + CsmTracer.toString(fun.getDefinition(), false));
        this.print("SIGNATURE " + fun.getSignature());
        this.print("UNIQUE NAME " + fun.getUniqueName());
        if (fun instanceof CsmFriendFunction) {
            this.print("REFERENCED FRIEND FUNCTION: " + CsmTracer.toString(((CsmFriendFunction)fun).getReferencedFunction(), false));
        }
        if (this.dumpTemplateParameters && CsmKindUtilities.isTemplate(fun)) {
            this.dumpTemplateParameters((CsmTemplate)((Object)fun));
        }
        this.dumpParameters(fun.getParameters());
        this.print("RETURNS " + CsmTracer.toString(fun.getReturnType(), false));
        this.unindent();
    }

    public void dumpModel(CsmFunctionDefinition fun) {
        CsmFunction decl = fun.getDeclaration();
        this.print("FUNCTION DEFINITION " + fun.getName() + ' ' + CsmTracer.getOffsetString(fun, false) + ' ' + this.getBriefClassName(fun) + ' ' + CsmTracer.getScopeString(fun));
        this.indent();
        this.print("SIGNATURE " + fun.getSignature());
        this.print("UNIQUE NAME " + fun.getUniqueName());
        this.print("DECLARATION: " + CsmTracer.toString(decl, false));
        if (this.dumpTemplateParameters && CsmKindUtilities.isTemplate(fun)) {
            this.dumpTemplateParameters((CsmTemplate)((Object)fun));
        }
        this.dumpParameters(fun.getParameters());
        this.print("RETURNS " + CsmTracer.toString(fun.getReturnType(), false));
        if (this.deep) {
            this.dumpStatement((CsmStatement)fun.getBody());
        }
        this.unindent();
    }

    public static String getScopeString(CsmScopeElement el) {
        StringBuilder sb = new StringBuilder("SCOPE: ");
        int initLen = sb.length();
        CsmScope scope = el.getScope();
        if (scope == null) {
            sb.append(NULL_TEXT);
        } else {
            if (CsmKindUtilities.isFile(scope)) {
                sb.append(((CsmFile)scope).getName());
            } else if (CsmKindUtilities.isNamedElement(scope)) {
                sb.append(((CsmNamedElement)((Object)scope)).getName());
                sb.append(' ');
            } else {
                if (CsmKindUtilities.isStatement(scope)) {
                    CsmStatement stmt = (CsmStatement)((Object)scope);
                    sb.append("Stmt ");
                }
                if (CsmKindUtilities.isOffsetable(scope)) {
                    sb.append(CsmTracer.getOffsetString(scope, false));
                }
            }
            if (sb.length() == initLen) {
                sb.append("???");
            }
        }
        return sb.toString();
    }

    public static String getOffsetString(CsmObject obj, boolean traceFile) {
        if (!CsmKindUtilities.isOffsetable(obj)) {
            return "";
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return " [" + offs.getStartPosition() + '-' + offs.getEndPosition() + ']' + (traceFile ? " " + CsmTracer.toString(offs.getContainingFile()) : "");
    }

    public String getBriefClassName(Object o) {
        return this.getBriefClassName(o.getClass());
    }

    public String getBriefClassName(Class cls) {
        String name = cls.getName();
        int pos = name.lastIndexOf(46);
        if (pos > 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }

    public void dumpParameters(Collection<CsmParameter> parameters) {
        this.print("PARAMETERS:");
        if (parameters != null && parameters.size() > 0) {
            this.indent();
            Iterator<CsmParameter> iter = parameters.iterator();
            while (iter.hasNext()) {
                this.print(CsmTracer.toString(iter.next(), false));
            }
            this.unindent();
        }
    }

    public void dumpStatement(CsmStatement stmt) {
        if (stmt == null) {
            this.print("STATEMENT is null");
            return;
        }
        this.print("STATEMENT " + (Object)((Object)stmt.getKind()) + ' ' + CsmTracer.getOffsetString(stmt, false) + ' ' + CsmTracer.getScopeString(stmt));
        this.indent();
        CsmStatement.Kind kind = stmt.getKind();
        if (kind == CsmStatement.Kind.COMPOUND) {
            this.dumpStatement((CsmCompoundStatement)stmt);
        } else if (kind == CsmStatement.Kind.IF) {
            this.dumpStatement((CsmIfStatement)stmt);
        } else if (kind == CsmStatement.Kind.TRY_CATCH) {
            this.dumpStatement((CsmTryCatchStatement)stmt);
        } else if (kind == CsmStatement.Kind.CATCH) {
            this.dumpStatement((CsmExceptionHandler)stmt);
        } else if (kind == CsmStatement.Kind.DECLARATION) {
            this.dumpStatement((CsmDeclarationStatement)stmt);
        } else if (kind == CsmStatement.Kind.WHILE || kind == CsmStatement.Kind.DO_WHILE) {
            this.dumpStatement((CsmLoopStatement)stmt);
        } else if (kind == CsmStatement.Kind.FOR) {
            this.dumpStatement((CsmForStatement)stmt);
        } else if (kind == CsmStatement.Kind.RANGE_FOR) {
            this.dumpStatement((CsmForStatement)stmt);
        } else if (kind == CsmStatement.Kind.SWITCH) {
            this.dumpStatement((CsmSwitchStatement)stmt);
        } else if (kind == CsmStatement.Kind.CASE) {
            this.dumpStatement((CsmCaseStatement)stmt);
        } else if (kind != CsmStatement.Kind.BREAK && kind != CsmStatement.Kind.CONTINUE && kind != CsmStatement.Kind.DEFAULT) {
            if (kind == CsmStatement.Kind.EXPRESSION) {
                this.print(" text: '" + stmt.getText() + '\'', false);
            } else if (kind == CsmStatement.Kind.GOTO) {
                this.print(" text: '" + stmt.getText() + '\'', false);
            } else if (kind == CsmStatement.Kind.LABEL) {
                this.print(" text: '" + stmt.getText() + '\'', false);
            } else if (kind == CsmStatement.Kind.RETURN) {
                this.print(" text: '" + stmt.getText() + '\'', false);
            } else {
                this.print("unexpected statement kind");
            }
        }
        this.unindent();
    }

    public void dumpStatement(CsmCompoundStatement stmt) {
        if (stmt != null) {
            Iterator<CsmStatement> iter = stmt.getStatements().iterator();
            while (iter.hasNext()) {
                this.dumpStatement(iter.next());
            }
        }
    }

    public void dumpStatement(CsmTryCatchStatement stmt) {
        this.print("TRY:");
        this.dumpStatement(stmt.getTryStatement());
        this.print("HANDLERS:");
        Iterator<CsmExceptionHandler> iter = stmt.getHandlers().iterator();
        while (iter.hasNext()) {
            this.dumpStatement((CsmStatement)iter.next());
        }
    }

    public void dumpStatement(CsmExceptionHandler stmt) {
        this.print("PARAMETER: " + CsmTracer.toString(stmt.getParameter(), false));
        this.dumpStatement((CsmCompoundStatement)stmt);
    }

    public void dumpStatement(CsmIfStatement stmt) {
        this.print("CONDITION " + CsmTracer.toString(stmt.getCondition()));
        this.print("THEN: ");
        this.indent();
        this.dumpStatement(stmt.getThen());
        this.unindent();
        this.print("ELSE: ");
        this.indent();
        this.dumpStatement(stmt.getElse());
        this.unindent();
    }

    public void dumpStatement(CsmDeclarationStatement stmt) {
        Iterator<CsmDeclaration> iter = stmt.getDeclarators().iterator();
        while (iter.hasNext()) {
            this.dumpModel(iter.next());
        }
    }

    public void dumpStatement(CsmLoopStatement stmt) {
        this.print("CONDITION: " + CsmTracer.toString(stmt.getCondition()) + " isPostCheck()=" + stmt.isPostCheck());
        this.print("BODY:");
        this.indent();
        this.dumpStatement(stmt.getBody());
        this.unindent();
    }

    public void dumpStatement(CsmForStatement stmt) {
        this.print("INIT:");
        this.indent();
        this.dumpStatement(stmt.getInitStatement());
        this.unindent();
        this.print("ITERATION: " + CsmTracer.toString(stmt.getIterationExpression(), false));
        this.print("CONDITION: " + CsmTracer.toString(stmt.getCondition()));
        this.print("BODY:");
        this.indent();
        this.dumpStatement(stmt.getBody());
        this.unindent();
    }

    public void dumpStatement(CsmSwitchStatement stmt) {
        this.print("CONDITION: " + CsmTracer.toString(stmt.getCondition()));
        this.print("BODY:");
        this.indent();
        this.dumpStatement(stmt.getBody());
        this.unindent();
    }

    public void dumpStatement(CsmCaseStatement stmt) {
        this.print(" EXPRESSION: " + CsmTracer.toString(stmt.getExpression(), false), false);
    }

    public void dumpNamespaceDefinitions(CsmNamespace nsp) {
        this.print("NAMESPACE DEFINITIONS for " + nsp.getName() + " (" + nsp.getQualifiedName() + ") ");
        this.indent();
        for (CsmNamespaceDefinition def : nsp.getDefinitions()) {
            this.print(def.getContainingFile().getName().toString() + ' ' + CsmTracer.getOffsetString(def, false));
        }
        this.unindent();
    }

    public void dumpModel(CsmProject project) {
        CsmNamespace nsp = project.getGlobalNamespace();
        this.print("\n========== Dumping model of PROJECT " + project.getName(), true);
        this.dumpModel(nsp);
    }

    public void dumpModel(CsmNamespace nsp) {
        if (!nsp.isGlobal()) {
            this.dumpNamespaceDefinitions(nsp);
            this.print("NAMESPACE " + nsp.getName() + " (" + nsp.getQualifiedName() + ") ");
            this.indent();
        }
        Iterator<CsmQualifiedNamedElement> iter = this.getSortedDeclarations(nsp);
        while (iter.hasNext()) {
            this.dumpModel(iter.next());
        }
        iter = this.getSortedNestedNamespaces(nsp);
        while (iter.hasNext()) {
            this.dumpModel((CsmNamespace)iter.next());
        }
        if (!nsp.isGlobal()) {
            this.unindent();
        }
    }

    private Iterator<CsmOffsetableDeclaration> getSortedDeclarations(CsmNamespace nsp) {
        TreeMap<String, CsmOffsetableDeclaration> map = new TreeMap<String, CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration decl : nsp.getDeclarations()) {
            map.put(CsmTracer.getSortKey(decl), decl);
        }
        return map.values().iterator();
    }

    private Iterator<CsmNamespace> getSortedNestedNamespaces(CsmNamespace nsp) {
        TreeMap<CharSequence, CsmNamespace> map = new TreeMap<CharSequence, CsmNamespace>(CharSequences.comparator());
        for (CsmNamespace decl : nsp.getNestedNamespaces()) {
            map.put(decl.getQualifiedName(), decl);
        }
        return map.values().iterator();
    }

    private static String getSortKey(CsmDeclaration declaration) {
        StringBuilder sb = new StringBuilder();
        if (declaration instanceof CsmOffsetable) {
            sb.append(((CsmOffsetable)((Object)declaration)).getContainingFile().getAbsolutePath());
            int start = ((CsmOffsetable)((Object)declaration)).getStartOffset();
            String s = Integer.toString(start);
            int gap = 8 - s.length();
            while (gap-- > 0) {
                sb.append('0');
            }
            sb.append(s);
            sb.append(declaration.getName());
        } else {
            sb.append(declaration.getUniqueName());
        }
        return sb.toString();
    }

    public void dumpModel(CsmFile file) {
        this.dumpModel(file, "\n========== Dumping model of FILE " + file.getName());
    }

    public void dumpModel(CsmFile file, String title) {
        this.print(title);
        Collection<CsmInclude> includes = file.getIncludes();
        this.print("Includes:");
        if (includes.size() > 0) {
            for (CsmInclude o : includes) {
                this.print(o.toString());
            }
        } else {
            this.indent();
            this.print("<no includes>");
            this.unindent();
        }
        Collection<CsmMacro> macros = file.getMacros();
        this.print("Macros:");
        if (macros.size() > 0) {
            for (CsmMacro o : macros) {
                this.print(o.toString());
            }
        } else {
            this.indent();
            this.print("<no macros>");
            this.unindent();
        }
        TreeMap<SortedKey, CsmOffsetableDeclaration> sorted = new TreeMap<SortedKey, CsmOffsetableDeclaration>();
        for (CsmOffsetableDeclaration decl : file.getDeclarations()) {
            sorted.put(new SortedKey(decl), decl);
        }
        for (CsmOffsetableDeclaration decl : sorted.values()) {
            this.dumpModel(decl);
        }
    }

    public void dumpModel(CsmVariable var) {
        this.print((var.isExtern() ? "EXTERN " : "") + "VARIABLE " + CsmTracer.toString(var, false));
        CsmVariableDefinition def = var.getDefinition();
        if (def != null) {
            this.indent();
            this.print("DEFINITION: " + CsmTracer.toString(def, false));
            this.unindent();
        }
    }

    public void dumpModel(CsmVariableDefinition var) {
        CsmVariable decl = var.getDeclaration();
        this.print("VARIABLE DEFINITION " + CsmTracer.toString(var, false));
        this.indent();
        this.print("DECLARATION: " + CsmTracer.toString(decl, false));
        this.unindent();
    }

    public void dumpModel(CsmField field) {
        StringBuilder sb = new StringBuilder("FIELD ");
        sb.append(field.getVisibility().toString());
        if (field.isStatic()) {
            sb.append(" static");
        }
        sb.append(" ");
        sb.append(CsmTracer.toString(field, false));
        this.print(sb.toString());
        CsmVariableDefinition def = field.getDefinition();
        if (def != null) {
            this.indent();
            this.print("DEFINITION: " + CsmTracer.toString(def, false));
            this.unindent();
        }
    }

    public void checkUniqueName(CsmDeclaration decl) {
        CharSequence uname = decl.getUniqueName();
        if (decl instanceof CsmOffsetableDeclaration && this.needsCheckUniqueName(decl)) {
            CsmProject project = ((CsmOffsetable)((Object)decl)).getContainingFile().getProject();
            CsmDeclaration found = project.findDeclaration(uname);
            if (found == null) {
                this.print("Unique name check failed: cant't find in project: " + uname);
            } else if (found != decl) {
                this.print("Unique name check failed: declaration found in project differs " + uname);
            }
        }
        if (!uname.toString().startsWith(decl.getKind().toString())) {
            this.print("Warning: unique name '" + uname + "' desn't start with " + decl.getKind().toString());
        }
    }

    protected boolean needsCheckUniqueName(CsmDeclaration decl) {
        if (decl.getName().length() == 0) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.USING_DECLARATION) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.USING_DIRECTIVE) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.ASM) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.BUILT_IN) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.FUNCTION_LAMBDA) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.VARIABLE_DEFINITION) {
            return false;
        }
        if (decl.getKind() == CsmDeclaration.Kind.VARIABLE) {
            if (CsmKindUtilities.isLocalVariable(decl)) {
                return false;
            }
            if (CsmKindUtilities.isFileLocalVariable(decl)) {
                return false;
            }
        }
        return true;
    }

    public void dumpModel(CsmDeclaration decl) {
        if (this.testUniqueName && decl instanceof CsmOffsetableDeclaration) {
            this.checkUniqueName(decl);
        }
        if (CsmKindUtilities.isClass(decl)) {
            this.dumpModel((CsmClass)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.ENUM) {
            this.dumpModel((CsmEnum)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.NAMESPACE_DEFINITION) {
            this.dumpModel((CsmNamespaceDefinition)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.FUNCTION) {
            this.dumpModel((CsmFunction)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
            this.dumpModel((CsmFunctionDefinition)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.FUNCTION_LAMBDA) {
            this.dumpModel((CsmFunctionDefinition)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND) {
            this.dumpModel((CsmFunction)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) {
            this.dumpModel((CsmFunctionDefinition)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.VARIABLE) {
            this.dumpModel((CsmVariable)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.VARIABLE_DEFINITION) {
            this.dumpModel((CsmVariableDefinition)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.NAMESPACE_ALIAS) {
            this.dumpModel((CsmNamespaceAlias)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.USING_DECLARATION) {
            this.dumpModel((CsmUsingDeclaration)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.USING_DIRECTIVE) {
            this.dumpModel((CsmUsingDirective)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.TYPEDEF) {
            this.dumpModel((CsmTypedef)decl);
        } else if (decl.getKind() == CsmDeclaration.Kind.TYPEALIAS) {
            this.dumpModel((CsmTypeAlias)decl);
        } else {
            String ofStr = CsmTracer.getOffsetString(decl, false);
            this.print("" + (Object)((Object)decl.getKind()) + ' ' + decl.getName() + ofStr);
        }
    }

    public void dumpModel(CsmNamespaceAlias alias) {
        CsmNamespace referencedNamespace = alias.getReferencedNamespace();
        String refNsName = referencedNamespace == null ? NULL_TEXT : referencedNamespace.getQualifiedName().toString();
        this.print("ALIAS " + alias.getAlias() + ' ' + refNsName + ' ' + CsmTracer.getOffsetString(alias, false) + ' ' + CsmTracer.getScopeString(alias));
    }

    public void dumpModel(CsmUsingDeclaration ud) {
        CsmOffsetableDeclaration decl = (CsmOffsetableDeclaration)ud.getReferencedDeclaration();
        String qname = decl == null ? NULL_TEXT : decl.getQualifiedName().toString();
        this.print("USING DECL. " + ud.getName() + ' ' + CsmTracer.getOffsetString(ud, false) + "; REF DECL: " + qname + ' ' + CsmTracer.getOffsetString(decl, false) + ' ' + CsmTracer.getScopeString(ud));
    }

    public void dumpModel(CsmTypedef td) {
        this.print("TYPEDEF " + td.getName() + ' ' + CsmTracer.getOffsetString(td, false) + " TYPE: " + CsmTracer.toString(td.getType(), false) + ' ' + CsmTracer.getScopeString(td));
    }

    public void dumpModel(CsmTypeAlias td) {
        this.print("TYPEALIAS " + td.getName() + ' ' + CsmTracer.getOffsetString(td, false) + " TYPE: " + CsmTracer.toString(td.getType(), false) + ' ' + CsmTracer.getScopeString(td));
    }

    public void dumpModel(CsmUsingDirective ud) {
        CsmNamespace nsp = ud.getReferencedNamespace();
        this.print("USING NAMESPACE. " + ud.getName() + ' ' + CsmTracer.getOffsetString(ud, false) + "; REF NS: " + (nsp == null ? NULL_TEXT : nsp.getQualifiedName()) + ' ' + CsmTracer.getScopeString(ud));
    }

    public void dumpTemplateParameters(CsmTemplate template) {
        this.indent();
        this.print("TEMPLATE PARAMETERS:");
        this.indent();
        for (CsmTemplateParameter parameter : template.getTemplateParameters()) {
            this.print(parameter.getName().toString());
        }
        this.unindent();
        this.unindent();
    }

    public void dumpModel(CsmClass cls) {
        String kw = cls.getKind() == CsmDeclaration.Kind.CLASS ? "CLASS" : (cls.getKind() == CsmDeclaration.Kind.STRUCT ? "STRUCT" : (cls.getKind() == CsmDeclaration.Kind.UNION ? "UNION" : "<unknown-CsmClass-kind>"));
        CharSequence name = CsmKindUtilities.isTemplate(cls) ? ((CsmTemplate)((Object)cls)).getDisplayName() : cls.getName();
        this.print(kw + ' ' + name + " (" + cls.getQualifiedName() + " )" + CsmTracer.getOffsetString(cls, false) + " lcurly=" + cls.getLeftBracketOffset() + ' ' + CsmTracer.getScopeString(cls));
        if (this.dumpTemplateParameters && CsmKindUtilities.isTemplate(cls)) {
            this.dumpTemplateParameters((CsmTemplate)((Object)cls));
        }
        this.indent();
        this.print("BASE CLASSES:");
        this.indent();
        for (CsmInheritance inh : cls.getBaseClasses()) {
            this.print(CsmTracer.toString(inh));
        }
        this.unindent();
        this.print("MEMBERS:");
        this.indent();
        Collection<CsmMember> members = cls.getMembers();
        for (CsmMember member : members) {
            CsmEnumForwardDeclaration fwdEnum;
            CsmEnum csmEnum;
            if (CsmKindUtilities.isClass(member)) {
                this.dumpModel((CsmClass)((Object)member));
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.ENUM) {
                this.dumpModel((CsmEnum)((Object)member));
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.VARIABLE) {
                this.dumpModel((CsmField)member);
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.FUNCTION) {
                this.dumpModel((CsmFunction)((Object)member));
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND) {
                this.dumpModel((CsmFunction)((Object)member));
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
                this.dumpModel((CsmFunctionDefinition)((Object)member));
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.FUNCTION_LAMBDA) {
                this.dumpModel((CsmFunctionDefinition)((Object)member));
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) {
                this.dumpModel((CsmFunctionDefinition)((Object)member));
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.TYPEDEF) {
                this.dumpModel((CsmTypedef)((Object)member));
                continue;
            }
            if (member.getKind() == CsmDeclaration.Kind.TYPEALIAS) {
                this.dumpModel((CsmTypeAlias)((Object)member));
                continue;
            }
            StringBuilder sb = new StringBuilder(member.getKind().toString());
            sb.append(' ');
            sb.append(member.getVisibility().toString());
            if (member.isStatic()) {
                sb.append(" static");
            }
            sb.append(' ');
            sb.append(member.getName());
            sb.append(CsmTracer.getOffsetString(member, false));
            sb.append(' ');
            sb.append(this.getBriefClassName(member));
            this.print(sb.toString());
            if (member.getKind() == CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION) {
                CsmClassForwardDeclaration fwdClass = (CsmClassForwardDeclaration)((Object)member);
                CsmClass csmClass = fwdClass.getCsmClass();
                if (csmClass == null || !cls.equals(csmClass.getScope())) continue;
                this.indent();
                this.dumpModel(csmClass);
                this.unindent();
                continue;
            }
            if (member.getKind() != CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION || (csmEnum = (fwdEnum = (CsmEnumForwardDeclaration)((Object)member)).getCsmEnum()) == null || !cls.equals(csmEnum.getScope())) continue;
            this.indent();
            this.dumpModel(csmEnum);
            this.unindent();
        }
        this.unindent();
        Collection<CsmFriend> friends = cls.getFriends();
        if (!friends.isEmpty()) {
            this.print("FRIENDS:");
            this.indent();
            for (CsmFriend friend : friends) {
                if (friend.getKind() == CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION) {
                    CsmFriendClass frClass = (CsmFriendClass)friend;
                    StringBuilder sb = new StringBuilder(frClass.getKind().toString());
                    sb.append(' ');
                    sb.append(friend.getName());
                    sb.append(CsmTracer.getOffsetString(friend, false));
                    sb.append(' ');
                    sb.append(this.getBriefClassName(friend));
                    this.print(sb.toString());
                    this.indent();
                    CsmClass refClass = frClass.getReferencedClass();
                    this.print("REFERENCED CLASS: " + (refClass == null ? "*UNRESOLVED*" : refClass.getUniqueName().toString()));
                    this.unindent();
                    continue;
                }
                if (friend.getKind() == CsmDeclaration.Kind.FUNCTION) {
                    this.dumpModel((CsmFunction)((Object)friend));
                    continue;
                }
                if (friend.getKind() == CsmDeclaration.Kind.FUNCTION_DEFINITION) {
                    this.dumpModel((CsmFunctionDefinition)((Object)friend));
                    continue;
                }
                if (friend.getKind() == CsmDeclaration.Kind.FUNCTION_LAMBDA) {
                    this.dumpModel((CsmFunctionDefinition)((Object)friend));
                    continue;
                }
                if (friend.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND) {
                    this.dumpModel((CsmFunction)((Object)friend));
                    continue;
                }
                if (friend.getKind() == CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION) {
                    this.dumpModel((CsmFunctionDefinition)((Object)friend));
                    continue;
                }
                assert (false) : "unexpected friend object " + friend;
            }
            this.unindent();
        }
        this.unindent();
    }

    public void dumpModel(CsmEnum enumeration) {
        this.print((enumeration.isStronglyTyped() ? "STRONGLY TYPED " : "") + "ENUM " + enumeration.getName() + CsmTracer.getOffsetString(enumeration, false) + ' ' + CsmTracer.getScopeString(enumeration));
        this.indent();
        for (CsmEnumerator enumerator : enumeration.getEnumerators()) {
            StringBuilder sb = new StringBuilder(enumerator.getName());
            if (enumerator.getExplicitValue() != null) {
                sb.append(' ');
                sb.append(enumerator.getExplicitValue().getText()).append(CsmTracer.getOffsetString(enumerator, false));
            }
            this.print(sb.toString());
        }
        this.unindent();
    }

    public void dumpModel(CsmNamespaceDefinition nsp) {
        this.print("NAMESPACE DEFINITOIN " + nsp.getName() + CsmTracer.getOffsetString(nsp, false) + ' ' + CsmTracer.getScopeString(nsp));
        this.indent();
        Iterator<CsmOffsetableDeclaration> iter = nsp.getDeclarations().iterator();
        while (iter.hasNext()) {
            this.dumpModel(iter.next());
        }
        this.unindent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpModelChangeEvent(CsmChangeEvent e) {
        Object object = this.modelChangeEventLock;
        synchronized (object) {
            this.print("Model Changed Event:");
            this.dumpFilesCollection(e.getNewFiles(), "New files");
            this.dumpFilesCollection(e.getRemovedFiles(), "Removed files");
            this.dumpFilesCollection(e.getChangedFiles(), "Changed files");
            this.dumpDeclarationsCollection(e.getNewDeclarations(), "New declarations");
            this.dumpDeclarationsCollection(e.getRemovedDeclarations(), "Removed declarations");
            this.dumpDeclarationsCollection(e.getChangedDeclarations().keySet(), "Changed declarations");
            this.dumpNamespacesCollection(e.getNewNamespaces(), "New namespaces");
            this.dumpNamespacesCollection(e.getRemovedNamespaces(), "Removed namespaces");
            this.print("");
        }
    }

    public void dumpFilesCollection(Collection<CsmFile> files, String title) {
        if (!files.isEmpty()) {
            this.print(title);
            this.indent();
            this.dumpFilesCollection(files);
            this.unindent();
        }
    }

    public void dumpFilesCollection(Collection<CsmFile> files) {
        if (!files.isEmpty()) {
            for (CsmFile file : files) {
                this.print(file == null ? NULL_TEXT : file.getAbsolutePath().toString());
            }
        }
    }

    public void dumpDeclarationsCollection(Collection<? extends CsmDeclaration> declarations, String title) {
        if (!declarations.isEmpty()) {
            this.print(title);
            this.indent();
            this.dumpDeclarationsCollection(declarations);
            this.unindent();
        }
    }

    public void dumpDeclarationsCollection(Collection<? extends CsmDeclaration> declarations) {
        if (!declarations.isEmpty()) {
            for (CsmDeclaration csmDeclaration : declarations) {
                this.print(csmDeclaration == null ? NULL_TEXT : csmDeclaration.getUniqueName() + " of kind: " + (Object)((Object)csmDeclaration.getKind()));
            }
        }
    }

    public void dumpNamespacesCollection(Collection<CsmNamespace> namespaces, String title) {
        if (!namespaces.isEmpty()) {
            this.print(title);
            this.indent();
            this.dumpNamespacesCollection(namespaces);
            this.unindent();
        }
    }

    public void dumpNamespacesCollection(Collection<CsmNamespace> namespaces) {
        if (!namespaces.isEmpty()) {
            for (CsmNamespace nsp : namespaces) {
                this.print(nsp == null ? NULL_TEXT : nsp.getQualifiedName().toString());
            }
        }
    }

    private static final class WriterOutputStream
    extends OutputStream {
        private final Writer writer;

        public WriterOutputStream(Writer writer) {
            this.writer = writer;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        @SuppressWarnings(value={"Dm"})
        public void write(byte[] b, int off, int len) throws IOException {
            this.writer.write(new String(b, off, len));
        }

        @Override
        public void flush() throws IOException {
            this.writer.flush();
        }

        @Override
        public void close() throws IOException {
            this.writer.close();
        }
    }

    private static final class SortedKey
    implements Comparable<SortedKey> {
        private final CsmOffsetableDeclaration decl;

        private SortedKey(CsmOffsetableDeclaration decl) {
            this.decl = decl;
        }

        @Override
        public int compareTo(SortedKey o) {
            int i = this.decl.getStartOffset() - o.decl.getStartOffset();
            if (i == 0) {
                i = this.decl.getName().toString().compareTo(o.decl.getName().toString());
            }
            return i;
        }
    }
}

