/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.j2ee;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.weblogic9.j2ee.WLJ2eePlatformFactory;
import org.netbeans.modules.javaee.specs.support.spi.JaxWsPoliciesSupportImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class JaxWsPoliciesSupportImpl
implements JaxWsPoliciesSupportImplementation {
    private static final String ORACLE = "oracle";
    private static final String ORACLE_COMMON_MODULES = "oracle_common/modules/";
    private static final String ORACLE_WEBSERVICES = "oracle.webservices";
    private static final String ORACLE_WEBSERVICES_STANDALONE_CLIENT = "oracle.webservices.standalone.client";
    private static final String JAR = "jar";
    private WLJ2eePlatformFactory.J2eePlatformImplImpl platformImpl;

    JaxWsPoliciesSupportImpl(WLJ2eePlatformFactory.J2eePlatformImplImpl platformImpl) {
        this.platformImpl = platformImpl;
    }

    public String getId() {
        return ORACLE;
    }

    public List<String> getClientPolicyIds() {
        return this.getAllPolicyIds(null);
    }

    public List<String> getServicePolicyIds() {
        return this.getAllPolicyIds(null);
    }

    public boolean supports(FileObject wsdl, Lookup loookup) {
        DefaultHandler handler = (DefaultHandler)loookup.lookup(DefaultHandler.class);
        if (handler instanceof OraclePolicyHandler) {
            return ((OraclePolicyHandler)handler).hasOraclePolicy;
        }
        return false;
    }

    public Map<String, String> getPolicyDescriptions() {
        HashMap<String, String> map = new HashMap<String, String>();
        this.getAllPolicyIds(map);
        return map;
    }

    public void extendsProjectClasspath(Project project, Collection<String> fqns) {
        SourceGroup[] sgs = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sgs == null || sgs.length < 1) {
            return;
        }
        FileObject sourceRoot = sgs[0].getRootFolder();
        List<FileObject> roots = this.getJarRoots(sgs);
        HashMap<FileObject, URL> archive2Url = new HashMap<FileObject, URL>();
        LinkedList<String> foundFqns = new LinkedList<String>(fqns);
        for (FileObject root : roots) {
            if (foundFqns.isEmpty()) break;
            Iterator iterator = foundFqns.iterator();
            while (iterator.hasNext()) {
                if (this.hasClassFile(root, (String)iterator.next())) {
                    iterator.remove();
                }
                if (archive2Url.containsKey(root)) continue;
                try {
                    archive2Url.put(root, root.getURL());
                }
                catch (FileStateInvalidException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Couldn't extends compile classpath with required jars for WL policy support", ex);
                }
            }
        }
        LinkedList urls = new LinkedList(archive2Url.values());
        try {
            ProjectClassPathModifier.addRoots((URL[])urls.toArray(new URL[urls.size()]), (FileObject)sourceRoot, (String)"classpath/compile");
        }
        catch (IOException ex) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, "Couldn't extends compile classpath with required jars for WL policy support", ex);
        }
    }

    public Lookup getLookup(FileObject wsdl) {
        OraclePolicyHandler handler = new OraclePolicyHandler();
        return Lookups.fixed((Object[])new Object[]{handler});
    }

    protected List<FileObject> getJarRoots(SourceGroup[] sgs) {
        File home = this.platformImpl.getMiddlewareHome();
        FileObject middlewareHome = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)home));
        FileObject modules = middlewareHome.getFileObject(ORACLE_COMMON_MODULES);
        if (modules == null) {
            return Collections.emptyList();
        }
        LinkedList<FileObject> roots = new LinkedList<FileObject>();
        for (FileObject child : modules.getChildren()) {
            String name = child.getName();
            if (name.startsWith(ORACLE_WEBSERVICES)) {
                FileObject jar = child.getFileObject(ORACLE_WEBSERVICES_STANDALONE_CLIENT, JAR);
                if (jar != null) {
                    this.addJar(roots, jar);
                }
                if ((jar = child.getFileObject("wsclient-rt", JAR)) == null) continue;
                this.addJar(roots, jar);
                continue;
            }
            if (!name.startsWith("ws.api_") || !child.getExt().equals(JAR)) continue;
            this.addJar(roots, child);
        }
        return roots;
    }

    protected void addJar(List<FileObject> archiveRoots, FileObject jar) {
        if (FileUtil.isArchiveFile((FileObject)jar)) {
            archiveRoots.add(FileUtil.getArchiveRoot((FileObject)jar));
        }
    }

    private List<String> getAllPolicyIds(Map<String, String> descriptions) {
        FileObject jar;
        FileObject archiveRoot;
        File home = this.platformImpl.getMiddlewareHome();
        FileObject middlewareHome = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)home));
        FileObject modules = middlewareHome.getFileObject(ORACLE_COMMON_MODULES);
        if (modules == null) {
            return Collections.emptyList();
        }
        FileObject policiesFolder = null;
        for (FileObject folder : modules.getChildren()) {
            if (!folder.getName().startsWith("oracle.wsm.policies")) continue;
            policiesFolder = folder;
            break;
        }
        if (policiesFolder == null) {
            return Collections.emptyList();
        }
        FileObject[] jars = policiesFolder.getChildren();
        FileObject policies = null;
        FileObject[] arr$ = jars;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (policies = (archiveRoot = FileUtil.getArchiveRoot((FileObject)(jar = arr$[i$]))).getFileObject("META-INF/policies/oracle/")) == null; ++i$) {
        }
        LinkedList<String> allIds = new LinkedList<String>();
        if (policies != null) {
            for (FileObject fileObject : policies.getChildren()) {
                String name = fileObject.getName();
                allIds.add(name);
                if (descriptions == null) continue;
                descriptions.put(name, this.readFile(fileObject));
            }
        }
        return allIds;
    }

    private boolean hasClassFile(FileObject root, String fqn) {
        String fileName = fqn.replace('.', '/');
        return root.getFileObject(fileName + ".class") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(FileObject fileObject) {
        StringBuilder builder = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            InputStream stream = fileObject.getInputStream();
            reader = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, ex);
                }
            }
        }
        return builder.toString();
    }

    private static final class OraclePolicyHandler
    extends DefaultHandler {
        private static final String POLICY = "Policy";
        private static final String COLON_POLICY = ":Policy";
        private boolean hasOraclePolicy;

        private OraclePolicyHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            boolean policy = false;
            if (localName != null && localName.equals(POLICY)) {
                policy = true;
            }
            if (qName != null && qName.endsWith(COLON_POLICY)) {
                policy = true;
            }
            if (!policy) {
                return;
            }
            int count = attributes.getLength();
            for (int i = 0; i < count; ++i) {
                String value = attributes.getValue(i);
                if (!value.toLowerCase(Locale.ENGLISH).contains(JaxWsPoliciesSupportImpl.ORACLE)) continue;
                this.hasOraclePolicy = true;
            }
        }

        boolean hasOraclePolicy() {
            return this.hasOraclePolicy;
        }
    }
}

