/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.lex.DefMacroDirective;
import org.clang.lex.MacroInfo;
import org.clang.lex.UndefMacroDirective;
import org.clang.lex.VisibilityMacroDirective;
import org.clank.java.std;
import org.clank.support.Casts;
import org.clank.support.Native;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.aliases.uint;
import org.llvm.adt.aliases.ArrayRefUInt;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;

public abstract class MacroDirective {
    private int HashLoc = SourceLocation.getInvalid();
    private int EodLoc = SourceLocation.getInvalid();
    protected MacroDirective Previous = null;
    protected int Loc;
    protected Kind MDKind;
    protected boolean IsFromPCH;
    protected boolean IsAmbiguous;
    protected boolean IsPublic;
    protected boolean IsImported;
    protected int NumOverrides;
    protected uint.ptr Extra;

    void setLocationRange(int HashLoc, int EodLoc) {
        assert (SourceLocation.isInvalid((int)this.HashLoc)) : "must be initialized once";
        assert (SourceLocation.isInvalid((int)this.EodLoc)) : "must be initialized once";
        this.HashLoc = HashLoc;
        this.EodLoc = EodLoc;
    }

    public int getHashLoc() {
        return this.HashLoc;
    }

    public int getEodLoc() {
        return this.EodLoc;
    }

    protected uint.ptr getModuleDataStart() {
        return this.Extra;
    }

    protected MacroDirective() {
        this(null, SourceLocation.getInvalid(), null);
    }

    protected MacroDirective(Kind K, int Loc, uint.ptr _Extra) {
        this(K, Loc, 0L, ArrayRefUInt.None(), _Extra);
    }

    protected MacroDirective(Kind K, int Loc, long ImportedFromModuleID, uint.ptr _Extra) {
        this(K, Loc, ImportedFromModuleID, ArrayRefUInt.None(), _Extra);
    }

    protected MacroDirective(Kind K, int Loc, long ImportedFromModuleID, ArrayRefUInt Overrides, uint.ptr _Extra) {
        this.Loc = Loc;
        this.MDKind = K;
        this.IsFromPCH = false;
        this.IsAmbiguous = false;
        this.IsPublic = true;
        this.IsImported = ImportedFromModuleID != 0L;
        this.NumOverrides = Overrides.size();
        this.Extra = _Extra;
        assert (this.NumOverrides == Overrides.size()) : "too many overrides";
        assert (this.IsImported || this.NumOverrides == 0) : "overrides for non-module macro";
        if (this.IsImported) {
            uint.ptr Extra = (uint.ptr)Native.$tryClone((NativeCloneable)this.getModuleDataStart());
            ((uint.ptr)Extra.$postInc()).$set(ImportedFromModuleID);
            std.copy((uint.iterator)Overrides.begin(), (uint.iterator)Overrides.end(), (uint.iterator)Extra);
        }
    }

    public Kind getKind() {
        return this.MDKind;
    }

    public int getLocation() {
        return this.Loc;
    }

    public void setPrevious(MacroDirective Prev) {
        this.Previous = Prev;
    }

    public MacroDirective getPrevious() {
        return this.Previous;
    }

    public boolean isFromPCH() {
        return this.IsFromPCH;
    }

    public void setIsFromPCH() {
        this.IsFromPCH = true;
    }

    public boolean isImported() {
        return this.IsImported;
    }

    public long getOwningModuleID() {
        if (this.isImported()) {
            return this.getModuleDataStart().$star();
        }
        return 0L;
    }

    public ArrayRefUInt getOverriddenModules() {
        assert (this.IsImported) : "can only get overridden modules for imported macro";
        return llvm.makeArrayRef((uint.ptr)((uint.ptr)this.getModuleDataStart().$add(1)), (int)this.NumOverrides);
    }

    public DefInfo getDefinition() {
        int UndefLoc = SourceLocation.getInvalid();
        boolean isPublic$hasValue = false;
        boolean isPublic$Value = false;
        for (MacroDirective MD = this; MD != null; MD = MD.getPrevious()) {
            if (MD instanceof DefMacroDirective) {
                return new DefInfo((DefMacroDirective)MD, UndefLoc, !isPublic$hasValue || isPublic$Value);
            }
            if (MD instanceof UndefMacroDirective) {
                UndefLoc = MD.getLocation();
                continue;
            }
            VisibilityMacroDirective VisMD = (VisibilityMacroDirective)MD;
            if (isPublic$hasValue) continue;
            isPublic$hasValue = true;
            isPublic$Value = VisMD.isPublic();
        }
        return new DefInfo(null, UndefLoc, !isPublic$hasValue || isPublic$Value);
    }

    public boolean isDefined() {
        DefInfo Def = this.getDefinition();
        if (Def.$boolean()) {
            return !Def.isUndefined();
        }
        return false;
    }

    public MacroInfo getMacroInfo() {
        return this.getDefinition().getMacroInfo();
    }

    public DefInfo findDirectiveAtLoc(SourceLocation L, SourceManager SM) {
        return this.findDirectiveAtLoc(L.getRawEncodingUInt(), SM);
    }

    public DefInfo findDirectiveAtLoc(int L, SourceManager SM) {
        assert (SourceLocation.isValid((int)L)) : "SourceLocation is invalid.";
        DefInfo Def = this.getDefinition();
        while (Def.$boolean()) {
            if (SourceLocation.isInvalid((int)Def.getLocation()) || SM.isBeforeInTranslationUnit(Def.getLocation(), L)) {
                return !Def.isUndefined() || SM.isBeforeInTranslationUnit(L, Def.getUndefLocation()) ? Def : new DefInfo();
            }
            Def.$assign(Def.getPreviousDefinition());
        }
        return new DefInfo();
    }

    public void dump() {
        MacroInfo Info;
        raw_ostream Out = llvm.errs();
        switch (this.getKind()) {
            case MD_Define: {
                Out.$out(NativePointer.$((String)"DefMacroDirective"));
                break;
            }
            case MD_Undefine: {
                Out.$out(NativePointer.$((String)"UndefMacroDirective"));
                break;
            }
            case MD_Visibility: {
                Out.$out(NativePointer.$((String)"VisibilityMacroDirective"));
            }
        }
        Out.$out(NativePointer.$((String)" ")).$out((Object)this);
        MacroDirective Prev = this.getPrevious();
        if (Prev != null) {
            Out.$out(NativePointer.$((String)" prev ")).$out((Object)Prev);
        }
        if (this.IsFromPCH) {
            Out.$out(NativePointer.$((String)" from_pch"));
        }
        if (this.IsImported) {
            Out.$out(NativePointer.$((String)" imported"));
        }
        if (this.IsAmbiguous) {
            Out.$out(NativePointer.$((String)" ambiguous"));
        }
        if (this.IsPublic) {
            Out.$out(NativePointer.$((String)" public"));
        } else if (llvm.isa(VisibilityMacroDirective.class, (Object)this)) {
            Out.$out(NativePointer.$((String)" private"));
        }
        DefMacroDirective DMD = (DefMacroDirective)Casts.dyn_cast(DefMacroDirective.class, (Object)this);
        if (DMD != null && (Info = DMD.getInfo()) != null) {
            Out.$out(NativePointer.$((String)"\n  "));
            Info.dump();
        }
        Out.$out(NativePointer.$((String)"\n"));
    }

    public static boolean classof(MacroDirective $Prm0) {
        return true;
    }

    public String toString() {
        return "Previous=" + this.Previous + ", Loc=" + this.Loc + ", MDKind=" + (Object)((Object)this.MDKind) + ", IsFromPCH=" + this.IsFromPCH + ", IsAmbiguous=" + this.IsAmbiguous + ", IsPublic=" + this.IsPublic + ", IsImported=" + this.IsImported + ", NumOverrides=" + this.NumOverrides;
    }

    public static class DefInfo {
        private DefMacroDirective DefDirective;
        private int UndefLoc;
        private boolean IsPublic;

        public DefInfo() {
            this.DefDirective = null;
            this.UndefLoc = SourceLocation.getInvalid();
        }

        public DefInfo(DefMacroDirective DefDirective, int UndefLoc, boolean isPublic) {
            this.DefDirective = DefDirective;
            this.UndefLoc = UndefLoc;
            this.IsPublic = isPublic;
        }

        public DefMacroDirective getDirective() {
            return this.DefDirective;
        }

        public int getLocation() {
            if (this.isInvalid()) {
                return SourceLocation.getInvalid();
            }
            return this.DefDirective.getLocation();
        }

        public MacroInfo getMacroInfo() {
            if (this.isInvalid()) {
                return null;
            }
            return this.DefDirective.getInfo();
        }

        public int getUndefLocation() {
            return this.UndefLoc;
        }

        public boolean isUndefined() {
            return SourceLocation.isValid((int)this.UndefLoc);
        }

        public boolean isPublic() {
            return this.IsPublic;
        }

        public boolean isValid() {
            return this.DefDirective != null;
        }

        public boolean isInvalid() {
            return !this.isValid();
        }

        public boolean $boolean() {
            return this.isValid();
        }

        public DefInfo getPreviousDefinition() {
            if (this.isInvalid() || this.DefDirective.getPrevious() == null) {
                return new DefInfo();
            }
            return this.DefDirective.getPrevious().getDefinition();
        }

        public DefInfo(DefInfo $Prm0) {
            this.DefDirective = $Prm0.DefDirective;
            this.UndefLoc = $Prm0.UndefLoc;
            this.IsPublic = $Prm0.IsPublic;
        }

        public DefInfo $assign(DefInfo $Prm0) {
            this.DefDirective = $Prm0.DefDirective;
            this.UndefLoc = $Prm0.UndefLoc;
            this.IsPublic = $Prm0.IsPublic;
            return this;
        }

        public DefInfo $assignMove(DefInfo $Prm0) {
            this.DefDirective = $Prm0.DefDirective;
            this.UndefLoc = $Prm0.UndefLoc;
            this.IsPublic = $Prm0.IsPublic;
            return this;
        }
    }

    public static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind MD_Define = new Kind(0);
        public static final /* enum */ Kind MD_Undefine = new Kind(1);
        public static final /* enum */ Kind MD_Visibility = new Kind(2);
        private final int value;
        private static final /* synthetic */ Kind[] $VALUES;

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String name) {
            return Enum.valueOf(Kind.class, name);
        }

        public static Kind valueOf(int val) {
            Kind out;
            Kind kind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Kind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Kind[]{MD_Define, MD_Undefine, MD_Visibility};
        }

        private static final class Values {
            private static final Kind[] VALUES;
            private static final Kind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Kind kind : Kind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Kind[min < 0 ? 1 - min : 0];
                VALUES = new Kind[max >= 0 ? 1 + max : 0];
                for (Kind kind : Kind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Kind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Kind)kind).value] = kind;
                }
            }
        }
    }
}

