/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.ClangGlobals;
import org.clang.basic.ClankAliases;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.DirectoryEntry;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.FileManager;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.LangOptions;
import org.clang.basic.Module;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.SourceRange;
import org.clang.basic.SrcMgr;
import org.clang.basic.target.TargetInfo;
import org.clang.lex.HeaderSearch;
import org.clang.lex.Lexer;
import org.clang.lex.impl.ModuleMapParser;
import org.clang.lex.impl.ModuleMapStatics;
import org.clank.java.std;
import org.clank.java.std_errors;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.SmallPtrSet;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.DenseMap;
import org.llvm.adt.aliases.DenseMapIterator;
import org.llvm.adt.aliases.DenseMapIteratorTypeBool;
import org.llvm.adt.aliases.DenseMapTypeBool;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.StringMap;
import org.llvm.adt.aliases.StringMapConstIterator;
import org.llvm.adt.aliases.StringMapIterator;
import org.llvm.support.MallocAllocator;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;

public class ModuleMap
implements Destructors.ClassWithDestructor {
    private SourceManager SourceMgr;
    private DiagnosticsEngine Diags;
    public LangOptions LangOpts;
    public TargetInfo Target;
    public HeaderSearch HeaderInfo;
    private DirectoryEntry BuiltinIncludeDir;
    private LangOptions MMapLangOpts;
    private Module CompilingModule;
    public Module SourceModule;
    public std.string SourceModuleName;
    private StringMap<Module, MallocAllocator> Modules;
    private DenseMap<FileEntry, SmallVector<KnownHeader>> Headers;
    public DenseMap<DirectoryEntry, Module> UmbrellaDirs;
    public DenseMap<DirectoryEntry, InferredDirectory> InferredDirectories;
    private DenseMap<Module, FileEntry> InferredModuleAllowedBy;
    private DenseMap<Module, SmallPtrSet<FileEntry>> AdditionalModMaps;
    private DenseMapTypeBool<FileEntry> ParsedModuleMap;

    private ADTAliases.PointerInt2Pair<Module> resolveExport(Module Mod, Module.UnresolvedExportDecl Unresolved, boolean Complain) {
        if (Unresolved.Id.empty()) {
            assert (Unresolved.Wildcard) : "Invalid unresolved export";
            return new ADTAliases.PointerInt2Pair(null, true);
        }
        Module Context2 = this.resolveModuleId(Unresolved.Id, Mod, Complain);
        if (Context2 == null) {
            return new ADTAliases.PointerInt2Pair();
        }
        return new ADTAliases.PointerInt2Pair((Object)Context2, Unresolved.Wildcard);
    }

    private Module resolveModuleId(ClankAliases.ModuleId Id, Module Mod, boolean Complain) {
        Module Context2 = this.lookupModuleUnqualified(new StringRef((std.string)((std.pair)Id.$at((int)0)).first), Mod);
        if (Context2 == null) {
            if (Complain) {
                ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diags.Report((SourceLocation)((std.pair)Id.$at((int)0)).second, 672L), (StringRef)new StringRef((std.string)((std.pair)Id.$at((int)0)).first)), (StringRef)new StringRef(Mod.getFullModuleName())).$destroy();
            }
            return null;
        }
        long N = Id.size();
        for (long I = 1L; I != N; ++I) {
            Module Sub = this.lookupModuleQualified(new StringRef((std.string)((std.pair)Id.$at((long)I)).first), Context2);
            if (Sub == null) {
                if (Complain) {
                    ClangGlobals.$out_DiagnosticBuilder_SourceRange((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.Diags.Report((SourceLocation)((std.pair)Id.$at((long)I)).second, 671L), (StringRef)new StringRef((std.string)((std.pair)Id.$at((long)I)).first)), (StringRef)new StringRef(Context2.getFullModuleName())), (SourceRange)new SourceRange((SourceLocation)((std.pair)Id.$at((int)0)).second, (SourceLocation)((std.pair)Id.$at((long)(I - 1L))).second)).$destroy();
                }
                return null;
            }
            Context2 = Sub;
        }
        return Context2;
    }

    private DenseMapIterator<FileEntry, SmallVector<KnownHeader>> findKnownHeader(FileEntry File) {
        DenseMapIterator Known = this.Headers.find((Object)File);
        if (Known.$eq(this.Headers.end()) && File.getDir() == this.BuiltinIncludeDir && ModuleMapStatics.isBuiltinHeader(path.filename((StringRef)new StringRef(File.getName())))) {
            this.HeaderInfo.loadTopLevelSystemModules();
            return this.Headers.find((Object)File);
        }
        return Known;
    }

    private KnownHeader findHeaderInUmbrellaDirs(FileEntry File, SmallVectorImpl<DirectoryEntry> IntermediateDirs) {
        DirectoryEntry Dir = File.getDir();
        assert (Dir != null) : "file in no directory";
        StringRef DirName = this.SourceMgr.getFileManager().getCanonicalName(Dir);
        do {
            DenseMapIterator KnownDir;
            if ((KnownDir = this.UmbrellaDirs.find((Object)Dir)).$noteq(this.UmbrellaDirs.end())) {
                return new KnownHeader((Module)KnownDir.$star().second, 0);
            }
            IntermediateDirs.push_back((Object)Dir);
            DirName.$assignMove(path.parent_path((StringRef)DirName));
        } while (!DirName.empty() && (Dir = this.SourceMgr.getFileManager().getDirectory(DirName)) != null);
        return new KnownHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isHeaderInUmbrellaDirs(FileEntry File) {
        SmallVector IntermediateDirs = null;
        try {
            IntermediateDirs = new SmallVector(2, (Object)null);
            boolean bl = this.findHeaderInUmbrellaDirs(File, (SmallVectorImpl<DirectoryEntry>)IntermediateDirs).$boolean();
            return bl;
        }
        finally {
            if (IntermediateDirs != null) {
                IntermediateDirs.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Module inferFrameworkModule(StringRef ModuleName, DirectoryEntry FrameworkDir, Attributes Attrs, Module Parent) {
        SmallString UmbrellaName = null;
        SmallString SubframeworksDirName = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            Module Mod = this.lookupModuleQualified(ModuleName, Parent);
            if (Mod != null) {
                Module module = Mod;
                return module;
            }
            FileManager FileMgr = this.SourceMgr.getFileManager();
            FileEntry ModuleMapFile = null;
            if (Parent == null) {
                StringRef _Parent;
                DirectoryEntry ParentDir;
                StringRef FrameworkDirName = this.SourceMgr.getFileManager().getCanonicalName(FrameworkDir);
                if (llvm.$noteq_StringRef((StringRef)path.stem((StringRef)FrameworkDirName), (StringRef)ModuleName)) {
                    Module module = null;
                    return module;
                }
                boolean canInfer = false;
                if (path.has_parent_path((Twine)new Twine(FrameworkDirName)) && (ParentDir = FileMgr.getDirectory(_Parent = path.parent_path((StringRef)FrameworkDirName))) != null) {
                    DenseMapIterator inferred = new DenseMapIterator(this.InferredDirectories.find((Object)ParentDir));
                    if (inferred.$eq(this.InferredDirectories.end())) {
                        boolean IsFrameworkDir = _Parent.endswith((CharSequence)".framework");
                        FileEntry ModMapFile = this.HeaderInfo.lookupModuleMapFile(ParentDir, IsFrameworkDir);
                        if (ModMapFile != null) {
                            this.parseModuleMapFile(ModMapFile, Attrs.IsSystem, ParentDir);
                            inferred.$assignMove(new DenseMapIterator(this.InferredDirectories.find((Object)ParentDir)));
                        }
                        if (inferred.$eq(this.InferredDirectories.end())) {
                            $c.clean((Object)inferred.$assignMove(new DenseMapIterator((DenseMapIterator)this.InferredDirectories.insert((std.pair)((std.pair)$c.track((Object)std.make_pair((Object)ParentDir, (Object)$c.track((Object)new InferredDirectory()))))).first)));
                        }
                    }
                    if (((InferredDirectory)inferred.$star().second).InferModules) {
                        StringRef Name = path.stem((StringRef)FrameworkDirName);
                        canInfer = ((InferredDirectory)inferred.$star().second).ExcludedModules.contains((Object)Name);
                        Attrs.IsSystem |= ((InferredDirectory)inferred.$star().second).Attrs.IsSystem;
                        Attrs.IsExternC |= ((InferredDirectory)inferred.$star().second).Attrs.IsExternC;
                        Attrs.IsExhaustive |= ((InferredDirectory)inferred.$star().second).Attrs.IsExhaustive;
                        ModuleMapFile = ((InferredDirectory)inferred.$star().second).ModuleMapFile;
                    }
                }
                if (!canInfer) {
                    _Parent = null;
                    return _Parent;
                }
            } else {
                ModuleMapFile = this.getModuleMapFileForUniquing(Parent);
            }
            UmbrellaName = new SmallString(new StringRef(FrameworkDir.getName(), FrameworkDir.getNameLen()), 128);
            path.append((SmallString)UmbrellaName, (Twine)new Twine(NativePointer.$((String)"Headers")), (Twine)llvm.$plus_StringRef_char$ptr((StringRef)ModuleName, (char.ptr)NativePointer.$((String)".h")));
            FileEntry UmbrellaHeader = FileMgr.getFile(UmbrellaName.$StringRef());
            if (UmbrellaHeader == null) {
                Module canInfer = null;
                return canInfer;
            }
            Module Result = new Module(ModuleName, new SourceLocation(), Parent, true, false);
            this.InferredModuleAllowedBy.ref$at((Object)Result).$set((Object)ModuleMapFile);
            Result.IsInferred = true;
            if (llvm.$eq_StringRef((StringRef)new StringRef(this.LangOpts.CurrentModule), (StringRef)ModuleName)) {
                this.SourceModule = Result;
                $c.clean((Object)this.SourceModuleName.$assignMove((std.string)$c.track((Object)ModuleName.$basic_string())));
            }
            Result.IsSystem |= Attrs.IsSystem;
            Result.IsExternC |= Attrs.IsExternC;
            Result.ConfigMacrosExhaustive |= Attrs.IsExhaustive;
            if (Parent == null) {
                this.Modules.GetOrCreateValue((StringRef)ModuleName).second = Result;
            }
            Result.Umbrella.$assign((Object)UmbrellaHeader);
            ((SmallVector)this.Headers.$at((Object)UmbrellaHeader)).push_back((Object)new KnownHeader(Result, 0));
            this.UmbrellaDirs.ref$at((Object)UmbrellaHeader.getDir()).$set((Object)Result);
            Result.Exports.push_back((Object)new ADTAliases.PointerInt2Pair(null, true));
            Result.InferSubmodules = true;
            Result.InferExportWildcard = true;
            std_errors.error_code EC = new std_errors.error_code();
            SubframeworksDirName = new SmallString(new StringRef(FrameworkDir.getName(), FrameworkDir.getNameLen()), 128);
            path.append((SmallString)SubframeworksDirName, (char.ptr)NativePointer.$((String)"Frameworks"));
            path.__native((SmallString)SubframeworksDirName);
            fs.directory_iterator Dir = null;
            fs.directory_iterator DirEnd = null;
            try {
                Dir = new fs.directory_iterator(new Twine(SubframeworksDirName.str()), EC);
                DirEnd = new fs.directory_iterator();
                while (Dir.$noteq(DirEnd) && !EC.$boolean()) {
                    DirectoryEntry SubframeworkDir;
                    if (new StringRef(Dir.$arrow().path()).endswith((CharSequence)".framework") && (SubframeworkDir = FileMgr.getDirectory(new StringRef(Dir.$arrow().path()))) != null) {
                        SmallString NameBuf = null;
                        try {
                            boolean FoundParent;
                            block37: {
                                StringRef SubframeworkDirName = FileMgr.getCanonicalName(SubframeworkDir);
                                FoundParent = false;
                                do {
                                    SubframeworkDirName.$assignMove(path.parent_path((StringRef)SubframeworkDirName));
                                    if (SubframeworkDirName.empty()) break block37;
                                } while (FileMgr.getDirectory(SubframeworkDirName) != FrameworkDir);
                                FoundParent = true;
                            }
                            if (FoundParent) {
                                NameBuf = new SmallString(32);
                                this.inferFrameworkModule(ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(Dir.$arrow().path())), NameBuf), SubframeworkDir, new Attributes(Attrs), Result);
                            }
                        }
                        finally {
                            if (NameBuf != null) {
                                NameBuf.$destroy();
                            }
                        }
                    }
                    Dir.increment(EC);
                }
            }
            finally {
                if (DirEnd != null) {
                    DirEnd.$destroy();
                }
                if (Dir != null) {
                    Dir.$destroy();
                }
            }
            if (!Result.isSubFramework()) {
                ModuleMapStatics.inferFrameworkLink(Result, FrameworkDir, FileMgr);
            }
            Module module = Result;
            return module;
        }
        finally {
            if (SubframeworksDirName != null) {
                SubframeworksDirName.$destroy();
            }
            if (UmbrellaName != null) {
                UmbrellaName.$destroy();
            }
            $c.$destroy();
        }
    }

    public ModuleMap(SourceManager SourceMgr, DiagnosticsEngine Diags, LangOptions LangOpts, TargetInfo Target, HeaderSearch HeaderInfo) {
        this.SourceMgr = SourceMgr;
        this.Diags = Diags;
        this.LangOpts = LangOpts;
        this.Target = Target;
        this.HeaderInfo = HeaderInfo;
        this.BuiltinIncludeDir = null;
        this.MMapLangOpts = new LangOptions();
        this.CompilingModule = null;
        this.SourceModule = null;
        this.SourceModuleName = new std.string();
        this.Modules = new StringMap(null);
        this.Headers = new DenseMap(FileEntry.DenseMapInfo, (Object)new SmallVector(1, (Object)new KnownHeader()));
        this.UmbrellaDirs = new DenseMap(DirectoryEntry.DenseMapInfo, null);
        this.InferredDirectories = new DenseMap(DirectoryEntry.DenseMapInfo, (Object)new InferredDirectory());
        this.InferredModuleAllowedBy = new DenseMap(Module.DenseMapInfo, null);
        this.AdditionalModMaps = new DenseMap(Module.DenseMapInfo, (Object)new SmallPtrSet(FileEntry.DenseMapInfo, 1));
        this.ParsedModuleMap = new DenseMapTypeBool(FileEntry.DenseMapInfo, false);
    }

    public void $destroy() {
        StringMapIterator I = this.Modules.begin();
        StringMapIterator IEnd = this.Modules.end();
        while (I.$noteq((StringMapConstIterator)IEnd)) {
            if (I.$arrow().getValue() != null) {
                ((Module)I.$arrow().getValue()).$destroy();
            }
            I.$preInc();
        }
        this.ParsedModuleMap.$destroy();
        this.AdditionalModMaps.$destroy();
        this.InferredModuleAllowedBy.$destroy();
        this.InferredDirectories.$destroy();
        this.UmbrellaDirs.$destroy();
        this.Headers.$destroy();
        this.Modules.$destroy();
        this.SourceModuleName.$destroy();
        this.MMapLangOpts.$destroy();
    }

    public void setTarget(TargetInfo Target) {
        assert (this.Target == null || this.Target == Target) : "Improper target override";
        this.Target = Target;
    }

    public void setBuiltinIncludeDir(DirectoryEntry Dir) {
        this.BuiltinIncludeDir = Dir;
    }

    public KnownHeader findModuleForHeader(FileEntry File) {
        return this.findModuleForHeader(File, null, false);
    }

    public KnownHeader findModuleForHeader(FileEntry File, Module RequestingModule) {
        return this.findModuleForHeader(File, RequestingModule, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public KnownHeader findModuleForHeader(FileEntry File, Module RequestingModule, final boolean IncludeTextualHeaders) {
        SkippedDirs = null;
        try {
            Known = this.findKnownHeader(File);
            MakeResult = new MakeResultLambda(){

                @Override
                public KnownHeader $call(KnownHeader R) {
                    if (!IncludeTextualHeaders && (R.getRole() & 2) != 0) {
                        return new KnownHeader();
                    }
                    return new KnownHeader(JavaDifferentiators.Move.INSTANCE, R);
                }
            };
            if (Known.$noteq(this.Headers.end())) {
                Result = new KnownHeader();
                I /* !! */  = ((SmallVector)Known.$star().second).begin();
                E = ((SmallVector)Known.$star().second).end();
                while (I /* !! */ .$noteq((Object)E)) {
                    if (((KnownHeader)I /* !! */ .$star()).getModule().isAvailable()) {
                        if (((KnownHeader)I /* !! */ .$star()).getModule() == RequestingModule) {
                            var10_14 = MakeResult.$call(new KnownHeader((KnownHeader)I /* !! */ .$star()));
                            return var10_14;
                        }
                        if (!(RequestingModule != null && this.LangOpts.ModulesDeclUse && !ModuleMapStatics.directlyUses(RequestingModule, ((KnownHeader)I /* !! */ .$star()).getModule()) || Result.$boolean() && (Result.getRole() & 1) == 0)) {
                            Result.$assign((KnownHeader)I /* !! */ .$star());
                        }
                    }
                    I /* !! */ .$preInc();
                }
                I /* !! */  = MakeResult.$call(new KnownHeader(Result));
                return I /* !! */ ;
            }
            SkippedDirs = new SmallVector(2, (Object)null);
            H = this.findHeaderInUmbrellaDirs(File, (SmallVectorImpl<DirectoryEntry>)SkippedDirs);
            if (H.$boolean()) {
                UmbrellaModule = Result = H.getModule();
                while (UmbrellaModule.getUmbrellaDir() == null && UmbrellaModule.Parent != null) {
                    UmbrellaModule = UmbrellaModule.Parent;
                }
                if (UmbrellaModule.InferSubmodules) {
                    NameBuf = null;
                    try {
                        UmbrellaModuleMap = this.getModuleMapFileForUniquing(UmbrellaModule);
                        Explicit = UmbrellaModule.InferExplicitSubmodules;
                        for (I = (long)SkippedDirs.size(); I != 0L; --I) {
                            _NameBuf = null;
                            try {
                                _NameBuf = new SmallString(32);
                                Name = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(((DirectoryEntry)SkippedDirs.$at(I - 1L)).getName())), _NameBuf);
                                Result = (Module)this.findOrCreateModule((StringRef)Name, (Module)Result, (boolean)false, (boolean)Explicit).first;
                                this.InferredModuleAllowedBy.ref$at((Object)Result).$set((Object)UmbrellaModuleMap);
                                Result.IsInferred = true;
                                this.UmbrellaDirs.ref$at(SkippedDirs.$at(I - 1L)).$set((Object)Result);
                                if (!UmbrellaModule.InferExportWildcard || !Result.Exports.empty()) continue;
                                Result.Exports.push_back((Object)new ADTAliases.PointerInt2Pair(null, true));
                                continue;
                            }
                            finally {
                                if (_NameBuf != null) {
                                    _NameBuf.$destroy();
                                }
                            }
                        }
                        NameBuf = new SmallString(32);
                        Name = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(File.getName())), NameBuf);
                        Result = (Module)this.findOrCreateModule((StringRef)Name, (Module)Result, (boolean)false, (boolean)Explicit).first;
                        this.InferredModuleAllowedBy.ref$at((Object)Result).$set((Object)UmbrellaModuleMap);
                        Result.IsInferred = true;
                        Result.addTopHeader(File);
                        if (!UmbrellaModule.InferExportWildcard || !Result.Exports.empty()) ** GOTO lbl71
                        Result.Exports.push_back((Object)new ADTAliases.PointerInt2Pair(null, true));
                    }
                    finally {
                        if (NameBuf != null) {
                            NameBuf.$destroy();
                        }
                    }
                } else {
                    N = SkippedDirs.size();
                    for (I = 0L; I != N; ++I) {
                        this.UmbrellaDirs.ref$at(SkippedDirs.$at(I)).$set((Object)Result);
                    }
                }
lbl71:
                // 3 sources

                ((SmallVector)this.Headers.$at((Object)File)).push_back((Object)new KnownHeader(Result, 0));
                if (!Result.isAvailable()) {
                    var10_17 = new KnownHeader();
                    return var10_17;
                }
                var10_18 = MakeResult.$call(new KnownHeader((KnownHeader)((SmallVector)this.Headers.$at((Object)File)).back()));
                return var10_18;
            }
            var8_11 = new KnownHeader();
            return var8_11;
        }
        finally {
            if (SkippedDirs != null) {
                SkippedDirs.$destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diagnoseHeaderInclusion(Module RequestingModule, SourceLocation FilenameLoc, StringRef Filename, FileEntry File) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            if (ModuleMapStatics.getTopLevelOrNull(RequestingModule) != ModuleMapStatics.getTopLevelOrNull(this.SourceModule)) {
                return;
            }
            if (RequestingModule != null) {
                this.resolveUses(RequestingModule, false);
            }
            boolean Excluded = false;
            Module Private = null;
            Module NotUsed = null;
            DenseMapIterator<FileEntry, SmallVector<KnownHeader>> Known = this.findKnownHeader(File);
            if (Known.$noteq(this.Headers.end())) {
                for (KnownHeader Header2 : (SmallVector)Known.$star().second) {
                    if (Header2.getModule() == RequestingModule) {
                        return;
                    }
                    if (ModuleMapStatics.violatesPrivateInclude(RequestingModule, File, (short)Header2.getRole(), Header2.getModule())) {
                        Private = Header2.getModule();
                        continue;
                    }
                    if (RequestingModule != null && this.LangOpts.ModulesDeclUse && !ModuleMapStatics.directlyUses(RequestingModule, Header2.getModule())) {
                        NotUsed = Header2.getModule();
                        continue;
                    }
                    return;
                }
                Excluded = true;
            }
            if (Private != null) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(FilenameLoc, 755L))), (StringRef)Filename));
                return;
            }
            if (NotUsed != null) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(FilenameLoc, 754L))), (StringRef)new StringRef((std.string)$c.track((Object)RequestingModule.getFullModuleName()))), (StringRef)Filename));
                return;
            }
            if (Excluded || this.isHeaderInUmbrellaDirs(File)) {
                return;
            }
            if (this.LangOpts.ModulesStrictDeclUse) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(FilenameLoc, 754L))), (StringRef)new StringRef((std.string)$c.track((Object)RequestingModule.getFullModuleName()))), (StringRef)Filename));
            } else if (RequestingModule != null) {
                long DiagID = RequestingModule.getTopLevelModule().IsFramework ? 865L : 866L;
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)this.Diags.Report(FilenameLoc, DiagID))), (StringRef)new StringRef((std.string)$c.track((Object)RequestingModule.getFullModuleName()))));
            }
        }
        finally {
            $c.$destroy();
        }
    }

    public boolean isHeaderInUnavailableModule(FileEntry Header2) {
        return this.isHeaderUnavailableInModule(Header2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHeaderUnavailableInModule(FileEntry Header2, final Module RequestingModule) {
        SmallVector SkippedDirs = null;
        try {
            DenseMapIterator Known = this.Headers.find((Object)Header2);
            if (Known.$noteq(this.Headers.end())) {
                SmallVectorImpl.iterator I22 = ((SmallVector)Known.$star().second).begin();
                SmallVectorImpl.iterator E = ((SmallVector)Known.$star().second).end();
                while (I22.$noteq((Object)E)) {
                    if (((KnownHeader)I22.$star()).isAvailable() && (RequestingModule == null || ((KnownHeader)I22.$star()).getModule().isSubModuleOf(RequestingModule))) {
                        boolean bl = false;
                        return bl;
                    }
                    I22.$preInc();
                }
                boolean I22 = true;
                return I22;
            }
            DirectoryEntry Dir = Header2.getDir();
            SkippedDirs = new SmallVector(2, (Object)null);
            StringRef DirName = new StringRef(Dir.getName(), Dir.getNameLen());
            IsUnavailableLambda IsUnavailable = new IsUnavailableLambda(){

                @Override
                public boolean $call(Module M) {
                    return !M.isAvailable() && (RequestingModule == null || M.isSubModuleOf(RequestingModule));
                }
            };
            do {
                DenseMapIterator KnownDir;
                if ((KnownDir = this.UmbrellaDirs.find((Object)Dir)).$noteq(this.UmbrellaDirs.end())) {
                    Module Found;
                    block32: {
                        Found = (Module)KnownDir.$star().second;
                        if (IsUnavailable.$call(Found)) {
                            boolean bl = true;
                            return bl;
                        }
                        Module UmbrellaModule = Found;
                        while (UmbrellaModule.getUmbrellaDir() == null && UmbrellaModule.Parent != null) {
                            UmbrellaModule = UmbrellaModule.Parent;
                        }
                        if (UmbrellaModule.InferSubmodules) {
                            SmallString NameBuf = null;
                            for (long I = (long)SkippedDirs.size(); I != 0L; --I) {
                                SmallString _NameBuf = null;
                                try {
                                    _NameBuf = new SmallString(32);
                                    StringRef Name = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(((DirectoryEntry)SkippedDirs.$at(I - 1L)).getName())), _NameBuf);
                                    Found = this.lookupModuleQualified(Name, Found);
                                    if (Found == null) {
                                        boolean bl = false;
                                        return bl;
                                    }
                                    if (!IsUnavailable.$call(Found)) continue;
                                    boolean bl = true;
                                    return bl;
                                }
                                finally {
                                    if (_NameBuf != null) {
                                        _NameBuf.$destroy();
                                    }
                                }
                            }
                            NameBuf = new SmallString(32);
                            StringRef Name = ModuleMapStatics.sanitizeFilenameAsIdentifier(path.stem((StringRef)new StringRef(Header2.getName())), NameBuf);
                            Found = this.lookupModuleQualified(Name, Found);
                            if (Found != null) break block32;
                            boolean bl = false;
                            return bl;
                            finally {
                                if (NameBuf != null) {
                                    NameBuf.$destroy();
                                }
                            }
                        }
                    }
                    boolean bl = IsUnavailable.$call(Found);
                    return bl;
                }
                SkippedDirs.push_back((Object)Dir);
                DirName.$assignMove(path.parent_path((StringRef)DirName));
            } while (!DirName.empty() && (Dir = this.SourceMgr.getFileManager().getDirectory(DirName)) != null);
            boolean bl = false;
            return bl;
        }
        finally {
            if (SkippedDirs != null) {
                SkippedDirs.$destroy();
            }
        }
    }

    public Module findModule(StringRef Name) {
        StringMapIterator Known = this.Modules.find(Name);
        if (Known.$noteq((StringMapConstIterator)this.Modules.end())) {
            return (Module)Known.$arrow().getValue();
        }
        return null;
    }

    public Module lookupModuleUnqualified(StringRef Name, Module Context2) {
        while (Context2 != null) {
            Module Sub = this.lookupModuleQualified(Name, Context2);
            if (Sub != null) {
                return Sub;
            }
            Context2 = Context2.Parent;
        }
        return this.findModule(Name);
    }

    public Module lookupModuleQualified(StringRef Name, Module Context2) {
        if (Context2 == null) {
            return this.findModule(Name);
        }
        return Context2.findSubmodule(Name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.pairTypeBool<Module> findOrCreateModule(StringRef Name, Module Parent, boolean IsFramework, boolean IsExplicit) {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            Module Sub = this.lookupModuleQualified(Name, Parent);
            if (Sub != null) {
                std.pairTypeBool pairTypeBool2 = std.make_pair((Object)Sub, (boolean)false);
                return pairTypeBool2;
            }
            Module Result = new Module(Name, new SourceLocation(), Parent, IsFramework, IsExplicit);
            if (llvm.$eq_StringRef((StringRef)new StringRef(this.LangOpts.CurrentModule), (StringRef)Name)) {
                this.SourceModule = Result;
                $c.clean((Object)this.SourceModuleName.$assignMove((std.string)$c.track((Object)Name.$basic_string())));
            }
            if (Parent == null) {
                this.Modules.GetOrCreateValue((StringRef)Name).second = Result;
                if (!this.LangOpts.CurrentModule.empty() && this.CompilingModule == null && llvm.$eq_StringRef((StringRef)Name, (StringRef)new StringRef(this.LangOpts.CurrentModule))) {
                    this.CompilingModule = Result;
                }
            }
            std.pairTypeBool pairTypeBool3 = std.make_pair((Object)Result, (boolean)true);
            return pairTypeBool3;
        }
        finally {
            $c.$destroy();
        }
    }

    public Module inferFrameworkModule(StringRef ModuleName, DirectoryEntry FrameworkDir, boolean IsSystem, Module Parent) {
        Attributes Attrs = new Attributes();
        Attrs.IsSystem = IsSystem;
        return this.inferFrameworkModule(ModuleName, FrameworkDir, new Attributes(Attrs), Parent);
    }

    public FileEntry getContainingModuleMapFile(Module Module2) {
        if (Module2.DefinitionLoc.isInvalid()) {
            return null;
        }
        return this.SourceMgr.getFileEntryForID(this.SourceMgr.getFileID(Module2.DefinitionLoc));
    }

    public FileEntry getModuleMapFileForUniquing(Module M) {
        if (M.IsInferred) {
            assert (this.InferredModuleAllowedBy.count((Object)M)) : "missing inferred module map";
            return (FileEntry)this.InferredModuleAllowedBy.find((Object)M).$star().second;
        }
        return this.getContainingModuleMapFile(M);
    }

    public void setInferredModuleAllowedBy(Module M, FileEntry ModMap) {
        assert (M.IsInferred) : "module not inferred";
        this.InferredModuleAllowedBy.ref$at((Object)M).$set((Object)ModMap);
    }

    public SmallPtrSet<FileEntry> getAdditionalModuleMapFiles(Module M) {
        DenseMapIterator I = this.AdditionalModMaps.find((Object)M);
        if (I.$eq(this.AdditionalModMaps.end())) {
            return null;
        }
        return (SmallPtrSet)I.$star().second;
    }

    public void addAdditionalModuleMapFile(Module M, FileEntry ModuleMap2) {
        ((SmallPtrSet)this.AdditionalModMaps.$at((Object)M)).insert((Object)ModuleMap2);
    }

    public boolean resolveExports(Module Mod, boolean Complain) {
        boolean HadError = false;
        long N = Mod.UnresolvedExports.size();
        for (long I = 0L; I != N; ++I) {
            ADTAliases.PointerInt2Pair<Module> Export = this.resolveExport(Mod, (Module.UnresolvedExportDecl)Mod.UnresolvedExports.$at(I), Complain);
            if (Export.getPointer() != null || Export.getInt() != 0) {
                Mod.Exports.push_back(Export);
                continue;
            }
            HadError = true;
        }
        Mod.UnresolvedExports.clear();
        return HadError;
    }

    public boolean resolveUses(Module Mod, boolean Complain) {
        boolean HadError = false;
        long N = Mod.UnresolvedDirectUses.size();
        for (long I = 0L; I != N; ++I) {
            Module DirectUse = this.resolveModuleId((ClankAliases.ModuleId)Mod.UnresolvedDirectUses.$at(I), Mod, Complain);
            if (DirectUse != null) {
                Mod.DirectUses.push_back((Object)DirectUse);
                continue;
            }
            HadError = true;
        }
        Mod.UnresolvedDirectUses.clear();
        return HadError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resolveConflicts(Module Mod, boolean Complain) {
        boolean HadError = false;
        long N = Mod.UnresolvedConflicts.size();
        for (long I = 0L; I != N; ++I) {
            Module.Conflict Conflict2 = null;
            try {
                Module OtherMod = this.resolveModuleId(((Module.UnresolvedConflict)Mod.UnresolvedConflicts.$at((long)I)).Id, Mod, Complain);
                if (OtherMod == null) {
                    HadError = true;
                    continue;
                }
                Conflict2 = new Module.Conflict();
                Conflict2.Other = OtherMod;
                Conflict2.Message.$assign(((Module.UnresolvedConflict)Mod.UnresolvedConflicts.$at((long)I)).Message);
                Mod.Conflicts.push_back((Object)Conflict2);
                continue;
            }
            finally {
                if (Conflict2 != null) {
                    Conflict2.$destroy();
                }
            }
        }
        Mod.UnresolvedConflicts.clear();
        return HadError;
    }

    public Module inferModuleFromLocation(FullSourceLoc Loc) {
        if (Loc.isInvalid()) {
            return null;
        }
        FullSourceLoc ExpansionLoc = Loc.getExpansionLoc();
        if (!ExpansionLoc.isFileID()) {
            return null;
        }
        SourceManager SrcMgr2 = Loc.getManager();
        FileID ExpansionFileID = ExpansionLoc.getFileID();
        FileEntry ExpansionFile = SrcMgr2.getFileEntryForID(ExpansionFileID);
        while (ExpansionFile != null) {
            Module Mod = this.findModuleForHeader(ExpansionFile).getModule();
            if (Mod != null) {
                return Mod;
            }
            SourceLocation IncludeLoc = SrcMgr2.getIncludeLoc(ExpansionFileID);
            if (IncludeLoc.isInvalid()) {
                return null;
            }
            ExpansionFileID.$assign(SrcMgr2.getFileID(IncludeLoc));
        }
        return null;
    }

    public void setUmbrellaHeader(Module Mod, FileEntry UmbrellaHeader) {
        ((SmallVector)this.Headers.$at((Object)UmbrellaHeader)).push_back((Object)new KnownHeader(Mod, 0));
        Mod.Umbrella.$assign((Object)UmbrellaHeader);
        this.UmbrellaDirs.ref$at((Object)UmbrellaHeader.getDir()).$set((Object)Mod);
    }

    public void setUmbrellaDir(Module Mod, DirectoryEntry UmbrellaDir) {
        Mod.Umbrella.$assign((Object)UmbrellaDir);
        this.UmbrellaDirs.ref$at((Object)UmbrellaDir).$set((Object)Mod);
    }

    public void addHeader(Module Mod, Module.Header Header2, int Role) {
        if ((Role & 2) == 0) {
            boolean isCompilingModuleHeader = Mod.getTopLevelModule() == this.CompilingModule;
            this.HeaderInfo.MarkFileModuleHeader(Header2.Entry, Role, isCompilingModuleHeader);
        }
        ((SmallVector)this.Headers.$at((Object)Header2.Entry)).push_back((Object)new KnownHeader(Mod, Role));
        Mod.Headers[ModuleMapStatics.headerRoleToKind(Role).getValue()].push_back(std.move((Object)Header2));
    }

    public void excludeHeader(Module Mod, Module.Header Header2) {
        this.Headers.$at((Object)Header2.Entry);
        Mod.Headers[Module.HeaderKind.HK_Excluded.getValue()].push_back(std.move((Object)Header2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean parseModuleMapFile(FileEntry File, boolean IsSystem, DirectoryEntry Dir) {
        Lexer L = null;
        ModuleMapParser Parser = null;
        try {
            DenseMapIteratorTypeBool Known = this.ParsedModuleMap.find((Object)File);
            if (Known.$noteq(this.ParsedModuleMap.end())) {
                boolean bl = Known.$star().second;
                return bl;
            }
            assert (this.Target != null) : "Missing target information";
            SrcMgr.CharacteristicKind FileCharacter = IsSystem ? SrcMgr.CharacteristicKind.C_System : SrcMgr.CharacteristicKind.C_User;
            int ID = this.SourceMgr.createFileID(File, new SourceLocation(), FileCharacter);
            MemoryBuffer Buffer = this.SourceMgr.getBuffer(ID);
            if (Buffer == null) {
                boolean bl = this.ParsedModuleMap.ref$at((Object)File).$set(true);
                return bl;
            }
            L = new Lexer(ID, this.SourceMgr.getBuffer(ID), this.SourceMgr, this.MMapLangOpts);
            Parser = new ModuleMapParser(L, this.SourceMgr, this.Target, this.Diags, this, File, Dir, this.BuiltinIncludeDir, IsSystem);
            boolean Result = Parser.parseModuleMapFile();
            this.ParsedModuleMap.ref$at((Object)File).$set(Result);
            boolean bl = Result;
            return bl;
        }
        finally {
            if (Parser != null) {
                Parser.$destroy();
            }
            if (L != null) {
                L.$destroy();
            }
        }
    }

    public void dump() {
        llvm.errs().$out((CharSequence)"Modules:");
        StringMapIterator M = this.Modules.begin();
        StringMapIterator MEnd = this.Modules.end();
        while (M.$noteq((StringMapConstIterator)MEnd)) {
            ((Module)M.$arrow().getValue()).print(llvm.errs(), 2L);
            M.$preInc();
        }
        llvm.errs().$out((CharSequence)"Headers:");
        DenseMapIterator H = this.Headers.begin();
        DenseMapIterator HEnd = this.Headers.end();
        while (H.$noteq(HEnd)) {
            llvm.errs().$out((CharSequence)"  \"").$out(((FileEntry)H.$star().first).getName()).$out((CharSequence)"\" -> ");
            SmallVectorImpl.iterator I = ((SmallVector)H.$star().second).begin();
            SmallVectorImpl.iterator E = ((SmallVector)H.$star().second).end();
            while (I.$noteq((Object)E)) {
                if (I != ((SmallVector)H.$star().second).begin()) {
                    llvm.errs().$out((CharSequence)",");
                }
                llvm.errs().$out(((KnownHeader)I.$star()).getModule().getFullModuleName());
                I.$preInc();
            }
            llvm.errs().$out((CharSequence)"\n");
            H.$preInc();
        }
    }

    public StringMapIterator<Module> module_begin() {
        return this.Modules.begin();
    }

    public StringMapIterator<Module> module_end() {
        return this.Modules.end();
    }

    private static interface IsUnavailableLambda {
        public boolean $call(Module var1);
    }

    private static interface MakeResultLambda {
        public KnownHeader $call(KnownHeader var1);
    }

    public static class InferredDirectory
    implements Native.NativePOD<InferredDirectory> {
        public boolean InferModules;
        public Attributes Attrs;
        public FileEntry ModuleMapFile;
        public SmallVector<std.string> ExcludedModules;

        public InferredDirectory() {
            this.InferModules = false;
            this.Attrs = new Attributes();
            this.ExcludedModules = new SmallVector(2, (Object)new std.string());
        }

        public InferredDirectory(JavaDifferentiators.Move _dparam, InferredDirectory $Prm0) {
            this.InferModules = $Prm0.InferModules;
            this.Attrs = new Attributes(JavaDifferentiators.Move.INSTANCE, $Prm0.Attrs);
            this.ModuleMapFile = $Prm0.ModuleMapFile;
            this.ExcludedModules = new SmallVector(JavaDifferentiators.Move.INSTANCE, $Prm0.ExcludedModules);
        }

        private InferredDirectory(InferredDirectory $Prm0) {
            this.InferModules = $Prm0.InferModules;
            this.Attrs = new Attributes($Prm0.Attrs);
            this.ModuleMapFile = $Prm0.ModuleMapFile;
            this.ExcludedModules = new SmallVector($Prm0.ExcludedModules);
        }

        public InferredDirectory $assign(InferredDirectory $Prm0) {
            this.InferModules = $Prm0.InferModules;
            this.Attrs = new Attributes($Prm0.Attrs);
            this.ModuleMapFile = $Prm0.ModuleMapFile;
            this.ExcludedModules = new SmallVector($Prm0.ExcludedModules);
            return this;
        }

        public InferredDirectory clone() {
            return new InferredDirectory(this);
        }

        public boolean $eq(InferredDirectory other) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public boolean $noteq(InferredDirectory other) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public String toString() {
            return "InferModules=" + this.InferModules + ", Attrs=" + this.Attrs + ", ModuleMapFile=" + this.ModuleMapFile + ", ExcludedModules=" + this.ExcludedModules;
        }
    }

    public static class Attributes {
        public boolean IsSystem;
        public boolean IsExternC;
        public boolean IsExhaustive;

        public Attributes() {
            this.IsSystem = false;
            this.IsExternC = false;
            this.IsExhaustive = false;
        }

        public Attributes(Attributes $Prm0) {
            this.IsSystem = $Prm0.IsSystem;
            this.IsExternC = $Prm0.IsExternC;
            this.IsExhaustive = $Prm0.IsExhaustive;
        }

        public Attributes(JavaDifferentiators.Move _dparam, Attributes $Prm0) {
            this.IsSystem = $Prm0.IsSystem;
            this.IsExternC = $Prm0.IsExternC;
            this.IsExhaustive = $Prm0.IsExhaustive;
        }

        public Attributes $assign(Attributes $Prm0) {
            this.IsSystem = $Prm0.IsSystem;
            this.IsExternC = $Prm0.IsExternC;
            this.IsExhaustive = $Prm0.IsExhaustive;
            return this;
        }

        public String toString() {
            return "IsSystem=" + this.IsSystem + ", IsExternC=" + this.IsExternC + ", IsExhaustive=" + this.IsExhaustive;
        }
    }

    public static class KnownHeader {
        private ADTAliases.PointerInt2Pair<Module> Storage;

        public KnownHeader() {
            this.Storage = new ADTAliases.PointerInt2Pair(null, 0);
        }

        public KnownHeader(Module M, int Role) {
            this.Storage = new ADTAliases.PointerInt2Pair((Object)M, Role);
        }

        public Module getModule() {
            return (Module)this.Storage.getPointer();
        }

        public int getRole() {
            return this.Storage.getInt();
        }

        public boolean isAvailable() {
            return this.getModule().isAvailable();
        }

        public boolean $boolean() {
            return this.Storage.getPointer() != null;
        }

        public KnownHeader(KnownHeader $Prm0) {
            this.Storage = new ADTAliases.PointerInt2Pair($Prm0.Storage);
        }

        public KnownHeader $assign(KnownHeader $Prm0) {
            this.Storage.$assign($Prm0.Storage);
            return this;
        }

        public KnownHeader $assignMove(KnownHeader $Prm0) {
            this.Storage.$assignMove($Prm0.Storage);
            return this;
        }

        public KnownHeader(JavaDifferentiators.Move _dparam, KnownHeader $Prm0) {
            this.Storage = new ADTAliases.PointerInt2Pair(JavaDifferentiators.Move.INSTANCE, $Prm0.Storage);
        }
    }

    public static final class ModuleHeaderRole {
        public static final int NormalHeader = 0;
        public static final int PrivateHeader = 1;
        public static final int TextualHeader = 2;
    }
}

