/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.LangOptions;
import org.clang.lex.ClangGlobals;
import org.clang.lex.Preprocessor;
import org.clang.lex.impl.LiteralSupportStatics;
import org.clank.java.std;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.APFloat;
import org.llvm.adt.APInt;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitch;
import org.llvm.support.llvm;

public class NumericLiteralParser
implements Destructors.ClassWithDestructor {
    private Preprocessor PP;
    private final char.ptr ThisTokBegin;
    private final int $ThisTokBegin;
    private int ThisTokEnd;
    private int DigitsBegin;
    private int SuffixBegin;
    private char.ptr s;
    private long radix;
    private boolean saw_exponent;
    private boolean saw_period;
    private boolean saw_ud_suffix;
    private SmallString UDSuffixBuf;
    public boolean hadError;
    public boolean isUnsigned;
    public boolean isLong;
    public boolean isLongLong;
    public boolean isFloat;
    public boolean isImaginary;
    public char MicrosoftInteger;

    /*
     * Enabled aggressive block sorting
     */
    public NumericLiteralParser(StringRef TokSpelling, int TokLoc, Preprocessor PP) {
        this.PP = PP;
        this.ThisTokBegin = Native.$noClone((char.ptr)TokSpelling.begin());
        this.UDSuffixBuf = new SmallString(32);
        this.$ThisTokBegin = this.ThisTokBegin.$index();
        this.ThisTokEnd = this.$ThisTokBegin + TokSpelling.size();
        assert (!org.clang.basic.ClangGlobals.isPreprocessingNumberBody((byte)this.Ptr$star(this.ThisTokEnd))) : "didn't maximally munch?";
        this.DigitsBegin = this.$ThisTokBegin;
        this.s = Native.$tryClone((char.ptr)this.ThisTokBegin);
        this.saw_exponent = false;
        this.saw_period = false;
        this.saw_ud_suffix = false;
        this.isLong = false;
        this.isUnsigned = false;
        this.isLongLong = false;
        this.isFloat = false;
        this.isImaginary = false;
        this.MicrosoftInteger = '\u0000';
        this.hadError = false;
        if (this.s.$star() == NativePointer.$0) {
            this.ParseNumberStartingWithZero(TokLoc);
            if (this.hadError) {
                return;
            }
        } else {
            this.radix = 10L;
            this.s = Native.$noClone((char.ptr)this.SkipDigits(this.s));
            if (this.s.$index() != this.ThisTokEnd) {
                if (org.clang.basic.ClangGlobals.isHexDigit((byte)this.s.$star()) && this.s.$star() != NativePointer.$e && this.s.$star() != NativePointer.$E) {
                    org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)PP.Diag(PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 640L), (StringRef)new StringRef(this.s, 1)).$destroy();
                    this.hadError = true;
                    return;
                }
                if (this.s.$star() == NativePointer.$DOT) {
                    this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
                    this.s.$postInc();
                    this.saw_period = true;
                    this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
                    this.s = Native.$noClone((char.ptr)this.SkipDigits(this.s));
                }
            }
            if (this.s.$star() == NativePointer.$e || this.s.$star() == NativePointer.$E) {
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
                int Exponent = this.s.$index();
                this.s.$postInc();
                this.saw_exponent = true;
                if (this.s.$star() == NativePointer.$PLUS || this.s.$star() == NativePointer.$MINUS) {
                    this.s.$postInc();
                }
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
                int $s = this.s.$index();
                char.ptr first_non_digit = Native.$noClone((char.ptr)this.SkipDigits(this.s));
                int $first_non_digit = first_non_digit.$index();
                if ($first_non_digit == $s) {
                    PP.Diag(PP.AdvanceToTokenCharacter(TokLoc, Exponent - this.$ThisTokBegin), 631L).$destroy();
                    this.hadError = true;
                    return;
                }
                assert (this.s == first_non_digit) : "we used SkipDigits with reuse 'true' above";
                this.s = first_non_digit;
            }
        }
        this.SuffixBegin = this.s.$index();
        this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
        boolean isFPConstant = this.isFloatingLiteral();
        int ImaginarySuffixLoc = -1;
        while (this.s.$index() != this.ThisTokEnd) {
            block33: {
                switch (this.s.$star()) {
                    case 70: 
                    case 102: {
                        if (!isFPConstant || this.isFloat || this.isLong) break;
                        this.isFloat = true;
                        break block33;
                    }
                    case 85: 
                    case 117: {
                        if (isFPConstant || this.isUnsigned) break;
                        this.isUnsigned = true;
                        break block33;
                    }
                    case 76: 
                    case 108: {
                        if (this.isLong || this.isLongLong || this.isFloat) break;
                        if (this.s.$index() + 1 != this.ThisTokEnd && this.s.$at(1) == this.s.$at(0)) {
                            if (isFPConstant) break;
                            this.isLongLong = true;
                            this.s.$preInc();
                            break block33;
                        } else {
                            this.isLong = true;
                        }
                        break block33;
                    }
                    case 73: 
                    case 105: {
                        if (PP.getLangOpts().MicrosoftExt) {
                            if (this.isLong || this.isLongLong || this.MicrosoftInteger != '\u0000') break;
                            if (this.s.$index() + 1 != this.ThisTokEnd) {
                                switch (this.s.$at(1)) {
                                    case 56: {
                                        if (isFPConstant) break;
                                        this.s.$inc(2);
                                        this.MicrosoftInteger = (char)8;
                                        break;
                                    }
                                    case 49: {
                                        if (isFPConstant || this.s.$index() + 2 == this.ThisTokEnd) break;
                                        if (this.s.$at(2) == NativePointer.$6) {
                                            this.s.$inc(3);
                                            this.MicrosoftInteger = (char)16;
                                            break;
                                        }
                                        if (this.s.$at(2) != NativePointer.$2 || this.s.$index() + 3 == this.ThisTokEnd || this.s.$at(3) != NativePointer.$8) break;
                                        this.s.$inc(4);
                                        this.MicrosoftInteger = (char)128;
                                        break;
                                    }
                                    case 51: {
                                        if (isFPConstant || this.s.$index() + 2 == this.ThisTokEnd || this.s.$at(2) != NativePointer.$2) break;
                                        this.s.$inc(3);
                                        this.MicrosoftInteger = (char)32;
                                        break;
                                    }
                                    case 54: {
                                        if (isFPConstant || this.s.$index() + 2 == this.ThisTokEnd || this.s.$at(2) != NativePointer.$4) break;
                                        this.s.$inc(3);
                                        this.MicrosoftInteger = (char)64;
                                        break;
                                    }
                                }
                                if (this.MicrosoftInteger != '\u0000') break;
                            }
                        }
                        if (PP.getLangOpts().CPlusPlus14 && this.s.$star() == NativePointer.$i) break;
                    }
                    case 74: 
                    case 106: {
                        if (this.isImaginary) break;
                        this.isImaginary = true;
                        ImaginarySuffixLoc = this.s.$index();
                        break block33;
                    }
                }
                break;
            }
            this.s.$preInc();
        }
        if (this.s.$index() != this.ThisTokEnd) {
            ClangGlobals.expandUCNs(this.UDSuffixBuf, new StringRef(this.$SuffixBegin(), this.ThisTokEnd - this.SuffixBegin));
            if (NumericLiteralParser.isValidUDSuffix(PP.getLangOpts(), this.UDSuffixBuf.$StringRef())) {
                this.isLong = false;
                this.isUnsigned = false;
                this.isLongLong = false;
                this.isFloat = false;
                this.isImaginary = false;
                this.MicrosoftInteger = '\u0000';
                this.saw_ud_suffix = true;
                return;
            }
            org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)PP.Diag(PP.AdvanceToTokenCharacter(TokLoc, this.SuffixBegin - this.$ThisTokBegin), isFPConstant ? 643L : 644L), (StringRef)new StringRef(this.$SuffixBegin(), this.ThisTokEnd - this.SuffixBegin)).$destroy();
            this.hadError = true;
            return;
        }
        if (this.isImaginary) {
            PP.Diag(PP.AdvanceToTokenCharacter(TokLoc, ImaginarySuffixLoc - this.$ThisTokBegin), 767L).$destroy();
        }
    }

    public boolean isIntegerLiteral() {
        return !this.saw_period && !this.saw_exponent;
    }

    public boolean isFloatingLiteral() {
        return this.saw_period || this.saw_exponent;
    }

    public boolean hasUDSuffix() {
        return this.saw_ud_suffix;
    }

    public StringRef getUDSuffix() {
        assert (this.saw_ud_suffix);
        return this.UDSuffixBuf.$StringRef();
    }

    public long getUDSuffixOffset() {
        assert (this.saw_ud_suffix);
        return this.SuffixBegin - this.$ThisTokBegin;
    }

    public static boolean isValidUDSuffix(LangOptions LangOpts, StringRef Suffix) {
        if (!LangOpts.CPlusPlus11 || Suffix.empty()) {
            return false;
        }
        if (Suffix.$at(0) == NativePointer.$UNDERSCORE) {
            return true;
        }
        if (!LangOpts.CPlusPlus14) {
            return false;
        }
        return (Boolean)new StringSwitch(Suffix).Cases((CharSequence)"h", (CharSequence)"min", (CharSequence)"s", (Object)true).Cases((CharSequence)"ms", (CharSequence)"us", (CharSequence)"ns", (Object)true).Cases((CharSequence)"il", (CharSequence)"i", (CharSequence)"if", (Object)true).Default((Object)false);
    }

    public long getRadix() {
        return this.radix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean GetIntegerValue(APInt Val) {
        APInt RadixVal = null;
        APInt CharVal = null;
        try {
            long NumDigits = this.SuffixBegin - this.DigitsBegin;
            if (LiteralSupportStatics.alwaysFitsInto64Bits(this.radix, NumDigits)) {
                int Ptr;
                long N = 0L;
                for (Ptr = this.DigitsBegin; Ptr != this.SuffixBegin; Ptr += 1) {
                    if (NumericLiteralParser.isDigitSeparator(this.Ptr$star(Ptr))) continue;
                    N = N * this.radix + llvm.hexDigitValue((byte)this.Ptr$star(Ptr));
                }
                Val.$assign(N);
                Ptr = Val.getZExtValue() != N ? 1 : 0;
                return Ptr != 0;
            }
            Val.$assign(0L);
            int Ptr = this.DigitsBegin;
            RadixVal = new APInt(Val.getBitWidth(), this.radix);
            CharVal = new APInt(Val.getBitWidth(), 0L);
            APInt OldVal = new APInt(Val);
            boolean OverflowOccurred = false;
            while (Ptr < this.SuffixBegin) {
                if (NumericLiteralParser.isDigitSeparator(this.Ptr$star(Ptr))) {
                    ++Ptr;
                    continue;
                }
                long C = llvm.hexDigitValue((byte)this.Ptr$star(Ptr));
                ++Ptr;
                assert (C < this.radix) : "NumericLiteralParser ctor should have rejected this";
                CharVal.$assign(C);
                OldVal.$assign(Val);
                Val.$starassign(RadixVal);
                OverflowOccurred |= Val.udiv(RadixVal).$noteq(OldVal);
                Val.$addassign(CharVal);
                OverflowOccurred |= Val.ult(CharVal);
            }
            boolean bl = OverflowOccurred;
            return bl;
        }
        finally {
            if (CharVal != null) {
                CharVal.$destroy();
            }
            if (RadixVal != null) {
                RadixVal.$destroy();
            }
        }
    }

    public APFloat.opStatus GetFloatValue(APFloat Result) {
        long n = std.min((int)(this.SuffixBegin - this.$ThisTokBegin), (int)(this.ThisTokEnd - this.$ThisTokBegin));
        SmallString Buffer = new SmallString(16);
        StringRef Str = new StringRef(this.ThisTokBegin, n);
        if (Str.find(NativePointer.$SGL_QUOTE) != StringRef.npos) {
            Buffer.reserve(n);
            std.remove_copy_if((Object)Str.begin(), (Object)Str.end(), (Object)std.back_inserter((Object)Buffer), (NativeCallback.BoolPredicate)new NativeCallback.BoolPredicate<Byte>(){

                public boolean $call(Byte param) {
                    return NumericLiteralParser.isDigitSeparator(param);
                }
            });
            Str.$assign(Buffer.$StringRef());
        }
        return Result.convertFromString(Str, APFloat.roundingMode.rmNearestTiesToEven);
    }

    public void $destroy() {
        this.UDSuffixBuf.$destroy();
    }

    private void ParseNumberStartingWithZero(int TokLoc) {
        assert (this.s.$at(0) == NativePointer.$0) : "Invalid method call";
        this.s.$preInc();
        byte c1 = this.s.$at(0);
        byte c2 = this.s.$at(1);
        if (!(c1 != NativePointer.$x && c1 != NativePointer.$X || !org.clang.basic.ClangGlobals.isHexDigit((byte)c2) && c2 != NativePointer.$DOT)) {
            boolean noSignificand;
            this.s.$preInc();
            this.radix = 16L;
            this.DigitsBegin = this.s.$index();
            this.s = Native.$noClone((char.ptr)this.SkipHexDigits(this.s));
            boolean bl = noSignificand = this.s.$index() == this.DigitsBegin;
            if (this.s.$index() != this.ThisTokEnd && this.s.$star() == NativePointer.$DOT) {
                this.s.$preInc();
                this.saw_period = true;
                int floatDigitsBegin = this.s.$index();
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
                this.s = Native.$noClone((char.ptr)this.SkipHexDigits(this.s));
                noSignificand &= floatDigitsBegin == this.s.$index();
            }
            if (noSignificand) {
                this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 635L).$destroy();
                this.hadError = true;
                return;
            }
            if (this.s.$star() == NativePointer.$p || this.s.$star() == NativePointer.$P) {
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
                int Exponent = this.s.$index();
                this.s.$preInc();
                this.saw_exponent = true;
                if (this.s.$star() == NativePointer.$PLUS || this.s.$star() == NativePointer.$MINUS) {
                    this.s.$preInc();
                }
                int $s = this.s.$index();
                char.ptr first_non_digit = Native.$noClone((char.ptr)this.SkipDigits(this.s));
                int $first_non_digit = first_non_digit.$index();
                if ($first_non_digit == $s) {
                    this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, Exponent - this.$ThisTokBegin), 631L).$destroy();
                    this.hadError = true;
                    return;
                }
                Native.$setIndex((char.ptr)this.s, (int)$s);
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
                Native.$setIndex((char.ptr)this.s, (int)$first_non_digit);
                if (!this.PP.getLangOpts().HexFloats) {
                    this.PP.Diag(TokLoc, 766L).$destroy();
                }
            } else if (this.saw_period) {
                this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 636L).$destroy();
                this.hadError = true;
            }
            return;
        }
        if (!(c1 != NativePointer.$b && c1 != NativePointer.$B || c2 != NativePointer.$0 && c2 != NativePointer.$1)) {
            this.PP.Diag(TokLoc, this.PP.getLangOpts().CPlusPlus14 ? 842L : (this.PP.getLangOpts().CPlusPlus ? 758L : 757L)).$destroy();
            this.s.$preInc();
            this.radix = 2L;
            this.DigitsBegin = this.s.$index();
            this.s = this.SkipBinaryDigits(this.s);
            if (this.s.$index() != this.ThisTokEnd && org.clang.basic.ClangGlobals.isHexDigit((byte)this.s.$star())) {
                org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 637L), (StringRef)new StringRef(this.s, 1)).$destroy();
                this.hadError = true;
            }
            return;
        }
        this.radix = 8L;
        this.DigitsBegin = this.s.$index();
        this.s = Native.$noClone((char.ptr)this.SkipOctalDigits(this.s));
        if (this.s.$index() == this.ThisTokEnd) {
            return;
        }
        if (org.clang.basic.ClangGlobals.isDigit((byte)this.s.$star())) {
            int $s = this.s.$index();
            char.ptr EndDecimal = Native.$noClone((char.ptr)this.SkipDigits(this.s));
            if (EndDecimal.$at(0) == NativePointer.$DOT || EndDecimal.$at(0) == NativePointer.$e || EndDecimal.$at(0) == NativePointer.$E) {
                assert (this.s == EndDecimal) : "we used SkipDigits above which reuse pointer";
                this.s = Native.$noClone((char.ptr)EndDecimal);
                this.radix = 10L;
            } else {
                Native.$setIndex((char.ptr)this.s, (int)$s);
            }
        }
        if (org.clang.basic.ClangGlobals.isHexDigit((byte)this.s.$star()) && this.s.$star() != NativePointer.$e && this.s.$star() != NativePointer.$E) {
            org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, this.s.$sub((abstract_iterator)this.ThisTokBegin)), 641L), (StringRef)new StringRef(this.s, 1)).$destroy();
            this.hadError = true;
            return;
        }
        if (this.s.$star() == NativePointer.$DOT) {
            this.s.$preInc();
            this.radix = 10L;
            this.saw_period = true;
            this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
            this.s = Native.$noClone((char.ptr)this.SkipDigits(this.s));
        }
        if (this.s.$star() == NativePointer.$e || this.s.$star() == NativePointer.$E) {
            this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_AfterDigits);
            int Exponent = this.s.$index();
            this.s.$preInc();
            this.radix = 10L;
            this.saw_exponent = true;
            if (this.s.$star() == NativePointer.$PLUS || this.s.$star() == NativePointer.$MINUS) {
                this.s.$preInc();
            }
            int $s = this.s.$index();
            char.ptr first_non_digit = Native.$noClone((char.ptr)this.SkipDigits(this.s));
            int $first_non_digit = first_non_digit.$index();
            if (first_non_digit.$noteq((Object)this.s)) {
                Native.$setIndex((char.ptr)this.s, (int)$s);
                this.checkSeparator(TokLoc, this.s, CheckSeparatorKind.CSK_BeforeDigits);
                Native.$setIndex((char.ptr)this.s, (int)$first_non_digit);
            } else {
                this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, Exponent - this.$ThisTokBegin), 631L).$destroy();
                this.hadError = true;
                return;
            }
        }
    }

    private static boolean isDigitSeparator(byte C) {
        return C == NativePointer.$SGL_QUOTE;
    }

    private void checkSeparator(int TokLoc, char.ptr Pos, CheckSeparatorKind IsAfterDigits) {
        int $PosDecremented = 0;
        if (IsAfterDigits == CheckSeparatorKind.CSK_AfterDigits) {
            if (Pos.$index() == this.$ThisTokBegin) {
                return;
            }
            --$PosDecremented;
        } else if (Pos.$index() == this.ThisTokEnd) {
            return;
        }
        if (NumericLiteralParser.isDigitSeparator(Pos.$at($PosDecremented))) {
            org.clang.basic.ClangGlobals.$out_DiagnosticBuilder_int((DiagnosticBuilder)this.PP.Diag(this.PP.AdvanceToTokenCharacter(TokLoc, Pos.$sub((abstract_iterator)this.ThisTokBegin) + $PosDecremented), 628L), (int)IsAfterDigits.getValue()).$destroy();
        }
    }

    private char.ptr SkipHexDigits(char.ptr ptr2) {
        ptr2 = Native.$noClone((char.ptr)ptr2);
        while (ptr2.$index() != this.ThisTokEnd && (org.clang.basic.ClangGlobals.isHexDigit((byte)ptr2.$star()) || NumericLiteralParser.isDigitSeparator(ptr2.$star()))) {
            ptr2.$preInc();
        }
        return ptr2;
    }

    private char.ptr SkipOctalDigits(char.ptr ptr2) {
        ptr2 = Native.$noClone((char.ptr)ptr2);
        while (ptr2.$index() != this.ThisTokEnd && (ptr2.$star() >= NativePointer.$0 && ptr2.$star() <= NativePointer.$7 || NumericLiteralParser.isDigitSeparator(ptr2.$star()))) {
            ptr2.$preInc();
        }
        return ptr2;
    }

    private char.ptr SkipDigits(char.ptr ptr2) {
        ptr2 = Native.$noClone((char.ptr)ptr2);
        while (ptr2.$index() != this.ThisTokEnd && (org.clang.basic.ClangGlobals.isDigit((byte)ptr2.$star()) || NumericLiteralParser.isDigitSeparator(ptr2.$star()))) {
            ptr2.$preInc();
        }
        return ptr2;
    }

    private char.ptr SkipBinaryDigits(char.ptr ptr2) {
        ptr2 = Native.$noClone((char.ptr)ptr2);
        while (ptr2.$index() != this.ThisTokEnd && (ptr2.$star() == NativePointer.$0 || ptr2.$star() == NativePointer.$1 || NumericLiteralParser.isDigitSeparator(ptr2.$star()))) {
            ptr2.$preInc();
        }
        return ptr2;
    }

    private char.ptr $SuffixBegin() {
        int shift = this.SuffixBegin - this.$ThisTokBegin;
        return shift == 0 ? this.ThisTokBegin : (char.ptr)this.ThisTokBegin.$add(shift);
    }

    private byte Ptr$star(int PtrIndex) {
        return this.ThisTokBegin.$at(PtrIndex - this.$ThisTokBegin);
    }

    private static final class CheckSeparatorKind
    extends Enum<CheckSeparatorKind> {
        public static final /* enum */ CheckSeparatorKind CSK_BeforeDigits = new CheckSeparatorKind(0L);
        public static final /* enum */ CheckSeparatorKind CSK_AfterDigits = new CheckSeparatorKind(1L);
        private final int value;
        private static final /* synthetic */ CheckSeparatorKind[] $VALUES;

        public static CheckSeparatorKind[] values() {
            return (CheckSeparatorKind[])$VALUES.clone();
        }

        public static CheckSeparatorKind valueOf(String name) {
            return Enum.valueOf(CheckSeparatorKind.class, name);
        }

        public static CheckSeparatorKind valueOf(int val) {
            CheckSeparatorKind out;
            CheckSeparatorKind checkSeparatorKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private CheckSeparatorKind(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new CheckSeparatorKind[]{CSK_BeforeDigits, CSK_AfterDigits};
        }

        private static final class Values {
            private static final CheckSeparatorKind[] VALUES;
            private static final CheckSeparatorKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (CheckSeparatorKind kind : CheckSeparatorKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CheckSeparatorKind[min < 0 ? 1 - min : 0];
                VALUES = new CheckSeparatorKind[max >= 0 ? 1 + max : 0];
                for (CheckSeparatorKind kind : CheckSeparatorKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CheckSeparatorKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CheckSeparatorKind)kind).value] = kind;
                }
            }
        }
    }
}

