/*
 * Decompiled with CFR 0.152.
 */
package org.clang.lex;

import org.clang.basic.ClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticsEngine;
import org.clang.basic.FileEntry;
import org.clang.basic.FileID;
import org.clang.basic.FileSystemStatCache;
import org.clang.basic.IdentifierInfo;
import org.clang.basic.IdentifierInfoLookup;
import org.clang.basic.OnDiskChainedHashTable;
import org.clang.lex.PTHLexer;
import org.clang.lex.Preprocessor;
import org.clang.lex.impl.PTHFileLookupCommonTrait;
import org.clang.lex.impl.PTHLexerStatics;
import org.clang.lex.impl.PTHStatCache;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Casts;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uchar;
import org.clank.support.void;
import org.llvm.adt.StringRef;
import org.llvm.adt.Twine;
import org.llvm.support.BumpPtrAllocator;
import org.llvm.support.ErrorOr;
import org.llvm.support.MemoryBuffer;
import org.llvm.support.llvm;

public class PTHManager
extends IdentifierInfoLookup
implements Destructors.ClassWithDestructor {
    private std_ptr.unique_ptr<MemoryBuffer> Buf;
    private BumpPtrAllocator Alloc;
    private std_ptr.unique_ptr_with_deleter<IdentifierInfo[]> PerIDCache;
    private std_ptr.unique_ptr<OnDiskChainedHashTable<FileEntry, std.pairUCharType<char.ptr>, PTHLexerStatics.PTHFileData>> FileLookup;
    private uchar.ptr IdDataTable;
    private std_ptr.unique_ptr<OnDiskChainedHashTable<std.pairTypeUInt<char.ptr>, std.pairTypeUInt<char.ptr>, Long>> StringIdLookup;
    private long NumIds;
    private Preprocessor PP;
    uchar.ptr SpellingBase;
    private char.ptr OriginalSourceFile;

    private PTHManager(std_ptr.unique_ptr<MemoryBuffer> buf, std_ptr.unique_ptr<OnDiskChainedHashTable<FileEntry, std.pairUCharType<char.ptr>, PTHLexerStatics.PTHFileData>> fileLookup, uchar.ptr idDataTable, std_ptr.unique_ptr_with_deleter<IdentifierInfo[]> perIDCache, std_ptr.unique_ptr<OnDiskChainedHashTable<std.pairTypeUInt<char.ptr>, std.pairTypeUInt<char.ptr>, Long>> stringIdLookup, long numIds, uchar.ptr spellingBase, char.ptr originalSourceFile) {
        this.Buf = new std_ptr.unique_ptr(JavaDifferentiators.Move.INSTANCE, std.move(buf));
        this.Alloc = new BumpPtrAllocator();
        this.PerIDCache = new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.Move.INSTANCE, std.move(perIDCache));
        this.FileLookup = new std_ptr.unique_ptr(JavaDifferentiators.Move.INSTANCE, std.move(fileLookup));
        this.IdDataTable = Native.$tryClone((uchar.ptr)idDataTable);
        this.StringIdLookup = new std_ptr.unique_ptr(JavaDifferentiators.Move.INSTANCE, std.move(stringIdLookup));
        this.NumIds = numIds;
        this.PP = null;
        this.SpellingBase = Native.$tryClone((uchar.ptr)spellingBase);
        this.OriginalSourceFile = Native.$tryClone((char.ptr)originalSourceFile);
    }

    private PTHManager(PTHManager $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private void $assign(PTHManager $Prm0) {
        throw new UnsupportedOperationException("LLVM_DELETED_FUNCTION");
    }

    private int getSpellingAtPTHOffset(int PTHOffset, type.ref<char.ptr> Buffer) {
        throw new UnsupportedOperationException("getSpellingAtPTHOffset doesn't have implementation");
    }

    IdentifierInfo GetIdentifierInfo(long PersistentID) {
        IdentifierInfo II = ((IdentifierInfo[])this.PerIDCache.$star())[(int)PersistentID];
        if (II != null) {
            return II;
        }
        return this.LazilyCreateIdentifierInfo(PersistentID);
    }

    private IdentifierInfo LazilyCreateIdentifierInfo(long PersistentID) {
        IdentifierInfo II;
        uchar.ptr TableEntry = (uchar.ptr)this.IdDataTable.$add((long)NativeType.sizeof(Long.TYPE) * PersistentID);
        uchar.ptr IDData = Native.$tryClone((uchar.ptr)((uchar.ptr)((uchar.ptr)Casts.reinterpret_cast(uchar.ptr.class, (void.ptr)((MemoryBuffer)this.Buf.$arrow()).getBufferStart())).$add(((Long)llvm.support.endian.readNext((uchar.ptr)TableEntry, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L)).longValue())));
        assert (IDData.$less(Casts.reinterpret_cast(uchar.ptr.class, (void.ptr)((MemoryBuffer)this.Buf.$arrow()).getBufferEnd())));
        std.pair Mem = new std.pair();
        Mem.second = Native.$tryClone((uchar.ptr)IDData);
        assert (IDData.$at(0) != '\u0000');
        ((IdentifierInfo[])this.PerIDCache.$star())[(int)PersistentID] = II = new IdentifierInfo(NativePointer.EMPTY, 0);
        assert (II.getNameStart() != null && II.getNameStart().$at(0) != 0);
        return II;
    }

    public void $destroy() {
        this.StringIdLookup.$destroy();
        this.FileLookup.$destroy();
        this.PerIDCache.$destroy();
        this.Alloc.$destroy();
        this.Buf.$destroy();
        super.$destroy();
    }

    public char.ptr getOriginalSourceFile() {
        return this.OriginalSourceFile;
    }

    public IdentifierInfo get(StringRef Name) {
        assert (Name.empty() || Name.back() != 0);
        OnDiskChainedHashTable.iterator I = ((OnDiskChainedHashTable)this.StringIdLookup.$arrow()).find((Object)new std.pairTypeUInt(std.make_pair_T_UInt((Object)Name.data(), (long)Name.size())));
        if (I.$eq(((OnDiskChainedHashTable)this.StringIdLookup.$arrow()).end())) {
            return null;
        }
        assert ((Long)I.$star() > 0L);
        return this.GetIdentifierInfo((Long)I.$star() - 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PTHManager Create(std.string file, DiagnosticsEngine Diags) {
        ErrorOr FileOrErr = null;
        std_ptr.unique_ptr FL = null;
        std_ptr.unique_ptr SL = null;
        std_ptr.unique_ptr_with_deleter PerIDCache = null;
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            uchar.ptr originalSourceBase;
            long len;
            uchar.ptr IDTableOffset;
            uchar.ptr IData;
            FileOrErr = MemoryBuffer.getFile((Twine)new Twine(file));
            if (!FileOrErr.$boolean()) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(642L))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            std_ptr.unique_ptr File = new std_ptr.unique_ptr(JavaDifferentiators.Move.INSTANCE, std.move((std_ptr.unique_ptr)((std_ptr.unique_ptr)FileOrErr.get())));
            uchar.ptr BufBeg = Native.$tryClone((uchar.ptr)((uchar.ptr)Casts.reinterpret_cast(uchar.ptr.class, (void.ptr)((MemoryBuffer)File.$arrow()).getBufferStart())));
            uchar.ptr BufEnd = Native.$tryClone((uchar.ptr)((uchar.ptr)Casts.reinterpret_cast(uchar.ptr.class, (void.ptr)((MemoryBuffer)File.$arrow()).getBufferEnd())));
            if (BufEnd.$sub((abstract_iterator)BufBeg) < NativeType.sizeof((Object)NativePointer.$((String)"cfe-pth")) + 4 + 4 || std.memcmp((uchar.ptr)BufBeg, (char.ptr)NativePointer.$((String)"cfe-pth"), (long)NativeType.sizeof((Object)NativePointer.$((String)"cfe-pth"))) != 0) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(642L))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            uchar.ptr p = Native.$tryClone((uchar.ptr)((uchar.ptr)BufBeg.$add(NativeType.sizeof((Object)NativePointer.$((String)"cfe-pth")))));
            long Version = (Long)llvm.support.endian.readNext((uchar.ptr)p, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
            if (Version < (long)Unnamed_enum.Version.getValue()) {
                PTHLexerStatics.InvalidPTH(Diags, Version < (long)Unnamed_enum.Version.getValue() ? NativePointer.$((String)"PTH file uses an older PTH format that is no longer supported") : NativePointer.$((String)"PTH file uses a newer PTH format that cannot be read"));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            uchar.ptr PrologueOffset = Native.$tryClone((uchar.ptr)p);
            if (PrologueOffset.$greatereq((Object)BufEnd)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(642L))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            uchar.ptr FileTableOffset = Native.$tryClone((uchar.ptr)((uchar.ptr)PrologueOffset.$add(NativeType.sizeof(Long.TYPE) * 2)));
            uchar.ptr FileTable = Native.$tryClone((uchar.ptr)((uchar.ptr)BufBeg.$add(((Long)llvm.support.endian.readNext((uchar.ptr)FileTableOffset, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L)).longValue())));
            if (!FileTable.$greater((Object)BufBeg) || !FileTable.$less((Object)BufEnd)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(642L))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            FL = new std_ptr.unique_ptr((Object)OnDiskChainedHashTable.Create((uchar.ptr)FileTable, (uchar.ptr)BufBeg, (OnDiskChainedHashTable.InfoInterface)new PTHFileLookupTrait()));
            if (((OnDiskChainedHashTable)FL.$arrow()).isEmpty()) {
                PTHLexerStatics.InvalidPTH(Diags, NativePointer.$((String)"PTH file contains no cached source data"));
            }
            if (!(IData = Native.$tryClone((uchar.ptr)((uchar.ptr)BufBeg.$add(((Long)llvm.support.endian.readNext((uchar.ptr)(IDTableOffset = Native.$tryClone((uchar.ptr)((uchar.ptr)PrologueOffset.$add(NativeType.sizeof(Long.TYPE) * 0)))), Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L)).longValue())))).$greatereq((Object)BufBeg) || !IData.$less((Object)BufEnd)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(642L))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            uchar.ptr StringIdTableOffset = Native.$tryClone((uchar.ptr)((uchar.ptr)PrologueOffset.$add(NativeType.sizeof(Long.TYPE) * 1)));
            uchar.ptr StringIdTable = Native.$tryClone((uchar.ptr)((uchar.ptr)BufBeg.$add(((Long)llvm.support.endian.readNext((uchar.ptr)StringIdTableOffset, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L)).longValue())));
            if (!StringIdTable.$greatereq((Object)BufBeg) || !StringIdTable.$less((Object)BufEnd)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(642L))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            SL = new std_ptr.unique_ptr((Object)OnDiskChainedHashTable.Create((uchar.ptr)StringIdTable, (uchar.ptr)BufBeg, (OnDiskChainedHashTable.InfoInterface)new PTHStringLookupTrait()));
            uchar.ptr spellingBaseOffset = Native.$tryClone((uchar.ptr)((uchar.ptr)PrologueOffset.$add(NativeType.sizeof(Long.TYPE) * 3)));
            uchar.ptr spellingBase = Native.$tryClone((uchar.ptr)((uchar.ptr)BufBeg.$add(((Long)llvm.support.endian.readNext((uchar.ptr)spellingBaseOffset, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L)).longValue())));
            if (!spellingBase.$greatereq((Object)BufBeg) || !spellingBase.$less((Object)BufEnd)) {
                $c.clean((Object)ClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c.track((Object)Diags.Report(642L))), (StringRef)new StringRef(file)));
                PTHManager pTHManager = null;
                return pTHManager;
            }
            long NumIds = (Long)llvm.support.endian.readNext((uchar.ptr)IData, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
            PerIDCache = new std_ptr.unique_ptr_with_deleter();
            if (NumIds != 0L) {
                PerIDCache.reset((Object)((IdentifierInfo[])std.calloc((long)NumIds, (long)NativeType.sizeof((Object)((IdentifierInfo[])PerIDCache.$star())[0])).$array()));
                if (!PerIDCache.$boolean()) {
                    PTHLexerStatics.InvalidPTH(Diags, NativePointer.$((String)"Could not allocate memory for processing PTH file"));
                    PTHManager pTHManager = null;
                    return pTHManager;
                }
            }
            if ((len = (long)((Character)llvm.support.endian.readNext((uchar.ptr)(originalSourceBase = Native.$tryClone((uchar.ptr)((uchar.ptr)PrologueOffset.$add(NativeType.sizeof(Long.TYPE) * 4)))), Character.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)1L)).charValue()) == 0L) {
                originalSourceBase = null;
            }
            PTHManager pTHManager = (PTHManager)((Object)$c.clean((Object)new PTHManager((std_ptr.unique_ptr<MemoryBuffer>)$c.track(new std_ptr.unique_ptr(std.move((std_ptr.unique_ptr)File))), (std_ptr.unique_ptr<OnDiskChainedHashTable<FileEntry, std.pairUCharType<char.ptr>, PTHLexerStatics.PTHFileData>>)$c.track(new std_ptr.unique_ptr(JavaDifferentiators.Move.INSTANCE, std.move((std_ptr.unique_ptr)FL))), IData, (std_ptr.unique_ptr_with_deleter<IdentifierInfo[]>)$c.track(new std_ptr.unique_ptr_with_deleter(JavaDifferentiators.Move.INSTANCE, std.move((std_ptr.unique_ptr)PerIDCache))), (std_ptr.unique_ptr<OnDiskChainedHashTable<std.pairTypeUInt<char.ptr>, std.pairTypeUInt<char.ptr>, Long>>)$c.track(new std_ptr.unique_ptr(JavaDifferentiators.Move.INSTANCE, std.move((std_ptr.unique_ptr)SL))), NumIds, spellingBase, (char.ptr)Casts.reinterpret_cast(char.ptr.class, (void.ptr)originalSourceBase))));
            return pTHManager;
        }
        finally {
            if (PerIDCache != null) {
                PerIDCache.$destroy();
            }
            if (SL != null) {
                SL.$destroy();
            }
            if (FL != null) {
                FL.$destroy();
            }
            if (FileOrErr != null) {
                FileOrErr.$destroy();
            }
            $c.$destroy();
        }
    }

    public void setPreprocessor(Preprocessor pp) {
        this.PP = pp;
    }

    public PTHLexer CreateLexer(FileID FID) {
        return this.CreateLexer(FID.$ID());
    }

    public PTHLexer CreateLexer(int FID) {
        FileEntry FE = this.PP.getSourceManager().getFileEntryForID(FID);
        if (FE == null) {
            return null;
        }
        OnDiskChainedHashTable.iterator I = ((OnDiskChainedHashTable)this.FileLookup.$arrow()).find((Object)FE);
        if (I.$eq(((OnDiskChainedHashTable)this.FileLookup.$arrow()).end())) {
            return null;
        }
        PTHLexerStatics.PTHFileData FileData = (PTHLexerStatics.PTHFileData)I.$star();
        uchar.ptr BufStart = Native.$tryClone((uchar.ptr)((uchar.ptr)Casts.reinterpret_cast(uchar.ptr.class, (void.ptr)((MemoryBuffer)this.Buf.$arrow()).getBufferStart())));
        uchar.ptr data = Native.$tryClone((uchar.ptr)((uchar.ptr)BufStart.$add(FileData.getTokenOffset())));
        uchar.ptr ppcond = Native.$tryClone((uchar.ptr)((uchar.ptr)BufStart.$add(FileData.getPPCondOffset())));
        long Len = (Long)llvm.support.endian.readNext((uchar.ptr)ppcond, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)0L);
        if (Len == 0L) {
            ppcond = null;
        }
        assert (this.PP != null) : "No preprocessor set yet!";
        return new PTHLexer(this.PP, FID, data, ppcond, this);
    }

    public std_ptr.unique_ptr<FileSystemStatCache> createStatCache() {
        JavaCleaner $c = Native.$createJavaCleaner();
        try {
            std_ptr.unique_ptr unique_ptr2 = (std_ptr.unique_ptr)$c.clean((Object)new std_ptr.unique_ptr($c.track(llvm.make_unique((Object)((Object)new PTHStatCache((OnDiskChainedHashTable<FileEntry, std.pairUCharType<char.ptr>, PTHLexerStatics.PTHFileData>)((OnDiskChainedHashTable)this.FileLookup.$star())))))));
            return unique_ptr2;
        }
        finally {
            $c.$destroy();
        }
    }

    public static final class Unnamed_enum
    extends Enum<Unnamed_enum> {
        public static final /* enum */ Unnamed_enum Version = new Unnamed_enum(10L);
        private final int value;
        private static final /* synthetic */ Unnamed_enum[] $VALUES;

        public static Unnamed_enum[] values() {
            return (Unnamed_enum[])$VALUES.clone();
        }

        public static Unnamed_enum valueOf(String name) {
            return Enum.valueOf(Unnamed_enum.class, name);
        }

        public static Unnamed_enum valueOf(int val) {
            Unnamed_enum out;
            Unnamed_enum unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            return out;
        }

        private Unnamed_enum(long val) {
            this.value = (int)val;
        }

        public int getValue() {
            return this.value;
        }

        static {
            $VALUES = new Unnamed_enum[]{Version};
        }

        private static final class Values {
            private static final Unnamed_enum[] VALUES;
            private static final Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (Unnamed_enum kind : Unnamed_enum.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Unnamed_enum)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }

    private static class PTHFileLookupTrait
    extends PTHFileLookupCommonTrait<FileEntry, PTHLexerStatics.PTHFileData> {
        public std.pairUCharType<char.ptr> GetInternalKey(FileEntry FE) {
            return std.make_pair_uchar_T((short)1, (Object)FE.getName());
        }

        public boolean EqualKey(std.pairUCharType<char.ptr> a, std.pairUCharType<char.ptr> b) {
            return a.first == b.first && std.strcmp((char.ptr)((char.ptr)a.second), (char.ptr)((char.ptr)b.second)) == 0;
        }

        public PTHLexerStatics.PTHFileData ReadData(std.pairUCharType<char.ptr> k, uchar.ptr d, long $Prm2) {
            assert (k.first == 1) : "Only file lookups can match!";
            long x = (Long)llvm.support.endian.readNext((uchar.ptr)d, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)1L);
            long y = (Long)llvm.support.endian.readNext((uchar.ptr)d, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)1L);
            return new PTHLexerStatics.PTHFileData(x, y);
        }

        public PTHFileLookupTrait(PTHFileLookupTrait $Prm0) {
            super($Prm0);
        }

        public PTHFileLookupTrait() {
        }

        public FileEntry GetExternalKey(std.pairUCharType<char.ptr> x) {
            throw new UnsupportedOperationException("Must Not Be called for this class.");
        }

        public String toString() {
            return "" + super.toString();
        }
    }

    private static class PTHStringLookupTrait
    implements OnDiskChainedHashTable.InfoInterface<std.pairTypeUInt<char.ptr>, std.pairTypeUInt<char.ptr>, Long> {
        public boolean EqualKey(std.pairTypeUInt<char.ptr> a, std.pairTypeUInt<char.ptr> b) {
            return a.second == b.second ? std.memcmp((char.ptr)((char.ptr)a.first), (char.ptr)((char.ptr)b.first), (int)Unsigned.long2uint((long)a.second)) == 0 : false;
        }

        public long ComputeHash(std.pairTypeUInt<char.ptr> a) {
            return llvm.HashString((StringRef)new StringRef((char.ptr)a.first, a.second));
        }

        public std.pairTypeUInt<char.ptr> GetInternalKey(std.pairTypeUInt<char.ptr> x) {
            return x;
        }

        public std.pairUIntUInt ReadKeyDataLength(type.ref<uchar.ptr> d) {
            return std.make_pair_uint_uint((long)((Character)llvm.support.endian.readNext((uchar.ptr)((uchar.ptr)d.$deref()), Character.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)1L)).charValue(), (long)NativeType.sizeof(Long.TYPE));
        }

        public std.pairTypeUInt<char.ptr> ReadKey(uchar.ptr d, long n) {
            assert (n >= 2L && d.$at(n - 1L) == '\u0000');
            return std.make_pair_T_UInt((Object)Casts.reinterpret_cast(char.ptr.class, (void.ptr)d), (long)(n - 1L));
        }

        public Long ReadData(std.pairTypeUInt<char.ptr> k, uchar.ptr d, long $Prm2) {
            return (Long)llvm.support.endian.readNext((uchar.ptr)d, Long.TYPE, (llvm.support.endianness)llvm.support.endianness.little, (long)1L);
        }

        public PTHStringLookupTrait(PTHStringLookupTrait $Prm0) {
        }

        public PTHStringLookupTrait() {
        }

        public std.pairTypeUInt<char.ptr> GetExternalKey(std.pairTypeUInt<char.ptr> x) {
            throw new UnsupportedOperationException("Must Not Be called for this class");
        }

        public String toString() {
            return "";
        }
    }
}

