/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.groovy.extender;

import java.util.List;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.POMComponentFactory;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.Project;

public class AddGroovyEclipseCompiler
implements ModelOperation<POMModel> {
    private static final String GROOVY_ECLIPSE_COMPILER_ARTIFACT_ID = "groovy-eclipse-compiler";
    private static final String GROOVY_ECLIPSE_COMPILER_GROUP_ID = "org.codehaus.groovy";
    private static final String GROOVY_ECLIPSE_COMPILER_VERSION = "2.6.0-01";

    public void performOperation(POMModel model) {
        POMComponentFactory factory = model.getFactory();
        Project project = model.getProject();
        Build build = project.getBuild();
        if (build == null) {
            build = factory.createBuild();
            project.setBuild(build);
        }
        Plugin groovyEclipseCompiler = factory.createPlugin();
        groovyEclipseCompiler.setArtifactId(GROOVY_ECLIPSE_COMPILER_ARTIFACT_ID);
        groovyEclipseCompiler.setGroupId(GROOVY_ECLIPSE_COMPILER_GROUP_ID);
        groovyEclipseCompiler.setVersion(GROOVY_ECLIPSE_COMPILER_VERSION);
        groovyEclipseCompiler.setExtensions(Boolean.TRUE);
        if (!this.groovyEclipseCompilerExists(build)) {
            build.addPlugin(groovyEclipseCompiler);
        }
    }

    private boolean groovyEclipseCompilerExists(Build build) {
        List plugins = build.getPlugins();
        if (plugins != null) {
            for (Plugin plugin : plugins) {
                if (!GROOVY_ECLIPSE_COMPILER_ARTIFACT_ID.equals(plugin.getArtifactId()) || !GROOVY_ECLIPSE_COMPILER_GROUP_ID.equals(plugin.getVersion())) continue;
                return true;
            }
        }
        return false;
    }
}

