/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.scenebuilder;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.javafx2.editor.spi.FXMLOpener;
import org.netbeans.modules.javafx2.scenebuilder.Bundle;
import org.netbeans.modules.javafx2.scenebuilder.Home;
import org.netbeans.modules.javafx2.scenebuilder.Settings;
import org.openide.cookies.SaveCookie;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;

public final class SceneBuilderFXMLOpener
extends FXMLOpener {
    private static final Logger LOG = Logger.getLogger(SceneBuilderFXMLOpener.class.getName());
    private Settings settings = Settings.getInstance();

    public boolean isEnabled(Lookup context) {
        return this.settings.getSelectedHome() != null;
    }

    public boolean open(Lookup context) {
        String execPath = this.getExecutablePath();
        if (execPath == null) {
            return false;
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.getExecutablePath());
        boolean allSaved = true;
        Collection dobjs = context.lookupAll(DataObject.class);
        for (DataObject dataObject : dobjs) {
            try {
                SaveCookie sc = (SaveCookie)dataObject.getLookup().lookup(SaveCookie.class);
                if (sc == null) continue;
                sc.save();
            }
            catch (IOException e) {
                allSaved = false;
                LOG.log(Level.SEVERE, null, e);
                return false;
            }
        }
        if (allSaved) {
            String firstPath = null;
            for (DataObject dataObject : dobjs) {
                if (firstPath == null) {
                    firstPath = dataObject.getPrimaryFile().getPath();
                }
                cmdList.add(dataObject.getPrimaryFile().getPath());
            }
            if (firstPath != null) {
                try {
                    ProcessBuilder pb = new ProcessBuilder(cmdList);
                    pb.start();
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return true;
    }

    private String getExecutablePath() {
        Home home = this.settings.getSelectedHome();
        if (home != null && home.isValid()) {
            return home.getLauncherPath();
        }
        if (home == null) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest(Bundle.LOG_NO_HOME());
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.log(Level.WARNING, Bundle.LOG_HOME_INVALID(home));
        }
        return null;
    }
}

