/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.validator;

import com.sun.javacard.offcardverifier.Verifier;
import com.sun.javacard.util.FileUtils;
import com.sun.javacard.util.ZipUtils;
import com.sun.javacard.validator.ErrorKey;
import com.sun.javacard.validator.Library;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ClassicLibrary
extends Library {
    private Vector<File> exportFiles;
    private static Vector<String> mandatoryCAPComponentsForLibrary = new Vector<String>(){
        {
            this.addElement("export.cap");
            this.addElement("header.cap");
            this.addElement("directory.cap");
            this.addElement("import.cap");
            this.addElement("constantpool.cap");
            this.addElement("class.cap");
            this.addElement("method.cap");
            this.addElement("staticfield.cap");
            this.addElement("reflocation.cap");
            this.addElement("descriptor.cap");
        }
    };

    public ClassicLibrary(String string) {
        super(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInternal() {
        Object object;
        File file = new File(this.folder, "META-INF/MANIFEST.MF");
        Manifest manifest = new Manifest();
        if (file.exists()) {
            object = null;
            try {
                object = new FileInputStream(file);
                manifest.read((InputStream)object);
            }
            catch (Exception exception) {
            }
            finally {
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (!"true".equalsIgnoreCase(((Attributes)(object = manifest.getMainAttributes())).getValue("Sealed"))) {
            this.addError(ErrorKey.badValueForSealedAttribute, new Object[0]);
        }
        super.processInternal();
        if (!this.isOk()) {
            return;
        }
        Vector<File> vector = FileUtils.listAllFilesInFolder(this.folder, ".class");
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < vector.size(); ++i) {
            file = vector.elementAt(i).getParentFile();
            if (file.getName().equals("proxy")) {
                file = file.getParentFile();
            }
            hashSet.add(file.getAbsolutePath());
        }
        if (hashSet.size() > 1) {
            this.addError(ErrorKey.OnlyOnePackageInClassicAppOrLib, new Object[0]);
            return;
        }
        vector = FileUtils.listAllFilesInFolder(this.folder, ".cap");
        for (File object2 : vector) {
            mandatoryCAPComponentsForLibrary.removeElement(object2.getName().toLowerCase());
        }
        if (mandatoryCAPComponentsForLibrary.size() != 0) {
            this.addError(ErrorKey.missingCAPComponent, new Object[0]);
        }
        try {
            File file2 = File.createTempFile("abc", null);
            ZipUtils.zip(this.folder, file2, false);
            FileInputStream fileInputStream = new FileInputStream(file2);
            Verifier.verifyCap(fileInputStream, null, this.exportFiles);
        }
        catch (Exception exception) {
            this.addError(ErrorKey.VerifierError, exception.getMessage());
            return;
        }
    }

    public void setExportFiles(Vector<File> vector) {
        this.exportFiles = vector;
    }
}

