/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.metrics.hints;

import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SourcePositions;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;

public final class NCLOCVisitor
extends TreePathScanner<Object, Object> {
    private final CharSequence sourceText;
    private final SourcePositions pos;
    private long lastPos = -1L;
    private int lines;
    private int statements;

    public NCLOCVisitor(CharSequence sourceText, SourcePositions pos) {
        this.sourceText = sourceText;
        this.pos = pos;
    }

    public int getLineCount() {
        return this.lines;
    }

    public int getStatementCount() {
        return this.statements;
    }

    @Override
    public Object scan(Tree tree, Object p) {
        long startPos = this.pos.getStartPosition(this.getCurrentPath().getCompilationUnit(), tree);
        if (this.lastPos < startPos) {
            int pos;
            ++this.lines;
            boolean nline = false;
            for (pos = (int)startPos; pos < this.sourceText.length() && !nline; ++pos) {
                char c = this.sourceText.charAt(pos);
                nline = c == '\n' || c == '\r';
            }
            this.lastPos = pos;
        }
        return super.scan(tree, p);
    }

    @Override
    public Object visitAssert(AssertTree node, Object p) {
        return super.visitAssert(node, p);
    }

    @Override
    public Object visitVariable(VariableTree node, Object p) {
        TreePath path = this.getCurrentPath();
        Tree parent = path.getParentPath().getLeaf();
        if (parent instanceof StatementTree) {
            boolean count = true;
            if (parent instanceof ForLoopTree) {
                count = !((ForLoopTree)parent).getInitializer().contains(node);
            } else if (parent instanceof EnhancedForLoopTree) {
                boolean bl = count = ((EnhancedForLoopTree)parent).getVariable() != node;
            }
            if (count) {
                ++this.statements;
            }
        }
        return super.visitVariable(node, p);
    }

    @Override
    public Object visitExpressionStatement(ExpressionStatementTree node, Object p) {
        boolean count = true;
        TreePath path = this.getCurrentPath();
        Tree parent = path.getParentPath().getLeaf();
        if (parent instanceof ForLoopTree) {
            boolean bl = count = !((ForLoopTree)parent).getUpdate().contains(node);
        }
        if (count) {
            ++this.statements;
        }
        return super.visitExpressionStatement(node, p);
    }

    @Override
    public Object visitDoWhileLoop(DoWhileLoopTree node, Object p) {
        ++this.statements;
        return super.visitDoWhileLoop(node, p);
    }

    @Override
    public Object visitForLoop(ForLoopTree node, Object p) {
        ++this.statements;
        return super.visitForLoop(node, p);
    }

    @Override
    public Object visitEnhancedForLoop(EnhancedForLoopTree node, Object p) {
        ++this.statements;
        return super.visitEnhancedForLoop(node, p);
    }

    @Override
    public Object visitSwitch(SwitchTree node, Object p) {
        ++this.statements;
        return super.visitSwitch(node, p);
    }

    @Override
    public Object visitCatch(CatchTree node, Object p) {
        ++this.statements;
        return super.visitCatch(node, p);
    }

    @Override
    public Object visitIf(IfTree node, Object p) {
        ++this.statements;
        return super.visitIf(node, p);
    }

    @Override
    public Object visitBreak(BreakTree node, Object p) {
        ++this.statements;
        return super.visitBreak(node, p);
    }

    @Override
    public Object visitContinue(ContinueTree node, Object p) {
        ++this.statements;
        return super.visitContinue(node, p);
    }

    @Override
    public Object visitReturn(ReturnTree node, Object p) {
        ++this.statements;
        return super.visitReturn(node, p);
    }

    @Override
    public Object visitThrow(ThrowTree node, Object p) {
        ++this.statements;
        return super.visitThrow(node, p);
    }

    @Override
    public Object visitMethodInvocation(MethodInvocationTree node, Object p) {
        Tree t;
        TreePath parentPath = this.getCurrentPath().getParentPath();
        if (parentPath != null && !ExpressionTree.class.isAssignableFrom((t = parentPath.getLeaf()).getKind().asInterface()) && !ExpressionStatementTree.class.isAssignableFrom(t.getKind().asInterface())) {
            ++this.statements;
        }
        return super.visitMethodInvocation(node, p);
    }

    @Override
    public Object visitWhileLoop(WhileLoopTree node, Object p) {
        ++this.statements;
        return super.visitWhileLoop(node, p);
    }
}

