/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.dialog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.lib.profiler.jps.JpsProxy;
import org.netbeans.lib.profiler.jps.RunningVM;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.swing.ActionPopupButton;
import org.netbeans.lib.profiler.ui.swing.FilteringToolbar;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.ProfilerTableContainer;
import org.netbeans.lib.profiler.ui.swing.renderer.LabelRenderer;
import org.netbeans.lib.profiler.ui.swing.renderer.ProfilerRenderer;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.attach.AttachWizard;
import org.netbeans.modules.profiler.attach.dialog.Bundle;
import org.netbeans.modules.profiler.attach.spi.AttachStepsProvider;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class AttachDialog
extends AttachWizard {
    private AttachStepsProvider currentProvider;
    private Panel panel;
    private static final String ATTACH_WIZARD_HELPCTX = "AttachDialog.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("AttachDialog.HelpCtx");

    @Override
    public boolean configured(AttachSettings settings) {
        if (settings == null) {
            return false;
        }
        if (settings.isRemote()) {
            String host = settings.getHost();
            return host != null && !host.trim().isEmpty();
        }
        if (settings.isDirect()) {
            return true;
        }
        int pid = settings.getPid();
        String name = settings.getProcessName();
        if (pid == -1 || name == null) {
            return false;
        }
        assert (!SwingUtilities.isEventDispatchThread());
        RunningVM[] vms = JpsProxy.getRunningVMs();
        if (vms == null || vms.length == 0) {
            return false;
        }
        ArrayList<RunningVM> targets = new ArrayList<RunningVM>();
        for (RunningVM vm : vms) {
            if (!AttachDialog.getProcessName(vm.getMainClass()).equals(name)) continue;
            targets.add(vm);
        }
        if (targets.isEmpty()) {
            return false;
        }
        if (settings.isAutoSelectProcess() && targets.size() == 1) {
            settings.setPid(((RunningVM)targets.get(0)).getPid());
            return true;
        }
        for (RunningVM vm : targets) {
            if (vm.getPid() != pid) continue;
            return true;
        }
        return false;
    }

    @Override
    public AttachSettings configure(AttachSettings settings, boolean partially) {
        AttachSettings result;
        if (settings == null) {
            settings = new AttachSettings();
        }
        if (settings.getTargetType().isEmpty()) {
            settings.setDirect(false);
            settings.setDynamic16(true);
            settings.setRemote(false);
        }
        settings.setTargetType(Bundle.AttachDialog_JavaApplication());
        settings.setServerType(Bundle.AttachDialog_JavaApplication());
        if (settings.isRemote()) {
            settings.setHostOS(null);
        }
        this.panel = new Panel();
        this.panel.setup(settings);
        DialogDescriptor dd = new DialogDescriptor((Object)this.panel, Bundle.AttachDialog_Caption());
        if (!partially) {
            dd.setValid(false);
            this.panel.setDisplayer(dd);
        }
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.setVisible(true);
        AttachSettings attachSettings = result = dd.getValue() == DialogDescriptor.OK_OPTION ? this.panel.getSettings() : null;
        if (this.currentProvider != null) {
            this.currentProvider.removeChangeListener(this.panel);
        }
        this.currentProvider = null;
        this.panel = null;
        return result;
    }

    private String steps(AttachSettings settings) {
        Collection providers = Lookup.getDefault().lookupAll(AttachStepsProvider.class);
        if (this.currentProvider != null) {
            this.currentProvider.removeChangeListener(this.panel);
        }
        for (AttachStepsProvider provider : providers) {
            String steps = provider.getSteps(settings);
            if (steps == null) continue;
            this.currentProvider = provider;
            this.currentProvider.addChangeListener(this.panel);
            return steps;
        }
        this.currentProvider = null;
        return Bundle.AttachDialog_NoSteps();
    }

    private static String getProcessName(String name) {
        name = name == null ? null : name.trim();
        return name == null || name.isEmpty() ? Bundle.AttachDialog_UnknownProcess() : name;
    }

    private static String escapedText(String text, String replace) {
        if (text != null) {
            text = text.trim();
        }
        if (text == null || text.isEmpty()) {
            return "&lt;" + replace + "&gt;";
        }
        return text;
    }

    private static void configureScrollBar(final JScrollBar s) {
        s.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                s.setEnabled(s.getVisibleAmount() < s.getMaximum());
            }
        });
    }

    private static void showDetails(RunningVM vm) {
        HTMLTextArea area = new HTMLTextArea();
        JScrollPane areaScroll = new JScrollPane((Component)area, 22, 32);
        areaScroll.setBorder(BorderFactory.createEmptyBorder());
        areaScroll.setViewportBorder(BorderFactory.createEmptyBorder());
        areaScroll.setPreferredSize(new Dimension(500, 260));
        AttachDialog.configureScrollBar(areaScroll.getVerticalScrollBar());
        AttachDialog.configureScrollBar(areaScroll.getHorizontalScrollBar());
        area.setText(AttachDialog.getDetails(vm));
        area.setCaretPosition(0);
        HelpCtx helpCtx = new HelpCtx("ProcessDetails.HelpCtx");
        JButton close = new JButton(Bundle.AttachDialog_BtnClose());
        close.setDefaultCapable(true);
        DialogDescriptor dd = new DialogDescriptor((Object)areaScroll, Bundle.AttachDialog_DetailsCaption(AttachDialog.getProcessName(vm.getMainClass())), true, new Object[]{close}, (Object)close, 0, helpCtx, null);
        Dialog d = DialogDisplayer.getDefault().createDialog(dd);
        d.pack();
        d.setVisible(true);
    }

    private static String getDetails(RunningVM vm) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<table cellspacing=\"3\" cellpadding=\"0\" width=\"400\">");
        buffer.append("<tr>");
        buffer.append("<td valign='top'><nobr><b>");
        buffer.append(Bundle.AttachDialog_RowPid());
        buffer.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td width=\"100%\">");
        buffer.append(vm.getPid());
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td valign='top'><nobr><b>");
        buffer.append(Bundle.AttachDialog_RowMainClass());
        buffer.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td width=\"100%\">");
        buffer.append(AttachDialog.escapedText(vm.getMainClass(), Bundle.AttachDialog_DetailsUnknown()));
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td valign='top'><nobr><b>");
        buffer.append(Bundle.AttachDialog_RowArguments());
        buffer.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td width=\"100%\">");
        buffer.append(AttachDialog.escapedText(vm.getMainArgs(), Bundle.AttachDialog_DetailsNone()));
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td valign='top'><nobr><b>");
        buffer.append(Bundle.AttachDialog_RowJvmArguments());
        buffer.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td width=\"100%\">");
        buffer.append(AttachDialog.escapedText(vm.getVMArgs(), Bundle.AttachDialog_DetailsNone()));
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("<tr>");
        buffer.append("<td valign='top'><nobr><b>");
        buffer.append(Bundle.AttachDialog_RowJvmFlags());
        buffer.append("</b>&nbsp;&nbsp;&nbsp;</nobr></td>");
        buffer.append("<td width=\"100%\">");
        buffer.append(AttachDialog.escapedText(vm.getVMFlags(), Bundle.AttachDialog_DetailsNone()));
        buffer.append("</td>");
        buffer.append("</tr>");
        buffer.append("</table>");
        return buffer.toString();
    }

    private class ProcessesModel
    extends AbstractTableModel {
        private RunningVM[] vms;
        private boolean refreshing;
        private boolean firstRefresh = true;

        private ProcessesModel() {
        }

        void refresh() {
            this.refreshing = true;
            this.fireTableDataChanged();
            new RequestProcessor("Processes refresher").post(new Runnable(){

                @Override
                public void run() {
                    final RunningVM[] _vms = JpsProxy.getRunningVMs();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ProcessesModel.access$1602(ProcessesModel.this, _vms);
                            ProcessesModel.this.refreshing = false;
                            ProcessesModel.this.fireTableDataChanged();
                            ProcessesModel.this.firstRefresh = false;
                        }
                    });
                }
            }, 500);
        }

        boolean isRefreshing() {
            return this.refreshing;
        }

        boolean isFirstRefresh() {
            return !this.refreshing && this.firstRefresh;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Bundle.AttachDialog_ColumnName();
            }
            if (columnIndex == 1) {
                return Bundle.AttachDialog_ColumnPid();
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == 1) {
                return Integer.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return this.vms == null ? 0 : this.vms.length;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return AttachDialog.getProcessName(this.vms[rowIndex].getMainClass());
            }
            if (columnIndex == 1) {
                return this.vms[rowIndex].getPid();
            }
            if (columnIndex == -1) {
                return this.vms[rowIndex];
            }
            return null;
        }

        static /* synthetic */ RunningVM[] access$1602(ProcessesModel x0, RunningVM[] x1) {
            x0.vms = x1;
            return x1;
        }
    }

    private class Panel
    extends JPanel
    implements HelpCtx.Provider,
    ChangeListener {
        private static final int VISIBLE_ROWS = 9;
        private ActionPopupButton modeButton;
        private JTextField hostname;
        private ActionPopupButton os;
        private HTMLTextArea steps;
        private JCheckBox autoSelect;
        private DialogDescriptor displayer;
        private AttachSettings as;
        private String selectedName;
        private int selectedPid = -1;
        private boolean updatingUI = false;

        Panel() {
            this.initComponents();
        }

        void setDisplayer(DialogDescriptor displayer) {
            this.displayer = displayer;
        }

        void setup(AttachSettings as) {
            this.as = as;
            this.updatingUI = true;
            if (as.isRemote()) {
                this.modeButton.selectAction(3);
            } else if (as.isDirect()) {
                this.modeButton.selectAction(2);
            } else {
                this.modeButton.selectAction(0);
            }
            this.modeButton.getSelectedAction().actionPerformed(null);
            if (as.isRemote()) {
                this.hostname.setText(as.getHost());
                String hostOS = as.getHostOS();
                for (Action action : this.os.getActions()) {
                    if (action == null || !action.getValue("Name").equals(hostOS)) continue;
                    this.os.selectAction(action);
                    break;
                }
            } else {
                this.hostname.setText("");
                this.os.selectAction(0);
            }
            if (!as.isRemote() && as.isDynamic16()) {
                this.selectedName = as.getProcessName();
                this.selectedPid = as.getPid();
                this.autoSelect.setSelected(as.isAutoSelectProcess());
                this.updateAutoSelect();
            }
            this.updatingUI = false;
            this.updateSteps();
        }

        AttachSettings getSettings() {
            int mode = this.modeButton.getSelectedIndex();
            this.as.setRemote(mode == 3);
            if (this.as.isRemote()) {
                this.as.setDirect(true);
                this.as.setDynamic16(false);
                this.as.setHost(this.hostname.getText().trim());
                this.as.setHostOS(this.os.getSelectedAction().getValue("Name").toString());
            } else {
                this.as.setDirect(mode == 2);
                this.as.setDynamic16(mode == 0);
                this.as.setHostOS(IntegrationUtils.getLocalPlatform((int)-1));
                this.as.setProcessName(this.selectedName);
                this.as.setPid(this.selectedPid);
                this.as.setAutoSelectProcess(this.autoSelect.isSelected());
            }
            return this.as;
        }

        private void initComponents() {
            final JLabel processesHint = new JLabel("", 10);
            Mnemonics.setLocalizedText((JLabel)processesHint, (String)Bundle.AttachDialog_SelectProcess());
            processesHint.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
            final ProcessesModel processesModel = new ProcessesModel();
            final ProfilerTable processes = new ProfilerTable(processesModel, true, true, null){

                public String getToolTipText(MouseEvent event) {
                    int row = this.rowAtPoint(event.getPoint());
                    if (row == -1) {
                        return null;
                    }
                    row = this.convertRowIndexToModel(row);
                    return "<html>" + AttachDialog.getDetails((RunningVM)processesModel.getValueAt(row, -1)) + "</html>";
                }

                public Point getToolTipLocation(MouseEvent event) {
                    int row = this.rowAtPoint(event.getPoint());
                    if (row == -1) {
                        return null;
                    }
                    Rectangle rect = this.getCellRect(row, 0, false);
                    return new Point(event.getX() + 15, rect.y + rect.height + 2);
                }
            };
            processesHint.setLabelFor((Component)processes);
            processes.setMainColumn(0);
            processes.setFitWidthColumn(0);
            processes.setDefaultSortOrder(SortOrder.ASCENDING);
            processes.setSortColumn(0);
            processes.setColumnToolTips(new String[]{Bundle.AttachDialog_ProcessNameTtp(), Bundle.AttachDialog_ProcessIdTtp()});
            LabelRenderer processRenderer = new LabelRenderer();
            processes.setColumnRenderer(0, (ProfilerRenderer)processRenderer);
            LabelRenderer pidRenderer = new LabelRenderer();
            pidRenderer.setHorizontalAlignment(11);
            processes.setColumnRenderer(1, (ProfilerRenderer)pidRenderer);
            pidRenderer.setValue((Object)processes.getColumnName(1), -1);
            int w = pidRenderer.getPreferredSize().width;
            pidRenderer.setValue((Object)"9999999", -1);
            w = Math.max(w, pidRenderer.getPreferredSize().width);
            processes.setDefaultColumnWidth(1, w + 10);
            Dimension prefSize = processes.getPreferredSize();
            prefSize.height = processes.getRowHeight() * 9;
            prefSize.height += processes.getTableHeader().getPreferredSize().height;
            processes.setPreferredScrollableViewportSize(prefSize);
            ProfilerTableContainer processesContainer = new ProfilerTableContainer(processes, true, null);
            final JButton refresh = new JButton(Icons.getIcon((String)"GeneralIcons.UpdateNow")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    processesModel.refresh();
                }
            };
            refresh.setToolTipText(Bundle.AttachDialog_ReloadProcesses());
            processesModel.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    boolean enabled = !processesModel.isRefreshing();
                    processes.setEnabled(enabled);
                    refresh.setEnabled(enabled);
                    Mnemonics.setLocalizedText((JLabel)processesHint, (String)(enabled ? Bundle.AttachDialog_SelectProcess() : Bundle.AttachDialog_SelectProcessReload()));
                    if (processesModel.isFirstRefresh() && Panel.this.selectedName != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                int _nameC = processes.convertColumnIndexToView(0);
                                int _pidC = processes.convertColumnIndexToView(1);
                                for (int row = 0; row < processes.getRowCount(); ++row) {
                                    if (!Panel.this.selectedName.equals(processes.getValueAt(row, _nameC)) || Panel.this.selectedPid != (Integer)processes.getValueAt(row, _pidC)) continue;
                                    processes.selectRow(row, true);
                                    return;
                                }
                                if (!Panel.this.autoSelect.isSelected()) {
                                    Panel.this.selectedName = null;
                                }
                                Panel.this.selectedPid = -1;
                                Panel.this.updateAutoSelect();
                            }
                        });
                    }
                }
            });
            final JButton details = new JButton(Icons.getIcon((String)"GeneralIcons.Info")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    AttachDialog.showDetails((RunningVM)processes.getSelectedValue(-1));
                }
            };
            details.setToolTipText(Bundle.AttachDialog_ShowDetails());
            this.autoSelect = new JCheckBox(){
                private final RowFilter rowFilter = new RowFilter(){

                    public boolean include(RowFilter.Entry entry) {
                        return Panel.this.selectedName == null || Panel.this.selectedName.equals(entry.getValue(0));
                    }
                };

                @Override
                protected void fireItemStateChanged(ItemEvent event) {
                    super.fireItemStateChanged(event);
                    if (this.isSelected()) {
                        processes.addRowFilter(this.rowFilter);
                    } else {
                        processes.removeRowFilter(this.rowFilter);
                    }
                    Panel.this.updateAutoSelect();
                }
            };
            Mnemonics.setLocalizedText((AbstractButton)this.autoSelect, (String)Bundle.AttachDialog_ConnectToSelected());
            this.autoSelect.setEnabled(false);
            processes.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (processes.getSelectedRow() == -1) {
                        Panel.this.selectedPid = -1;
                    } else {
                        Panel.this.selectedPid = (Integer)processes.getSelectedValue(1);
                        Panel.this.selectedName = AttachDialog.getProcessName(processes.getSelectedValue(0).toString());
                    }
                    Panel.this.updateDetails(details);
                    Panel.this.updateAutoSelect();
                    Panel.this.updateDisplayer();
                }
            });
            FilteringToolbar toolbar = new FilteringToolbar(Bundle.AttachDialog_FilterProcesses()){
                private String filter;
                private final RowFilter rowFilter;
                {
                    super(x0);
                    this.rowFilter = new RowFilter(){

                        public boolean include(RowFilter.Entry entry) {
                            return filter == null || entry.getValue(0).toString().toLowerCase().contains(filter);
                        }
                    };
                }

                protected void filterChanged(String filter) {
                    this.filter = filter == null ? null : filter.toLowerCase();
                    processes.addRowFilter(this.rowFilter);
                }
            };
            toolbar.add(Box.createHorizontalStrut(2));
            toolbar.addSeparator();
            toolbar.add(Box.createHorizontalStrut(1));
            toolbar.add((Component)refresh);
            toolbar.add(Box.createHorizontalStrut(2));
            toolbar.add((Component)details);
            toolbar.add(Box.createHorizontalStrut(3));
            toolbar.add((Component)this.autoSelect);
            final JPanel dynamicContent = new JPanel(new BorderLayout());
            dynamicContent.add((Component)processesHint, "North");
            dynamicContent.add((Component)processesContainer, "Center");
            dynamicContent.add((Component)toolbar, "South");
            JLabel stepsHint = new JLabel("", 10);
            Mnemonics.setLocalizedText((JLabel)stepsHint, (String)Bundle.AttachDialog_Steps());
            this.steps = new HTMLTextArea(){

                protected void showURL(URL url) {
                    if (AttachDialog.this.currentProvider != null) {
                        final String action = url.toString();
                        final AttachSettings settings = new AttachSettings();
                        Panel.this.getSettings().copyInto(settings);
                        RequestProcessor.getDefault().post(new Runnable(){

                            @Override
                            public void run() {
                                AttachDialog.this.currentProvider.handleAction(action, settings);
                            }
                        });
                    }
                }
            };
            stepsHint.setLabelFor((Component)this.steps);
            JScrollPane stepsScroll = new JScrollPane((Component)this.steps);
            final JPanel directContent = new JPanel(new BorderLayout(3, 3));
            directContent.add((Component)stepsHint, "North");
            directContent.add((Component)stepsScroll, "Center");
            final JPanel remoteSettings = new JPanel(new GridBagLayout());
            final JPanel content = new JPanel(new BorderLayout());
            content.add((Component)dynamicContent, "Center");
            this.setLayout(new GridBagLayout());
            JLabel profile = new JLabel();
            Mnemonics.setLocalizedText((JLabel)profile, (String)Bundle.AttachDialog_Profile());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = new Insets(10, 10, 0, 0);
            this.add((Component)profile, c);
            class ModeAction
            extends AbstractAction {
                private final boolean remote;
                private final boolean hasSteps;

                ModeAction(String name, boolean remote, boolean hasSteps) {
                    super(name);
                    this.remote = remote;
                    this.hasSteps = hasSteps;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    content.removeAll();
                    remoteSettings.setVisible(this.remote);
                    if (this.hasSteps) {
                        Panel.this.updateSteps();
                    }
                    content.add((Component)(this.hasSteps ? directContent : dynamicContent), "Center");
                    content.invalidate();
                    content.revalidate();
                    content.repaint();
                    Panel.this.updateDisplayer();
                }
            }
            this.modeButton = new ActionPopupButton(new Action[]{new ModeAction(Bundle.AttachDialog_LocalRunningProcess(), false, false), null, new ModeAction(Bundle.AttachDialog_LocalStartedProcess(), false, true), new ModeAction(Bundle.AttachDialog_RemoteStartedProcess(), true, true)});
            this.modeButton.setPopupAlign(4);
            profile.setLabelFor((Component)this.modeButton);
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.anchor = 17;
            c.fill = 2;
            c.gridwidth = 0;
            c.insets = new Insets(10, 5, 0, 10);
            this.add((Component)this.modeButton, c);
            JLabel hostnameLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)hostnameLabel, (String)Bundle.AttachDialog_Hostname());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = new Insets(0, 0, 0, 0);
            remoteSettings.add((Component)hostnameLabel, c);
            this.hostname = new JTextField();
            hostnameLabel.setLabelFor(this.hostname);
            this.hostname.setText("https://netbeans.org/features/index.html");
            c = new GridBagConstraints();
            c.gridx = 1;
            c.gridy = 0;
            c.weightx = 1.0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(0, 5, 0, 10);
            remoteSettings.add((Component)this.hostname, c);
            JLabel osJvmLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)osJvmLabel, (String)Bundle.AttachDialog_OsJvm());
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 0;
            c.anchor = 17;
            c.insets = new Insets(0, 0, 0, 0);
            remoteSettings.add((Component)osJvmLabel, c);
            class OsAction
            extends AbstractAction {
                OsAction(String name) {
                    super(name);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    Panel.this.updateSteps();
                }
            }
            this.os = new ActionPopupButton(new Action[]{new OsAction(IntegrationUtils.PLATFORM_WINDOWS_OS), new OsAction(IntegrationUtils.PLATFORM_WINDOWS_AMD64_OS), new OsAction(IntegrationUtils.PLATFORM_WINDOWS_CVM), null, new OsAction(IntegrationUtils.PLATFORM_LINUX_OS), new OsAction(IntegrationUtils.PLATFORM_LINUX_AMD64_OS), new OsAction(IntegrationUtils.PLATFORM_LINUX_ARM_OS), new OsAction(IntegrationUtils.PLATFORM_LINUX_ARM_VFP_HFLT_OS), new OsAction(IntegrationUtils.PLATFORM_LINUX_CVM), null, new OsAction(IntegrationUtils.PLATFORM_MAC_OS), null, new OsAction(IntegrationUtils.PLATFORM_SOLARIS_SPARC_OS), new OsAction(IntegrationUtils.PLATFORM_SOLARIS_SPARC64_OS), new OsAction(IntegrationUtils.PLATFORM_SOLARIS_INTEL_OS), new OsAction(IntegrationUtils.PLATFORM_SOLARIS_AMD64_OS)});
            osJvmLabel.setLabelFor((Component)this.os);
            this.os.setPopupAlign(4);
            c = new GridBagConstraints();
            c.gridx = 3;
            c.gridy = 0;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(0, 5, 0, 0);
            remoteSettings.add((Component)this.os, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.anchor = 17;
            c.fill = 2;
            c.gridwidth = 0;
            c.insets = new Insets(5, 10, 0, 10);
            this.add((Component)remoteSettings, c);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 10;
            c.weighty = 1.0;
            c.anchor = 18;
            c.fill = 1;
            c.gridwidth = 0;
            c.insets = new Insets(20, 10, 10, 10);
            this.add((Component)content, c);
            this.setPreferredSize(this.getPreferredSize());
            this.hostname.setText("");
            processesModel.refresh();
            this.updateDetails(details);
            this.updateAutoSelect();
        }

        private void updateSteps() {
            if (this.updatingUI) {
                return;
            }
            this.steps.setText(AttachDialog.this.steps(this.getSettings()));
            this.steps.setCaretPosition(0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Panel.this.steps.setCaretPosition(0);
                }
            });
        }

        public HelpCtx getHelpCtx() {
            return HELP_CTX;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Panel.this.updateSteps();
                }
            });
        }

        private void updateDetails(JButton info) {
            info.setEnabled(this.selectedPid != -1);
        }

        private void updateAutoSelect() {
            if (!this.autoSelect.isSelected() && this.selectedPid == -1) {
                this.selectedName = null;
            }
            this.autoSelect.setEnabled(this.autoSelect.isSelected() || this.selectedPid != -1);
            Mnemonics.setLocalizedText((AbstractButton)this.autoSelect, (String)(this.selectedName == null ? Bundle.AttachDialog_ConnectToSelected() : Bundle.AttachDialog_ConnectToProcess(this.selectedName)));
        }

        private void updateDisplayer() {
            if (this.displayer == null) {
                return;
            }
            if (this.modeButton.getSelectedIndex() != 0) {
                this.displayer.setValid(true);
                return;
            }
            this.displayer.setValid(this.selectedPid != -1);
        }
    }
}

