/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.parser.impl;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.parser.CppFoldRecord;
import org.netbeans.modules.cnd.editor.parser.impl.TokenFilter;

public class CommentTokenFilter
implements TokenFilter {
    private Token<CppTokenId> firstLineComment = null;
    private Token<CppTokenId> lastLineComment = null;
    private static final int BEFORE_FIRST_TOKEN_STATE = 0;
    private static final int INIT_STATE = 1;
    private static final int AFTER_LINE_COMMENT = 3;
    private int state = 0;
    private CppFoldRecord initialCommentFold = null;
    private final List<CppFoldRecord> blockCommentFolds = new ArrayList<CppFoldRecord>();
    private final List<CppFoldRecord> lineCommentFolds = new ArrayList<CppFoldRecord>();

    @Override
    public void visit(Token<CppTokenId> token) {
        if ("whitespace".equals(((CppTokenId)token.id()).primaryCategory())) {
            return;
        }
        switch ((CppTokenId)token.id()) {
            case DOXYGEN_COMMENT: 
            case BLOCK_COMMENT: {
                if (this.isMultilineToken(token)) {
                    this.createBlockCommentsFold(token);
                }
            }
            case DOXYGEN_LINE_COMMENT: 
            case LINE_COMMENT: {
                if (this.firstLineComment == null) {
                    this.firstLineComment = token;
                    this.state = 3;
                }
                this.lastLineComment = token;
                break;
            }
            case EOF: {
                this.createLineCommentsFoldIfNeeded();
                break;
            }
            case PREPROCESSOR_DIRECTIVE: {
                this.onPreprocNode();
                break;
            }
            default: {
                this.createLineCommentsFoldIfNeeded();
            }
        }
    }

    @Override
    public void visitEof() {
        this.createLineCommentsFoldIfNeeded();
    }

    @Override
    public boolean consumes(CppTokenId id) {
        String primaryCategory = id.primaryCategory();
        return "whitespace".equals(primaryCategory) || "comment".equals(primaryCategory);
    }

    public void onPreprocNode() {
        switch (this.state) {
            case 0: {
                this.state = 1;
                break;
            }
            case 3: {
                this.createLineCommentsFoldIfNeeded();
            }
        }
    }

    @Override
    public List<CppFoldRecord> getFolders() {
        ArrayList<CppFoldRecord> out = new ArrayList<CppFoldRecord>(this.blockCommentFolds.size() + this.lineCommentFolds.size() + 1);
        if (this.initialCommentFold != null) {
            out.add(this.initialCommentFold);
        }
        out.addAll(this.blockCommentFolds);
        out.addAll(this.lineCommentFolds);
        return out;
    }

    private void createLineCommentsFoldIfNeeded() {
        if (this.state == 3) {
            if (this.firstLineComment != this.lastLineComment) {
                assert (this.firstLineComment != null);
                assert (this.lastLineComment != null);
                this.lineCommentFolds.add(this.createFoldRecord(3, this.firstLineComment, this.lastLineComment));
            }
            this.firstLineComment = null;
            this.lastLineComment = null;
            this.state = 1;
        }
    }

    private void createBlockCommentsFold(Token<CppTokenId> token) {
        this.createLineCommentsFoldIfNeeded();
        if (this.state == 0) {
            assert (this.initialCommentFold == null) : "how there could be two copyrights?";
            this.initialCommentFold = this.createFoldRecord(1, token, token);
        } else {
            this.blockCommentFolds.add(this.createFoldRecord(2, token, token));
        }
        this.state = 1;
    }

    private CppFoldRecord createFoldRecord(int folderKind, Token<CppTokenId> begin, Token<CppTokenId> end) {
        return new CppFoldRecord(folderKind, begin.offset(null), end.offset(null) + end.length());
    }

    private boolean isMultilineToken(Token token) {
        CharSequence text = token.text();
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c != '\n' && c != '\r') continue;
            return true;
        }
        return false;
    }
}

