/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

public class ClientCodeWrapper {
    Map<Class<?>, Boolean> trustedClasses = new HashMap();

    public static ClientCodeWrapper instance(Context context) {
        ClientCodeWrapper instance = context.get(ClientCodeWrapper.class);
        if (instance == null) {
            instance = new ClientCodeWrapper(context);
        }
        return instance;
    }

    protected ClientCodeWrapper(Context context) {
    }

    public JavaFileManager wrap(JavaFileManager fm) {
        if (this.isTrusted(fm)) {
            return fm;
        }
        return new WrappedJavaFileManager(fm);
    }

    public FileObject wrap(FileObject fo) {
        if (this.isTrusted(fo)) {
            return fo;
        }
        return new WrappedFileObject(fo);
    }

    FileObject unwrap(FileObject fo) {
        if (fo instanceof WrappedFileObject) {
            return ((WrappedFileObject)fo).clientFileObject;
        }
        return fo;
    }

    public JavaFileObject wrap(JavaFileObject fo) {
        if (this.isTrusted(fo)) {
            return fo;
        }
        return new WrappedJavaFileObject(fo);
    }

    public Iterable<JavaFileObject> wrapJavaFileObjects(Iterable<? extends JavaFileObject> list) {
        ArrayList<JavaFileObject> wrapped = new ArrayList<JavaFileObject>();
        for (JavaFileObject javaFileObject : list) {
            wrapped.add(this.wrap(javaFileObject));
        }
        return Collections.unmodifiableList(wrapped);
    }

    JavaFileObject unwrap(JavaFileObject fo) {
        if (fo instanceof WrappedJavaFileObject) {
            return (JavaFileObject)((WrappedJavaFileObject)fo).clientFileObject;
        }
        return fo;
    }

    public <T> DiagnosticListener<T> wrap(DiagnosticListener<T> dl) {
        if (this.isTrusted(dl)) {
            return dl;
        }
        return new WrappedDiagnosticListener<T>(dl);
    }

    TaskListener wrap(TaskListener tl) {
        if (this.isTrusted(tl)) {
            return tl;
        }
        return new WrappedTaskListener(tl);
    }

    TaskListener unwrap(TaskListener l) {
        if (l instanceof WrappedTaskListener) {
            return ((WrappedTaskListener)l).clientTaskListener;
        }
        return l;
    }

    Collection<TaskListener> unwrap(Collection<? extends TaskListener> listeners) {
        ArrayList<TaskListener> c = new ArrayList<TaskListener>(listeners.size());
        for (TaskListener taskListener : listeners) {
            c.add(this.unwrap(taskListener));
        }
        return c;
    }

    private <T> Diagnostic<T> unwrap(Diagnostic<T> diagnostic) {
        if (diagnostic instanceof JCDiagnostic) {
            JCDiagnostic d = (JCDiagnostic)diagnostic;
            return new DiagnosticSourceUnwrapper(d);
        }
        return diagnostic;
    }

    protected boolean isTrusted(Object o) {
        if (o == null) {
            return true;
        }
        Class<?> c = o.getClass();
        Boolean trusted = this.trustedClasses.get(c);
        if (trusted == null) {
            trusted = c.getName().startsWith("com.sun.tools.javac.") || c.isAnnotationPresent(Trusted.class);
            this.trustedClasses.put(c, trusted);
        }
        return trusted;
    }

    private String wrappedToString(Class<?> wrapperClass, Object wrapped) {
        return wrapperClass.getSimpleName() + "[" + wrapped + "]";
    }

    protected class WrappedTaskListener
    implements TaskListener {
        protected TaskListener clientTaskListener;

        WrappedTaskListener(TaskListener clientTaskListener) {
            clientTaskListener.getClass();
            this.clientTaskListener = clientTaskListener;
        }

        @Override
        public void started(TaskEvent ev) {
            try {
                this.clientTaskListener.started(ev);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public void finished(TaskEvent ev) {
            try {
                this.clientTaskListener.finished(ev);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientTaskListener);
        }
    }

    public class DiagnosticSourceUnwrapper
    implements Diagnostic<JavaFileObject> {
        public final JCDiagnostic d;

        DiagnosticSourceUnwrapper(JCDiagnostic d) {
            this.d = d;
        }

        @Override
        public Diagnostic.Kind getKind() {
            return this.d.getKind();
        }

        @Override
        public JavaFileObject getSource() {
            return ClientCodeWrapper.this.unwrap(this.d.getSource());
        }

        @Override
        public long getPosition() {
            return this.d.getPosition();
        }

        @Override
        public long getStartPosition() {
            return this.d.getStartPosition();
        }

        @Override
        public long getEndPosition() {
            return this.d.getEndPosition();
        }

        @Override
        public long getLineNumber() {
            return this.d.getLineNumber();
        }

        @Override
        public long getColumnNumber() {
            return this.d.getColumnNumber();
        }

        @Override
        public String getCode() {
            return this.d.getCode();
        }

        @Override
        public String getMessage(Locale locale) {
            return this.d.getMessage(locale);
        }

        public String toString() {
            return this.d.toString();
        }
    }

    protected class WrappedDiagnosticListener<T>
    implements DiagnosticListener<T> {
        protected DiagnosticListener<T> clientDiagnosticListener;

        WrappedDiagnosticListener(DiagnosticListener<T> clientDiagnosticListener) {
            clientDiagnosticListener.getClass();
            this.clientDiagnosticListener = clientDiagnosticListener;
        }

        @Override
        public void report(Diagnostic<? extends T> diagnostic) {
            try {
                this.clientDiagnosticListener.report(ClientCodeWrapper.this.unwrap(diagnostic));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientDiagnosticListener);
        }
    }

    protected class WrappedJavaFileObject
    extends WrappedFileObject
    implements JavaFileObject {
        WrappedJavaFileObject(JavaFileObject clientJavaFileObject) {
            super(clientJavaFileObject);
        }

        @Override
        public JavaFileObject.Kind getKind() {
            try {
                return ((JavaFileObject)this.clientFileObject).getKind();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean isNameCompatible(String simpleName, JavaFileObject.Kind kind) {
            try {
                return ((JavaFileObject)this.clientFileObject).isNameCompatible(simpleName, kind);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public NestingKind getNestingKind() {
            try {
                return ((JavaFileObject)this.clientFileObject).getNestingKind();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public Modifier getAccessLevel() {
            try {
                return ((JavaFileObject)this.clientFileObject).getAccessLevel();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientFileObject);
        }
    }

    protected class WrappedFileObject
    implements FileObject {
        protected FileObject clientFileObject;

        WrappedFileObject(FileObject clientFileObject) {
            clientFileObject.getClass();
            this.clientFileObject = clientFileObject;
        }

        @Override
        public URI toUri() {
            try {
                return this.clientFileObject.toUri();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public String getName() {
            try {
                return this.clientFileObject.getName();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public InputStream openInputStream() throws IOException {
            try {
                return this.clientFileObject.openInputStream();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            try {
                return this.clientFileObject.openOutputStream();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public Reader openReader(boolean ignoreEncodingErrors) throws IOException {
            try {
                return this.clientFileObject.openReader(ignoreEncodingErrors);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
            try {
                return this.clientFileObject.getCharContent(ignoreEncodingErrors);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public Writer openWriter() throws IOException {
            try {
                return this.clientFileObject.openWriter();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public long getLastModified() {
            try {
                return this.clientFileObject.getLastModified();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean delete() {
            try {
                return this.clientFileObject.delete();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientFileObject);
        }
    }

    protected class WrappedJavaFileManager
    implements JavaFileManager {
        protected JavaFileManager clientJavaFileManager;

        WrappedJavaFileManager(JavaFileManager clientJavaFileManager) {
            clientJavaFileManager.getClass();
            this.clientJavaFileManager = clientJavaFileManager;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            try {
                return this.clientJavaFileManager.getClassLoader(location);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
            try {
                return ClientCodeWrapper.this.wrapJavaFileObjects(this.clientJavaFileManager.list(location, packageName, kinds, recurse));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
            try {
                return this.clientJavaFileManager.inferBinaryName(location, ClientCodeWrapper.this.unwrap(file));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean isSameFile(FileObject a, FileObject b) {
            try {
                return this.clientJavaFileManager.isSameFile(ClientCodeWrapper.this.unwrap(a), ClientCodeWrapper.this.unwrap(b));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean handleOption(String current, Iterator<String> remaining) {
            try {
                return this.clientJavaFileManager.handleOption(current, remaining);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public boolean hasLocation(JavaFileManager.Location location) {
            try {
                return this.clientJavaFileManager.hasLocation(location);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getJavaFileForInput(location, className, kind));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getJavaFileForOutput(location, className, kind, ClientCodeWrapper.this.unwrap(sibling)));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getFileForInput(location, packageName, relativeName));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
            try {
                return ClientCodeWrapper.this.wrap(this.clientJavaFileManager.getFileForOutput(location, packageName, relativeName, ClientCodeWrapper.this.unwrap(sibling)));
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public void flush() throws IOException {
            try {
                this.clientJavaFileManager.flush();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public void close() throws IOException {
            try {
                this.clientJavaFileManager.close();
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        @Override
        public int isSupportedOption(String option) {
            try {
                return this.clientJavaFileManager.isSupportedOption(option);
            }
            catch (ClientCodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ClientCodeException(e);
            }
            catch (Error e) {
                throw new ClientCodeException(e);
            }
        }

        public String toString() {
            return ClientCodeWrapper.this.wrappedToString(this.getClass(), this.clientJavaFileManager);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Trusted {
    }
}

