/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.api;

import org.netbeans.modules.subversion.remote.api.SVNConflictVersion;

public class SVNConflictDescriptor {
    private final String path;
    private final Action action;
    private final Operation operation;
    private final SVNConflictVersion srcLeftVersion;
    private final SVNConflictVersion srcRightVersion;

    public SVNConflictDescriptor(String path, Action action, Reason reason, Operation operation, SVNConflictVersion srcLeftVersion, SVNConflictVersion srcRightVersion) {
        this.path = path;
        this.action = action;
        this.operation = operation;
        this.srcLeftVersion = srcLeftVersion;
        this.srcRightVersion = srcRightVersion;
    }

    public String getPath() {
        return this.path;
    }

    public SVNConflictVersion.NodeKind getNodeKind() {
        return this.srcLeftVersion.getNodeKind();
    }

    public Action getAction() {
        return this.action;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public SVNConflictVersion getSrcLeftVersion() {
        return this.srcLeftVersion;
    }

    public SVNConflictVersion getSrcRightVersion() {
        return this.srcRightVersion;
    }

    public static enum Kind {
        text,
        property;

    }

    public static enum Action {
        edit("edited"),
        add("added"),
        delete("deleted");

        private final String value;

        private Action(String value) {
            this.value = value;
        }

        public static Action fromString(String s) {
            for (Action r : Action.values()) {
                if (!r.value.equals(s)) continue;
                return r;
            }
            return null;
        }
    }

    public static enum Reason {
        edited("edited"),
        obstructed("obstructed"),
        deleted("deleted"),
        missing("missing"),
        unversioned("unversioned"),
        added("added"),
        replaced("replaced"),
        moved_away("moved_away"),
        moved_here("moved_here");

        private final String value;

        private Reason(String value) {
            this.value = value;
        }

        public static Reason fromString(String s) {
            for (Reason r : Reason.values()) {
                if (!r.value.equals(s)) continue;
                return r;
            }
            return null;
        }
    }

    public static enum Operation {
        _none("none"),
        _update("update"),
        _switch("switch"),
        _merge("merge");

        private final String value;

        private Operation(String value) {
            this.value = value;
        }

        public static Operation fromString(String s) {
            for (Operation o : Operation.values()) {
                if (!o.value.equals(s)) continue;
                return o;
            }
            return null;
        }
    }
}

