/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.commit;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.FileInformation;
import org.netbeans.modules.subversion.remote.FileStatusCache;
import org.netbeans.modules.subversion.remote.Subversion;
import org.netbeans.modules.subversion.remote.SvnFileNode;
import org.netbeans.modules.subversion.remote.SvnModuleConfig;
import org.netbeans.modules.subversion.remote.api.ISVNLogMessage;
import org.netbeans.modules.subversion.remote.api.ISVNProperty;
import org.netbeans.modules.subversion.remote.api.ISVNStatus;
import org.netbeans.modules.subversion.remote.api.SVNBaseDir;
import org.netbeans.modules.subversion.remote.api.SVNClientException;
import org.netbeans.modules.subversion.remote.api.SVNRevision;
import org.netbeans.modules.subversion.remote.api.SVNUrl;
import org.netbeans.modules.subversion.remote.client.PanelProgressSupport;
import org.netbeans.modules.subversion.remote.client.SvnClient;
import org.netbeans.modules.subversion.remote.client.SvnClientExceptionHandler;
import org.netbeans.modules.subversion.remote.client.SvnProgressSupport;
import org.netbeans.modules.subversion.remote.ui.actions.ActionUtils;
import org.netbeans.modules.subversion.remote.ui.actions.ContextAction;
import org.netbeans.modules.subversion.remote.ui.commit.CommitOptions;
import org.netbeans.modules.subversion.remote.ui.commit.CommitPanel;
import org.netbeans.modules.subversion.remote.ui.commit.CommitTable;
import org.netbeans.modules.subversion.remote.ui.diff.DiffNode;
import org.netbeans.modules.subversion.remote.ui.status.SyncFileNode;
import org.netbeans.modules.subversion.remote.util.ClientCheckSupport;
import org.netbeans.modules.subversion.remote.util.Context;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.diff.SaveBeforeClosingDiffConfirmation;
import org.netbeans.modules.versioning.diff.SaveBeforeCommitConfirmation;
import org.netbeans.modules.versioning.hooks.SvnHook;
import org.netbeans.modules.versioning.hooks.SvnHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommitAction
extends ContextAction {
    public static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";
    private static final String PANEL_PREFIX = "commit";
    private static final String ICON_RESOURCE = "org/netbeans/modules/subversion/remote/resources/icons/commit.png";
    private static final long COMMIT_PAUSE = Long.getLong("versioning.subversion.commit.pause", 5000L);
    private static final String ERROR_COLOR;
    private static final String INFO_COLOR;

    public CommitAction() {
        super(ICON_RESOURCE);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Commit";
    }

    @Override
    protected boolean enable(Node[] nodes) {
        Context cachedContext = this.getCachedContext(nodes);
        FileSystem fileSystem = cachedContext.getFileSystem();
        if (fileSystem == null || !VCSFileProxySupport.isConnectedFileSystem((FileSystem)fileSystem)) {
            return false;
        }
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        if (!CommitAction.isSvnNodes(nodes) && !CommitAction.isDeepRefreshDisabledGlobally()) {
            return cache.ready();
        }
        return cache.ready() && cache.containsFiles(cachedContext, 88532, true);
    }

    public static void commit(String contentTitle, Context ctx, boolean deepScanEnabled) {
        if (ctx.getRoots().size() < 1) {
            Subversion.LOG.info("Svn context contains no files");
            return;
        }
        if (!Subversion.getInstance().checkClientAvailable(ctx)) {
            return;
        }
        CommitAction.commitChanges(contentTitle, ctx, deepScanEnabled && !CommitAction.isDeepRefreshDisabledGlobally());
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    private static boolean isSvnNodes(Node[] nodes) {
        boolean fromSubversionView = true;
        for (Node node : nodes) {
            if (node instanceof SyncFileNode || node instanceof DiffNode) continue;
            fromSubversionView = false;
            break;
        }
        return fromSubversionView;
    }

    private static boolean isDeepRefreshDisabledGlobally() {
        return "false".equals(System.getProperty("netbeans.subversion.commit.deepStatusRefresh"));
    }

    private static void commitChanges(String contentTitle, Context ctx, boolean deepScanEnabled) {
        CommitPanel panel = new CommitPanel(ctx.getFileSystem());
        Collection hooks = VCSHooks.getInstance().getHooks(SvnHook.class);
        panel.setHooks(hooks, new SvnHookContext(null, null, null));
        Map<String, Integer> sortingStatus = SvnModuleConfig.getDefault(ctx.getFileSystem()).getSortingStatus(PANEL_PREFIX);
        if (sortingStatus == null) {
            sortingStatus = Collections.singletonMap("path", 1);
        }
        CommitTable data = new CommitTable(panel.filesLabel, CommitTable.COMMIT_COLUMNS, sortingStatus);
        panel.setCommitTable(data);
        data.setCommitPanel(panel);
        JButton commitButton = new JButton();
        SVNUrl repository = null;
        try {
            repository = ContextAction.getSvnUrl(ctx);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
        }
        List<VCSFileProxy> roots = ctx.getRoots();
        SvnProgressSupport prepareSupport = CommitAction.getProgressSupport(ctx, roots, data, (JPanel)panel.progressPanel, deepScanEnabled);
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        prepareSupport.start(rp, repository, NbBundle.getMessage(CommitAction.class, (String)"BK1009"));
        boolean startCommit = CommitAction.showCommitDialog(panel, data, commitButton, contentTitle, ctx) == commitButton;
        String message = panel.getCommitMessage().trim();
        if (!startCommit && !message.isEmpty()) {
            SvnModuleConfig.getDefault(ctx.getFileSystem()).setLastCanceledCommitMessage(message);
        }
        SvnModuleConfig.getDefault(ctx.getFileSystem()).setSortingStatus(PANEL_PREFIX, data.getSortingState());
        if (startCommit) {
            CommitAction.startCommitTask(panel, data, ctx, roots.toArray(new VCSFileProxy[roots.size()]), hooks);
        } else {
            prepareSupport.cancel();
        }
    }

    private static Set<VCSFileProxy> getUnversionedParents(Collection<VCSFileProxy> files, boolean onlyCached) {
        HashSet<VCSFileProxy> checked = new HashSet<VCSFileProxy>();
        HashSet<VCSFileProxy> ret = new HashSet<VCSFileProxy>();
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        Iterator<VCSFileProxy> i$ = files.iterator();
        block0: while (i$.hasNext()) {
            VCSFileProxy file;
            VCSFileProxy parent = file = i$.next();
            while ((parent = parent.getParentFile()) != null && !checked.contains(parent)) {
                checked.add(parent);
                if (files.contains(parent) || !SvnUtils.isManaged(parent)) continue block0;
                FileInformation info = onlyCached ? cache.getCachedStatus(parent) : cache.getStatus(parent);
                if (info == null || info.getStatus() != 4096 && info.getStatus() != 4) continue;
                ret.add(parent);
            }
        }
        return ret;
    }

    private static SvnFileNode[] getFileNodes(final Collection<VCSFileProxy> files, final SvnProgressSupport supp) {
        final ArrayList nodesList = new ArrayList(files.size());
        SvnUtils.runWithInfoCache(new Runnable(){

            @Override
            public void run() {
                Iterator it = files.iterator();
                while (it.hasNext() && !supp.isCanceled()) {
                    VCSFileProxy file = (VCSFileProxy)it.next();
                    SvnFileNode node = new SvnFileNode(file);
                    node.initializeProperties();
                    nodesList.add(node);
                }
            }
        });
        SvnFileNode[] nodes = nodesList.toArray(new SvnFileNode[nodesList.size()]);
        return nodes;
    }

    private static Object showCommitDialog(final CommitPanel panel, final CommitTable data, final JButton commitButton, String contentTitle, Context ctx) {
        Mnemonics.setLocalizedText((AbstractButton)commitButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        commitButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Commit"));
        commitButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Commit"));
        final JButton cancelButton = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        Mnemonics.setLocalizedText((AbstractButton)cancelButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Cancel"));
        cancelButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Cancel"));
        cancelButton.setDefaultCapable(false);
        commitButton.setEnabled(false);
        final DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)contentTitle), true, new Object[]{commitButton, cancelButton}, (Object)commitButton, 0, new HelpCtx(CommitAction.class), null);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dd.setClosingOptions(new Object[]{commitButton, cancelButton});
                SaveCookie[] saveCookies = panel.getSaveCookies();
                if (cancelButton == e.getSource()) {
                    if (saveCookies.length > 0) {
                        if (SaveBeforeClosingDiffConfirmation.allSaved((SaveCookie[])saveCookies) || !panel.isShowing()) {
                            EditorCookie[] editorCookies;
                            for (EditorCookie cookie : editorCookies = panel.getEditorCookies()) {
                                cookie.open();
                            }
                        } else {
                            dd.setClosingOptions(new Object[0]);
                        }
                    }
                    dd.setValue((Object)cancelButton);
                } else if (commitButton == e.getSource()) {
                    if (saveCookies.length > 0 && !SaveBeforeCommitConfirmation.allSaved((SaveCookie[])saveCookies)) {
                        dd.setClosingOptions(new Object[0]);
                    } else if (!panel.canCommit()) {
                        dd.setClosingOptions(new Object[0]);
                    }
                    dd.setValue((Object)commitButton);
                }
            }
        };
        dd.setButtonListener(al);
        panel.addVersioningListener(new VersioningListener(){

            public void versioningEvent(VersioningEvent event) {
                CommitAction.refreshCommitDialog(panel, data, commitButton);
            }
        });
        data.getTableModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                CommitAction.refreshCommitDialog(panel, data, commitButton);
            }
        });
        commitButton.setEnabled(CommitAction.containsCommitable(data));
        panel.putClientProperty("contentTitle", contentTitle);
        panel.putClientProperty("DialogDescriptor", dd);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        DialogBoundsPreserver windowListener = new DialogBoundsPreserver(SvnModuleConfig.getDefault(ctx.getFileSystem()).getPreferences(), "svn.commit.dialog");
        dialog.addWindowListener((WindowListener)windowListener);
        dialog.pack();
        windowListener.windowOpened(new WindowEvent(dialog, 200));
        dialog.setVisible(true);
        if (dd.getValue() == DialogDescriptor.CLOSED_OPTION) {
            al.actionPerformed(new ActionEvent(cancelButton, 1001, null));
        }
        return dd.getValue();
    }

    private static void startCommitTask(CommitPanel panel, CommitTable data, final Context ctx, final VCSFileProxy[] rootFiles, final Collection<SvnHook> hooks) {
        final Map<SvnFileNode, CommitOptions> commitFiles = data.getCommitFiles();
        final String message = panel.getCommitMessage();
        SvnModuleConfig.getDefault(ctx.getFileSystem()).setLastCanceledCommitMessage("");
        Utils.insert((Preferences)SvnModuleConfig.getDefault(ctx.getFileSystem()).getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)message.trim(), (int)20);
        SVNUrl url = null;
        try {
            url = ContextAction.getSvnUrl(ctx);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
        }
        final SVNUrl repository = url;
        RequestProcessor rp = Subversion.getInstance().getRequestProcessor(repository);
        SvnProgressSupport support = new SvnProgressSupport(ctx.getFileSystem()){

            @Override
            public void perform() {
                CommitAction.performCommit(message, commitFiles, ctx, rootFiles, repository, this, (Collection<SvnHook>)hooks);
            }
        };
        support.start(rp, repository, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
    }

    private static SvnProgressSupport getProgressSupport(final Context ctx, final List<VCSFileProxy> roots, final CommitTable data, JPanel progressPanel, final boolean deepScanEnabled) {
        PanelProgressSupport support = new PanelProgressSupport(ctx.getFileSystem(), progressPanel){

            @Override
            public void perform() {
                VCSFileProxy[] contextFiles = ctx.getFiles();
                if (contextFiles.length == 0) {
                    return;
                }
                HashSet<VCSFileProxy> filesSet = new HashSet<VCSFileProxy>();
                filesSet.addAll(Arrays.asList(contextFiles));
                for (VCSFileProxy file : roots) {
                    filesSet.add(file);
                }
                contextFiles = filesSet.toArray(new VCSFileProxy[filesSet.size()]);
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                if (deepScanEnabled) {
                    for (VCSFileProxy f : contextFiles) {
                        if (this.isCanceled()) {
                            return;
                        }
                        cache.refreshRecursively(f);
                    }
                }
                VCSFileProxy[][] split = VCSFileProxySupport.splitFlatOthers((VCSFileProxy[])contextFiles);
                LinkedHashSet<VCSFileProxy> fileSet = new LinkedHashSet<VCSFileProxy>();
                for (int c = 0; c < split.length; ++c) {
                    int i;
                    VCSFileProxy[] files;
                    boolean recursive;
                    contextFiles = split[c];
                    boolean bl = recursive = c == 1;
                    if (recursive) {
                        files = cache.listFiles(ctx, 88532);
                        for (i = 0; i < files.length; ++i) {
                            for (int r = 0; r < contextFiles.length; ++r) {
                                if (this.isCanceled()) {
                                    return;
                                }
                                if (!SvnUtils.isParentOrEqual(contextFiles[r], files[i]) || fileSet.contains(files[i])) continue;
                                fileSet.add(files[i]);
                            }
                        }
                        continue;
                    }
                    if (this.isCanceled()) {
                        return;
                    }
                    files = SvnUtils.flatten(contextFiles, 88532);
                    for (i = 0; i < files.length; ++i) {
                        if (fileSet.contains(files[i])) continue;
                        fileSet.add(files[i]);
                    }
                }
                if (fileSet.isEmpty()) {
                    return;
                }
                fileSet.addAll(CommitAction.getUnversionedParents(fileSet, false));
                roots.addAll(this.addDeletedFiles(fileSet, cache));
                final SvnFileNode[] nodes = CommitAction.getFileNodes(fileSet, this);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        data.setNodes(nodes);
                    }
                });
            }

            private Collection<VCSFileProxy> addDeletedFiles(Set<VCSFileProxy> fileSet, FileStatusCache cache) {
                ISVNStatus st;
                FileInformation fi;
                LinkedList<VCSFileProxy> added = new LinkedList<VCSFileProxy>();
                HashMap<SVNUrl, VCSFileProxy> deletedCandidates = new HashMap<SVNUrl, VCSFileProxy>();
                for (VCSFileProxy f : fileSet) {
                    fi = cache.getCachedStatus(f);
                    if (fi == null || (fi.getStatus() & 0x900) == 0 || (st = fi.getEntry(null)) == null || !this.checkUrl(st, f)) continue;
                    deletedCandidates.put(st.getUrl(), f);
                }
                for (VCSFileProxy f : fileSet) {
                    VCSFileProxy copiedFrom;
                    SVNUrl copiedUrl;
                    fi = cache.getCachedStatus(f);
                    if (fi == null || (fi.getStatus() & 0x1000) == 0 || (st = fi.getEntry(f)) == null || !st.isCopied() || (copiedUrl = SvnUtils.getCopiedUrl(f)) == null || deletedCandidates.containsKey(copiedUrl) || !this.checkUrl(st, f) || (fi = cache.getCachedStatus(copiedFrom = this.getCopiedFromFile(st, f, copiedUrl))) == null || (fi.getStatus() & 0x900) == 0) continue;
                    deletedCandidates.put(copiedUrl, copiedFrom);
                }
                for (VCSFileProxy f : deletedCandidates.values()) {
                    if (fileSet.contains(f)) continue;
                    added.add(f);
                    fileSet.add(f);
                }
                return added;
            }

            private VCSFileProxy getCopiedFromFile(ISVNStatus st, VCSFileProxy f, SVNUrl copiedUrl) {
                int j;
                String relativized = ".";
                String[] urlSegments = SvnUtils.decode(st.getUrl()).getPathSegments();
                String[] copiedUrlSegments = SvnUtils.decode(copiedUrl).getPathSegments();
                for (int i = 0; i < Math.min(urlSegments.length, copiedUrlSegments.length) && urlSegments[i].equals(copiedUrlSegments[i]); ++i) {
                }
                for (j = i; j < urlSegments.length; ++j) {
                    relativized = relativized + "/..";
                }
                for (j = i; j < copiedUrlSegments.length; ++j) {
                    relativized = relativized + "/" + copiedUrlSegments[j];
                }
                VCSFileProxy copiedFrom = VCSFileProxy.createFileProxy((VCSFileProxy)f, (String)relativized).normalizeFile();
                return copiedFrom;
            }

            private boolean checkUrl(ISVNStatus st, VCSFileProxy f) {
                if (st.getUrl() == null) {
                    Subversion.LOG.log(Level.INFO, null, new IllegalStateException("Null URL for: " + f.getPath() + ", " + st));
                    return false;
                }
                return true;
            }
        };
        return support;
    }

    private static boolean containsCommitable(CommitTable data) {
        Map<SvnFileNode, CommitOptions> map = data.getCommitFiles();
        for (CommitOptions co : map.values()) {
            if (co == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel panel, CommitTable table, JButton commit) {
        String errorLabel;
        String msg;
        assert (EventQueue.isDispatchThread());
        ResourceBundle loc = NbBundle.getBundle(CommitAction.class);
        Map<SvnFileNode, CommitOptions> files = table.getCommitFiles();
        HashSet<String> stickyTags = new HashSet<String>();
        boolean conflicts = false;
        boolean enabled = commit.isEnabled();
        commit.setEnabled(false);
        for (SvnFileNode fileNode : files.keySet()) {
            CommitOptions options = files.get(fileNode);
            if (options == CommitOptions.EXCLUDE) continue;
            stickyTags.add(fileNode.getCopy());
            int status = fileNode.getInformation().getStatus();
            if ((status & 0x6A0) == 0 && (status & 0x4040) == 0) continue;
            enabled = false;
            msg = (status & 0x4040) != 0 ? loc.getString("MSG_CommitForm_ErrorConflicts") : loc.getString("MSG_CommitForm_ErrorRemoteChanges");
            panel.setErrorLabel("<html><font color=\"" + INFO_COLOR + "\">" + msg + "</font></html>");
            conflicts = true;
        }
        if (stickyTags.size() > 1) {
            table.setColumns(new String[]{PANEL_PREFIX, "name", "branch", "status", "action", "path"});
        } else {
            table.setColumns(new String[]{PANEL_PREFIX, "name", "status", "action", "path"});
        }
        String contentTitle = (String)panel.getClientProperty("contentTitle");
        DialogDescriptor dd = (DialogDescriptor)panel.getClientProperty("DialogDescriptor");
        if (stickyTags.size() <= 1) {
            String stickyTag;
            String string = stickyTag = stickyTags.isEmpty() ? null : (String)stickyTags.iterator().next();
            if (stickyTag == null) {
                dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title"), contentTitle));
                errorLabel = "";
            } else {
                dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title_Branch"), contentTitle, stickyTag));
                msg = MessageFormat.format(loc.getString("MSG_CommitForm_InfoBranch"), stickyTag);
                errorLabel = "<html><font color=\"" + INFO_COLOR + "\">" + msg + "</font></html>";
            }
        } else {
            dd.setTitle(MessageFormat.format(loc.getString("CTL_CommitDialog_Title_Branches"), contentTitle));
            String msg2 = loc.getString("MSG_CommitForm_ErrorMultipleBranches");
            errorLabel = "<html><font color=\"" + ERROR_COLOR + "\">" + msg2 + "</font></html>";
        }
        if (!conflicts) {
            panel.setErrorLabel(errorLabel);
            enabled = true;
        }
        commit.setEnabled(enabled && CommitAction.containsCommitable(table));
    }

    @Override
    protected void performContextAction(final Node[] nodes) {
        ClientCheckSupport.getInstance().runInAWTIfAvailable(nodes, ActionUtils.cutAmpersand(this.getRunningName(nodes)), new Runnable(){

            @Override
            public void run() {
                Context ctx = CommitAction.this.getContext(nodes);
                CommitAction.commit(CommitAction.this.getContextDisplayName(nodes), ctx, !CommitAction.isSvnNodes(nodes));
            }
        });
    }

    private static void performCommit(String message, Map<SvnFileNode, CommitOptions> commitFiles, Context ctx, VCSFileProxy[] rootFiles, SVNUrl repository, SvnProgressSupport support, Collection<SvnHook> hooks) {
        SvnClient client = repository == null ? CommitAction.getClient(ctx, support) : CommitAction.getClient(ctx, repository, support);
        if (client == null) {
            return;
        }
        CommitAction.performCommit(client, message, commitFiles, rootFiles, support, false, hooks);
    }

    public static void performCommit(String message, Map<SvnFileNode, CommitOptions> commitFiles, Context ctx, SVNUrl repository, SvnProgressSupport support, boolean rootUpdate) {
        SvnClient client = repository == null ? CommitAction.getClient(ctx, support) : CommitAction.getClient(ctx, repository, support);
        if (client == null) {
            return;
        }
        CommitAction.performCommit(client, message, commitFiles, ctx.getRootFiles(), support, rootUpdate, new ArrayList<SvnHook>(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void performCommit(SvnClient client, String message, Map<SvnFileNode, CommitOptions> commitFiles, VCSFileProxy[] rootFiles, SvnProgressSupport support, boolean rootUpdate, Collection<SvnHook> hooks) {
        try {
            support.setCancellableDelegate(client);
            client.addNotifyListener(support);
            support.setDisplayName(NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
            ArrayList<SvnFileNode> addCandidates = new ArrayList<SvnFileNode>();
            ArrayList<VCSFileProxy> removeCandidates = new ArrayList<VCSFileProxy>();
            ArrayList<VCSFileProxy> missingFiles = new ArrayList<VCSFileProxy>();
            LinkedHashSet<VCSFileProxy> commitCandidates = new LinkedHashSet<VCSFileProxy>();
            HashSet<VCSFileProxy> binnaryCandidates = new HashSet<VCSFileProxy>();
            Iterator<SvnFileNode> it = commitFiles.keySet().iterator();
            while (it.hasNext()) {
                VCSFileProxy file;
                Iterator<VCSFileProxy> dit;
                List<VCSFileProxy> l;
                if (support.isCanceled()) {
                    return;
                }
                SvnFileNode node = it.next();
                CommitOptions option = commitFiles.get(node);
                if (CommitOptions.ADD_BINARY == option) {
                    l = CommitAction.listUnmanagedParents(node);
                    dit = l.iterator();
                    while (dit.hasNext()) {
                        if (support.isCanceled()) {
                            return;
                        }
                        file = dit.next();
                        addCandidates.add(new SvnFileNode(file));
                        commitCandidates.add(file);
                    }
                    if (support.isCanceled()) {
                        return;
                    }
                    binnaryCandidates.add(node.getFile());
                    addCandidates.add(node);
                    commitCandidates.add(node.getFile());
                    continue;
                }
                if (CommitOptions.ADD_TEXT == option || CommitOptions.ADD_DIRECTORY == option) {
                    l = CommitAction.listUnmanagedParents(node);
                    dit = l.iterator();
                    while (dit.hasNext()) {
                        if (support.isCanceled()) {
                            return;
                        }
                        file = dit.next();
                        addCandidates.add(new SvnFileNode(file));
                        commitCandidates.add(file);
                    }
                    if (support.isCanceled()) {
                        return;
                    }
                    addCandidates.add(node);
                    commitCandidates.add(node.getFile());
                    continue;
                }
                if (CommitOptions.COMMIT_REMOVE == option) {
                    removeCandidates.add(node.getFile());
                    commitCandidates.add(node.getFile());
                    if ((node.getInformation().getStatus() & 0x800) == 0) continue;
                    missingFiles.add(node.getFile());
                    continue;
                }
                if (CommitOptions.COMMIT == option) {
                    commitCandidates.add(node.getFile());
                    continue;
                }
                Logger.getLogger(CommitAction.class.getName()).log(Level.FINEST, "Ignoring file for commit: {0}", node.getFile());
            }
            Logger.getLogger(CommitAction.class.getName()).log(Level.FINEST, "All commit candidates: {0}", commitCandidates);
            CommitAction.performAdds(client, support, addCandidates);
            if (support.isCanceled()) {
                return;
            }
            CommitAction.setIgnoredProperties(client, support, addCandidates);
            if (support.isCanceled()) {
                return;
            }
            List<List<VCSFileProxy>> managedTrees = CommitAction.getManagedTrees(client, support, commitCandidates, binnaryCandidates);
            if (support.isCanceled()) {
                return;
            }
            ArrayList<ISVNLogMessage> logs = new ArrayList<ISVNLogMessage>();
            ArrayList<VCSFileProxy> hookFiles = new ArrayList<VCSFileProxy>();
            boolean handleHooks = false;
            String originalMessage = message;
            if (!missingFiles.isEmpty()) {
                CommitAction.deleteMissingFiles(missingFiles, client);
                if (support.isCanceled()) {
                    return;
                }
            }
            Logger.getLogger(CommitAction.class.getName()).log(Level.FINEST, "All commit managed trees: {0} - {1}", new Object[]{managedTrees.size(), managedTrees});
            for (List<VCSFileProxy> commitList : managedTrees) {
                VCSFileProxy[] commitedFiles = commitList.toArray(new VCSFileProxy[commitList.size()]);
                CommitCmd cmd = new CommitCmd(client, support, message, handleHooks ? logs : null);
                List<VCSFileProxy> recursiveCommits = CommitAction.getRecursiveCommits(commitList, removeCandidates);
                Logger.getLogger(CommitAction.class.getName()).log(Level.FINEST, "Committing files: {0}", commitList);
                if (recursiveCommits.size() > 0) {
                    commitList.removeAll(CommitAction.getAllChildren(recursiveCommits, commitList));
                    recursiveCommits = CommitAction.filterChildren(recursiveCommits);
                    Logger.getLogger(CommitAction.class.getName()).log(Level.FINEST, "Committing files recursively: {0}", recursiveCommits);
                    cmd.commitFiles(recursiveCommits, true);
                    if (support.isCanceled()) {
                        return;
                    }
                }
                if (commitList.size() > 0) {
                    Logger.getLogger(CommitAction.class.getName()).log(Level.FINEST, "Committing files non-recursively: {0}", commitList);
                    cmd.commitFiles(commitList, false);
                    if (support.isCanceled()) {
                        return;
                    }
                }
                Subversion.getInstance().getHistoryProvider().fireHistoryChange(commitedFiles);
                if (handleHooks) {
                    CommitAction.afterCommit(hooks, hookFiles, originalMessage, logs);
                }
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                if (rootUpdate) {
                    int i;
                    for (i = 0; i < rootFiles.length; ++i) {
                        client.update(rootFiles[i], SVNRevision.HEAD, false);
                    }
                    for (i = 0; i < rootFiles.length; ++i) {
                        cache.refresh(rootFiles[i], FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                    }
                }
                CommitAction.refreshFiles(cache, commitList);
                if (support.isCanceled()) {
                    return;
                }
                CommitAction.refreshFiles(cache, recursiveCommits);
                if (!support.isCanceled()) continue;
                return;
            }
            SvnUtils.refreshFS(commitCandidates.toArray(new VCSFileProxy[commitCandidates.size()]));
        }
        catch (SVNClientException ex) {
            support.annotate(ex);
        }
        finally {
            client.removeNotifyListener(support);
        }
    }

    private static void afterCommit(Collection<SvnHook> hooks, List<VCSFileProxy> files, String message, List<ISVNLogMessage> logs) {
        if (hooks.isEmpty()) {
            return;
        }
        ArrayList<SvnHookContext.LogEntry> entries = new ArrayList<SvnHookContext.LogEntry>(logs.size());
        for (int i = 0; i < logs.size(); ++i) {
            entries.add(new SvnHookContext.LogEntry(logs.get(i).getMessage(), logs.get(i).getAuthor(), logs.get(i).getRevision().getNumber(), logs.get(i).getDate()));
        }
    }

    private static ISVNLogMessage getLogMessage(SvnClient client, VCSFileProxy file, long revision) throws SVNClientException {
        SVNUrl fileRepositoryUrl;
        ISVNLogMessage[] ls;
        SVNRevision rev = SVNRevision.HEAD;
        ISVNLogMessage log = null;
        try {
            rev = SVNRevision.getRevision(String.valueOf(revision));
        }
        catch (ParseException ex) {
            Subversion.LOG.log(Level.WARNING, "" + revision, ex);
        }
        if (Subversion.LOG.isLoggable(Level.FINER)) {
            Subversion.LOG.log(Level.FINER, "{0}: getting last commit message for svn hooks", CommitAction.class.getName());
        }
        if ((ls = client.getLogMessages(fileRepositoryUrl = SvnUtils.getRepositoryUrl(file), rev, rev)).length > 0) {
            log = ls[0];
        } else {
            Subversion.LOG.log(Level.WARNING, "no logs available for file {0} with repo url {1}", new Object[]{file, fileRepositoryUrl});
        }
        return log;
    }

    private static List<List<VCSFileProxy>> getManagedTrees(SvnClient client, SvnProgressSupport support, Set<VCSFileProxy> commitCandidates, Set<VCSFileProxy> binnaryCandidates) throws SVNClientException {
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        ArrayList<List<VCSFileProxy>> managedTrees = new ArrayList<List<VCSFileProxy>>();
        for (VCSFileProxy commitCandidateFile : commitCandidates) {
            if (binnaryCandidates.contains(commitCandidateFile)) {
                ISVNProperty prop = client.propertyGet(commitCandidateFile, "svn:mime-type");
                if (prop != null) {
                    String s = prop.getValue();
                    if (s == null || s.startsWith("text/")) {
                        client.propertySet(commitCandidateFile, "svn:mime-type", "application/octet-stream", false);
                    }
                } else {
                    client.propertySet(commitCandidateFile, "svn:mime-type", "application/octet-stream", false);
                }
            }
            if (support.isCanceled()) {
                return null;
            }
            List<Object> managedTreesList = null;
            for (List list : managedTrees) {
                FileInformation status;
                VCSFileProxy managedTreeFile = (VCSFileProxy)list.get(0);
                VCSFileProxy base = SVNBaseDir.getRootDir(new VCSFileProxy[]{commitCandidateFile, managedTreeFile});
                if (base != null && ((status = cache.getStatus(base)).getStatus() & 0xFFFFFFFE) != 0) {
                    managedTreesList = list;
                    break;
                }
                if (!support.isCanceled()) continue;
                return null;
            }
            if (managedTreesList == null) {
                managedTreesList = new ArrayList<VCSFileProxy>();
                managedTrees.add(managedTreesList);
            }
            managedTreesList.add(commitCandidateFile);
        }
        return managedTrees;
    }

    private static void performAdds(SvnClient client, SvnProgressSupport support, List<SvnFileNode> addCandidates) throws SVNClientException {
        ArrayList<VCSFileProxy> addFiles = new ArrayList<VCSFileProxy>();
        ArrayList<VCSFileProxy> addDirs = new ArrayList<VCSFileProxy>();
        Iterator<SvnFileNode> it = addCandidates.iterator();
        while (it.hasNext()) {
            if (support.isCanceled()) {
                return;
            }
            SvnFileNode svnFileNode = it.next();
            VCSFileProxy file = svnFileNode.getFile();
            if (file.isDirectory()) {
                addDirs.add(file);
                continue;
            }
            if (!file.isFile()) continue;
            addFiles.add(file);
        }
        if (support.isCanceled()) {
            return;
        }
        Iterator itFiles = addDirs.iterator();
        ArrayList<VCSFileProxy> dirsToAdd = new ArrayList<VCSFileProxy>();
        while (itFiles.hasNext()) {
            VCSFileProxy dir = (VCSFileProxy)itFiles.next();
            if (dirsToAdd.contains(dir)) continue;
            dirsToAdd.add(dir);
        }
        if (dirsToAdd.size() > 0) {
            for (VCSFileProxy file : dirsToAdd) {
                client.addDirectory(file, false);
            }
        }
        if (support.isCanceled()) {
            return;
        }
        if (addFiles.size() > 0) {
            for (VCSFileProxy file : addFiles) {
                client.addFile(file);
            }
        }
    }

    private static void setIgnoredProperties(SvnClient client, SvnProgressSupport support, List<SvnFileNode> addCandidates) {
        for (SvnFileNode fileNode : addCandidates) {
            VCSFileProxy[] children;
            VCSFileProxy file = fileNode.getFile();
            if (!file.isDirectory() || (children = file.listFiles()) == null || children.length <= 0) continue;
            for (VCSFileProxy child : children) {
                FileStatusCache cache = Subversion.getInstance().getStatusCache();
                FileInformation info = cache.getStatus(child);
                if (info.getStatus() != 2) continue;
                VCSFileProxy parent = child.getParentFile();
                if ((cache.getStatus(parent).getStatus() & 0x15DF8) == 0) {
                    cache.refresh(parent, FileStatusCache.REPOSITORY_STATUS_UNKNOWN).getStatus();
                }
                cache.refresh(child, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
            }
        }
    }

    private static List<VCSFileProxy> getRecursiveCommits(List<VCSFileProxy> nonRecursiveComits, List<VCSFileProxy> removeCandidates) {
        ISVNStatus st;
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        ArrayList<VCSFileProxy> recursiveCommits = new ArrayList<VCSFileProxy>();
        boolean nonRecursiveDirs = false;
        for (VCSFileProxy file : nonRecursiveComits) {
            st = null;
            if (!file.isDirectory() || removeCandidates.contains(file) || (st = cache.getStatus(file).getEntry(file)) != null && st.isCopied()) continue;
            nonRecursiveDirs = true;
            break;
        }
        if (!nonRecursiveDirs) {
            recursiveCommits.addAll(recursiveCommits);
            recursiveCommits.addAll(nonRecursiveComits);
        } else {
            for (VCSFileProxy file : nonRecursiveComits) {
                st = null;
                FileInformation fi = cache.getStatus(file);
                if (!file.isDirectory() && !fi.isDirectory() || !removeCandidates.contains(file) && ((st = fi.getEntry(file)) == null || !st.isCopied())) continue;
                recursiveCommits.add(file);
            }
        }
        return recursiveCommits;
    }

    private static List<VCSFileProxy> getAllChildren(List<VCSFileProxy> parents, List<VCSFileProxy> children) {
        ArrayList<VCSFileProxy> ret = new ArrayList<VCSFileProxy>();
        if (parents.size() > 0) {
            Iterator<VCSFileProxy> i$ = children.iterator();
            while (i$.hasNext()) {
                VCSFileProxy child;
                for (VCSFileProxy parent = child = i$.next(); parent != null; parent = parent.getParentFile()) {
                    if (!parents.contains(parent)) continue;
                    ret.add(child);
                }
            }
        }
        return ret;
    }

    private static void refreshFiles(FileStatusCache cache, List<VCSFileProxy> files) {
        for (VCSFileProxy file : files) {
            cache.refresh(file, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
        }
    }

    private static List<VCSFileProxy> listUnmanagedParents(SvnFileNode node) {
        ArrayList<VCSFileProxy> unmanaged = new ArrayList<VCSFileProxy>();
        VCSFileProxy file = node.getFile();
        VCSFileProxy parent = file.getParentFile();
        FileStatusCache cache = Subversion.getInstance().getStatusCache();
        while (!SvnUtils.hasMetadata(parent) && (cache.getStatus(parent).getStatus() & 4) != 0) {
            unmanaged.add(0, parent);
            if ((parent = parent.getParentFile()) != null) continue;
        }
        ArrayList<VCSFileProxy> ret = new ArrayList<VCSFileProxy>();
        for (VCSFileProxy un : unmanaged) {
            ret.add(un);
        }
        return ret;
    }

    private static SvnClient getClient(Context ctx, SvnProgressSupport support) {
        try {
            return Subversion.getInstance().getClient(ctx, support);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return null;
        }
    }

    private static SvnClient getClient(Context ctx, SVNUrl url, SvnProgressSupport support) {
        try {
            return Subversion.getInstance().getClient(ctx, url, support);
        }
        catch (SVNClientException ex) {
            SvnClientExceptionHandler.notifyException(ctx, ex, true, true);
            return null;
        }
    }

    private static List<VCSFileProxy> filterChildren(List<VCSFileProxy> files) {
        LinkedHashSet<VCSFileProxy> filteredFiles = new LinkedHashSet<VCSFileProxy>(files);
        for (VCSFileProxy parent : files) {
            HashSet<VCSFileProxy> toRemove = new HashSet<VCSFileProxy>(filteredFiles.size());
            for (VCSFileProxy f : filteredFiles) {
                if (VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)f, (VCSFileProxy)parent) || !VCSFileProxySupport.isAncestorOrEqual((VCSFileProxy)parent, (VCSFileProxy)f)) continue;
                toRemove.add(f);
            }
            filteredFiles.removeAll(toRemove);
        }
        return new ArrayList<VCSFileProxy>(filteredFiles);
    }

    private static void deleteMissingFiles(List<VCSFileProxy> removeCandidates, SvnClient client) throws SVNClientException {
        client.remove(removeCandidates.toArray(new VCSFileProxy[removeCandidates.size()]), true);
    }

    static {
        Color c = UIManager.getColor("nb.errorForeground");
        ERROR_COLOR = c == null ? "#CC0000" : SvnUtils.getColorString(c);
        c = UIManager.getColor("nb.warningForeground");
        INFO_COLOR = c == null ? "#002080" : SvnUtils.getColorString(c);
    }

    private static class CommitCmd {
        private final SvnClient client;
        private final SvnProgressSupport supp;
        private final List<ISVNLogMessage> logs;
        private final String message;
        private SVNUrl repositoryRootUrl;

        public CommitCmd(SvnClient client, SvnProgressSupport supp, String message, List<ISVNLogMessage> logs) {
            this.client = client;
            this.supp = supp;
            this.logs = logs;
            this.message = message;
        }

        private void commitFiles(List<VCSFileProxy> commitFiles, boolean recursive) throws SVNClientException {
            ISVNLogMessage revisionLog;
            VCSFileProxy[] files = commitFiles.toArray(new VCSFileProxy[commitFiles.size()]);
            long revision = this.client.commit(files, this.message, recursive);
            if (files.length > 0 && !this.supp.isCanceled() && revision > -1L && (revisionLog = this.getLogMessage(files, revision)) != null) {
                Subversion.getInstance().getLogger(VCSFileProxySupport.getFileSystem((VCSFileProxy)files[0]), this.getRepositoryRootUrl(files[0])).logMessage(NbBundle.getMessage(CommitAction.class, (String)"MSG_OutputCommitMessage", (Object[])new Object[]{revisionLog.getRevision(), revisionLog.getAuthor(), DateFormat.getDateTimeInstance().format(revisionLog.getDate()), revisionLog.getMessage()}));
                if (this.logs != null) {
                    this.logs.add(revisionLog);
                }
            }
        }

        private SVNUrl getRepositoryRootUrl(VCSFileProxy file) throws SVNClientException {
            if (this.repositoryRootUrl == null) {
                this.repositoryRootUrl = SvnUtils.getRepositoryRootUrl(file);
            }
            return this.repositoryRootUrl;
        }

        private ISVNLogMessage getLogMessage(VCSFileProxy[] files, long revision) throws SVNClientException {
            ISVNLogMessage revisionLog = null;
            long maxPause = COMMIT_PAUSE;
            long nextPause = 500L;
            for (int i = 0; i < files.length && revisionLog == null; ++i) {
                try {
                    VCSFileProxy f = files[i];
                    while (!f.exists()) {
                        f = f.getParentFile();
                    }
                    revisionLog = CommitAction.getLogMessage(this.client, f, revision);
                    continue;
                }
                catch (SVNClientException ex) {
                    if (SvnClientExceptionHandler.isNoSuchRevision(ex.getMessage())) {
                        Logger.getLogger(CommitAction.class.getName()).log(Level.INFO, "After commit pause for {0} ms. No such revision {1}", new Object[]{nextPause, revision});
                        if (maxPause > 0L) {
                            try {
                                Thread.sleep(nextPause);
                            }
                            catch (InterruptedException ex1) {
                                // empty catch block
                            }
                            maxPause -= nextPause;
                            nextPause *= 2L;
                            --i;
                            continue;
                        }
                    }
                    if (SvnClientExceptionHandler.isFileNotFoundInRevision(ex.getMessage())) continue;
                    throw ex;
                }
            }
            return revisionLog;
        }
    }
}

