/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.RetentionPolicy;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.web.beans.analysis.analyzer.annotation.TargetAnalyzer;

public abstract class RuntimeAnnotationChecker
extends TargetAnalyzer {
    protected static final String VALUE = "value";

    public void init(TypeElement element, AnnotationModelHelper helper) {
        this.init((Element)element, helper.getHelper());
    }

    public boolean check() {
        List<? extends AnnotationMirror> annotations = this.getElement().getAnnotationMirrors();
        boolean hasAnnotation = this.getHelper().hasAnnotation(annotations, this.getAnnotation());
        if (!hasAnnotation) {
            return false;
        }
        if (!this.hasRuntimeRetention()) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + " declared as " + this.getAnnotation() + " but has wrong retention policy." + " Correct retention policy is " + RetentionPolicy.RUNTIME.toString());
            return false;
        }
        return this.hasTarget();
    }

    @Override
    protected void handleNoRetention() {
        this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as " + this.getAnnotation() + " but has no Retention");
    }

    @Override
    protected void handleNoTarget() {
        this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as " + this.getAnnotation() + " but has no Target");
    }

    protected abstract Logger getLogger();

    protected abstract String getAnnotation();

    @Override
    protected TypeElement getElement() {
        return (TypeElement)super.getElement();
    }
}

