/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmExpressionBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypeBasedSpecializationParameter;
import org.netbeans.modules.cnd.api.model.CsmVariadicSpecializationParameter;
import org.openide.util.Lookup;

public abstract class CsmInstantiationProvider {
    private static final CsmInstantiationProvider EMPTY = new Empty();
    private static CsmInstantiationProvider defaultProvider;

    protected CsmInstantiationProvider() {
    }

    public static CsmInstantiationProvider getDefault() {
        if (defaultProvider != null) {
            return defaultProvider;
        }
        defaultProvider = (CsmInstantiationProvider)Lookup.getDefault().lookup(CsmInstantiationProvider.class);
        return defaultProvider == null ? EMPTY : defaultProvider;
    }

    public abstract CsmType[] deduceTemplateType(CsmTemplateParameter var1, CsmType var2, CsmType var3, DeduceTemplateTypeStrategy var4);

    public abstract CsmObject instantiate(CsmTemplate var1, List<CsmSpecializationParameter> var2);

    public abstract CsmObject instantiate(CsmTemplate var1, CsmInstantiation var2);

    public abstract CsmObject instantiate(CsmTemplate var1, CsmType var2);

    public abstract CsmType instantiate(CsmTemplateParameter var1, List<CsmInstantiation> var2);

    public abstract boolean isInstantiatedType(CsmType var1);

    public abstract CsmInstantiation getInstantiatedTypeInstantiation(CsmType var1);

    public abstract List<CsmInstantiation> getInstantiatedTypeInstantiations(CsmType var1);

    public abstract boolean isViableInstantiation(CsmInstantiation var1, boolean var2);

    public abstract CsmTypeBasedSpecializationParameter createTypeBasedSpecializationParameter(CsmType var1, CsmScope var2);

    public abstract CsmTypeBasedSpecializationParameter createTypeBasedSpecializationParameter(CsmType var1, CsmScope var2, CsmFile var3, int var4, int var5);

    public abstract CsmVariadicSpecializationParameter createVariadicSpecializationParameter(List<CsmSpecializationParameter> var1, CsmFile var2, int var3, int var4);

    public abstract CsmExpressionBasedSpecializationParameter createExpressionBasedSpecializationParameter(String var1, CsmScope var2, CsmFile var3, int var4, int var5);

    public abstract CharSequence getInstantiatedText(CsmType var1);

    public abstract CharSequence getTemplateSignature(CsmTemplate var1);

    public abstract Collection<CsmOffsetableDeclaration> getSpecializations(CsmDeclaration var1, CsmFile var2, int var3);

    public Collection<CsmOffsetableDeclaration> getSpecializations(CsmDeclaration templateDecl) {
        return this.getSpecializations(templateDecl, null, -1);
    }

    public abstract Collection<CsmOffsetableDeclaration> getBaseTemplate(CsmDeclaration var1);

    private static final class Empty
    extends CsmInstantiationProvider {
        Empty() {
        }

        @Override
        public CsmType[] deduceTemplateType(CsmTemplateParameter templateParam, CsmType patternType, CsmType actualType, DeduceTemplateTypeStrategy strategy) {
            return null;
        }

        @Override
        public CsmObject instantiate(CsmTemplate template, List<CsmSpecializationParameter> params) {
            return template;
        }

        @Override
        public CsmObject instantiate(CsmTemplate template, CsmInstantiation instantiation) {
            return template;
        }

        @Override
        public CsmObject instantiate(CsmTemplate template, CsmType type) {
            return template;
        }

        @Override
        public CsmType instantiate(CsmTemplateParameter templateParam, List<CsmInstantiation> instantiations) {
            return null;
        }

        @Override
        public boolean isInstantiatedType(CsmType type) {
            return false;
        }

        @Override
        public CsmInstantiation getInstantiatedTypeInstantiation(CsmType type) {
            return null;
        }

        @Override
        public List<CsmInstantiation> getInstantiatedTypeInstantiations(CsmType type) {
            return null;
        }

        @Override
        public boolean isViableInstantiation(CsmInstantiation instantiation, boolean acceptTemplateParams) {
            return false;
        }

        @Override
        public CsmTypeBasedSpecializationParameter createTypeBasedSpecializationParameter(CsmType type, CsmScope scope) {
            return null;
        }

        @Override
        public CsmTypeBasedSpecializationParameter createTypeBasedSpecializationParameter(CsmType type, CsmScope scope, CsmFile file, int start, int end) {
            return null;
        }

        @Override
        public CsmExpressionBasedSpecializationParameter createExpressionBasedSpecializationParameter(String expression, CsmScope scope, CsmFile file, int start, int end) {
            return null;
        }

        @Override
        public CsmVariadicSpecializationParameter createVariadicSpecializationParameter(List<CsmSpecializationParameter> args, CsmFile file, int start, int end) {
            return null;
        }

        @Override
        public CharSequence getInstantiatedText(CsmType type) {
            return type.getText();
        }

        @Override
        public CharSequence getTemplateSignature(CsmTemplate template) {
            return "";
        }

        @Override
        public Collection<CsmOffsetableDeclaration> getSpecializations(CsmDeclaration templateDecl, CsmFile contextFile, int contextOffset) {
            return Collections.emptyList();
        }

        @Override
        public Collection<CsmOffsetableDeclaration> getBaseTemplate(CsmDeclaration declaration) {
            return Collections.emptyList();
        }
    }

    public static final class DefaultDeduceTemplateTypeStrategy
    implements DeduceTemplateTypeStrategy {
        private final Set<DeduceTemplateTypeStrategy.Error> errors = new HashSet<DeduceTemplateTypeStrategy.Error>();
        private final Set<DeduceTemplateTypeStrategy.Error> acceptableErrors;

        public DefaultDeduceTemplateTypeStrategy() {
            this(Collections.emptySet());
        }

        public DefaultDeduceTemplateTypeStrategy(DeduceTemplateTypeStrategy.Error ... acceptableErrors) {
            this(EnumSet.copyOf(Arrays.asList(acceptableErrors)));
        }

        public DefaultDeduceTemplateTypeStrategy(Set<DeduceTemplateTypeStrategy.Error> acceptableErrors) {
            this.acceptableErrors = acceptableErrors;
        }

        public final Set<DeduceTemplateTypeStrategy.Error> getErrors() {
            return Collections.unmodifiableSet(this.errors);
        }

        @Override
        public boolean canSkipError(DeduceTemplateTypeStrategy.Error error) {
            this.errors.add(error);
            return this.acceptableErrors.contains((Object)error);
        }
    }

    public static interface DeduceTemplateTypeStrategy {
        public boolean canSkipError(Error var1);

        public static enum Error {
            MatchQualsError,
            ExtractNextTypeError;

        }
    }
}

