/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.spi.model.services.CsmSymbolResolverImplementation;
import org.openide.util.Lookup;

public final class CsmSymbolResolver {
    private static final CsmSymbolResolverImplementation DEFAULT = new Default();

    public static Collection<CsmOffsetable> resolveSymbol(NativeProject project, CharSequence declText) {
        return DEFAULT.resolveSymbol(project, declText);
    }

    public static Collection<CsmOffsetable> resolveSymbol(CsmProject project, CharSequence declText) {
        return DEFAULT.resolveSymbol(project, declText);
    }

    private CsmSymbolResolver() {
        throw new AssertionError((Object)"Not instantiable");
    }

    private static final class Default
    implements CsmSymbolResolverImplementation {
        private final Lookup.Result<CsmSymbolResolverImplementation> res = Lookup.getDefault().lookupResult(CsmSymbolResolverImplementation.class);
        private CsmSymbolResolverImplementation delegate;

        private Default() {
        }

        private CsmSymbolResolverImplementation getDelegate() {
            CsmSymbolResolverImplementation service = this.delegate;
            if (service == null) {
                Iterator i$ = this.res.allInstances().iterator();
                if (i$.hasNext()) {
                    CsmSymbolResolverImplementation resolver;
                    service = resolver = (CsmSymbolResolverImplementation)i$.next();
                }
                this.delegate = service;
            }
            return service;
        }

        @Override
        public Collection<CsmOffsetable> resolveSymbol(NativeProject project, CharSequence declText) {
            return this.getDelegate().resolveSymbol(project, declText);
        }

        @Override
        public Collection<CsmOffsetable> resolveSymbol(CsmProject project, CharSequence declText) {
            return this.getDelegate().resolveSymbol(project, declText);
        }
    }
}

