/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.libs.common;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.openide.util.RequestProcessor;

public class PerformanceLogger {
    private static final boolean PROFILING_ENABLED;
    private static final boolean CPU_TIME_AVAILABLE;
    private static final ThreadMXBean threadMXBean;
    private static final PerformanceLogger INSANCE;
    private final ReentrantReadWriteLock listenersLock = new ReentrantReadWriteLock();
    private final List<PerformanceListener> listeners = new ArrayList<PerformanceListener>();
    private final ReentrantReadWriteLock lineLock = new ReentrantReadWriteLock();
    private final LinkedList<PerformanceEvent> line = new LinkedList();
    private final Map<PerformaceAction, Integer> register = new HashMap<PerformaceAction, Integer>();
    private final ScheduledFuture<?> periodicTask = PROFILING_ENABLED ? new RequestProcessor("PerformanceLoggerUpdater").scheduleAtFixedRate(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block9: while (true) {
                PerformanceEvent last = null;
                PerformanceLogger.this.lineLock.writeLock().lock();
                try {
                    if (!PerformanceLogger.this.line.isEmpty()) {
                        last = (PerformanceEvent)PerformanceLogger.this.line.pollLast();
                    }
                }
                finally {
                    PerformanceLogger.this.lineLock.writeLock().unlock();
                }
                if (last == null) break;
                PerformanceLogger.this.listenersLock.readLock().lock();
                try {
                    if (PerformanceLogger.this.listeners.size() <= 0) continue;
                    Iterator i$ = PerformanceLogger.this.listeners.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block9;
                        PerformanceListener listener = (PerformanceListener)i$.next();
                        listener.processEvent(last);
                    }
                }
                finally {
                    PerformanceLogger.this.listenersLock.readLock().unlock();
                    continue;
                }
                break;
            }
            ArrayList toSend = null;
            PerformanceLogger.this.lineLock.writeLock().lock();
            try {
                if (!PerformanceLogger.this.register.isEmpty()) {
                    toSend = new ArrayList();
                    for (Map.Entry entry : PerformanceLogger.this.register.entrySet()) {
                        long delta = System.nanoTime() - ((PerformaceAction)entry.getKey()).start;
                        if (delta / 1000L / 1000L / 1000L <= (long)((Integer)entry.getValue()).intValue()) continue;
                        toSend.add(entry.getKey());
                    }
                }
            }
            finally {
                PerformanceLogger.this.lineLock.writeLock().unlock();
            }
            if (toSend != null && !toSend.isEmpty()) {
                for (PerformaceAction action : toSend) {
                    PerformanceLogger.this.logTimeOut(action);
                }
            }
        }
    }, 1L, 1L, TimeUnit.SECONDS) : null;
    private static final int SCHEDULE = 1;

    public static boolean isProfilingEnabled() {
        return PROFILING_ENABLED;
    }

    public static boolean isCpuTimeProfilingAvailable() {
        return CPU_TIME_AVAILABLE;
    }

    private PerformanceLogger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTimeOut(PerformaceAction action, int timeOut) {
        if (PROFILING_ENABLED) {
            this.lineLock.writeLock().lock();
            try {
                this.register.put(action, timeOut);
            }
            finally {
                this.lineLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(PerformaceAction action, Object ... extra) {
        if (PROFILING_ENABLED) {
            long userTime;
            long cpuTime;
            long delta = System.nanoTime() - action.start;
            Runtime runtime = Runtime.getRuntime();
            long usedMemeory = runtime.totalMemory() - runtime.freeMemory();
            if (CPU_TIME_AVAILABLE && action.cpuTime != -1L && action.userTime != -1L) {
                cpuTime = threadMXBean.getCurrentThreadCpuTime() - action.cpuTime;
                userTime = threadMXBean.getCurrentThreadUserTime() - action.userTime;
            } else {
                cpuTime = 0L;
                userTime = 0L;
            }
            PerformanceEventImpl event = new PerformanceEventImpl(action.id, action.source, action.start, delta, cpuTime, userTime, usedMemeory, extra);
            this.lineLock.writeLock().lock();
            try {
                this.register.remove(action);
                this.line.addFirst(event);
            }
            finally {
                this.lineLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logTimeOut(PerformaceAction action) {
        if (PROFILING_ENABLED) {
            long userTime;
            long cpuTime;
            long delta = System.nanoTime() - action.start;
            Runtime runtime = Runtime.getRuntime();
            long usedMemeory = runtime.totalMemory() - runtime.freeMemory();
            if (CPU_TIME_AVAILABLE && action.cpuTime != -1L && action.userTime != -1L && action.threadID >= 0L) {
                cpuTime = threadMXBean.getThreadCpuTime(action.threadID) - action.cpuTime;
                userTime = threadMXBean.getThreadUserTime(action.threadID) - action.userTime;
            } else {
                cpuTime = 0L;
                userTime = 0L;
            }
            PerformanceEventImpl event = new PerformanceEventImpl(action.id, action.source, action.start, delta, cpuTime, userTime, usedMemeory, new Object[0]);
            this.lineLock.writeLock().lock();
            try {
                Integer remove = this.register.remove(action);
                if (remove != null) {
                    this.line.addFirst(event);
                }
            }
            finally {
                this.lineLock.writeLock().unlock();
            }
        }
    }

    public static PerformanceLogger getLogger() {
        return INSANCE;
    }

    public PerformaceAction start(String id, Object source) {
        return new PerformaceAction(id, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPerformanceListener(PerformanceListener listener) {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.add(listener);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerformanceListener(PerformanceListener listener) {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.remove(listener);
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    static {
        threadMXBean = ManagementFactory.getThreadMXBean();
        boolean isDebugMode = false;
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        try {
            List<String> args = runtime.getInputArguments();
            if (args.contains("-Xdebug")) {
                isDebugMode = true;
            }
        }
        catch (SecurityException ex) {
            // empty catch block
        }
        String enabled = System.getProperty("dlight.libs.common.profiling.enabled", "false");
        PROFILING_ENABLED = "true".equals(enabled) ? true : ("false".equals(enabled) ? false : ("auto".equals(enabled) ? !isDebugMode : false));
        boolean cpu = true;
        if (PROFILING_ENABLED) {
            try {
                threadMXBean.setThreadCpuTimeEnabled(true);
            }
            catch (UnsupportedOperationException ex) {
                cpu = false;
            }
            catch (SecurityException ex) {
                cpu = false;
            }
        } else {
            cpu = false;
        }
        CPU_TIME_AVAILABLE = cpu;
        INSANCE = new PerformanceLogger();
    }

    private static final class PerformanceEventImpl
    implements PerformanceEvent {
        private final String id;
        private final Object source;
        private final long startTime;
        private final long time;
        private final long cpu;
        private final long user;
        private final Object[] extra;
        private final long usedMemeory;

        private PerformanceEventImpl(String id, Object source, long startTime, long time, long cpu, long user, long usedMemeory, Object[] extra) {
            this.id = id;
            this.source = source;
            this.startTime = startTime;
            this.time = time;
            this.cpu = cpu;
            this.user = user;
            this.extra = extra;
            this.usedMemeory = usedMemeory;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public Object getSource() {
            return this.source;
        }

        @Override
        public Object[] getAttrs() {
            return this.extra;
        }

        @Override
        public long getStartTime() {
            return this.startTime;
        }

        @Override
        public long getTime() {
            return this.time;
        }

        @Override
        public long getCpuTime() {
            return this.cpu;
        }

        @Override
        public long getUserTime() {
            return this.user;
        }

        @Override
        public long getUsedMemory() {
            return this.usedMemeory;
        }
    }

    public static interface PerformanceListener {
        public void processEvent(PerformanceEvent var1);
    }

    public static interface PerformanceEvent {
        public String getId();

        public Object getSource();

        public Object[] getAttrs();

        public long getStartTime();

        public long getTime();

        public long getCpuTime();

        public long getUserTime();

        public long getUsedMemory();
    }

    public static final class PerformaceAction {
        private final String id;
        private final Object source;
        private final long start;
        private final long cpuTime;
        private final long userTime;
        private final long threadID;

        public void log(Object ... extra) {
            INSANCE.log(this, extra);
        }

        public void setTimeOut(int timeOut) {
            INSANCE.setTimeOut(this, timeOut);
        }

        private PerformaceAction(String id, Object source) {
            this.id = id;
            this.source = source;
            if (PROFILING_ENABLED) {
                this.start = System.nanoTime();
                if (CPU_TIME_AVAILABLE) {
                    this.cpuTime = threadMXBean.getCurrentThreadCpuTime();
                    this.userTime = threadMXBean.getCurrentThreadUserTime();
                    this.threadID = Thread.currentThread().getId();
                } else {
                    this.cpuTime = -1L;
                    this.userTime = -1L;
                    this.threadID = -1L;
                }
            } else {
                this.start = 0L;
                this.cpuTime = -1L;
                this.userTime = -1L;
                this.threadID = -1L;
            }
        }
    }
}

