/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.text.Document;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.hibernate.completion.CompletionContext;
import org.netbeans.modules.hibernate.completion.HibernateCompletionItem;
import org.netbeans.modules.hibernate.completion.LazyTypeCompletionItem;
import org.netbeans.modules.hibernate.editor.HibernateEditorUtil;
import org.netbeans.modules.hibernate.service.TableColumn;
import org.netbeans.modules.hibernate.service.api.HibernateEnvironment;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public abstract class Completor {
    private int anchorOffset = -1;

    public abstract List<HibernateCompletionItem> doCompletion(CompletionContext var1);

    protected void setAnchorOffset(int anchorOffset) {
        this.anchorOffset = anchorOffset;
    }

    public int getAnchorOffset() {
        return this.anchorOffset;
    }

    public static class HbMappingFileCompletor
    extends Completor {
        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext context) {
            ArrayList<HibernateCompletionItem> results = new ArrayList<HibernateCompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            String[] mappingFiles = this.getMappingFilesFromProject(context);
            for (int i = 0; i < mappingFiles.length; ++i) {
                if (!mappingFiles[i].startsWith(typedChars.trim())) continue;
                HibernateCompletionItem item = HibernateCompletionItem.createHbMappingFileItem(caretOffset - typedChars.length(), mappingFiles[i]);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentToken().getOffset() + 1);
            return results;
        }

        private String[] getMappingFilesFromProject(CompletionContext context) {
            Project enclosingProject = FileOwnerQuery.getOwner((FileObject)NbEditorUtilities.getFileObject((Document)context.getDocument()));
            HibernateEnvironment env = (HibernateEnvironment)enclosingProject.getLookup().lookup(HibernateEnvironment.class);
            if (env != null) {
                return env.getAllHibernateMappings().toArray(new String[0]);
            }
            return new String[0];
        }
    }

    public static class HbPropertyNameCompletor
    extends Completor {
        private String[] itemTextAndDocs;

        public HbPropertyNameCompletor(String[] itemTextAndDocs) {
            this.itemTextAndDocs = itemTextAndDocs;
        }

        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext context) {
            ArrayList<HibernateCompletionItem> results = new ArrayList<HibernateCompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            for (int i = 0; i < this.itemTextAndDocs.length; i += 2) {
                if (!this.itemTextAndDocs[i].startsWith(typedChars.trim()) && !this.itemTextAndDocs[i].startsWith("hibernate." + typedChars.trim())) continue;
                HibernateCompletionItem item = HibernateCompletionItem.createAttribValueItem(caretOffset - typedChars.length(), this.itemTextAndDocs[i], this.itemTextAndDocs[i + 1]);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentToken().getOffset() + 1);
            return results;
        }
    }

    public static class DatabaseTableColumnCompletor
    extends Completor {
        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext context) {
            ArrayList<HibernateCompletionItem> results = new ArrayList<HibernateCompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            String tableName = HibernateEditorUtil.getTableName(context.getTag());
            if (tableName == null) {
                return Collections.emptyList();
            }
            List<TableColumn> tableColumns = this.getColumnsForTable(context, tableName);
            for (TableColumn tableColumn : tableColumns) {
                if (!tableColumn.getColumnName().startsWith(typedChars.trim())) continue;
                HibernateCompletionItem item = HibernateCompletionItem.createDatabaseColumnItem(caretOffset - typedChars.length(), tableColumn.getColumnName(), tableColumn.isPrimaryKey());
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentToken().getOffset() + 1);
            return results;
        }

        private List<TableColumn> getColumnsForTable(CompletionContext context, String tableName) {
            List<TableColumn> tableColumns = new ArrayList<TableColumn>();
            FileObject currentFileObject = NbEditorUtilities.getFileObject((Document)context.getDocument());
            Project enclosingProject = FileOwnerQuery.getOwner((FileObject)currentFileObject);
            HibernateEnvironment env = (HibernateEnvironment)enclosingProject.getLookup().lookup(HibernateEnvironment.class);
            if (env != null) {
                tableColumns = env.getColumnsForTable(tableName, currentFileObject);
            }
            return tableColumns;
        }
    }

    public static class DatabaseTableCompletor
    extends Completor {
        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext context) {
            ArrayList<HibernateCompletionItem> results = new ArrayList<HibernateCompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            List<String> tableNames = this.getDatabaseTableNamesForThisMappingFile(context);
            for (String tableName : tableNames) {
                if (!tableName.startsWith(typedChars.trim())) continue;
                HibernateCompletionItem item = HibernateCompletionItem.createDatabaseTableItem(caretOffset - typedChars.length(), tableName);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentToken().getOffset() + 1);
            return results;
        }

        private List<String> getDatabaseTableNamesForThisMappingFile(CompletionContext context) {
            List<String> tableNames = new ArrayList<String>();
            FileObject mappingFile = NbEditorUtilities.getFileObject((Document)context.getDocument());
            Project enclosingProject = FileOwnerQuery.getOwner((FileObject)mappingFile);
            HibernateEnvironment env = (HibernateEnvironment)enclosingProject.getLookup().lookup(HibernateEnvironment.class);
            if (env != null) {
                tableNames = env.getDatabaseTables(mappingFile);
            }
            return tableNames;
        }
    }

    public static class PropertyCompletor
    extends Completor {
        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext context) {
            final ArrayList<HibernateCompletionItem> results = new ArrayList<HibernateCompletionItem>();
            final int caretOffset = context.getCaretOffset();
            final String typedChars = context.getTypedPrefix();
            final String className = HibernateEditorUtil.getClassName(context.getTag());
            if (className == null) {
                return Collections.emptyList();
            }
            try {
                JavaSource classJavaSrc = HibernateEditorUtil.getJavaSource(context.getDocument());
                classJavaSrc.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController cc) throws Exception {
                        cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElem = cc.getElements().getTypeElement(className);
                        if (typeElem == null) {
                            return;
                        }
                        List<? extends Element> clsChildren = typeElem.getEnclosedElements();
                        for (Element element : clsChildren) {
                            if (element.getKind() != ElementKind.FIELD) continue;
                            VariableElement elem = (VariableElement)element;
                            HibernateCompletionItem item = HibernateCompletionItem.createClassPropertyItem(caretOffset - typedChars.length(), elem, (ElementHandle<VariableElement>)ElementHandle.create((Element)elem), cc.getElements().isDeprecated(element));
                            results.add(item);
                        }
                    }
                }, true);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.setAnchorOffset(context.getCurrentToken().getOffset() + 1);
            return results;
        }
    }

    public static class JavaClassCompletor
    extends Completor {
        private boolean packageOnly = false;

        public JavaClassCompletor(boolean packageOnly) {
            this.packageOnly = packageOnly;
        }

        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext context) {
            ArrayList<HibernateCompletionItem> results = new ArrayList<HibernateCompletionItem>();
            try {
                Document doc = context.getDocument();
                String typedChars = context.getTypedPrefix();
                JavaSource js = HibernateEditorUtil.getJavaSource(doc);
                if (js == null) {
                    return Collections.emptyList();
                }
                if (typedChars.contains(".") || typedChars.equals("")) {
                    this.doNormalJavaCompletion(js, results, typedChars, context.getCurrentToken().getOffset() + 1);
                } else {
                    this.doSmartJavaCompletion(js, results, typedChars, context.getCurrentToken().getOffset() + 1);
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            return results;
        }

        private void doNormalJavaCompletion(JavaSource js, final List<HibernateCompletionItem> results, final String typedPrefix, final int substitutionOffset) throws IOException {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex ci = cc.getClasspathInfo().getClassIndex();
                    int index = substitutionOffset;
                    String packName = typedPrefix;
                    String classPrefix = "";
                    int dotIndex = typedPrefix.lastIndexOf(46);
                    if (dotIndex != -1) {
                        index += dotIndex + 1;
                        packName = typedPrefix.substring(0, dotIndex);
                        classPrefix = dotIndex + 1 < typedPrefix.length() ? typedPrefix.substring(dotIndex + 1) : "";
                    }
                    JavaClassCompletor.this.addPackages(ci, results, typedPrefix, index);
                    PackageElement pkgElem = cc.getElements().getPackageElement(packName);
                    if (pkgElem == null) {
                        return;
                    }
                    if (!JavaClassCompletor.this.packageOnly) {
                        List<? extends Element> pkgChildren = pkgElem.getEnclosedElements();
                        for (Element element : pkgChildren) {
                            if (element.getKind() != ElementKind.CLASS || !element.getSimpleName().toString().startsWith(classPrefix)) continue;
                            TypeElement typeElement = (TypeElement)element;
                            HibernateCompletionItem item = HibernateCompletionItem.createTypeItem(substitutionOffset, typeElement, (ElementHandle<TypeElement>)ElementHandle.create((Element)typeElement), cc.getElements().isDeprecated(element), false);
                            results.add(item);
                        }
                    }
                    JavaClassCompletor.this.setAnchorOffset(index);
                }
            }, true);
        }

        private void doSmartJavaCompletion(final JavaSource js, final List<HibernateCompletionItem> results, final String typedPrefix, final int substitutionOffset) throws IOException {
            js.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController cc) throws Exception {
                    cc.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    ClassIndex ci = cc.getClasspathInfo().getClassIndex();
                    JavaClassCompletor.this.addPackages(ci, results, typedPrefix, substitutionOffset);
                    if (!JavaClassCompletor.this.packageOnly) {
                        Set matchingTypes = ci.getDeclaredTypes(typedPrefix, ClassIndex.NameKind.CASE_INSENSITIVE_PREFIX, EnumSet.allOf(ClassIndex.SearchScope.class));
                        for (ElementHandle eh : matchingTypes) {
                            if (eh.getKind() != ElementKind.CLASS || eh.getKind() != ElementKind.CLASS) continue;
                            LazyTypeCompletionItem item = LazyTypeCompletionItem.create(substitutionOffset, (ElementHandle<TypeElement>)eh, js);
                            results.add(item);
                        }
                    }
                }
            }, true);
            this.setAnchorOffset(substitutionOffset);
        }

        private void addPackages(ClassIndex ci, List<HibernateCompletionItem> results, String typedPrefix, int substitutionOffset) {
            Set packages = ci.getPackageNames(typedPrefix, true, EnumSet.allOf(ClassIndex.SearchScope.class));
            for (String pkg : packages) {
                if (pkg.length() <= 0) continue;
                HibernateCompletionItem item = HibernateCompletionItem.createPackageItem(substitutionOffset, pkg, false);
                results.add(item);
            }
        }
    }

    public static class CascadeStyleCompletor
    extends Completor {
        private String[] itemTextAndDocs;

        public CascadeStyleCompletor(String[] itemTextAndDocs) {
            this.itemTextAndDocs = itemTextAndDocs;
        }

        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext context) {
            ArrayList<HibernateCompletionItem> results = new ArrayList<HibernateCompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            String styleName = null;
            if (typedChars.contains(",")) {
                int index = typedChars.lastIndexOf(",");
                styleName = typedChars.substring(index + 1);
            } else {
                styleName = typedChars;
            }
            for (int i = 0; i < this.itemTextAndDocs.length; i += 2) {
                if (!this.itemTextAndDocs[i].startsWith(styleName.trim())) continue;
                HibernateCompletionItem item = HibernateCompletionItem.createCascadeStyleItem(caretOffset - styleName.length(), this.itemTextAndDocs[i], this.itemTextAndDocs[i + 1]);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentToken().getOffset() + 1);
            return results;
        }
    }

    public static class AttributeValueCompletor
    extends Completor {
        private String[] itemTextAndDocs;

        public AttributeValueCompletor(String[] itemTextAndDocs) {
            this.itemTextAndDocs = itemTextAndDocs;
        }

        @Override
        public List<HibernateCompletionItem> doCompletion(CompletionContext context) {
            ArrayList<HibernateCompletionItem> results = new ArrayList<HibernateCompletionItem>();
            int caretOffset = context.getCaretOffset();
            String typedChars = context.getTypedPrefix();
            for (int i = 0; i < this.itemTextAndDocs.length; i += 2) {
                if (!this.itemTextAndDocs[i].startsWith(typedChars.trim())) continue;
                HibernateCompletionItem item = HibernateCompletionItem.createAttribValueItem(caretOffset - typedChars.length(), this.itemTextAndDocs[i], this.itemTextAndDocs[i + 1]);
                results.add(item);
            }
            this.setAnchorOffset(context.getCurrentToken().getOffset() + 1);
            return results;
        }
    }
}

